/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.MonocleSettings;
import com.sun.glass.ui.monocle.MonocleTrace;
import com.sun.glass.ui.monocle.NativePlatform;
import java.security.AccessController;

public abstract class NativePlatformFactory {
    private static NativePlatform platform;
    private static final int majorVersion = 1;
    private static final int minorVersion = 0;

    protected abstract boolean matches();

    protected abstract NativePlatform createNativePlatform();

    protected abstract int getMajorVersion();

    protected abstract int getMinorVersion();

    public static synchronized NativePlatform getNativePlatform() {
        if (platform == null) {
            String string = AccessController.doPrivileged(() -> System.getProperty("monocle.platform", "MX6,OMAP,Dispman,Android,X11,Linux,Headless"));
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                String string3 = string2.contains(".") ? string2 : "com.sun.glass.ui.monocle." + string2 + "PlatformFactory";
                if (MonocleSettings.settings.tracePlatformConfig) {
                    MonocleTrace.traceConfig("Trying platform %s with class %s", string2, string3);
                }
                try {
                    ClassLoader classLoader = NativePlatformFactory.class.getClassLoader();
                    Class<?> clazz = Class.forName(string3, false, classLoader);
                    if (!NativePlatformFactory.class.isAssignableFrom(clazz)) {
                        throw new IllegalArgumentException("Unrecognized Monocle platform: " + string3);
                    }
                    NativePlatformFactory nativePlatformFactory = (NativePlatformFactory)clazz.newInstance();
                    if (!nativePlatformFactory.matches() || nativePlatformFactory.getMajorVersion() != 1 || nativePlatformFactory.getMinorVersion() != 0) continue;
                    platform = nativePlatformFactory.createNativePlatform();
                    if (MonocleSettings.settings.tracePlatformConfig) {
                        MonocleTrace.traceConfig("Matched %s", string2);
                    }
                    return platform;
                }
                catch (Exception exception) {
                    if (MonocleSettings.settings.tracePlatformConfig) {
                        MonocleTrace.traceConfig("Failed to create platform %s", string3);
                    }
                    exception.printStackTrace();
                }
            }
            throw new UnsupportedOperationException("Cannot load a native platform from: '" + string + "'");
        }
        return platform;
    }
}

