/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.TextureAttributes;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.NodeComponentState;
import org.scijava.vecmath.Color4f;
import org.scijava.vecmath.Matrix4d;

public class TextureAttributesState
extends NodeComponentState {
    private static final int MAX_COLOR_OPERANDS = 2;

    public TextureAttributesState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        int i;
        super.writeObject(out);
        TextureAttributes attr = (TextureAttributes)this.node;
        Color4f clr = new Color4f();
        Matrix4d mat = new Matrix4d();
        Transform3D trans = new Transform3D();
        int tableComponents = attr.getNumTextureColorTableComponents();
        int tableSize = attr.getTextureColorTableSize();
        int[][] colorTable = new int[tableComponents][tableSize];
        out.writeInt(attr.getPerspectiveCorrectionMode());
        attr.getTextureBlendColor(clr);
        this.control.writeColor4f(out, clr);
        out.writeInt(tableComponents);
        out.writeInt(tableSize);
        attr.getTextureColorTable(colorTable);
        for (i = 0; i < tableComponents; ++i) {
            for (int j = 0; j < tableSize; ++j) {
                out.writeInt(colorTable[i][j]);
            }
        }
        out.writeInt(attr.getTextureMode());
        attr.getTextureTransform(trans);
        trans.get(mat);
        this.control.writeMatrix4d(out, mat);
        out.writeInt(attr.getCombineRgbMode());
        out.writeInt(attr.getCombineAlphaMode());
        for (i = 0; i < 2; ++i) {
            out.writeInt(attr.getCombineRgbSource(i));
            out.writeInt(attr.getCombineAlphaSource(i));
            out.writeInt(attr.getCombineRgbFunction(i));
            out.writeInt(attr.getCombineAlphaFunction(i));
        }
        out.writeInt(attr.getCombineRgbScale());
        out.writeInt(attr.getCombineAlphaScale());
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        TextureAttributes attr = (TextureAttributes)this.node;
        attr.setPerspectiveCorrectionMode(in.readInt());
        attr.setTextureBlendColor(this.control.readColor4f(in));
        int tableComponents = in.readInt();
        int tableSize = in.readInt();
        int[][] colorTable = new int[tableComponents][tableSize];
        for (int i = 0; i < tableComponents; ++i) {
            for (int j = 0; j < tableSize; ++j) {
                colorTable[i][j] = in.readInt();
            }
        }
        if (tableComponents != 0) {
            attr.setTextureColorTable(colorTable);
        }
        attr.setTextureMode(in.readInt());
        Matrix4d mat = this.control.readMatrix4d(in);
        Transform3D trans = new Transform3D(mat);
        attr.setTextureTransform(trans);
        attr.setCombineRgbMode(in.readInt());
        attr.setCombineAlphaMode(in.readInt());
        for (int i = 0; i < 2; ++i) {
            attr.setCombineRgbSource(i, in.readInt());
            attr.setCombineAlphaSource(i, in.readInt());
            attr.setCombineRgbFunction(i, in.readInt());
            attr.setCombineAlphaFunction(i, in.readInt());
        }
        attr.setCombineRgbScale(in.readInt());
        attr.setCombineAlphaScale(in.readInt());
    }

    @Override
    protected SceneGraphObject createNode() {
        return new TextureAttributes();
    }
}

