/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.internal;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.scijava.java3d.J3DBuffer;
import org.scijava.java3d.internal.BufferWrapper;

public class FloatBufferWrapper
extends BufferWrapper {
    private FloatBuffer buffer = null;

    public FloatBufferWrapper(FloatBuffer buffer) {
        this.buffer = buffer;
    }

    public FloatBufferWrapper(J3DBuffer b) {
        this.buffer = (FloatBuffer)b.getBuffer();
    }

    @Override
    public Buffer getBuffer() {
        return this.buffer;
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public float get() {
        return this.buffer.get();
    }

    public float get(int index) {
        return this.buffer.get(index);
    }

    public FloatBufferWrapper get(float[] dst) {
        this.buffer.get(dst);
        return this;
    }

    public FloatBufferWrapper get(float[] dst, int offset, int length) {
        this.buffer.get(dst, offset, length);
        return this;
    }

    public FloatBufferWrapper put(float[] src) {
        this.buffer.put(src);
        return this;
    }

    public J3DBuffer getJ3DBuffer() {
        return new J3DBuffer(this.buffer);
    }
}

