/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform.inverse;

import net.imglib2.realtransform.inverse.DifferentiableRealTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BacktrackingLineSearch {
    double[] target;
    double[] x;
    double[] y;
    double fx;
    double[] x_ap;
    double[] y_ap;
    double[] dir;
    double currentSquaredError;
    private final int nd;
    private DifferentiableRealTransform fwdXfm;
    private int maxIters = 1000;
    private double eps = 0.1;
    private double epsSquared = this.eps * this.eps;
    private double c = 0.5;
    private double beta = 0.5;
    private double initStepSize = 10.0;
    private int lineSearchMaxTries = 16;
    protected static Logger logger = LoggerFactory.getLogger(BacktrackingLineSearch.class);

    public BacktrackingLineSearch(int nd) {
        this.nd = nd;
        this.y = new double[nd];
        this.x_ap = new double[nd];
        this.y_ap = new double[nd];
    }

    public BacktrackingLineSearch(DifferentiableRealTransform fwdXfm) {
        this.fwdXfm = fwdXfm;
        this.nd = fwdXfm.numSourceDimensions();
        this.y = new double[this.nd];
        this.x_ap = new double[this.nd];
        this.y_ap = new double[this.nd];
    }

    public void setForwardTransform(DifferentiableRealTransform fwdXfm) {
        assert (fwdXfm.numSourceDimensions() == this.nd);
        this.fwdXfm = fwdXfm;
    }

    public void setC(double c) {
        this.c = c;
    }

    public void setBeta(double beta) {
        this.beta = beta;
    }

    public void setInitStep(double initStepSize) {
        this.initStepSize = initStepSize;
    }

    public void setMaxIterations(int maxIters) {
        this.maxIters = maxIters;
    }

    public void setMaxLineSearchTries(int lineSearchMaxTries) {
        this.lineSearchMaxTries = lineSearchMaxTries;
    }

    public void setEpsilon(double eps) {
        this.eps = eps;
        this.epsSquared = eps * eps;
    }

    public void setEstimate(double[] est) {
        this.x = est;
        this.fwdXfm.apply(this.x, this.y);
        this.fx = this.squaredError(this.y);
    }

    public void setTarget(double[] tgt) {
        this.target = tgt;
    }

    public void setDirection(double[] dir) {
        this.dir = dir;
        double mag = this.dirMag();
        for (int i = 0; i < this.nd; ++i) {
            dir[i] = dir[i] / mag;
        }
    }

    public double squaredError(double[] estimate) {
        double squaredError = 0.0;
        for (int d = 0; d < this.nd; ++d) {
            squaredError += (estimate[d] - this.target[d]) * (estimate[d] - this.target[d]);
        }
        return squaredError;
    }

    public double squaredErrorAt(double[] source) {
        double[] srcXfm = new double[this.nd];
        this.fwdXfm.apply(source, srcXfm);
        double squaredError = 0.0;
        for (int d = 0; d < this.nd; ++d) {
            squaredError += (srcXfm[d] - this.target[d]) * (srcXfm[d] - this.target[d]);
        }
        return squaredError;
    }

    public double dirMag() {
        double mag = 0.0;
        for (int i = 0; i < this.nd; ++i) {
            mag += this.dir[i] * this.dir[i];
        }
        return Math.sqrt(mag);
    }

    public double backtrackingLineSearch(double c, double beta, int maxtries, double t0) {
        double t = t0;
        for (int k = 0; k < maxtries && !this.armijoCondition(c, t); ++k) {
            t *= beta;
        }
        return t;
    }

    private double sumSquaredErrorsDeriv(double[] y, double[] x) {
        double errDeriv = 0.0;
        for (int i = 0; i < this.nd; ++i) {
            errDeriv += (y[i] - x[i]) * (y[i] - x[i]);
        }
        return 2.0 * errDeriv;
    }

    private boolean armijoCondition(double c, double t) {
        for (int i = 0; i < this.x.length; ++i) {
            this.x_ap[i] = this.x[i] + t * this.dir[i];
        }
        this.fwdXfm.apply(this.x_ap, this.y_ap);
        double fx_ap = this.squaredError(this.y_ap);
        double m = 1.0;
        if (fx_ap < this.fx - c * t * m) {
            this.currentSquaredError = fx_ap;
            return true;
        }
        return false;
    }

    public double iterativeInverse(double[] source, double[] destination) {
        this.target = destination;
        double stepSize = this.initStepSize;
        double[] tmp = new double[this.nd];
        double[] tmpsrc = new double[this.nd];
        double[] displacement = new double[this.nd];
        double olderror = Double.MAX_VALUE;
        double currentError = 0.0;
        for (int i = 0; i < this.maxIters; ++i) {
            stepSize = this.initStepSize;
            this.setEstimate(source);
            this.fwdXfm.directionToward(displacement, source, destination);
            this.setDirection(displacement);
            stepSize = this.backtrackingLineSearch(this.c, this.beta, this.lineSearchMaxTries, stepSize);
            for (int d = 0; d < this.nd; ++d) {
                tmpsrc[d] = source[d] + stepSize * displacement[d];
            }
            this.fwdXfm.apply(tmpsrc, tmp);
            currentError = this.squaredError(tmp);
            if (currentError > olderror) {
                return Math.sqrt(currentError);
            }
            System.arraycopy(tmpsrc, 0, source, 0, source.length);
            olderror = currentError;
            if (currentError < this.epsSquared) break;
        }
        this.currentSquaredError = currentError;
        return Math.sqrt(currentError);
    }

    public double getLastSquaredError() {
        return this.currentSquaredError;
    }

    public double getLastError() {
        return Math.sqrt(this.currentSquaredError);
    }
}

