/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.RealTransform;

public class RealTransformRealRandomAccessible<T, R extends RealTransform>
implements RealRandomAccessible<T> {
    protected final RealRandomAccessible<T> source;
    protected final R transformToSource;

    public RealTransformRealRandomAccessible(RealRandomAccessible<T> source, R transformToSource) {
        assert (source.numDimensions() == transformToSource.numTargetDimensions());
        this.source = source;
        this.transformToSource = transformToSource;
    }

    public int numDimensions() {
        return this.transformToSource.numSourceDimensions();
    }

    public RealTransformRealRandomAccess realRandomAccess() {
        return new RealTransformRealRandomAccess();
    }

    public RealTransformRealRandomAccess realRandomAccess(RealInterval interval) {
        return this.realRandomAccess();
    }

    public RealRandomAccessible<T> getSource() {
        return this.source;
    }

    public R getTransformToSource() {
        return this.transformToSource;
    }

    public T getType() {
        return (T)this.source.getType();
    }

    public class RealTransformRealRandomAccess
    extends RealPoint
    implements RealRandomAccess<T> {
        protected final RealRandomAccess<T> sourceAccess;
        protected final R transformCopy;

        protected RealTransformRealRandomAccess() {
            super(RealTransformRealRandomAccessible.this.transformToSource.numSourceDimensions());
            this.sourceAccess = RealTransformRealRandomAccessible.this.source.realRandomAccess();
            this.transformCopy = RealTransformRealRandomAccessible.this.transformToSource.copy();
        }

        private RealTransformRealRandomAccess(RealTransformRealRandomAccess a) {
            super((RealLocalizable)a);
            this.sourceAccess = a.sourceAccess.copy();
            this.transformCopy = a.transformCopy.copy();
        }

        protected final void apply() {
            this.transformCopy.apply((RealLocalizable)this, (RealPositionable)this.sourceAccess);
        }

        public T get() {
            this.apply();
            return this.sourceAccess.get();
        }

        public T getType() {
            return this.sourceAccess.getType();
        }

        public RealTransformRealRandomAccess copy() {
            return new RealTransformRealRandomAccess(this);
        }
    }
}

