/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.InterpolatedRealTransform;
import net.imglib2.realtransform.RealTransform;

public class ClippedTransitionRealTransform
implements RealTransform {
    private final InterpolatedRealTransform interpolant;
    private final double transitionOffset;
    private final double transitionScale;
    private final int maxN;

    private ClippedTransitionRealTransform(InterpolatedRealTransform interpolant, double transitionOffset, double transitionScale) {
        this.interpolant = interpolant;
        this.transitionOffset = transitionOffset;
        this.transitionScale = transitionScale;
        this.maxN = interpolant.numSourceDimensions();
    }

    public ClippedTransitionRealTransform(RealTransform a, RealTransform b, double min, double max) {
        this(new InterpolatedRealTransform(a, b, 1.0), min, 1.0 / (max - min));
    }

    @Override
    public int numSourceDimensions() {
        return this.interpolant.numSourceDimensions() + 1;
    }

    @Override
    public int numTargetDimensions() {
        return this.numSourceDimensions();
    }

    private final double lambda(double position) {
        return Math.max(0.0, Math.min(1.0, 1.0 - (position - this.transitionOffset) * this.transitionScale));
    }

    @Override
    public void apply(double[] source, double[] target) {
        this.interpolant.setLambda(this.lambda(source[this.maxN]));
        this.interpolant.apply(source, target);
        target[this.maxN] = source[this.maxN];
    }

    @Override
    public void apply(float[] source, float[] target) {
        this.interpolant.setLambda(this.lambda(source[this.maxN]));
        this.interpolant.apply(source, target);
        target[this.maxN] = source[this.maxN];
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        double z = source.getDoublePosition(this.maxN);
        this.interpolant.setLambda(this.lambda(z));
        this.interpolant.apply(source, target);
        target.setPosition(z, this.maxN);
    }

    @Override
    public ClippedTransitionRealTransform copy() {
        return new ClippedTransitionRealTransform(this.interpolant.copy(), this.transitionOffset, this.transitionScale);
    }
}

