/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import loci.formats.FormatException;
import loci.formats.MetadataTools;
import loci.formats.in.DeltavisionReader;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;

public class RCPNLReader
extends DeltavisionReader {
    public RCPNLReader() {
        this.format = "RCPNL";
        this.suffixes = new String[]{"rcpnl"};
        this.suffixNecessary = true;
        this.hasCompanionFiles = false;
        this.positionInT = true;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        return RCPNLReader.checkSuffix((String)name, (String)"rcpnl") && super.isThisType(name, open);
    }

    @Override
    protected void populateObjective(MetadataStore store, int lensID) throws FormatException {
        super.populateObjective(store, lensID);
        switch (lensID) {
            case 18107: {
                store.setObjectiveNominalMagnification(Double.valueOf(10.0), 0, 0);
                store.setObjectiveLensNA(Double.valueOf(0.3), 0, 0);
                store.setObjectiveWorkingDistance(new Length((Number)15.0, UNITS.MILLIMETER), 0, 0);
                store.setObjectiveImmersion(MetadataTools.getImmersion((String)"Air"), 0, 0);
                store.setObjectiveCorrection(MetadataTools.getCorrection((String)"PlanFluor"), 0, 0);
                store.setObjectiveManufacturer("Nikon", 0, 0);
                break;
            }
            case 18108: {
                store.setObjectiveNominalMagnification(Double.valueOf(20.0), 0, 0);
                store.setObjectiveLensNA(Double.valueOf(0.75), 0, 0);
                store.setObjectiveCorrection(MetadataTools.getCorrection((String)"PlanApo"), 0, 0);
                store.setObjectiveManufacturer("Nikon", 0, 0);
                break;
            }
            case 18109: {
                store.setObjectiveNominalMagnification(Double.valueOf(40.0), 0, 0);
                store.setObjectiveLensNA(Double.valueOf(0.95), 0, 0);
                store.setObjectiveCorrection(MetadataTools.getCorrection((String)"PlanApo"), 0, 0);
                store.setObjectiveManufacturer("Nikon", 0, 0);
                break;
            }
            case 18110: {
                store.setObjectiveNominalMagnification(Double.valueOf(40.0), 0, 0);
                store.setObjectiveLensNA(Double.valueOf(0.6), 0, 0);
                store.setObjectiveCorrection(MetadataTools.getCorrection((String)"PlanFluor"), 0, 0);
                store.setObjectiveManufacturer("Nikon", 0, 0);
                break;
            }
            case 18111: {
                store.setObjectiveNominalMagnification(Double.valueOf(4.0), 0, 0);
                store.setObjectiveLensNA(Double.valueOf(0.2), 0, 0);
                store.setObjectiveCorrection(MetadataTools.getCorrection((String)"PlanApo"), 0, 0);
                store.setObjectiveManufacturer("Nikon", 0, 0);
                break;
            }
            case 18112: {
                store.setObjectiveNominalMagnification(Double.valueOf(20.0), 0, 0);
                store.setObjectiveLensNA(Double.valueOf(0.8), 0, 0);
                store.setObjectiveWorkingDistance(new Length((Number)0.8, UNITS.MILLIMETER), 0, 0);
                store.setObjectiveImmersion(MetadataTools.getImmersion((String)"Air"), 0, 0);
                store.setObjectiveCorrection(MetadataTools.getCorrection((String)"PlanApo"), 0, 0);
                store.setObjectiveManufacturer("Nikon", 0, 0);
            }
        }
    }
}

