/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.gui.Toolbar;
import ij.io.OpenDialog;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.MacroRunner;
import ij.macro.Program;
import ij.macro.Symbol;
import ij.macro.Tokenizer;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Recorder;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class MacroInstaller
implements PlugIn,
MacroConstants,
ActionListener {
    public static final int MAX_SIZE = 28000;
    public static final int MAX_MACROS = 100;
    public static final int XINC = 10;
    public static final int YINC = 18;
    public static final char commandPrefix = '^';
    static final String commandPrefixS = "^";
    static final int MACROS_MENU_COMMANDS = 7;
    private ArrayList<String> macroNames = new ArrayList();
    private ArrayList<Integer> macroStarts = new ArrayList();
    private MenuBar mb = new MenuBar();
    private int nMacros;
    private Program pgm;
    private boolean firstEvent = true;
    private String shortcutsInUse;
    private int inUseCount;
    private int nShortcuts;
    private int toolCount;
    private String text;
    private String anonymousName;
    private Menu macrosMenu;
    private boolean menuReset;
    private int autoRunCount;
    private int autoRunAndHideCount;
    private boolean openingStartupMacrosInEditor;
    private boolean installTools = true;
    private static String defaultDir;
    private static String fileName;
    private static MacroInstaller instance;
    private static MacroInstaller listener;
    private Thread macroToolThread;
    private ArrayList<Menu> subMenus = new ArrayList();
    private static Program autoRunPgm;
    private static int autoRunAddress;
    private static String autoRunName;
    private boolean autoRunOnCurrentThread;

    @Override
    public void run(String path) {
        if (path == null || path.equals("")) {
            path = this.showDialog();
        }
        if (path == null) {
            return;
        }
        this.openingStartupMacrosInEditor = path.indexOf("StartupMacros") != -1;
        String text = this.open(path);
        if (text != null) {
            String functions = Interpreter.getAdditionalFunctions();
            if (functions != null) {
                text = !text.endsWith("\n") && !functions.startsWith("\n") ? text + "\n" + functions : text + functions;
            }
            this.install(text);
        }
    }

    void install() {
        String word;
        this.subMenus.clear();
        if (this.text != null) {
            Tokenizer tok = new Tokenizer();
            this.pgm = tok.tokenize(this.text);
        }
        if (this.macrosMenu != null) {
            IJ.showStatus("");
        }
        int[] code = this.pgm.getCode();
        Symbol[] symbolTable = this.pgm.getSymbolTable();
        int count = 0;
        this.shortcutsInUse = null;
        this.inUseCount = 0;
        this.nShortcuts = 0;
        this.toolCount = 0;
        boolean isPluginsMacrosMenu = false;
        if (this.macrosMenu != null) {
            isPluginsMacrosMenu = this.macrosMenu == Menus.getMacrosMenu();
        }
        this.menuReset = false;
        if (this.pgm.hasVars() && this.pgm.macroCount() > 0 && this.pgm.getGlobals() == null) {
            new Interpreter().saveGlobals(this.pgm);
        }
        ArrayList<String> tools = new ArrayList<String>();
        for (int i = 0; i < code.length; ++i) {
            int token = code[i] & 0xFFF;
            if (token == 200) {
                boolean inSubMenu;
                boolean isTool;
                int nextToken = code[i + 1] & 0xFFF;
                if (nextToken != 133) continue;
                int address = code[i + 1] >> 12;
                Symbol symbol = symbolTable[address];
                String name = symbol.str;
                boolean bl = isTool = name.contains("-") && (name.contains("Tool") || name.contains("tool"));
                if (!isTool && !name.contains("Tool Options")) {
                    ++count;
                }
                this.macroNames.add(name);
                this.macroStarts.add(i + 2);
                if (isTool) {
                    tools.add(name);
                    ++this.toolCount;
                    continue;
                }
                if (name.startsWith("AutoRun")) {
                    if (this.autoRunCount == 0 && !this.openingStartupMacrosInEditor && !IJ.isMacro()) {
                        int codeAddress = this.macroStarts.get(this.macroStarts.size() - 1);
                        if (this.autoRunOnCurrentThread) {
                            autoRunPgm = this.pgm;
                            autoRunAddress = codeAddress;
                            autoRunName = name;
                        } else {
                            new MacroRunner(this.pgm, codeAddress, name, (String)null);
                        }
                        if (name.equals("AutoRunAndHide")) {
                            ++this.autoRunAndHideCount;
                        }
                    }
                    ++this.autoRunCount;
                    --count;
                    continue;
                }
                if (name.equals("Popup Menu")) {
                    this.installPopupMenu(name, this.pgm);
                    continue;
                }
                if (name.endsWith("Tool Selected") || this.macrosMenu == null) continue;
                this.addShortcut(name);
                int pos = name.indexOf(">");
                boolean bl2 = inSubMenu = name.startsWith("<") && pos > 1;
                if (inSubMenu) {
                    this.resetMenu(isPluginsMacrosMenu);
                    Menu parent = this.macrosMenu;
                    Menu subMenu = null;
                    String parentStr = name.substring(1, pos).trim();
                    String childStr = name.substring(pos + 1).trim();
                    MenuItem mnuItem = new MenuItem();
                    mnuItem.setActionCommand(name);
                    mnuItem.setLabel(childStr);
                    for (int jj = 0; jj < this.subMenus.size(); ++jj) {
                        String aName = this.subMenus.get(jj).getName();
                        if (!aName.equals(parentStr)) continue;
                        subMenu = this.subMenus.get(jj);
                    }
                    if (subMenu == null) {
                        subMenu = new Menu(parentStr);
                        subMenu.setName(parentStr);
                        subMenu.addActionListener(this);
                        this.subMenus.add(subMenu);
                        parent.add(subMenu);
                        ++count;
                    }
                    subMenu.add(mnuItem);
                    continue;
                }
                if (name.contains("Tool Options") && isPluginsMacrosMenu) continue;
                this.resetMenu(isPluginsMacrosMenu);
                this.macrosMenu.add(new MenuItem(name));
                continue;
            }
            if (token == 128) break;
        }
        this.nMacros = count;
        if (this.toolCount > 0 && this.installTools) {
            Toolbar tb = Toolbar.getInstance();
            if (this.toolCount == 1) {
                tb.addMacroTool((String)tools.get(0), this);
            } else {
                for (int i = 0; i < tools.size(); ++i) {
                    String toolName = (String)tools.get(i);
                    if (toolName.startsWith("Abort Macro or Plugin") && this.toolCount > 6) {
                        toolName = "Unused " + toolName;
                    }
                    tb.addMacroTool(toolName, this, i);
                }
            }
            if (this.toolCount > 1 && Toolbar.getToolId() >= 15) {
                tb.setTool(0);
            }
            tb.repaint();
            this.installTools = false;
        }
        if (this.macrosMenu != null && this.nMacros > 0) {
            instance = this;
        }
        if (this.shortcutsInUse != null && this.text != null) {
            IJ.showMessage("Install Macros", (this.inUseCount == 1 ? "This keyboard shortcut is" : "These keyboard shortcuts are") + " already in use:" + this.shortcutsInUse);
        }
        if (this.nMacros == 0 && this.toolCount == 0 && fileName != null) {
            if (this.text == null || this.text.length() == 0) {
                return;
            }
            int dotIndex = fileName.lastIndexOf(46);
            this.anonymousName = dotIndex > 0 ? fileName.substring(0, dotIndex) : fileName;
            if (this.macrosMenu != null) {
                this.resetMenu(isPluginsMacrosMenu);
                this.macrosMenu.add(new MenuItem(this.anonymousName));
                instance = this;
            }
            this.macroNames.add(this.anonymousName);
            this.nMacros = 1;
        }
        String string = word = this.nMacros == 1 ? " macro" : " macros";
        if (isPluginsMacrosMenu) {
            IJ.showStatus(this.nMacros + word + " installed");
        }
    }

    private void resetMenu(boolean isPluginsMacrosMenu) {
        int baseCount;
        if (this.menuReset || this.macrosMenu == null) {
            return;
        }
        int itemCount = this.macrosMenu.getItemCount();
        int n = baseCount = isPluginsMacrosMenu ? 7 : 15;
        if (itemCount > baseCount) {
            for (int i = itemCount - 1; i >= baseCount; --i) {
                this.macrosMenu.remove(i);
            }
        }
        this.menuReset = true;
    }

    public int install(String text) {
        if (text == null && this.pgm == null) {
            return 0;
        }
        this.text = text;
        this.macrosMenu = Menus.getMacrosMenu();
        if (listener != null) {
            this.macrosMenu.removeActionListener(listener);
        }
        this.macrosMenu.addActionListener(this);
        listener = this;
        this.install();
        return this.nShortcuts;
    }

    public int install(String text, Menu menu) {
        this.text = text;
        this.macrosMenu = menu;
        this.install();
        return this.nShortcuts;
    }

    public void installFile(String path) {
        Toolbar tb;
        String text = this.open(path);
        if (text == null) {
            return;
        }
        boolean isStartupMacros = path.contains("StartupMacros");
        if (isStartupMacros && !Toolbar.installStartupMacrosTools()) {
            this.installTools = false;
        }
        this.install(text);
        this.installTools = true;
        if (isStartupMacros && (tb = Toolbar.getInstance()) != null) {
            tb.installStartupTools();
        }
    }

    public void installTool(String path) {
        String text = this.open(path);
        if (text != null) {
            this.installSingleTool(text);
        }
    }

    public void installLibrary(String path) {
        String text = this.open(path);
        if (text != null) {
            Interpreter.setAdditionalFunctions(text);
        }
    }

    public static void installFromJar(String path) {
        try {
            new MacroInstaller().installFromIJJar(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void installFromIJJar(String path) {
        String text;
        boolean installMacros = false;
        if (path.endsWith("MenuTool.txt+")) {
            path = path.substring(0, path.length() - 1);
            installMacros = true;
        }
        if ((text = this.openFromIJJar(path)) == null) {
            return;
        }
        if (path.endsWith("StartupMacros.txt")) {
            Toolbar tb;
            if (Toolbar.installStartupMacrosTools()) {
                this.install(text);
            }
            if ((tb = Toolbar.getInstance()) != null) {
                tb.installStartupTools();
            }
        } else if (path.contains("Tools") || installMacros) {
            this.install(text);
        } else {
            this.installSingleTool(text);
        }
    }

    public void installSingleTool(String text) {
        this.text = text;
        this.macrosMenu = null;
        this.install();
    }

    void installPopupMenu(String name, Program pgm) {
        Hashtable h = pgm.getMenus();
        if (h == null) {
            return;
        }
        String[] commands = (String[])h.get(name);
        if (commands == null) {
            return;
        }
        PopupMenu popup = Menus.getPopupMenu();
        if (popup == null) {
            return;
        }
        popup.removeAll();
        for (int i = 0; i < commands.length; ++i) {
            if (commands[i].equals("-")) {
                popup.addSeparator();
                continue;
            }
            MenuItem mi = new MenuItem(commands[i]);
            mi.addActionListener(this);
            popup.add(mi);
        }
    }

    void removeShortcuts() {
        Menus.getMacroShortcuts().clear();
        Hashtable shortcuts = Menus.getShortcuts();
        Enumeration en = shortcuts.keys();
        while (en.hasMoreElements()) {
            Integer key = (Integer)en.nextElement();
            String value = (String)shortcuts.get(key);
            if (value.charAt(0) != '^') continue;
            shortcuts.remove(key);
        }
    }

    void addShortcut(String name) {
        Hashtable shortcuts;
        int code;
        int index1;
        if (IJ.debugMode) {
            IJ.log("addShortcut: " + name);
        }
        if ((index1 = name.indexOf(91)) == -1) {
            return;
        }
        int index2 = name.lastIndexOf(93);
        if (index2 <= index1 + 1) {
            return;
        }
        String shortcut = name.substring(index1 + 1, index2);
        int len = shortcut.length();
        if (len > 1) {
            shortcut = shortcut.toUpperCase(Locale.US);
        }
        if (len > 3 || len > 1 && shortcut.charAt(0) != 'F' && shortcut.charAt(0) != 'N' && shortcut.charAt(0) != '&') {
            return;
        }
        boolean bothNumKeys = shortcut.startsWith("&");
        if (bothNumKeys) {
            shortcut = shortcut.replace("&", "");
            len = shortcut.length();
        }
        if ((code = Menus.convertShortcutToCode(shortcut)) == 0) {
            return;
        }
        if (this.nShortcuts == 0) {
            this.removeShortcuts();
        }
        if (len == 1 || shortcut.equals("N+") || shortcut.equals("N-")) {
            Hashtable macroShortcuts = Menus.getMacroShortcuts();
            macroShortcuts.put(code, '^' + name);
            ++this.nShortcuts;
            if (!bothNumKeys) {
                return;
            }
        }
        if (bothNumKeys) {
            shortcut = "N" + shortcut;
            code = Menus.convertShortcutToCode(shortcut);
        }
        if ((shortcuts = Menus.getShortcuts()).get(code) != null) {
            if (this.shortcutsInUse == null) {
                this.shortcutsInUse = "\n \n";
            }
            this.shortcutsInUse = this.shortcutsInUse + "\t  " + name + "\n";
            ++this.inUseCount;
            return;
        }
        shortcuts.put(code, '^' + name);
        ++this.nShortcuts;
    }

    String showDialog() {
        OpenDialog od;
        String name;
        if (defaultDir == null) {
            defaultDir = Menus.getMacrosPath();
        }
        if ((name = (od = new OpenDialog("Install Macros", defaultDir, fileName)).getFileName()) == null) {
            return null;
        }
        String dir = od.getDirectory();
        if (!name.endsWith(".txt") && !name.endsWith(".ijm")) {
            IJ.showMessage("Macro Installer", "File name must end with \".txt\" or \".ijm\" .");
            return null;
        }
        fileName = name;
        defaultDir = dir;
        return dir + name;
    }

    String open(String path) {
        if (path == null) {
            return null;
        }
        try {
            String s;
            StringBuffer sb = new StringBuffer(5000);
            BufferedReader r = new BufferedReader(new FileReader(path));
            while ((s = r.readLine()) != null) {
                sb.append(s + "\n");
            }
            r.close();
            return new String(sb);
        }
        catch (Exception e) {
            IJ.error(e.getMessage());
            return null;
        }
    }

    public String openFromIJJar(String path) {
        String text = null;
        try {
            int n;
            InputStream is = this.getClass().getResourceAsStream(path);
            if (is == null) {
                return null;
            }
            InputStreamReader isr = new InputStreamReader(is);
            StringBuffer sb = new StringBuffer();
            char[] b = new char[8192];
            while ((n = isr.read(b)) > 0) {
                sb.append(b, 0, n);
            }
            text = sb.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return text;
    }

    public boolean runMacroTool(String name) {
        for (int i = 0; i < this.macroNames.size(); ++i) {
            if (!this.macroNames.get(i).startsWith(name)) continue;
            if (this.macroToolThread != null && this.macroToolThread.getName().indexOf(name) != -1 && this.macroToolThread.isAlive()) {
                return false;
            }
            MacroRunner mw = new MacroRunner(this.pgm, (int)this.macroStarts.get(i), name, (String)null);
            this.macroToolThread = mw.getThread();
            return true;
        }
        return false;
    }

    public boolean runMenuTool(String name, String command) {
        for (int i = 0; i < this.macroNames.size(); ++i) {
            if (!this.macroNames.get(i).startsWith(name)) continue;
            Recorder.recordInMacros = true;
            new MacroRunner(this.pgm, (int)this.macroStarts.get(i), name, command);
            return true;
        }
        return false;
    }

    public static boolean runMacroCommand(String name) {
        if (instance == null) {
            return false;
        }
        if (name.startsWith(commandPrefixS)) {
            name = name.substring(1);
        }
        for (int i = 0; i < MacroInstaller.instance.macroNames.size(); ++i) {
            if (!name.equals(MacroInstaller.instance.macroNames.get(i))) continue;
            MacroRunner mm = new MacroRunner();
            mm.run(MacroInstaller.instance.pgm, MacroInstaller.instance.macroStarts.get(i), name);
            return true;
        }
        return false;
    }

    public static boolean isMacroCommand(String name) {
        if (instance == null) {
            return false;
        }
        if (name.startsWith(commandPrefixS)) {
            name = name.substring(1);
        }
        for (int i = 0; i < MacroInstaller.instance.macroNames.size(); ++i) {
            if (!name.equals(MacroInstaller.instance.macroNames.get(i))) continue;
            return true;
        }
        return false;
    }

    public static void runMacroShortcut(String name) {
        if (instance == null) {
            return;
        }
        if (name.startsWith(commandPrefixS)) {
            name = name.substring(1);
        }
        for (int i = 0; i < MacroInstaller.instance.macroNames.size(); ++i) {
            if (!name.equals(MacroInstaller.instance.macroNames.get(i))) continue;
            new MacroRunner().runShortcut(MacroInstaller.instance.pgm, MacroInstaller.instance.macroStarts.get(i), name);
            return;
        }
    }

    public void runMacro(String name) {
        this.runMacro(name, null);
    }

    public void runMacro(String name, Editor editor) {
        if (this.anonymousName != null && name.equals(this.anonymousName)) {
            ImageJ.setCommandName(name);
            new MacroRunner(this.pgm, 0, this.anonymousName, editor);
            return;
        }
        for (int i = 0; i < this.macroNames.size(); ++i) {
            if (!name.equals(this.macroNames.get(i))) continue;
            ImageJ.setCommandName(name);
            Interpreter.abort();
            new MacroRunner(this.pgm, (int)this.macroStarts.get(i), name, editor);
            return;
        }
    }

    public int getMacroCount() {
        return this.macroNames.size();
    }

    public Program getProgram() {
        return this.pgm;
    }

    public boolean isAutoRunAndHide() {
        return this.autoRunAndHideCount > 0;
    }

    public void setFileName(String fileName) {
        MacroInstaller.fileName = fileName;
        this.openingStartupMacrosInEditor = fileName.startsWith("StartupMacros");
    }

    public static String getFileName() {
        return fileName;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        ImageJ.setCommandName(cmd);
        MenuItem item = (MenuItem)evt.getSource();
        MenuContainer parent = item.getParent();
        if (parent instanceof PopupMenu) {
            for (int i = 0; i < this.macroNames.size(); ++i) {
                if (!this.macroNames.get(i).equals("Popup Menu")) continue;
                new MacroRunner(this.pgm, (int)this.macroStarts.get(i), "Popup Menu", cmd);
                return;
            }
        }
        instance.runMacro(cmd);
    }

    public void installStartupMacros(String path) {
        this.autoRunOnCurrentThread = true;
        this.installFile(path);
        this.autoRunOnCurrentThread = false;
    }

    public static void autoRun() {
        if (autoRunPgm != null) {
            new MacroRunner().run(autoRunPgm, autoRunAddress, autoRunName);
        }
        autoRunPgm = null;
    }

    public String toString() {
        return "MacroInstaller[size=" + this.macroNames.size() + (this.macroNames.size() > 0 ? "," + this.macroNames.get(0) : "") + "]";
    }
}

