/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import net.imglib2.type.label.Label;
import net.imglib2.type.label.LabelMultisetEntry;
import net.imglib2.type.label.LabelMultisetEntryList;
import net.imglib2.type.label.LabelMultisetType;
import net.imglib2.type.label.LongMappedAccessData;
import net.imglib2.type.label.Multiset;

public class LabelMultiset
implements Multiset<Label> {
    private final LabelMultisetEntryList entries;
    private final int totalSize;
    private final Set<LabelMultisetType.Entry<Label>> entrySet = new AbstractSet<LabelMultisetType.Entry<Label>>(){

        @Override
        public Iterator<LabelMultisetType.Entry<Label>> iterator() {
            return new Iterator<LabelMultisetType.Entry<Label>>(){
                private int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < this.size();
                }

                @Override
                public LabelMultisetEntry next() {
                    return (LabelMultisetEntry)LabelMultiset.this.entries.get(this.i++);
                }
            };
        }

        @Override
        public int size() {
            return LabelMultiset.this.entries.size();
        }
    };

    public LabelMultiset(LabelMultisetEntryList entries) {
        this.entries = entries;
        int s = 0;
        for (LabelMultisetEntry entry : entries) {
            s += entry.getCount();
        }
        this.totalSize = s;
    }

    public LabelMultiset(LabelMultisetEntryList entries, int size) {
        this.entries = entries;
        this.totalSize = size;
    }

    protected LabelMultiset(int size) {
        this.entries = new LabelMultisetEntryList();
        this.totalSize = size;
    }

    protected void referToDataAt(LongMappedAccessData data, long baseOffset) {
        this.entries.referToDataAt(data, baseOffset);
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Label && this.entries.binarySearch(((Label)o).id()) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int count(Label l) {
        int pos = this.entries.binarySearch(l.id());
        if (pos < 0) {
            return 0;
        }
        return ((LabelMultisetEntry)this.entries.get(pos)).getCount();
    }

    @Override
    public Set<LabelMultisetType.Entry<Label>> entrySet() {
        return this.entrySet;
    }

    public String toString() {
        return this.entries.toString();
    }

    @Override
    public Iterator<Label> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Label e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Label> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

