/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io;

import java.io.File;
import java.io.IOException;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.NamedObjectException;
import org.jogamp.java3d.utils.scenegraph.io.ObjectNotLoadedException;
import org.jogamp.java3d.utils.scenegraph.io.retained.RandomAccessFileControl;
import org.jogamp.java3d.utils.universe.ConfiguredUniverse;

public class SceneGraphFileReader {
    private RandomAccessFileControl fileControl = new RandomAccessFileControl();

    public SceneGraphFileReader(File file) throws IOException {
        this.fileControl.openFile(file);
    }

    public ConfiguredUniverse readUniverse(boolean attachBranchGraphs) throws IOException {
        return this.fileControl.readUniverse(attachBranchGraphs, null);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.fileControl.setClassLoader(classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.fileControl.getClassLoader();
    }

    public ConfiguredUniverse readUniverse(boolean attachBranchGraphs, Canvas3D canvas) throws IOException {
        return this.fileControl.readUniverse(attachBranchGraphs, canvas);
    }

    public Object readUserData() throws IOException {
        return this.fileControl.getUserData();
    }

    public String readDescription() throws IOException {
        return this.fileControl.readFileDescription();
    }

    public int getBranchGraphCount() {
        return this.fileControl.getBranchGraphCount();
    }

    public BranchGroup[] readBranchGraph(int index) throws IOException {
        return this.fileControl.readBranchGraph(index);
    }

    public BranchGroup[] readAllBranchGraphs() throws IOException {
        return this.fileControl.readAllBranchGraphs();
    }

    public void dereferenceBranchGraph(BranchGroup graph) {
        throw new RuntimeException("Not implemented");
    }

    public int getBranchGraphPosition(BranchGroup graph) {
        return this.fileControl.getBranchGraphPosition(graph);
    }

    public Object readBranchGraphUserData(int index) throws IOException {
        return this.fileControl.readBranchGraphUserData(index);
    }

    public String[] getNames() {
        return this.fileControl.getNames();
    }

    public SceneGraphObject getNamedObject(String name) throws NamedObjectException, ObjectNotLoadedException {
        return this.fileControl.getNamedObject(name);
    }

    public void close() throws IOException {
        this.fileControl.close();
    }
}

