/*
 * Decompiled with CFR 0.152.
 */
package vib.oldregistration;

import java.util.Arrays;
import java.util.Comparator;
import vib.transforms.FastMatrixTransform;

class PrincipalComponents {
    public double[][] vectors;
    public double[] values;
    public double[] meanXYZ;
    public FastMatrixTransform correctAspect;

    public String toString() {
        String result = "Means in each dimension: ( " + this.meanXYZ[0] + ", " + this.meanXYZ[1] + ", " + this.meanXYZ[2] + ")\n";
        for (int i = 0; i < 3; ++i) {
            result = result + "  [ " + this.vectors[i][0] + ",   (eigenvalue: " + this.values[i] + ")\n";
            result = result + "    " + this.vectors[i][1] + ",\n";
            result = result + "    " + this.vectors[i][2] + " ]\n";
        }
        return result;
    }

    public PrincipalComponents(double[] values, double[][] vectors, double[] meanXYZ, double relativeSpacingX, double relativeSpacingY, double relativeSpacingZ) {
        int i;
        this.correctAspect = new FastMatrixTransform(1.0).scale(relativeSpacingX, relativeSpacingY, relativeSpacingZ);
        if (values.length != 3) {
            throw new IllegalArgumentException("There must be 3 eigenvalues (not " + values.length + ")");
        }
        Double[] boxedEigenValues = new Double[3];
        for (i = 0; i < 3; ++i) {
            boxedEigenValues[i] = values[i];
        }
        Arrays.sort(boxedEigenValues, new MagnitudeComparator());
        this.values = new double[3];
        for (i = 0; i < 3; ++i) {
            this.values[i] = boxedEigenValues[i];
        }
        if (vectors.length != 3 || vectors[0].length != 3 || vectors[1].length != 3 || vectors[2].length != 3) {
            throw new IllegalArgumentException("The eigenvecctors must be passed as double[3][3] array");
        }
        boolean[] vectorsFilled = new boolean[3];
        vectorsFilled[2] = false;
        vectorsFilled[1] = false;
        vectorsFilled[0] = false;
        this.vectors = new double[3][];
        for (int i2 = 0; i2 < 3; ++i2) {
            int j = 0;
            while (vectorsFilled[j] || this.values[j] != values[i2]) {
                ++j;
            }
            this.vectors[j] = (double[])vectors[i2].clone();
            vectorsFilled[j] = true;
        }
        if (meanXYZ.length != 3) {
            throw new IllegalArgumentException("There must be 3 mean values (not " + meanXYZ.length + ")");
        }
        this.meanXYZ = (double[])meanXYZ.clone();
        assert (this.values != null);
        assert (this.vectors[0] != null);
        assert (this.vectors[1] != null);
        assert (this.vectors[2] != null);
        assert (this.meanXYZ != null);
    }

    class MagnitudeComparator
    implements Comparator {
        MagnitudeComparator() {
        }

        public int compare(Object a, Object b) {
            double x = (Double)a;
            double y = (Double)b;
            return Double.compare(Math.abs(x), Math.abs(y));
        }
    }
}

