/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;

public class Visual_Grep
implements PlugInFilter {
    ImagePlus imp;
    float minDistance;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 144;
    }

    public void run(ImageProcessor ip) {
        int[] ids = WindowManager.getIDList();
        String[] idList = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            idList[i] = WindowManager.getImage((int)ids[i]).getTitle();
        }
        int level = 0;
        int w = ip.getWidth();
        while (w > 200) {
            w /= 2;
            ++level;
        }
        GenericDialog gd = new GenericDialog("Visual Grep");
        gd.addChoice("needle", idList, idList[0]);
        gd.addNumericField("tolerance", 5000.0, 0);
        gd.addNumericField("pyramidLevel", (double)level, 0);
        gd.addCheckbox("testDistance", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int needleIndex = ids[gd.getNextChoiceIndex()];
        ImagePlus needle = WindowManager.getImage((int)needleIndex);
        int tolerance = (int)gd.getNextNumber();
        level = (int)gd.getNextNumber();
        boolean testDistance = gd.getNextBoolean();
        if (testDistance) {
            this.testDistance(ip, needle.getProcessor(), level);
            return;
        }
        this.minDistance = Float.MAX_VALUE;
        ArrayList points = this.getPoints(ip, needle.getProcessor(), tolerance, level, level, null);
        if (points.size() == 0) {
            IJ.error((String)("No region found! Minimal tolerance needed: " + this.minDistance));
            return;
        }
        Roi roi = this.getRoi(points, needle.getWidth(), needle.getHeight());
        this.imp.setRoi(roi);
        this.imp.updateAndDraw();
    }

    void testDistance(ImageProcessor haystack, ImageProcessor needle, int level) {
        if (level > 0) {
            int factor = 1 << level;
            haystack = haystack.resize(haystack.getWidth() / factor, haystack.getHeight() / factor);
            needle = needle.resize(needle.getWidth() / factor, needle.getHeight() / factor);
        }
        int[] haystackPixels = (int[])haystack.getPixels();
        int[] needlePixels = (int[])needle.getPixels();
        int haystackW = haystack.getWidth();
        int haystackH = haystack.getHeight();
        int needleW = needle.getWidth();
        int needleH = needle.getHeight();
        int w = haystackW - needleW;
        int h = haystackH - needleH;
        float[] pixels = new float[w * h];
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                pixels[i + w * j] = this.distance(haystackPixels, i, j, haystackW, needlePixels, needleW, needleH);
            }
            IJ.showProgress((int)(j + 1), (int)h);
        }
        FloatProcessor fp = new FloatProcessor(w, h, pixels, null);
        new ImagePlus("distance", (ImageProcessor)fp).show();
    }

    ArrayList getPoints(ImageProcessor haystack, ImageProcessor needle, int tolerance, int level, int totalLevel, ArrayList initial) {
        int w = haystack.getWidth();
        int h = haystack.getHeight();
        int needleW = needle.getWidth();
        int needleH = needle.getHeight();
        ArrayList points = new ArrayList();
        int[] pixels = (int[])haystack.getPixels();
        int[] needlePixels = (int[])needle.getPixels();
        if (level > 0) {
            ArrayList<Point> scaledInitial = null;
            if (initial != null) {
                scaledInitial = new ArrayList<Point>();
                for (int i = 0; i < initial.size(); ++i) {
                    Point p = (Point)initial.get(i);
                    Point p2 = new Point(p.x / 2, p.y / 2, p.diff);
                    scaledInitial.add(p2);
                }
            }
            ImageProcessor scaledHaystack = haystack.resize(w / 2, h / 2);
            ImageProcessor scaledNeedle = needle.resize(needleW / 2, needleH / 2);
            initial = this.getPoints(scaledHaystack, scaledNeedle, tolerance, level - 1, totalLevel, scaledInitial);
            for (int i = 0; i < initial.size(); ++i) {
                Point p = (Point)initial.get(i);
                p.x *= 2;
                p.y *= 2;
                int xo = 2;
                int yo = 2;
                if (p.x + xo + needleW > w) {
                    xo = 1;
                }
                if (p.y + yo + needleH > h) {
                    yo = 1;
                }
                this.getPoints(points, pixels, w, needlePixels, needleW, needleH, p.x, p.y, p.x + xo, p.y + yo, tolerance, false);
            }
        } else {
            this.getPoints(points, pixels, w, needlePixels, needleW, needleH, 0, 0, w - needleW, h - needleH, tolerance, true);
        }
        IJ.showProgress((int)(level + 1), (int)totalLevel);
        return points;
    }

    void getPoints(ArrayList points, int[] pixels, int row, int[] needle, int needleW, int needleH, int x1, int y1, int x2, int y2, int tolerance, boolean showProgress) {
        for (int y = y1; y < y2; ++y) {
            for (int x = x1; x < x2; ++x) {
                float d = this.distance(pixels, x, y, row, needle, needleW, needleH);
                if (!(d < (float)tolerance)) continue;
                this.addPoint(points, needleW, needleH, new Point(x, y, d));
            }
            if (!showProgress) continue;
            IJ.showProgress((int)(y - y1 + 1), (int)(y2 - y1));
        }
    }

    void addPoint(ArrayList points, int needleW, int needleH, Point p) {
        for (int i = 0; i < points.size(); ++i) {
            Point p2 = (Point)points.get(i);
            if (!p2.overlaps(p, needleW, needleH)) continue;
            if (p2.diff > p.diff) {
                p2.replaceWith(p);
            }
            return;
        }
        points.add(p);
    }

    float distance(int[] haystack, int x, int y, int row, int[] needle, int needleW, int needleH) {
        long diff = 0L;
        for (int j = 0; j < needleH; ++j) {
            for (int i = 0; i < needleW; ++i) {
                int v1 = haystack[x + i + row * (y + j)];
                int v2 = needle[i + needleW * j];
                int r = (v1 >> 16 & 0xFF) - (v2 >> 16 & 0xFF);
                int g = (v1 >> 8 & 0xFF) - (v2 >> 8 & 0xFF);
                int b = (v1 & 0xFF) - (v2 & 0xFF);
                diff += (long)(r * r + g * g + b * b);
            }
        }
        float result = (float)diff / (float)(needleW * needleH);
        if (this.minDistance > result) {
            this.minDistance = result;
        }
        return result;
    }

    Roi getRoi(ArrayList points, int w, int h) {
        if (points.size() < 0) {
            return null;
        }
        if (points.size() == 1) {
            Point p = (Point)points.get(0);
            return new Roi(p.x, p.y, w, h);
        }
        GeneralPath gp = new GeneralPath();
        for (int i = 0; i < points.size(); ++i) {
            Point p = (Point)points.get(i);
            gp.moveTo(p.x, p.y);
            gp.lineTo(p.x + w, p.y);
            gp.lineTo(p.x + w, p.y + h);
            gp.lineTo(p.x, p.y + h);
            gp.closePath();
        }
        return new ShapeRoi((Shape)gp);
    }

    private class Point {
        int x;
        int y;
        float diff;

        Point(int x, int y, float diff) {
            this.x = x;
            this.y = y;
            this.diff = diff;
        }

        boolean overlaps(Point other, int w, int h) {
            return this.x + w > other.x && other.x + w > this.x && this.y + h > other.y && other.y + h > this.y;
        }

        void replaceWith(Point other) {
            this.x = other.x;
            this.y = other.y;
            this.diff = other.diff;
        }
    }
}

