/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import java.awt.CheckboxMenuItem;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JOptionPane;
import view5d.ImageCanvas;
import view5d.My3DData;
import view5d.MyMenuProcessor;
import view5d.PixelDisplay;
import view5d.View5D;
import view5d.View5D_;

public class PositionLabel
extends Panel
implements MouseListener,
KeyListener {
    ImageCanvas c1;
    ImageCanvas c2;
    ImageCanvas c3;
    My3DData data3d;
    Label l1;
    Label l2;
    Label l3;
    Label l4;
    Label l5;
    Label l6;
    public PixelDisplay PixDisplay;
    TextArea MyText;
    NumberFormat nf;
    NumberFormat nf2;
    Scrollbar TimeScrollbar = null;
    int px = 0;
    int py = 0;
    int pz = 0;
    int pt = 0;
    int lnr = -1;
    int lpos = -1;
    PopupMenu MyPopupMenu;
    CheckboxMenuItem DispIntScaleOffset;
    CheckboxMenuItem DispPosSizePix;
    CheckboxMenuItem DispPosWorld;
    CheckboxMenuItem DispROIInfo;
    CheckboxMenuItem DispCoordScales;
    CheckboxMenuItem DispThreshColor;
    CheckboxMenuItem DispListNrPos;
    CheckboxMenuItem DispMarkerInfo;

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.MyPopupMenu.show(this, e.getX(), e.getY());
            this.CoordsChanged();
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.MyPopupMenu.show(this, e.getX(), e.getY());
            this.CoordsChanged();
            return;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public PositionLabel(String text, ImageCanvas C1, ImageCanvas C2, ImageCanvas C3, My3DData data) {
        this.c1 = C1;
        this.c2 = C2;
        this.c3 = C3;
        this.data3d = data;
        this.MyText = new TextArea(text, 15, 30);
        this.MyText.setFont(new Font(this.data3d.FontType, 0, this.data3d.FontSize));
        this.MyText.setEditable(false);
        this.PixDisplay = new PixelDisplay(data, this.c1, this.c2, this.c3);
        this.nf = NumberFormat.getNumberInstance(Locale.US);
        this.nf.setMaximumFractionDigits(6);
        this.nf.setGroupingUsed(false);
        this.nf2 = NumberFormat.getNumberInstance(Locale.US);
        this.nf2.setMaximumFractionDigits(7);
        this.nf2.setGroupingUsed(false);
        GridLayout myLayout = new GridLayout(2, 2);
        this.setLayout(myLayout);
        this.add(this.MyText);
        this.add(this.PixDisplay);
        this.MyText.addMouseListener(this);
        this.MyText.addKeyListener(this);
        this.MyPopupMenu = new PopupMenu("Text Menu");
        PopupMenu MyMenu = new PopupMenu("Text to Display");
        this.add(this.MyPopupMenu);
        this.MyPopupMenu.add(MyMenu);
        this.DispIntScaleOffset = new CheckboxMenuItem("Intensity, Scale, Offset, Type : ", true);
        MyMenu.add(this.DispIntScaleOffset);
        this.DispPosSizePix = new CheckboxMenuItem("Position, Size (Pixel coordinates): ", true);
        MyMenu.add(this.DispPosSizePix);
        this.DispPosWorld = new CheckboxMenuItem("Position, (world coordinates): ", true);
        MyMenu.add(this.DispPosWorld);
        this.DispROIInfo = new CheckboxMenuItem("ROI Information: ", true);
        MyMenu.add(this.DispROIInfo);
        this.DispCoordScales = new CheckboxMenuItem("Coordinate Scales: ", true);
        MyMenu.add(this.DispCoordScales);
        this.DispThreshColor = new CheckboxMenuItem("Thresholds, Color: ", true);
        MyMenu.add(this.DispThreshColor);
        this.DispListNrPos = new CheckboxMenuItem("List Nr., Position: ", true);
        MyMenu.add(this.DispListNrPos);
        this.DispMarkerInfo = new CheckboxMenuItem("Marker and List Information: ", true);
        MyMenu.add(this.DispMarkerInfo);
        PopupMenu MyFontMenu = new PopupMenu("Font Size");
        this.MyPopupMenu.add(MyFontMenu);
        MenuItem tmp = new MenuItem("Small [1]");
        tmp.addActionListener(new MyMenuProcessor(this, '1'));
        MyFontMenu.add(tmp);
        tmp = new MenuItem("Medium [2]");
        tmp.addActionListener(new MyMenuProcessor(this, '2'));
        MyFontMenu.add(tmp);
        tmp = new MenuItem("Large [3]");
        tmp.addActionListener(new MyMenuProcessor(this, '3'));
        MyFontMenu.add(tmp);
        tmp = new MenuItem("Smaller [-]");
        tmp.addActionListener(new MyMenuProcessor(this, '-'));
        MyFontMenu.add(tmp);
        tmp = new MenuItem("Larger [+]");
        tmp.addActionListener(new MyMenuProcessor(this, '+'));
        MyFontMenu.add(tmp);
    }

    void Help() {
        String Version = this.data3d.applet instanceof View5D ? ((View5D)this.data3d.applet).getVersion() : ((View5D_)((Object)this.data3d.applet)).getVersion();
        String newtext = "Java 5D image viewer, Version V" + Version + " by Rainer Heintzmann\nLeibniz-IPHT and Friedrich Schiller University of Jena, Germany (heintzmann@gmail.com)\n\nNAVIGATION: Right-click for menu and context menus (individual for panels, colopmap list and text panel)\nUse mouse click for changing slices or cursor keys (arrows) and next/previous page keys.\nZoom in and out via the mouse wheel. Press `shift` and use the mouse wheel to change the LUT gamma value. `shift middle mouse click resets gamma to one`\n +'e' and 'E' movel along the element- (color-) direction. ',' and '.' along time or between multiple images.\n +'home'/'pos1' positions the cursor at the center for this panel.\nshift-drag images for positon or press space bar before draggin with the mouse, zoom by typing 'A' and 'a' or zoom-fit a ROI by pressing 'Z'\n\nVIEW ADJUSTMENT:'<' and '>' to adjusting display magnification (if aspect is not locked) perpendicular to the current display (like the mouse wheel)\n'i' to initialize view, 'c' to change ColorMap, \n1,2,5,6' for lower and '3,4,7,8' for upper Threshold coarse and fine adjustment, 't' and 'T' for automatic contrast adjustment for one or all elements repectively\n'e': toggle elements (if present), 'C': toggle multicolor display, 'r','g','b': select element for respective display\n'G': set element to gray colormap, 'R': glow red colormap, 'B': rainbow colormap, 'p','P': Toggle Projections (MIP, Avg)\n\nROIs: 'shift' and mouse-drag for square ROIs, 'Ctrl-s' toggles ROI modes mouse-drag for multiple line ROIs\n\nSee the context menus (right click) in the main and element displays for more commands with the respective keys shown in []\nFor further Documentation and commands see http://www.nanoimaging.de/View5D/";
        JOptionPane.showMessageDialog(null, newtext);
    }

    void PrintPointList() {
        this.MyText.setText(this.data3d.GetMarkerPrintout(this.data3d));
        this.MyText.setCaretPosition(0);
    }

    String GetPositionString() {
        String pstr = "";
        pstr = pstr + "Pos: (" + this.nf.format((double)((int)this.c2.PositionValue) * this.data3d.GetScale(0, 0) + this.data3d.GetOffset(0, 0)) + ", " + this.nf.format((double)((int)this.c3.PositionValue) * this.data3d.GetScale(0, 1) + this.data3d.GetOffset(0, 1)) + ", " + this.nf.format((double)((int)this.c1.PositionValue) * this.data3d.GetScale(0, 2) + this.data3d.GetOffset(0, 2)) + ", " + this.nf.format((double)this.data3d.GetActiveElement() * this.data3d.GetScale(0, 3) + this.data3d.GetOffset(0, 3)) + ", " + this.nf.format((double)this.data3d.GetActiveTime() * this.data3d.GetScale(0, 4) + this.data3d.GetOffset(0, 4)) + ") [" + this.data3d.GetAxisUnits()[0] + ", " + this.data3d.GetAxisUnits()[1] + ", " + this.data3d.GetAxisUnits()[2] + ", " + this.data3d.GetAxisUnits()[3] + ", " + this.data3d.GetAxisUnits()[4] + "]";
        return pstr;
    }

    String CreateValueString(String valstring) {
        String str = this.data3d.GetValueName(this.data3d.GetActiveElement()) + " [" + this.data3d.GetValueUnit(this.data3d.GetActiveElement()) + "]: " + valstring;
        return str;
    }

    String CreateValueString(double val) {
        return this.CreateValueString(this.nf.format(val));
    }

    String GetValueString() {
        return this.CreateValueString(this.data3d.ActElement().GetValueStringAt((int)this.c2.PositionValue, (int)this.c3.PositionValue, (int)this.c1.PositionValue));
    }

    void CoordsChanged() {
        this.px = (int)this.c2.PositionValue;
        this.py = (int)this.c3.PositionValue;
        this.pz = (int)this.c1.PositionValue;
        this.pt = this.data3d.ActiveTime;
        this.lnr = this.data3d.MyMarkers.ActiveList;
        this.lpos = this.data3d.MyMarkers.ActiveMarkerPos();
        int elem = this.data3d.GetActiveElement();
        boolean colormd = this.data3d.GetColorMode();
        boolean projmode = this.data3d.GetProjectionMode(2);
        boolean histconnected = this.data3d.DataToHistogram != null;
        this.PixDisplay.CoordinatesChanged();
        double PsizeX = this.data3d.GetROISize(-1, 0);
        double PsizeY = this.data3d.GetROISize(-1, 1);
        double PsizeZ = this.data3d.GetROISize(-1, 2);
        double diagonal = Math.sqrt(PsizeX * PsizeX + PsizeY * PsizeY + PsizeZ * PsizeZ);
        if (this.c2.myPanel.ROIstarted) {
            PsizeX = this.data3d.ActElement().Scales[0] * (1.0 + Math.abs((double)this.c2.ROIe - (double)this.c2.ROIs));
        }
        if (this.c3.myPanel.ROIstarted) {
            PsizeY = this.data3d.ActElement().Scales[1] * (1.0 + Math.abs((double)this.c3.ROIe - (double)this.c3.ROIs));
        }
        if (this.c1.myPanel.ROIstarted) {
            PsizeZ = this.data3d.ActElement().Scales[2] * (1.0 + Math.abs((double)this.c1.ROIe - (double)this.c1.ROIs));
        }
        String UnitX = this.data3d.GetAxisUnits()[0];
        String UnitY = this.data3d.GetAxisUnits()[1];
        String UnitZ = this.data3d.GetAxisUnits()[2];
        String UnitT = this.data3d.GetAxisUnits()[4];
        String X = this.data3d.GetAxisNames()[0];
        String Y = this.data3d.GetAxisNames()[1];
        String Z = this.data3d.GetAxisNames()[2];
        double sx = this.data3d.GetScale(0, 0);
        double sy = this.data3d.GetScale(0, 1);
        double sz = this.data3d.GetScale(0, 2);
        double st = this.data3d.GetScale(0, 4);
        double mx = 0.0;
        double my = 0.0;
        double mz = 0.0;
        double mx2 = 0.0;
        double my2 = 0.0;
        double mz2 = 0.0;
        double dxy2 = 0.0;
        double Dxy = 0.0;
        double dxyz = 0.0;
        double Dxyz = 0.0;
        double DSum = 0.0;
        double dt = 0.0;
        double slope = 0.0;
        double slope3 = 0.0;
        double MIntegral = 0.0;
        double MMax = 0.0;
        for (int i = 0; i < this.data3d.NumMarkers(-1); ++i) {
            if (i == this.data3d.ActiveMarkerPos()) {
                mx = this.data3d.GetPoint((int)i).coord[0];
                my = this.data3d.GetPoint((int)i).coord[1];
                mz = this.data3d.GetPoint((int)i).coord[2];
                int iprev = i - 1;
                if (iprev < 0) {
                    iprev = 0;
                }
                mx2 = this.data3d.GetPoint((int)iprev).coord[0];
                my2 = this.data3d.GetPoint((int)iprev).coord[1];
                mz2 = this.data3d.GetPoint((int)iprev).coord[2];
                dt = (this.data3d.GetPoint((int)i).coord[4] - this.data3d.GetPoint((int)iprev).coord[4]) * st;
                dxy2 = (mx - mx2) * (mx - mx2) * sx * sx + (my - my2) * (my - my2) * sy * sy;
                dxyz = Math.sqrt(dxy2 + (mz - mz2) * (mz - mz2) * sz * sz);
                Dxy = Math.sqrt(dxy2);
                Dxyz = dxyz;
                slope = mz - mz2 != 0.0 && sz != 0.0 ? Dxy / (mz - mz2) / sz : 0.0;
                slope3 = dt != 0.0 ? Dxyz / dt : 0.0;
                MIntegral = this.data3d.GetPoint((int)i).integral;
                MMax = this.data3d.GetPoint((int)i).max;
            }
            DSum += dxyz;
        }
        String GateString = "";
        if (this.data3d.GateActive) {
            GateString = "(gated) ";
        }
        String newtext = "";
        if (this.DispIntScaleOffset.getState()) {
            newtext = newtext + this.GetValueString() + ", scale :" + this.nf.format(this.data3d.GetValueScale(elem)) + ", offset: " + this.data3d.GetValueOffset(elem) + ", type: " + this.data3d.GetDataTypeName(elem) + "\n";
        }
        if (this.DispPosSizePix.getState()) {
            newtext = newtext + "at (" + this.nf.format(this.px) + ", " + this.nf.format(this.py) + ", " + this.nf.format(this.pz) + ", " + this.nf.format(elem) + ", " + this.nf.format(this.pt) + ") of (" + this.data3d.SizeX + ", " + this.data3d.SizeY + ", " + this.data3d.SizeZ + ", " + this.data3d.Elements + ", " + this.data3d.Times + ")\n";
        }
        if (this.DispPosWorld.getState()) {
            newtext = newtext + this.GetPositionString() + "\nCoordinate scales: (" + this.nf.format(sx) + ", " + this.nf.format(sy) + ", " + this.nf.format(sz) + ")  ,";
        }
        if (this.DispListNrPos.getState()) {
            newtext = newtext + "ListNr+Pos: (" + this.nf.format(this.lnr + 1) + ", " + this.nf.format(this.lpos) + ")\n";
        }
        if (this.DispROIInfo.getState()) {
            newtext = newtext + "ROI Sizes [" + UnitX + "]: (" + (PsizeX + "     ").substring(0, 6) + ", " + this.nf.format(PsizeY) + ", " + this.nf.format(PsizeZ) + ")\n -> 3D-Diagonal[" + UnitX + "]: " + this.nf.format(diagonal) + "\nROI Volume " + GateString + this.nf.format(this.data3d.GetROIVoxels(elem)) + " voxels, " + this.nf.format(this.data3d.GetROIVoxels(elem) * sx * sy * sz) + " [" + UnitX + "*" + UnitY + "*" + UnitZ + "]\nSum:" + this.nf.format(this.data3d.GetROISum(elem)) + ", Average:" + this.nf.format(this.data3d.GetROIAvg(elem)) + ", Max:" + this.nf.format(this.data3d.GetROIMax(elem)) + ", Min:" + this.nf.format(this.data3d.GetROIMin(elem)) + "\n";
        }
        if (this.DispCoordScales.getState()) {
            newtext = newtext + "Magnifications (x,y,z) = " + this.nf.format(this.c2.scale) + ", " + this.nf.format(this.c3.scale) + "," + this.nf.format(this.c1.scale) + "\n";
        }
        if (this.DispThreshColor.getState()) {
            newtext = newtext + "Thresholds : min=" + this.nf.format(this.data3d.GetScaledMincs(elem)) + " max=" + this.nf.format(this.data3d.GetScaledMaxcs(elem)) + "\nColor: " + colormd + ", Projection Mode: " + projmode + ", Data connected: " + histconnected + "\n";
        }
        if (this.DispMarkerInfo.getState()) {
            newtext = newtext + "List " + this.data3d.ActiveMarkerListPos() + ", Marker " + this.data3d.ActiveMarkerPos() + ": " + this.nf.format(mx) + ", " + this.nf.format(my) + ", " + this.nf.format(mz) + ", Integral: " + this.nf.format(MIntegral) + ", Max= " + this.nf.format(MMax) + "\nLast Distance " + X + Y + "=" + this.nf2.format(Dxy) + ", " + X + Y + Z + "=" + this.nf2.format(Dxyz) + "\nSlope " + X + "/" + Z + "=" + this.nf2.format(slope) + " [" + UnitX + "/" + UnitZ + "], TimeSlope=" + this.nf2.format(slope3) + " [" + UnitX + "/" + UnitT + "]  Sum Distances " + X + Y + Z + "=" + this.nf2.format(DSum);
        }
        this.MyText.setText(newtext);
        this.MyText.setFont(new Font(this.data3d.FontType, 0, this.data3d.FontSize));
        this.MyText.setCaretPosition(0);
        if (this.TimeScrollbar != null) {
            this.TimeScrollbar.setValue(this.pt);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        char myChar = e.getKeyChar();
        this.ProcessKey(myChar);
    }

    public void ProcessKey(char myChar) {
        switch (myChar) {
            case '1': {
                this.data3d.FontSize = 10;
                this.CoordsChanged();
                this.c1.RedrawAll();
                return;
            }
            case '2': {
                this.data3d.FontSize = 18;
                this.CoordsChanged();
                this.c1.RedrawAll();
                return;
            }
            case '3': {
                this.data3d.FontSize = 26;
                this.CoordsChanged();
                this.c1.RedrawAll();
                return;
            }
            case '+': {
                if (this.data3d.FontSize < 40) {
                    this.data3d.FontSize += 4;
                }
                this.CoordsChanged();
                this.c1.RedrawAll();
                return;
            }
            case '-': {
                if (this.data3d.FontSize > 8) {
                    this.data3d.FontSize -= 4;
                }
                this.CoordsChanged();
                this.c1.RedrawAll();
                return;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

