/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.ImageObserver;
import java.text.NumberFormat;
import java.util.Locale;
import view5d.AlternateViewer;
import view5d.Bundle;
import view5d.ImageCanvas;
import view5d.My3DData;
import view5d.MyMenuProcessor;
import view5d.PlotInfo;
import view5d.View5D_;

public class PixelDisplay
extends Panel
implements MouseListener,
MouseWheelListener,
ImageObserver,
KeyListener {
    static final long serialVersionUID = 1L;
    ImageCanvas c1;
    ImageCanvas c2;
    ImageCanvas c3;
    My3DData data3d;
    int imgw = -1;
    int imgh = -1;
    private int lxold = 0;
    private int lyold = 0;
    private int PointNr = 0;
    private double pval = 0.0;
    boolean didinit = false;
    int PlotMode = 0;
    PlotInfo myInfo = new PlotInfo();
    boolean normalize = true;
    boolean logmode = false;
    double maxdispl = 1.0;
    double mindispl = 0.0;
    String TextToDisplay = "";
    PopupMenu MyPopupMenu;
    Menu ColorMenu;

    void AddColorMenu(String Name, int i) {
        MenuItem tmp = new MenuItem(Name);
        tmp.addActionListener(new MyMenuProcessor(this, this.c1, false, i));
        this.ColorMenu.add(tmp);
        tmp = new MenuItem(Name + " (inverted)");
        tmp.addActionListener(new MyMenuProcessor(this, this.c1, true, i));
        this.ColorMenu.add(tmp);
    }

    PixelDisplay(My3DData data, ImageCanvas C1, ImageCanvas C2, ImageCanvas C3) {
        this.c1 = C1;
        this.c2 = C2;
        this.c3 = C3;
        this.data3d = data;
        this.setBounds(0, 0, 200, 50);
        if (data.Elements > 5) {
            this.PlotMode = 1;
        }
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.MyPopupMenu = new PopupMenu("Element Menu");
        this.add(this.MyPopupMenu);
        Menu SubMenu = new Menu("General", false);
        this.MyPopupMenu.add(SubMenu);
        MenuItem tmp = new MenuItem("initialise scaling [i]");
        tmp.addActionListener(new MyMenuProcessor(this, 'i'));
        SubMenu.add(tmp);
        tmp = new MenuItem("Set Value Units and Scalings [N]");
        tmp.addActionListener(new MyMenuProcessor(this, 'N'));
        SubMenu.add(tmp);
        tmp = new MenuItem("eXport to ImageJ (ImageJ only) [X]");
        tmp.addActionListener(new MyMenuProcessor(this, 'X'));
        SubMenu.add(tmp);
        SubMenu = new Menu("Markers", false);
        this.MyPopupMenu.add(SubMenu);
        tmp = new MenuItem("Marker Menu [M]");
        tmp.addActionListener(new MyMenuProcessor(this, 'M'));
        SubMenu.add(tmp);
        tmp = new MenuItem("print/save marker list [m]");
        tmp.addActionListener(new MyMenuProcessor(this, 'm'));
        SubMenu.add(tmp);
        SubMenu = new Menu("Plotting", false);
        this.MyPopupMenu.add(SubMenu);
        tmp = new MenuItem("spawn plot display [s]");
        tmp.addActionListener(new MyMenuProcessor(this, 's'));
        SubMenu.add(tmp);
        tmp = new MenuItem("toggle plot display [q]");
        tmp.addActionListener(new MyMenuProcessor(this, 'q'));
        SubMenu.add(tmp);
        tmp = new MenuItem("normalize plot display [n]");
        tmp.addActionListener(new MyMenuProcessor(this, 'n'));
        SubMenu.add(tmp);
        tmp = new MenuItem("logarithmic mode [O]");
        tmp.addActionListener(new MyMenuProcessor(this, 'O'));
        SubMenu.add(tmp);
        SubMenu = new Menu("ColorMaps", false);
        this.MyPopupMenu.add(SubMenu);
        this.ColorMenu = SubMenu;
        for (int i = 0; i < 15; ++i) {
            this.AddColorMenu(Bundle.ElementModelName[i], i);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.isShiftDown()) {
            for (int el = 0; el < this.data3d.Elements; ++el) {
                double gamma = this.c1.my3ddata.GetGamma(el);
                gamma = e.getWheelRotation() < 0 ? (gamma *= 1.125) : (gamma /= 1.125);
                this.c1.my3ddata.SetGamma(el, gamma);
            }
        } else {
            int ae = this.c1.my3ddata.GetActiveElement();
            double gamma = this.c1.my3ddata.GetGamma(ae);
            gamma = e.getWheelRotation() < 0 ? (gamma *= 1.125) : (gamma /= 1.125);
            this.c1.my3ddata.SetGamma(ae, gamma);
        }
        this.c1.UpdateAll();
    }

    Color GetBWColor(int e) {
        int px = (int)this.c2.PositionValue;
        int py = (int)this.c3.PositionValue;
        int pz = (int)this.c1.PositionValue;
        int val = (int)(this.data3d.NormedValueAt(px, py, pz, e) * 255.0);
        if (val < 0) {
            val = 0;
        }
        if (val > 255) {
            val = 255;
        }
        return new Color(val, val, val);
    }

    Color GetBWSatColor(int e) {
        int px = (int)this.c2.PositionValue;
        int py = (int)this.c3.PositionValue;
        int pz = (int)this.c1.PositionValue;
        double valsat = this.data3d.NormedValueAt(px, py, pz, e) * 255.0;
        if (valsat >= 255.0) {
            return Color.blue;
        }
        if (valsat <= 0.0) {
            return new Color(0, 100, 0);
        }
        return new Color((int)valsat, (int)valsat, (int)valsat);
    }

    Color GetColColor(int e) {
        return this.data3d.GetColColor(e, (int)this.c2.PositionValue, (int)this.c3.PositionValue, (int)this.c1.PositionValue);
    }

    Color GetMarkerColor(int e) {
        return this.data3d.GetMarkerColor(e);
    }

    Color GetCMapColor(int e, int pos, int range) {
        return this.data3d.GetCMapColor(e, pos, range);
    }

    void CoordinatesChanged() {
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (this.PlotMode > 0) {
            this.plot(g);
            return;
        }
        this.drawCMaps(g);
    }

    public void drawCMaps(Graphics g) {
        Rectangle r = this.getBounds();
        int elements = this.data3d.GetNumElements();
        int elem = this.data3d.GetActiveElement();
        double sizex = (double)(r.width - 1) / (double)elements;
        int sizey = (r.height - 1) / 4;
        for (int e = 0; e < elements; ++e) {
            for (int y = 0; y < r.height; ++y) {
                g.setColor(this.GetCMapColor(e, r.height - y - 1, r.height));
                g.drawLine((int)((double)e * sizex), y, (int)((double)(e + 1) * sizex), y);
            }
            g.setColor(Color.white);
            g.setFont(new Font(this.data3d.FontType, 0, this.data3d.FontSize));
            if (e == this.data3d.HistoX) {
                g.drawString("HX", (int)((double)e * sizex + 5.0), (int)(1.0 * (double)sizey));
            }
            if (e == this.data3d.HistoY) {
                g.drawString("HY", (int)((double)e * sizex + 5.0), (int)(1.33 * (double)sizey));
            }
            if (e == this.data3d.HistoZ) {
                g.drawString("HZ", (int)((double)e * sizex + 5.0), (int)(1.66 * (double)sizey));
            }
            if (e == this.data3d.GateElem) {
                if (this.data3d.GateActive) {
                    g.drawString("GA", (int)((double)e * sizex + 5.0), 2 * sizey);
                } else {
                    g.drawString("G", (int)((double)e * sizex + 5.0), 2 * sizey);
                }
            }
            if (this.data3d.InOverlayDispl(e)) {
                g.drawString("Ov", (int)((double)e * sizex + 0.0), 3 * sizey);
            }
            g.drawString(String.format("%.3f", this.data3d.GetGamma(e)), (int)((double)e * sizex + 5.0), 4 * sizey);
        }
        g.setColor(Color.red);
        g.drawRect(elem * r.width / elements, 0, (int)sizex, r.height);
        super.paint(g);
    }

    public void drawElements(Graphics g) {
        Rectangle r = this.getBounds();
        int elements = this.data3d.GetNumElements();
        int elem = this.data3d.GetActiveElement();
        double sizex = (double)(r.width - 1) / (double)elements;
        int sizey = (r.height - 1) / 4;
        for (int e = 0; e < elements; ++e) {
            g.setColor(this.GetBWColor(e));
            g.fillRect((int)((double)e * sizex), 0, (int)((double)(e + 1) * sizex), sizey);
            g.setColor(this.GetBWSatColor(e));
            g.fillRect((int)((double)e * sizex), sizey, (int)((double)(e + 1) * sizex), 2 * sizey);
            g.setColor(this.GetColColor(e));
            g.fillRect((int)((double)e * sizex), 2 * sizey, (int)((double)(e + 1) * sizex), 3 * sizey);
            g.setColor(this.GetMarkerColor(e));
            g.fillRect((int)((double)e * sizex), 3 * sizey, (int)((double)(e + 1) * sizex), 4 * sizey);
            g.setColor(Color.white);
            g.setFont(new Font(this.data3d.FontType, 0, this.data3d.FontSize));
            if (e == this.data3d.HistoX) {
                g.drawString("HX", (int)((double)e * sizex + 5.0), (int)(4.2 * (double)sizey));
            }
            if (e == this.data3d.HistoY) {
                g.drawString("HY", (int)((double)e * sizex + 5.0 + (sizex / 3.0 - 10.0)), 4 * sizey);
            }
            if (e == this.data3d.HistoZ) {
                g.drawString("HZ", (int)((double)e * sizex + 5.0 + (2.0 * sizex / 3.0 - 10.0)), 4 * sizey);
            }
            if (e == this.data3d.GateElem) {
                if (this.data3d.GateActive) {
                    g.drawString("GA", (int)((double)e * sizex + 5.0), 3 * sizey);
                } else {
                    g.drawString("G", (int)((double)e * sizex + 5.0), 3 * sizey);
                }
            }
            if (!this.data3d.InOverlayDispl(e)) continue;
            g.drawString("Ov", (int)((double)e * sizex + 0.0), 4 * sizey);
        }
        g.setColor(Color.red);
        g.drawRect(elem * r.width / elements, 0, (int)sizex, r.height);
        super.paint(g);
    }

    public double ApplyLog(double val) {
        if (!this.logmode) {
            return val;
        }
        if (val > 0.0) {
            return (Math.log(val) - Math.log(0.001)) / -Math.log(0.001);
        }
        return -10.0;
    }

    int InitDataPoints(int mlist) {
        this.PointNr = 0;
        switch (this.PlotMode) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.data3d.Elements;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.data3d.NumMarkers(mlist);
            }
        }
        return 0;
    }

    double GetNextDataPoint(int mlist) {
        double val = 0.0;
        switch (this.PlotMode) {
            case 0: {
                break;
            }
            case 1: {
                if (mlist < 0) {
                    if (this.data3d.GetProjectionMode(2)) {
                        val = this.data3d.GetROIVal(this.PointNr);
                        break;
                    }
                    val = this.data3d.NormedValueAt((int)this.c2.PositionValue, (int)this.c3.PositionValue, (int)this.c1.PositionValue, this.PointNr);
                    break;
                }
                val = this.data3d.NormedValueAt((int)(this.data3d.GetPoint((int)-1, (int)mlist).coord[0] + 0.5), (int)(this.data3d.GetPoint((int)-1, (int)mlist).coord[1] + 0.5), (int)(this.data3d.GetPoint((int)-1, (int)mlist).coord[2] + 0.5), this.PointNr);
                break;
            }
            case 2: {
                this.pval = this.data3d.GetPoint((int)this.PointNr, (int)mlist).integral / (((double)this.data3d.COMX * 2.0 + 1.0) * ((double)this.data3d.COMY * 2.0 + 1.0) * ((double)this.data3d.COMZ * 2.0 + 1.0));
                int e = (int)this.data3d.GetPoint((int)this.PointNr, (int)mlist).coord[3];
                val = this.data3d.Normalize(this.pval, e);
                break;
            }
            case 3: {
                this.pval = this.data3d.GetPoint((int)this.PointNr, (int)mlist).max;
                int e = (int)this.data3d.GetPoint((int)this.PointNr, (int)mlist).coord[3];
                val = this.data3d.Normalize(this.pval, e);
                break;
            }
            case 4: {
                this.pval = this.data3d.GetPoint((int)this.PointNr, (int)mlist).min;
                int e = (int)this.data3d.GetPoint((int)this.PointNr, (int)mlist).coord[3];
                val = this.data3d.Normalize(this.pval, e);
                break;
            }
            case 5: {
                this.pval = this.data3d.GetPoint((int)this.PointNr, (int)mlist).integralAboveMin / (((double)this.data3d.COMX * 2.0 + 1.0) * ((double)this.data3d.COMY * 2.0 + 1.0) * ((double)this.data3d.COMZ * 2.0 + 1.0));
                int e = (int)this.data3d.GetPoint((int)this.PointNr, (int)mlist).coord[3];
                val = this.data3d.Normalize(this.pval, e);
            }
        }
        ++this.PointNr;
        return val;
    }

    double GetNextNormDataPoint(int mlist) {
        double val = this.GetNextDataPoint(mlist);
        val = this.ApplyLog(val);
        if (this.PointNr == 1) {
            this.myInfo.newMaxVal = val;
            this.myInfo.newMinVal = val;
        }
        if (val > this.myInfo.newMaxVal) {
            this.myInfo.newMaxVal = val;
        }
        if (val < this.myInfo.newMinVal) {
            this.myInfo.newMinVal = val;
        }
        return val;
    }

    void drawDataPoint(Graphics g, Rectangle r, double val, double posx, double ActPos, double SizeX, boolean DrawMarker) {
        val = this.normalize ? (this.myInfo.ValScale * (val - this.myInfo.MinVal) - this.mindispl) / (this.maxdispl - this.mindispl) : (this.myInfo.ValScale * val - this.mindispl) / (this.maxdispl - this.mindispl);
        int lxnew = (int)(10.0 + posx * ((double)r.width - 20.0) / (SizeX - 1.0));
        int lynew = r.height - 10 - (int)((double)(r.height - 20) * val);
        if (this.PointNr > 1) {
            g.drawLine(this.lxold, this.lyold, lxnew, lynew);
        }
        if (posx == ActPos) {
            g.fillOval(lxnew - 4, lynew - 4, 9, 9);
        }
        if (DrawMarker) {
            g.drawOval(lxnew - 5, lynew - 5, 11, 11);
        }
        this.lxold = lxnew;
        this.lyold = lynew;
    }

    public void plot(Graphics g) {
        Rectangle r = this.getBounds();
        g.setColor(Color.black);
        g.fillRect(0, 0, r.width - 1, r.height - 1);
        g.setColor(Color.white);
        int ActPos = 0;
        int NumPts = 0;
        int Size = this.data3d.Elements;
        if (Size == 1) {
            Size = 2;
        }
        g.drawLine(10, r.height - 10, r.width - 10, r.height - 10);
        ActPos = this.data3d.GetActiveElement();
        int pos = 10 + ActPos * (r.width - 20) / (Size - 1);
        g.drawLine(pos, 0, pos, r.height - 1);
        switch (this.PlotMode) {
            case 1: {
                this.TextToDisplay = "Intensity(Elements)";
                break;
            }
            case 2: {
                this.TextToDisplay = "Mean(Marker Trace)";
                break;
            }
            case 3: {
                this.TextToDisplay = "Max(Marker Trace)";
                break;
            }
            case 4: {
                this.TextToDisplay = "Min(Marker Trace)";
                break;
            }
            case 5: {
                this.TextToDisplay = "[Mean-Min](Marker Trace)";
            }
        }
        if (this.data3d.GetProjectionMode(2)) {
            this.TextToDisplay = this.data3d.GetMIPMode(2) ? this.TextToDisplay + ", Max. Proj." : this.TextToDisplay + ", Avg. Proj.";
        }
        if (this.normalize && !this.data3d.GetProjectionMode(2)) {
            this.TextToDisplay = this.TextToDisplay + ", normalized";
        }
        if (this.logmode) {
            this.TextToDisplay = this.TextToDisplay + ", logmode";
        }
        if (!this.normalize) {
            this.myInfo.MinVal = 0.0;
            this.myInfo.MaxVal = 1.0;
            this.myInfo.ValScale = 1.0;
        }
        double printval = 0.0;
        String XTitle = "";
        if (this.PlotMode == 1) {
            double val;
            int e;
            XTitle = "Elements";
            if (this.normalize) {
                NumPts = this.InitDataPoints(-1);
                for (e = 0; e < NumPts; ++e) {
                    val = this.GetNextNormDataPoint(-1);
                }
                this.myInfo.MinVal = this.myInfo.newMinVal;
                this.myInfo.MaxVal = this.myInfo.newMaxVal;
                this.myInfo.ValScale = 1.0 / (this.myInfo.MaxVal - this.myInfo.MinVal);
            }
            g.setColor(Color.white);
            NumPts = this.InitDataPoints(-1);
            for (e = 0; e < NumPts; ++e) {
                val = this.GetNextNormDataPoint(-1);
                this.drawDataPoint(g, r, val, e, ActPos, Size, false);
                if (ActPos != e) continue;
                printval = this.data3d.ValueAt((int)this.c2.PositionValue, (int)this.c3.PositionValue, (int)this.c1.PositionValue, e);
            }
            for (int l = 0; l < this.data3d.NumMarkerLists(); ++l) {
                if (this.data3d.NumMarkers(l) <= 0) continue;
                if (this.normalize) {
                    NumPts = this.InitDataPoints(-1);
                    for (int e2 = 0; e2 < NumPts; ++e2) {
                        val = this.GetNextNormDataPoint(l);
                    }
                    this.myInfo.MinVal = this.myInfo.newMinVal;
                    this.myInfo.MaxVal = this.myInfo.newMaxVal;
                    this.myInfo.ValScale = 1.0 / (this.myInfo.MaxVal - this.myInfo.MinVal);
                }
                Color MarkerColor = new Color(this.data3d.GetPoint((int)0, (int)l).mycolor);
                g.setColor(MarkerColor);
                NumPts = this.InitDataPoints(-1);
                for (int e3 = 0; e3 < NumPts; ++e3) {
                    val = this.GetNextNormDataPoint(l);
                    this.drawDataPoint(g, r, val, e3, ActPos, Size, false);
                }
            }
        } else {
            XTitle = this.data3d.TrackDirections[this.data3d.TrackDirection];
            int px = (int)this.c2.PositionValue;
            int py = (int)this.c3.PositionValue;
            int pz = (int)this.c1.PositionValue;
            int element = this.data3d.ActiveElement;
            int time = this.data3d.ActiveTime;
            int[] ActPosition = new int[]{px, py, pz, element, time};
            for (int l = 0; l < this.data3d.NumMarkerLists(); ++l) {
                double val;
                if (this.data3d.NumMarkers(l) <= 0) continue;
                NumPts = this.InitDataPoints(l);
                for (int e = 0; e < NumPts; ++e) {
                    val = this.GetNextNormDataPoint(l);
                    this.data3d.CheckActiveMarker(l, e, px, py, pz, element, time);
                }
                if (this.normalize) {
                    this.myInfo.MinVal = this.myInfo.newMinVal;
                    this.myInfo.MaxVal = this.myInfo.newMaxVal;
                    this.myInfo.ValScale = 1.0 / (this.myInfo.MaxVal - this.myInfo.MinVal);
                }
                Color MarkerColor = new Color(this.data3d.GetPoint((int)0, (int)l).mycolor);
                g.setColor(MarkerColor);
                NumPts = this.InitDataPoints(l);
                for (int e = 0; e < NumPts; ++e) {
                    val = this.GetNextNormDataPoint(l);
                    boolean MDispl = this.data3d.MarkerDisplayed(this.data3d.GetPoint(e, l), ActPosition);
                    double posx = this.data3d.GetPoint((int)e, (int)l).coord[this.data3d.TrackDirection];
                    double APos = this.data3d.GetPoint((int)this.data3d.ActiveMarkerPos(), (int)l).coord[this.data3d.TrackDirection];
                    if (l == this.data3d.ActiveMarkerListPos() && e == this.data3d.ActiveMarkerPos()) {
                        g.setColor(Color.white);
                        printval = this.pval;
                    } else {
                        g.setColor(MarkerColor);
                        APos = -1.0E10;
                    }
                    this.drawDataPoint(g, r, val, posx, APos, this.data3d.GetSize(this.data3d.TrackDirection), MDispl);
                }
            }
        }
        g.setColor(Color.white);
        g.setFont(new Font(this.data3d.FontType, 0, this.data3d.FontSize));
        g.drawString(this.TextToDisplay, 12, 12);
        g.drawString(XTitle, r.width - XTitle.length() * 9, r.height - 15);
        NumberFormat nf2 = NumberFormat.getNumberInstance(Locale.US);
        nf2.setMaximumFractionDigits(6);
        nf2.setGroupingUsed(false);
        g.drawString(nf2.format(printval), 12, r.height - 20);
    }

    public void SetTrackDirVal(int posx) {
        if (posx >= this.data3d.GetSize(this.data3d.TrackDirection)) {
            posx = this.data3d.GetSize(this.data3d.TrackDirection) - 1;
        }
        if (posx < 0) {
            posx = 0;
        }
        switch (this.data3d.TrackDirection) {
            case 0: {
                this.c3.PositionValue = posx;
                break;
            }
            case 1: {
                this.c2.PositionValue = posx;
                break;
            }
            case 2: {
                this.c1.PositionValue = posx;
                break;
            }
            case 3: {
                this.data3d.setElement(posx);
            }
            case 4: {
                this.data3d.setTime(posx);
            }
        }
    }

    public int GetTrackDirVal() {
        switch (this.data3d.TrackDirection) {
            case 0: {
                return (int)this.c3.PositionValue;
            }
            case 1: {
                return (int)this.c2.PositionValue;
            }
            case 2: {
                return (int)this.c1.PositionValue;
            }
            case 3: {
                return this.data3d.ActiveElement;
            }
            case 4: {
                return this.data3d.ActiveTime;
            }
        }
        return 0;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 2) {
            if (e.isShiftDown()) {
                for (int el = 0; el < this.data3d.Elements; ++el) {
                    this.c1.my3ddata.SetGamma(el, 1.0);
                    this.c1.UpdateAll();
                }
                return;
            }
            this.c1.my3ddata.SetGamma(this.c1.my3ddata.GetActiveElement(), 1.0);
            this.c1.UpdateAll();
            return;
        }
        if (e.isPopupTrigger()) {
            this.MyPopupMenu.show(this, e.getX(), e.getY());
            return;
        }
        Rectangle r = this.getBounds();
        int xprev = e.getX();
        if (this.PlotMode <= 1) {
            int elements = this.data3d.GetNumElements();
            int element = xprev * elements / r.width;
            this.c1.myPanel.RememberOffset();
            this.data3d.setElement(element);
            this.c1.myPanel.AdjustOffset();
        } else if (this.PlotMode > 1) {
            int posx = (int)((double)(xprev * this.data3d.GetSize(this.data3d.TrackDirection) / r.width) + 0.5);
            this.c1.myPanel.RememberOffset();
            this.SetTrackDirVal(posx);
            this.c1.myPanel.AdjustOffset();
        }
        this.c1.UpdateAll();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.MyPopupMenu.show(this, e.getX(), e.getY());
            return;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        char myChar = e.getKeyChar();
        if (this.PlotMode <= 1) {
            if (39 == e.getKeyCode()) {
                this.c1.myPanel.RememberOffset();
                this.c1.my3ddata.advanceElement(1);
                this.c1.myPanel.AdjustOffset();
                this.c1.UpdateAll();
                return;
            }
            if (37 == e.getKeyCode()) {
                this.c1.myPanel.RememberOffset();
                this.c1.my3ddata.advanceElement(-1);
                this.c1.myPanel.AdjustOffset();
                this.c1.UpdateAll();
                return;
            }
        } else if (39 == e.getKeyCode() || 37 == e.getKeyCode()) {
            int posx = this.GetTrackDirVal();
            if (39 == e.getKeyCode()) {
                ++posx;
            }
            if (37 == e.getKeyCode()) {
                --posx;
            }
            this.SetTrackDirVal(posx);
            this.c1.UpdateAll();
            return;
        }
        this.ProcessKey(myChar);
    }

    public void ProcessKey(char myChar) {
        switch (myChar) {
            case 's': {
                this.c1.myPanel.label.remove(this);
                GridLayout myLayout = new GridLayout(1, 2);
                this.c1.myPanel.label.setLayout(myLayout);
                this.c1.myPanel.label.doLayout();
                AlternateViewer xx = new AlternateViewer(this.c1.applet);
                xx.AssignPixelDisplay(this);
                return;
            }
            case 'q': {
                this.PlotMode = (this.PlotMode + 1) % 6;
                this.repaint();
                break;
            }
            case 'n': {
                this.normalize = !this.normalize;
                this.repaint();
                break;
            }
            case 'N': {
                this.data3d.ValueUnitsDialog();
                this.data3d.InvalidateProjs(-1);
                this.c1.label.CoordsChanged();
                this.c1.UpdateAll();
                break;
            }
            case 'm': {
                if (this.data3d.markerOutfilename != null) {
                    this.data3d.SaveMarkers();
                }
                this.c1.label.PrintPointList();
                break;
            }
            case 'M': {
                this.data3d.MarkerDialog();
                break;
            }
            case 'O': {
                this.logmode = !this.logmode;
                this.repaint();
                break;
            }
            case '1': {
                if (this.mindispl < this.maxdispl - 0.01) {
                    this.mindispl += 0.01;
                }
                this.repaint();
                break;
            }
            case '2': {
                this.mindispl -= 0.01;
                this.repaint();
                break;
            }
            case '3': {
                this.maxdispl += 0.02;
                this.repaint();
                break;
            }
            case '4': {
                if (this.mindispl < this.maxdispl - 0.02) {
                    this.maxdispl -= 0.02;
                }
                this.repaint();
                break;
            }
            case '5': {
                if (this.mindispl < this.maxdispl - 0.001) {
                    this.mindispl += 0.001;
                }
                this.repaint();
                break;
            }
            case '6': {
                this.mindispl -= 0.001;
                this.repaint();
                break;
            }
            case '7': {
                this.maxdispl += 0.002;
                this.repaint();
                break;
            }
            case '8': {
                if (this.mindispl < this.maxdispl - 0.002) {
                    this.maxdispl -= 0.002;
                }
                this.repaint();
                break;
            }
            case 'i': {
                this.maxdispl = 1.0;
                this.mindispl = 0.0;
                this.repaint();
                break;
            }
            case 'X': {
                if (!(this.c1.applet instanceof View5D_)) break;
                this.data3d.Export(-1, -1);
                break;
            }
            default: {
                this.c1.ProcessKey(myChar);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

