/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import ij.IJ;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;
import view5d.AGenericDialog;
import view5d.APoint;
import view5d.MarkerList;
import view5d.My3DData;

public class MarkerLists {
    MarkerList MyActiveList = null;
    int NumLists = 0;
    int ActiveList = -1;
    int ListOffset = 0;
    int CurrentNameNr = 1;
    Vector<MarkerList> ListOfLists = new Vector();
    static int dx = 3;
    static int dy = 3;

    public MarkerLists() {
        this.NewList();
    }

    int NumMarkers(int lpos) {
        if (this.NumLists < 1) {
            return 0;
        }
        if (lpos < 0) {
            lpos = this.ActiveList;
        }
        if (this.ListOfLists != null && lpos >= 0) {
            MarkerList MyMarkerList = this.GetMarkerList(lpos);
            if (MyMarkerList != null) {
                return MyMarkerList.NumMarkers();
            }
            return 0;
        }
        return 0;
    }

    int NumMarkerLists() {
        return this.NumLists;
    }

    int ActiveMarkerListPos() {
        return this.ActiveList;
    }

    MarkerList ActiveMarkerList() {
        return this.MyActiveList;
    }

    MarkerList GetMarkerList(int list) {
        if (list < 0) {
            return null;
        }
        if (this.ListOfLists != null) {
            return this.ListOfLists.elementAt(list);
        }
        return null;
    }

    APoint GetPoint(int p, int list) {
        MarkerList alist = list < 0 ? this.MyActiveList : this.GetMarkerList(list);
        if (alist == null) {
            return null;
        }
        return alist.GetPoint(p);
    }

    void AddPoint(APoint p) {
        if (this.NumLists < 1) {
            this.NewList();
        }
        this.MyActiveList.AddPoint(p);
    }

    void RemovePoint() {
        if (this.NumLists < 1) {
            return;
        }
        this.MyActiveList.RemovePoint();
    }

    void RemoveTrailingPoints() {
        if (this.NumLists < 1) {
            return;
        }
        this.MyActiveList.RemoveTrailingPoints();
    }

    boolean AdvancePoint(int howmany, int TrackDirection) {
        if (this.NumLists < 1) {
            return false;
        }
        int CurPos = this.MyActiveList.ActivePoint;
        if (CurPos + howmany >= this.MyActiveList.NumPoints) {
            if (this.MyActiveList.Child1List != null && (this.MyActiveList.Child2List == null || this.MyActiveList.PreferredChild == 1)) {
                this.SetActiveList(this.GetChild1Index(this.ActiveList));
                this.MyActiveList.SetActiveMarker(0);
                return true;
            }
            if (this.MyActiveList.Child2List != null && (this.MyActiveList.Child1List == null || this.MyActiveList.PreferredChild == 2)) {
                this.SetActiveList(this.GetChild2Index(this.ActiveList));
                this.MyActiveList.SetActiveMarker(0);
                return true;
            }
            return false;
        }
        if (CurPos + howmany < 0) {
            if (this.MyActiveList.Parent1List != null) {
                if (this.MyActiveList == this.MyActiveList.Parent1List.Child1List) {
                    this.MyActiveList.Parent1List.PreferredChild = 1;
                }
                if (this.MyActiveList == this.MyActiveList.Parent1List.Child2List) {
                    this.MyActiveList.Parent1List.PreferredChild = 2;
                }
                this.SetActiveList(this.GetParent1Index(this.ActiveList));
                this.MyActiveList.SetActiveMarker(this.MyActiveList.NumMarkers() - 1);
                return true;
            }
            if (this.MyActiveList.Parent2List != null) {
                if (this.MyActiveList == this.MyActiveList.Parent2List.Child1List) {
                    this.MyActiveList.Parent2List.PreferredChild = 1;
                }
                if (this.MyActiveList == this.MyActiveList.Parent2List.Child2List) {
                    this.MyActiveList.Parent2List.PreferredChild = 2;
                }
                this.SetActiveList(this.GetParent2Index(this.ActiveList));
                this.MyActiveList.SetActiveMarker(this.MyActiveList.NumMarkers() - 1);
                return true;
            }
            return false;
        }
        this.MyActiveList.AdvancePoint(howmany);
        return true;
    }

    int ActiveMarkerPos() {
        if (this.NumLists < 1) {
            return 0;
        }
        return this.MyActiveList.ActiveMarkerPos();
    }

    boolean CommonRoot(int list1, int list2) {
        MarkerList Root1 = this.GetMarkerList(list1);
        MarkerList Root2 = this.GetMarkerList(list2);
        while (Root1.Parent1List != null) {
            Root1 = Root1.Parent1List;
        }
        while (Root2.Parent1List != null) {
            Root2 = Root2.Parent1List;
        }
        return Root1 == Root2;
    }

    void SetActiveMarker(int pos) {
        if (this.NumLists < 1) {
            return;
        }
        this.MyActiveList.SetActiveMarker(pos);
    }

    void SetActiveMarker(APoint pt) {
        if (this.NumLists < 1) {
            return;
        }
        for (int nr = 0; nr < this.NumLists; ++nr) {
            int mymarker = this.GetMarkerList(nr).GetMarkerNr(pt);
            if (mymarker < 0) continue;
            this.SetActiveList(nr);
            this.SetActiveMarker(mymarker);
            return;
        }
    }

    void ToggleColor() {
        if (this.NumLists < 1) {
            return;
        }
        this.MyActiveList.ToggleColor();
    }

    public void ImportPositions(float[][] positions) {
        int numpos = positions.length;
        for (int n = 0; n < numpos; ++n) {
            this.MyActiveList.AddPoint(new APoint(positions[n][0], positions[n][1], positions[n][2], positions[n][3], positions[n][4]));
        }
    }

    void SetActiveList(int listnr) {
        this.ActiveList = listnr;
        this.MyActiveList = this.GetMarkerList(this.ActiveList);
    }

    int GetActiveList() {
        return this.ActiveList;
    }

    int GetPrefChildListNr(int alist) {
        if (alist < 0) {
            alist = this.ActiveList;
        }
        if (this.GetMarkerList((int)alist).Child1List != null && (this.GetMarkerList((int)alist).Child2List == null || this.GetMarkerList((int)alist).PreferredChild == 1)) {
            return this.GetChild1Index(alist);
        }
        if (this.GetMarkerList((int)alist).Child2List != null && (this.GetMarkerList((int)alist).Child1List == null || this.GetMarkerList((int)alist).PreferredChild == 2)) {
            return this.GetChild2Index(alist);
        }
        return -1;
    }

    int GetFirstAncestorNr(int alist) {
        if (alist < 0) {
            alist = this.ActiveList;
        }
        while (this.GetParent1Index(alist) >= 0) {
            int parent = this.GetParent1Index(alist);
            this.GetMarkerList((int)parent).PreferredChild = this.GetMarkerList((int)parent).Child1List == this.GetMarkerList(alist) ? 1 : 2;
            alist = parent;
        }
        return alist;
    }

    void MarkerListDialog(int MarkerListNr) {
        if (MarkerListNr < 0) {
            MarkerListNr = this.ActiveList;
        }
        MarkerList mlist = this.GetMarkerList(MarkerListNr);
        int mycolor = mlist.GetColor();
        int Red = mycolor / 256 / 256 & 0xFF;
        int Green = mycolor / 256 & 0xFF;
        int Blue = mycolor & 0xFF;
        AGenericDialog md = new AGenericDialog("Marker List " + MarkerListNr);
        md.addStringField("MarkerListName: ", mlist.MyName);
        md.addNumericField("Parent1: ", this.GetParent1Index(MarkerListNr), 5);
        md.addNumericField("Parent2: ", this.GetParent2Index(MarkerListNr), 5);
        md.addNumericField("Child1: ", this.GetChild1Index(MarkerListNr), 5);
        md.addNumericField("Child2: ", this.GetChild2Index(MarkerListNr), 5);
        md.addNumericField("Red: ", Red, 5);
        md.addNumericField("Green: ", Green, 5);
        md.addNumericField("Blue: ", Blue, 5);
        md.showDialog();
        if (!md.wasCanceled()) {
            int Ch2;
            MarkerList nch;
            int Ch1;
            MarkerList nparent;
            mlist.MyName = md.getNextString();
            int Parent1 = (int)md.getNextNumber();
            int Parent2 = (int)md.getNextNumber();
            if (Parent1 != this.GetParent1Index(MarkerListNr)) {
                if (Parent1 < 0) {
                    if (mlist.Parent1List != null && mlist.Parent1List.Child1List == mlist) {
                        mlist.Parent1List.Child1List = null;
                    }
                    if (mlist.Parent1List != null && mlist.Parent1List.Child2List == mlist) {
                        mlist.Parent1List.Child2List = null;
                    }
                    mlist.Parent1List = null;
                } else {
                    nparent = this.GetMarkerList(Parent1);
                    if (nparent.Child1List == null) {
                        nparent.Child1List = mlist;
                        mlist.Parent1List = nparent;
                    } else if (nparent.Child2List == null) {
                        nparent.Child2List = mlist;
                        mlist.Parent1List = nparent;
                    } else {
                        IJ.showMessage((String)"Warning: Cannot reconnect parent 1. New Parent 1 has no free children.");
                    }
                }
            }
            if (Parent2 != this.GetParent2Index(MarkerListNr)) {
                if (Parent2 < 0) {
                    if (mlist.Parent2List != null && mlist.Parent2List.Child1List == mlist) {
                        mlist.Parent2List.Child1List = null;
                    }
                    if (mlist.Parent2List != null && mlist.Parent2List.Child2List == mlist) {
                        mlist.Parent2List.Child2List = null;
                    }
                    mlist.Parent2List = null;
                } else {
                    nparent = this.GetMarkerList(Parent2);
                    if (nparent.Child1List == null) {
                        nparent.Child1List = mlist;
                        mlist.Parent2List = nparent;
                    } else if (nparent.Child2List == null) {
                        nparent.Child2List = mlist;
                        mlist.Parent2List = nparent;
                    } else {
                        IJ.showMessage((String)"Warning: Cannot reconnect parent 2. New Parent 2 has no free children.");
                    }
                }
            }
            if ((Ch1 = (int)md.getNextNumber()) != this.GetChild1Index(MarkerListNr)) {
                if (Ch1 < 0) {
                    if (mlist.Child1List != null && mlist.Child1List.Parent1List == mlist) {
                        mlist.Child1List.Parent1List = null;
                        mlist.Child1List = null;
                    } else if (mlist.Child1List != null && mlist.Child1List.Parent2List == mlist) {
                        mlist.Child1List.Parent2List = null;
                        mlist.Child1List = null;
                    }
                } else {
                    nch = this.GetMarkerList(Ch1);
                    if (nch != null) {
                        if (nch.Parent1List != null) {
                            if (nch.Parent2List != null) {
                                if (nch.Parent2List.Child1List == nch) {
                                    nch.Parent2List.Child1List = null;
                                }
                                if (nch.Parent2List.Child2List == nch) {
                                    nch.Parent2List.Child2List = null;
                                }
                                nch.Parent2List = mlist;
                            } else {
                                nch.Parent2List = mlist;
                            }
                        } else {
                            nch.Parent1List = mlist;
                        }
                        mlist.Child1List = nch;
                    }
                }
            }
            if ((Ch2 = (int)md.getNextNumber()) != this.GetChild2Index(MarkerListNr)) {
                if (Ch2 < 0) {
                    if (mlist.Child2List != null && mlist.Child2List.Parent1List == mlist) {
                        mlist.Child2List.Parent1List = null;
                        mlist.Child2List = null;
                    } else if (mlist.Child2List != null && mlist.Child2List.Parent2List == mlist) {
                        mlist.Child2List.Parent2List = null;
                        mlist.Child2List = null;
                    }
                } else {
                    nch = this.GetMarkerList(Ch2);
                    if (nch != null) {
                        if (nch.Parent1List != null) {
                            if (nch.Parent2List != null) {
                                if (nch.Parent2List.Child1List == nch) {
                                    nch.Parent2List.Child1List = null;
                                }
                                if (nch.Parent2List.Child2List == nch) {
                                    nch.Parent2List.Child2List = null;
                                }
                                nch.Parent2List = mlist;
                            } else {
                                nch.Parent2List = mlist;
                            }
                        } else {
                            nch.Parent1List = mlist;
                        }
                        mlist.Child2List = nch;
                    }
                }
            }
            Red = (int)md.getNextNumber();
            Green = (int)md.getNextNumber();
            Blue = (int)md.getNextNumber();
            mlist.SetColor(Blue + Green * 256 + Red * 256 * 256);
        }
    }

    int FindMarkerListByName(String MarkerName) {
        for (int n = 0; n < this.NumLists; ++n) {
            if (!this.GetMarkerList((int)n).MyName.equals(MarkerName)) continue;
            return n;
        }
        return this.NumLists;
    }

    void DeleteDublicateMarkerLists() {
        for (int n = this.ListOffset; n < this.NumLists; ++n) {
            for (int m = 0; m < this.ListOffset; ++m) {
                MarkerList nlist = this.GetMarkerList(n);
                if (nlist.MyName == null || nlist.MyName.equals("") || !nlist.MyName.equals(this.GetMarkerList((int)m).MyName)) continue;
                try {
                    int mynum = Integer.parseInt(nlist.MyName);
                    if (mynum >= this.CurrentNameNr) {
                        this.CurrentNameNr = mynum + 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.SetActiveList(m);
                this.RemoveList();
                --this.ListOffset;
                --m;
                --n;
            }
        }
        this.ListOffset = 0;
        this.SetActiveList(this.NumLists - 1);
        this.MyActiveList.ActivePoint = 0;
    }

    boolean InsertInformationVector(float[] info, String MarkerName) {
        int ll;
        int listnr = (int)info[0] + this.ListOffset;
        int markernr = (int)info[1];
        double posx = info[2];
        double posy = info[3];
        double posz = info[4];
        double pose = info[5];
        double post = info[6];
        double integral = info[7];
        double max = info[8];
        int tagged = (int)info[16];
        int Parent1Nr = (int)info[17];
        int Parent2Nr = (int)info[18];
        int Child1Nr = (int)info[19];
        int Child2Nr = (int)info[20];
        int MyColor = (int)info[21];
        if (Parent1Nr >= 0) {
            Parent1Nr += this.ListOffset;
        }
        if (Parent2Nr >= 0) {
            Parent2Nr += this.ListOffset;
        }
        if (Child1Nr >= 0) {
            Child1Nr += this.ListOffset;
        }
        if (Child2Nr >= 0) {
            Child2Nr += this.ListOffset;
        }
        if (listnr > this.NumLists) {
            listnr = this.NumLists;
        }
        if (listnr >= this.NumLists) {
            for (ll = this.NumLists; ll <= listnr; ++ll) {
                this.AppendList();
            }
        }
        if (Parent1Nr >= 0 && Parent1Nr >= this.NumLists) {
            for (ll = this.NumLists; ll <= Parent1Nr; ++ll) {
                this.AppendList();
            }
        }
        if (Parent2Nr >= 0 && Parent2Nr >= this.NumLists) {
            for (ll = this.NumLists; ll <= Parent2Nr; ++ll) {
                this.AppendList();
            }
        }
        if (Child1Nr >= 0 && Child1Nr >= this.NumLists) {
            for (ll = this.NumLists; ll <= Child1Nr; ++ll) {
                this.AppendList();
            }
        }
        if (Child2Nr >= 0 && Child2Nr >= this.NumLists) {
            for (ll = this.NumLists; ll <= Child2Nr; ++ll) {
                this.AppendList();
            }
        }
        this.SetActiveList(listnr);
        if (Parent1Nr >= 0) {
            this.MyActiveList.Parent1List = this.GetMarkerList(Parent1Nr);
        }
        if (Parent2Nr >= 0) {
            this.MyActiveList.Parent2List = this.GetMarkerList(Parent2Nr);
        }
        if (Child1Nr >= 0) {
            this.MyActiveList.Child1List = this.GetMarkerList(Child1Nr);
        }
        if (Child2Nr >= 0) {
            this.MyActiveList.Child2List = this.GetMarkerList(Child2Nr);
        }
        int NumPoints = this.NumMarkers(this.ActiveList);
        APoint pt = new APoint(posx, posy, posz, pose, post);
        if (NumPoints > 0) {
            pt.mycolor = this.GetPoint((int)0, (int)-1).mycolor;
        }
        if (NumPoints == 1) {
            this.MyActiveList.SetColor(pt.mycolor);
        }
        pt.tagged = tagged != 0;
        pt.integral = integral;
        pt.max = max;
        pt.mycolor = MyColor;
        this.MyActiveList.MyName = MarkerName;
        if (MarkerName == null || MarkerName.equals("")) {
            if (Parent1Nr >= 0 && Parent2Nr >= 0) {
                this.MyActiveList.MyName = "(" + this.MyActiveList.Parent1List.MyName + "_" + this.MyActiveList.Parent2List.MyName + ")";
            } else if (Parent1Nr >= 0) {
                if (this.MyActiveList.Parent1List.Child1List == this.MyActiveList) {
                    this.MyActiveList.MyName = this.MyActiveList.Parent1List.MyName + "a";
                }
                if (this.MyActiveList.Parent1List.Child2List == this.MyActiveList) {
                    this.MyActiveList.MyName = this.MyActiveList.Parent1List.MyName + "b";
                }
                if (this.MyActiveList.Child1List != null && this.MyActiveList.Child1List.Parent1List == this.MyActiveList) {
                    this.MyActiveList.Child1List.MyName = this.MyActiveList.MyName + "a";
                }
                if (this.MyActiveList.Child2List != null && this.MyActiveList.Child2List.Parent1List == this.MyActiveList) {
                    this.MyActiveList.Child2List.MyName = this.MyActiveList.MyName + "b";
                }
            } else if (Parent2Nr >= 0) {
                if (this.MyActiveList.Parent2List.Child1List == this.MyActiveList) {
                    this.MyActiveList.MyName = this.MyActiveList.Parent2List.MyName + "a";
                }
                if (this.MyActiveList.Parent2List.Child2List == this.MyActiveList) {
                    this.MyActiveList.MyName = this.MyActiveList.Parent2List.MyName + "b";
                }
                if (this.MyActiveList.Child1List != null && this.MyActiveList.Child1List.Parent2List == this.MyActiveList) {
                    this.MyActiveList.Child1List.MyName = this.MyActiveList.MyName + "a";
                }
                if (this.MyActiveList.Child2List != null && this.MyActiveList.Child2List.Parent2List == this.MyActiveList) {
                    this.MyActiveList.Child2List.MyName = this.MyActiveList.MyName + "b";
                }
            } else {
                if (this.MyActiveList == null || this.MyActiveList.MyName == null || !this.MyActiveList.MyName.equals("" + this.CurrentNameNr)) {
                    this.CurrentNameNr = listnr + 1;
                }
                this.MyActiveList.MyName = "" + this.CurrentNameNr;
            }
        }
        if (markernr > NumPoints) {
            return false;
        }
        if (markernr == NumPoints) {
            this.MyActiveList.AddPoint(pt);
        } else {
            pt = this.GetPoint(markernr, listnr);
            pt.coord[0] = posx;
            pt.coord[1] = posy;
            pt.coord[2] = posz;
            pt.coord[3] = pose;
            pt.coord[4] = post;
        }
        pt.integral = integral;
        pt.max = max;
        pt.tagged = tagged != 0;
        return true;
    }

    public void DeleteAllMarkerLists() {
        while (this.NumMarkerLists() > 1) {
            this.RemoveList();
        }
        this.RemoveList();
    }

    public void ImportMarkerLists(float[][] lists) {
        this.ListOffset = this.NumLists;
        for (int l = 0; l < lists.length; ++l) {
            float[] alist = lists[l];
            this.InsertInformationVector(alist, "");
        }
        this.DeleteDublicateMarkerLists();
    }

    boolean readline(StreamTokenizer is, My3DData data3d) throws IOException {
        float[] myinfo = new float[22];
        is.eolIsSignificant(true);
        int pos = 0;
        while (pos < 22) {
            if (is.ttype == -1) {
                return false;
            }
            is.nextToken();
            if (is.ttype == 10 && pos > 7) {
                return this.InsertInformationVector(myinfo, "");
            }
            if (is.ttype != -2) continue;
            myinfo[pos] = (float)is.nval;
            ++pos;
        }
        is.nextToken();
        String myVal = "";
        while (is.ttype != 10 && is.ttype != -1) {
            if (is.ttype == -2) {
                myVal = (double)((int)is.nval) == is.nval ? myVal + (int)is.nval : myVal + is.nval;
                if (is.nval > (double)this.CurrentNameNr) {
                    this.CurrentNameNr = (int)is.nval + 1;
                }
            }
            if (is.ttype == -3) {
                myVal = myVal + is.sval;
            }
            is.nextToken();
        }
        return this.InsertInformationVector(myinfo, myVal);
    }

    int GetParent1Index(int listnr) {
        if (this.NumLists <= 0) {
            return -1;
        }
        return this.ListOfLists.indexOf(this.GetMarkerList((int)listnr).Parent1List);
    }

    int GetParent2Index(int listnr) {
        if (this.NumLists <= 0) {
            return -1;
        }
        return this.ListOfLists.indexOf(this.GetMarkerList((int)listnr).Parent2List);
    }

    int GetChild1Index(int listnr) {
        if (this.NumLists <= 0) {
            return -1;
        }
        return this.ListOfLists.indexOf(this.GetMarkerList((int)listnr).Child1List);
    }

    int GetChild2Index(int listnr) {
        if (this.NumLists <= 0) {
            return -1;
        }
        return this.ListOfLists.indexOf(this.GetMarkerList((int)listnr).Child2List);
    }

    boolean HasParent(int list) {
        return this.GetParent1Index(list) >= 0 || this.GetParent2Index(list) >= 0;
    }

    boolean HasParent1(int list) {
        return this.GetParent1Index(list) >= 0;
    }

    boolean HasParent2(int list) {
        return this.GetParent2Index(list) >= 0;
    }

    APoint GetParent1EndOfTrack(int list, int dir) {
        if (!this.HasParent(list)) {
            return null;
        }
        MarkerList myparent = this.GetMarkerList(this.GetParent1Index(list));
        return myparent.GetPoint(myparent.NumPoints - 1);
    }

    APoint GetParent2EndOfTrack(int list, int dir) {
        if (!this.HasParent(list)) {
            return null;
        }
        MarkerList myparent = this.GetMarkerList(this.GetParent2Index(list));
        return myparent.GetPoint(myparent.NumPoints - 1);
    }

    public double[][] ExportMarkers(int list, My3DData data3d) {
        if (list >= this.NumLists) {
            return new double[0][0];
        }
        double[][] markers = this.GetMarkerList(list).ExportMarkers();
        for (int i = 0; i < markers.length; ++i) {
            int elem = (int)(markers[i][3] + 0.5);
            double[] dArray = markers[i];
            dArray[7] = dArray[7] * data3d.GetScale(elem, 0);
            double[] dArray2 = markers[i];
            dArray2[7] = dArray2[7] + data3d.GetOffset(elem, 0);
            double[] dArray3 = markers[i];
            dArray3[8] = dArray3[8] * data3d.GetScale(elem, 1);
            double[] dArray4 = markers[i];
            dArray4[8] = dArray4[8] + data3d.GetOffset(elem, 1);
            double[] dArray5 = markers[i];
            dArray5[9] = dArray5[9] * data3d.GetScale(elem, 2);
            double[] dArray6 = markers[i];
            dArray6[9] = dArray6[9] + data3d.GetOffset(elem, 2);
            double[] dArray7 = markers[i];
            dArray7[10] = dArray7[10] * data3d.GetScale(elem, 3);
            double[] dArray8 = markers[i];
            dArray8[10] = dArray8[10] + data3d.GetOffset(elem, 3);
            double[] dArray9 = markers[i];
            dArray9[11] = dArray9[11] * data3d.GetScale(elem, 4);
            double[] dArray10 = markers[i];
            dArray10[11] = dArray10[11] + data3d.GetOffset(elem, 4);
            double[] dArray11 = markers[i];
            dArray11[12] = dArray11[12] * data3d.GetValueScale(elem);
            double[] dArray12 = markers[i];
            dArray12[12] = dArray12[12] + data3d.GetValueScale(elem);
            double[] dArray13 = markers[i];
            dArray13[13] = dArray13[13] * data3d.GetValueScale(elem);
            double[] dArray14 = markers[i];
            dArray14[13] = dArray14[13] + data3d.GetValueScale(elem);
            markers[i][15] = this.GetParent1Index(list);
            markers[i][16] = this.GetParent2Index(list);
            markers[i][17] = this.GetChild1Index(list);
            markers[i][18] = this.GetChild2Index(list);
        }
        return markers;
    }

    public double[][] ExportMarkerLists(My3DData data3d) {
        int totallength = 0;
        for (int list = 0; list < this.NumLists; ++list) {
            totallength += this.GetMarkerList((int)list).NumPoints;
        }
        double[][] alllists = new double[totallength][];
        int pos = 0;
        for (int list = 0; list < this.NumLists; ++list) {
            double[][] alist = this.ExportMarkers(list, data3d);
            for (int m = 0; m < alist.length; ++m) {
                alllists[pos] = new double[22];
                alllists[pos][0] = list;
                alllists[pos][1] = m;
                for (int n = 0; n < alist[m].length; ++n) {
                    alllists[pos][n + 2] = alist[m][n];
                }
                ++pos;
            }
        }
        return alllists;
    }

    double[] MSD(int list, My3DData data3d) {
        int asize = data3d.sizes[data3d.TrackDirection];
        double[] msds = new double[asize];
        double[] events = new double[asize];
        this.MSDSum(list, data3d, msds, events);
        this.MSDFinal(msds, events, asize);
        return msds;
    }

    double[] AllMSD(My3DData data3d) {
        int asize = data3d.sizes[data3d.TrackDirection];
        double[] msds = new double[asize];
        double[] events = new double[asize];
        for (int list = 0; list < this.NumLists; ++list) {
            this.MSDSum(list, data3d, msds, events);
        }
        this.MSDFinal(msds, events, asize);
        return msds;
    }

    static final double ClipAt(double data, double low, double high) {
        return data > high ? high : (data < low ? low : data);
    }

    boolean MSDSum(int list, My3DData data3d, double[] msds, double[] events) {
        int asize = data3d.sizes[data3d.TrackDirection];
        int listlength = this.NumMarkers(list);
        for (int n = 0; n < listlength; ++n) {
            for (int t = 0; t < listlength - n; ++t) {
                APoint pointT = this.GetPoint(t, list);
                APoint pointTN = this.GetPoint(t + n, list);
                int dT = (int)(pointTN.coord[data3d.TrackDirection] - pointT.coord[data3d.TrackDirection]);
                dT = (int)MarkerLists.ClipAt(dT, 0.0, asize - 1);
                if (data3d.TrackDirection == 2) {
                    int n2 = dT;
                    msds[n2] = msds[n2] + pointT.SqrXYDistTo(pointTN, 1.0, 1.0);
                } else {
                    int n3 = dT;
                    msds[n3] = msds[n3] + pointT.SqrDistTo(pointTN, 1.0, 1.0, 1.0);
                }
                int n4 = dT;
                events[n4] = events[n4] + 1.0;
            }
        }
        return true;
    }

    boolean MSDFinal(double[] msds, double[] events, int listlength) {
        for (int n = 0; n < listlength; ++n) {
            int n2 = n;
            msds[n2] = msds[n2] / events[n];
        }
        return true;
    }

    void Penalize(APoint aPt, double fwhm, int direction) {
        double sigma2 = fwhm / 2.0 * (fwhm / 2.0) / Math.log(2.0);
        for (int list = 0; list < this.NumLists; ++list) {
            if (list == this.ActiveList) continue;
            int listlength = this.NumMarkers(list);
            for (int i = 0; i < listlength; ++i) {
                int d;
                APoint point = this.GetPoint(i, list);
                if (aPt == point || point.coord[direction] != aPt.coord[direction]) continue;
                double ssqr = 0.0;
                for (d = 0; d < 5; ++d) {
                    if (direction == d) continue;
                    ssqr += (point.coord[d] - aPt.coord[d]) * (point.coord[d] - aPt.coord[d]);
                }
                System.out.println("penalizing point " + aPt.toString() + " by " + ssqr);
                if (ssqr <= 0.0) {
                    return;
                }
                double weight = fwhm * Math.exp(-ssqr / sigma2);
                System.out.println(" weight" + weight);
                for (d = 0; d < 5; ++d) {
                    if (direction == d) continue;
                    int n = d;
                    aPt.coord[n] = aPt.coord[n] - (point.coord[d] - aPt.coord[d]) / Math.sqrt(ssqr) * weight;
                }
                System.out.println("penalized point" + aPt.toString() + " by " + ssqr);
            }
        }
    }

    double Penalty(APoint aPt, double fwhm, int direction, double IntMaxScale) {
        double penalty = 0.0;
        double sigma2 = fwhm / 2.0 * (fwhm / 2.0) / Math.log(2.0);
        for (int list = 0; list < this.NumLists; ++list) {
            if (list == this.ActiveList) continue;
            int listlength = this.NumMarkers(list);
            for (int i = 0; i < listlength; ++i) {
                double ssqr = 0.0;
                APoint point = this.GetPoint(i, list);
                if (aPt != point && point.coord[direction] == aPt.coord[direction]) {
                    for (int d = 0; d < 5; ++d) {
                        if (direction == d) continue;
                        ssqr += (point.coord[d] - aPt.coord[d]) * (point.coord[d] - aPt.coord[d]);
                    }
                }
                penalty += IntMaxScale * point.integralAboveMin * Math.exp(-ssqr / sigma2);
            }
        }
        return penalty;
    }

    public String PrintList(My3DData data3d) {
        String newtext = "#List Nr.,\tMarker Nr,\tPosX [pixels],\tY [pixels],\tZ [pixels],\tElements [element],\tTime [time],\tIntegral (no BG sub) [Units],\tMax (no BG sub) [Units],\t" + data3d.GetAxisNames()[0] + " [" + data3d.GetAxisUnits()[0] + "],\t" + data3d.GetAxisNames()[1] + " [" + data3d.GetAxisUnits()[1] + "],\t" + data3d.GetAxisNames()[2] + " [" + data3d.GetAxisUnits()[2] + "],\t" + data3d.GetAxisNames()[3] + " [" + data3d.GetAxisUnits()[3] + "],\t" + data3d.GetAxisNames()[4] + " [" + data3d.GetAxisUnits()[4] + "],\tIntegral " + data3d.GetValueName(data3d.ActiveElement) + " (no BG sub)[" + data3d.GetValueUnit(data3d.ActiveElement) + "],\tMax " + data3d.GetValueName(data3d.ActiveElement) + " (no BG sub)[" + data3d.GetValueUnit(data3d.ActiveElement) + "]\tTagText \tTagInteger \tParent1 \tParent2 \tChild1 \t Child2 \tListColor \tListName\n";
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setMaximumFractionDigits(2);
        nf.setGroupingUsed(false);
        for (int l = 0; l < this.NumLists; ++l) {
            newtext = newtext + "\n";
            for (int i = 0; i < this.NumMarkers(l); ++i) {
                APoint point = this.GetPoint(i, l);
                int elem = (int)(point.coord[3] + 0.5);
                newtext = newtext + l + "\t" + i + "\t" + nf.format(point.coord[0]) + "\t" + nf.format(point.coord[1]) + "\t" + nf.format(point.coord[2]) + "\t" + nf.format(point.coord[3]) + "\t" + nf.format(point.coord[4]) + "\t" + nf.format(point.integral) + "\t" + nf.format(point.max) + "\t" + nf.format(point.coord[0] * data3d.GetScale(elem, 0) + data3d.GetOffset(elem, 0)) + "\t" + nf.format(point.coord[1] * data3d.GetScale(elem, 1) + data3d.GetOffset(elem, 1)) + "\t" + nf.format(point.coord[2] * data3d.GetScale(elem, 2) + data3d.GetOffset(elem, 2)) + "\t" + nf.format(point.coord[3] * data3d.GetScale(elem, 3) + data3d.GetOffset(elem, 3)) + "\t" + nf.format(point.coord[4] * data3d.GetScale(elem, 4) + data3d.GetOffset(elem, 4)) + "\t" + nf.format(point.integral * data3d.GetValueScale(elem) + data3d.GetValueOffset(elem)) + "\t" + nf.format(point.max * data3d.GetValueScale(elem) + data3d.GetValueOffset(elem)) + '\t' + point.tagged + "\t";
                newtext = point.tagged ? newtext + "1\t" : newtext + "0\t";
                newtext = newtext + this.GetParent1Index(l) + "\t";
                newtext = newtext + this.GetParent2Index(l) + "\t";
                newtext = newtext + this.GetChild1Index(l) + "\t";
                newtext = newtext + this.GetChild2Index(l) + "\t";
                newtext = newtext + this.GetMarkerList(l).GetColor() + "\t";
                newtext = newtext + this.GetMarkerList(l).GetMarkerListName() + "\n";
            }
        }
        return newtext;
    }

    double[] MSDFromList(My3DData data3d, int l, boolean do3D) {
        int i;
        double[] MSDs = new double[(int)Math.sqrt(this.NumMarkers(l) + 1)];
        double[] MSDNums = new double[(int)Math.sqrt(this.NumMarkers(l) + 1)];
        for (i = 0; i < this.NumMarkers(l); ++i) {
            for (int j = i + 1; j < this.NumMarkers(l); ++j) {
                APoint point = this.GetPoint(i, l);
                APoint point2 = this.GetPoint(j, l);
                int elem = (int)point.coord[3];
                int adT = (int)(point2.coord[data3d.TrackDirection] - point.coord[data3d.TrackDirection]);
                double SumDist2 = do3D ? point.SqrDistTo(point2, data3d.GetScale(elem, 0), data3d.GetScale(elem, 1), data3d.GetScale(elem, 2)) : point.SqrXYDistTo(point2, data3d.GetScale(elem, 0), data3d.GetScale(elem, 1));
                if (adT < 0) {
                    adT = -adT;
                }
                if (adT < MSDs.length + 1) {
                    if (adT <= 0) continue;
                    int n = adT - 1;
                    MSDs[n] = MSDs[n] + SumDist2;
                    int n2 = adT - 1;
                    MSDNums[n2] = MSDNums[n2] + 1.0;
                    continue;
                }
                j = this.NumMarkers(l);
            }
        }
        for (i = 0; i < MSDs.length; ++i) {
            if (!(MSDNums[i] > 0.0)) continue;
            int n = i;
            MSDs[n] = MSDs[n] / MSDNums[i];
        }
        return MSDs;
    }

    String PrintSummary(My3DData data3d) {
        String newtext = "# Statistics Summary\n#\t";
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setMaximumFractionDigits(3);
        nf.setGroupingUsed(false);
        int doMSD = 1;
        for (int l = 0; l < this.NumLists; ++l) {
            double[] MSDs;
            double SumXYSpeed = 0.0;
            double SumXYZSpeed = 0.0;
            double N = 0.0;
            APoint oldpoint = this.GetPoint(0, l);
            for (int i = 1; i < this.NumMarkers(l); ++i) {
                APoint point = this.GetPoint(i, l);
                int elem = (int)point.coord[3];
                double adT = (point.coord[data3d.TrackDirection] - oldpoint.coord[data3d.TrackDirection]) * data3d.GetScale(elem, data3d.TrackDirection);
                double XYDist = Math.sqrt(point.SqrXYDistTo(oldpoint, data3d.GetScale(elem, 0), data3d.GetScale(elem, 1)));
                double XYZDist = Math.sqrt(point.SqrDistTo(oldpoint, data3d.GetScale(elem, 0), data3d.GetScale(elem, 1), data3d.GetScale(elem, 2)));
                SumXYSpeed += XYDist / adT;
                SumXYZSpeed += XYZDist / adT;
                oldpoint = point;
                N += 1.0;
            }
            if (this.NumMarkers(l) > 0) {
                newtext = newtext + "\n# Summary for List \t" + l + "\n";
                int elem = (int)this.GetPoint((int)0, (int)l).coord[3];
                double totalXY = Math.sqrt(this.GetPoint(0, l).SqrXYDistTo(this.GetPoint(this.NumMarkers(l) - 1, l), data3d.GetScale(elem, 0), data3d.GetScale(elem, 1)));
                double totalXYZ = Math.sqrt(this.GetPoint(0, l).SqrDistTo(this.GetPoint(this.NumMarkers(l) - 1, l), data3d.GetScale(elem, 0), data3d.GetScale(elem, 1), data3d.GetScale(elem, 2)));
                double dT = (this.GetPoint((int)(this.NumMarkers((int)l) - 1), (int)l).coord[data3d.TrackDirection] - this.GetPoint((int)elem, (int)l).coord[data3d.TrackDirection]) * data3d.GetScale(elem, data3d.TrackDirection);
                String XY = data3d.GetAxisNames()[0] + data3d.GetAxisNames()[1];
                String XYZ = data3d.GetAxisNames()[0] + data3d.GetAxisNames()[1] + data3d.GetAxisNames()[2];
                if (data3d.TrackDirection == 2) {
                    newtext = newtext + "\n# Total " + XY + " Distance traveled: \t" + nf.format(totalXY) + " [" + data3d.GetAxisUnits()[0] + "]\n";
                    newtext = newtext + "# Length of Trace: \t" + nf.format(dT) + " [" + data3d.GetAxisUnits()[data3d.TrackDirection] + "]\n";
                    newtext = newtext + "# Segments in Trace: \t" + nf.format(N) + "\n";
                    newtext = newtext + "# Total " + XY + " speed: \t" + nf.format(totalXY / dT) + " [" + data3d.GetAxisUnits()[0] + "/" + data3d.GetAxisUnits()[data3d.TrackDirection] + "]\n";
                    newtext = newtext + "# Average " + XY + " speed: \t" + nf.format(SumXYSpeed / N) + " [" + data3d.GetAxisUnits()[0] + "/" + data3d.GetAxisUnits()[data3d.TrackDirection] + "]\n";
                    newtext = newtext + "# Directionality Index: \t" + nf.format(totalXY / dT / (SumXYSpeed / N)) + "\n";
                } else if (data3d.TrackDirection == 4) {
                    newtext = newtext + "\n# Total XYZ Distance traveled: \t" + nf.format(totalXYZ) + " [" + data3d.GetAxisUnits()[0] + "]\n";
                    newtext = newtext + "# Length of Trace: \t" + nf.format(dT) + " [" + data3d.GetAxisUnits()[data3d.TrackDirection] + "]\n";
                    newtext = newtext + "# Segments in Trace: \t" + nf.format(N) + "\n";
                    newtext = newtext + "# Total " + XY + " speed: \t" + nf.format(totalXY / dT) + " [" + data3d.GetAxisUnits()[0] + "/" + data3d.GetAxisUnits()[data3d.TrackDirection] + "]\n";
                    newtext = newtext + "# Total " + XYZ + " speed: \t" + nf.format(totalXYZ / dT) + " [" + data3d.GetAxisUnits()[0] + "/" + data3d.GetAxisUnits()[data3d.TrackDirection] + "]\n";
                    newtext = newtext + "# Average " + XY + " speed: \t" + nf.format(SumXYSpeed / N) + " [" + data3d.GetAxisUnits()[0] + "/" + data3d.GetAxisUnits()[data3d.TrackDirection] + "]\n";
                    newtext = newtext + "# Average " + XYZ + " speed: \t" + nf.format(SumXYZSpeed / N) + " [" + data3d.GetAxisUnits()[0] + "/" + data3d.GetAxisUnits()[data3d.TrackDirection] + "]\n";
                    newtext = newtext + "# Directionality " + XY + " Index: \t" + nf.format(totalXY / dT / (SumXYSpeed / N)) + "\n";
                    newtext = newtext + "# Directionality " + XYZ + " Index: \t" + nf.format(totalXYZ / dT / (SumXYZSpeed / N)) + "\n";
                }
            }
            if (doMSD <= 0 || this.NumMarkers(l) <= 1) continue;
            if (data3d.TrackDirection == 2 || data3d.SizeZ == 1) {
                newtext = newtext + "\n# XY-MSD summary list : \t" + l + "]\n";
                MSDs = this.MSDFromList(data3d, l, false);
            } else {
                newtext = newtext + "\n# XYZ-MSD summary list : \t" + l + "]\n";
                MSDs = this.MSDFromList(data3d, l, true);
            }
            int elem = (int)this.GetPoint((int)0, (int)l).coord[3];
            for (int dd = 0; dd < MSDs.length; ++dd) {
                newtext = newtext + "#\t" + l + "\t" + (double)(dd + 1) * data3d.GetScale(elem, data3d.TrackDirection) + "\t" + MSDs[dd] + "\n";
            }
        }
        return newtext;
    }

    void AppendList() {
        this.MyActiveList = new MarkerList();
        this.ListOfLists.addElement(this.MyActiveList);
        ++this.NumLists;
    }

    void NewList() {
        this.MyActiveList = new MarkerList();
        if (this.ActiveList < 0) {
            this.ActiveList = 0;
            this.ListOfLists.addElement(this.MyActiveList);
        } else {
            ++this.ActiveList;
            this.ListOfLists.insertElementAt(this.MyActiveList, this.ActiveList);
        }
        ++this.NumLists;
        this.MyActiveList.MyName = "" + this.CurrentNameNr++;
    }

    void NewList(int linkTo, String NameExtension) {
        this.NewList();
        --this.CurrentNameNr;
        this.MyActiveList.Link1To(this.GetMarkerList(linkTo));
        this.MyActiveList.MyName = this.MyActiveList.Parent1List.MyName + NameExtension;
    }

    void RemoveList() {
        if (this.NumLists < 1) {
            return;
        }
        if (this.MyActiveList == null) {
            return;
        }
        this.MyActiveList.MyPoints = null;
        if (this.MyActiveList.Parent1List != null) {
            if (this.MyActiveList.Parent1List.Child1List == this.MyActiveList) {
                this.MyActiveList.Parent1List.Child1List = null;
            }
            if (this.MyActiveList.Parent1List.Child2List == this.MyActiveList) {
                this.MyActiveList.Parent1List.Child2List = null;
            }
        }
        if (this.MyActiveList.Parent2List != null) {
            if (this.MyActiveList.Parent2List.Child1List == this.MyActiveList) {
                this.MyActiveList.Parent2List.Child1List = null;
            }
            if (this.MyActiveList.Parent2List.Child2List == this.MyActiveList) {
                this.MyActiveList.Parent2List.Child2List = null;
            }
        }
        if (this.MyActiveList.Child1List != null) {
            if (this.MyActiveList.Child1List.Parent1List == this.MyActiveList) {
                this.MyActiveList.Child1List.Parent1List = null;
            }
            if (this.MyActiveList.Child1List.Parent2List == this.MyActiveList) {
                this.MyActiveList.Child1List.Parent2List = null;
            }
        }
        if (this.MyActiveList.Child2List != null) {
            if (this.MyActiveList.Child2List.Parent1List == this.MyActiveList) {
                this.MyActiveList.Child2List.Parent1List = null;
            }
            if (this.MyActiveList.Child2List.Parent2List == this.MyActiveList) {
                this.MyActiveList.Child2List.Parent2List = null;
            }
        }
        this.ListOfLists.removeElementAt(this.ActiveList);
        --this.NumLists;
        if (this.NumLists <= 0) {
            this.ActiveList = -1;
            this.MyActiveList = null;
            this.NewList();
            this.NumLists = 1;
        }
        if (this.ActiveList >= this.NumLists) {
            this.ActiveList = this.NumLists - 1;
        }
        this.MyActiveList = this.GetMarkerList(this.ActiveList);
    }

    void AdvanceList(int howmany, int TrackDirection) {
        if (this.NumLists <= 1) {
            return;
        }
        int curpos = this.MyActiveList.ActiveMarkerPos();
        APoint CurPt = this.MyActiveList.GetPoint(curpos);
        if (this.NumMarkers(this.ActiveList) <= 0 && this.NumLists > 1) {
            this.RemoveList();
            --howmany;
        }
        this.ActiveList += howmany;
        if (this.ActiveList < 0) {
            this.ActiveList += this.NumLists;
        }
        if (this.ActiveList >= this.NumLists) {
            this.ActiveList %= this.NumLists;
        }
        this.MyActiveList = this.GetMarkerList(this.ActiveList);
        this.MyActiveList.SetActiveMarkerClosest(CurPt, TrackDirection, 0);
    }

    APoint MarkerFromPosition(double px, double py, int dir, double DistX, double DistY, boolean alllists, boolean allslices, boolean alltrack, int trackdir, int trackpos) {
        for (int list = 0; list < this.NumLists; ++list) {
            if (!alllists && list != this.ActiveList) continue;
            for (int p = 0; p < this.NumMarkers(list); ++p) {
                APoint Pt = this.GetPoint(p, list);
                if (!Pt.InRange(px, py, dir, DistX, DistY)) continue;
                if (alltrack || Pt == this.GetPoint(-1, -1)) {
                    return Pt;
                }
                if ((double)((int)Pt.coord[trackdir]) + 0.5 != (double)trackpos) continue;
                return Pt;
            }
        }
        return null;
    }

    APoint MarkerFromPosition(double px, double py, int dir, double DistX, double DistY, My3DData my3ddata) {
        APoint Pt = null;
        for (int list = 0; list < this.NumLists; ++list) {
            Pt = this.GetMarkerList(list).MarkerFromPosition(px, py, dir, DistX, DistY);
            if (Pt == null) continue;
            return Pt;
        }
        return null;
    }
}

