/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.shadergen;

import bvv.core.backend.GpuContext;
import bvv.core.backend.SetUniforms;
import bvv.core.backend.Texture;
import bvv.core.shadergen.Shader;
import bvv.core.shadergen.Uniform1f;
import bvv.core.shadergen.Uniform1fv;
import bvv.core.shadergen.Uniform1i;
import bvv.core.shadergen.Uniform1iv;
import bvv.core.shadergen.Uniform2f;
import bvv.core.shadergen.Uniform2fv;
import bvv.core.shadergen.Uniform2i;
import bvv.core.shadergen.Uniform2iv;
import bvv.core.shadergen.Uniform3f;
import bvv.core.shadergen.Uniform3fv;
import bvv.core.shadergen.Uniform3i;
import bvv.core.shadergen.Uniform3iv;
import bvv.core.shadergen.Uniform4f;
import bvv.core.shadergen.Uniform4fv;
import bvv.core.shadergen.Uniform4i;
import bvv.core.shadergen.Uniform4iv;
import bvv.core.shadergen.UniformMatrix3f;
import bvv.core.shadergen.UniformMatrix4f;
import bvv.core.shadergen.UniformSampler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public abstract class AbstractShader
implements Shader {
    private final StringBuilder vpCode;
    private final StringBuilder fpCode;
    private final Map<String, UniformImp> uniforms = new HashMap<String, UniformImp>();
    private final List<UniformImpSampler> samplers = new ArrayList<UniformImpSampler>();

    public AbstractShader(String vpCode, String fpCode) {
        this.vpCode = new StringBuilder(vpCode);
        this.fpCode = new StringBuilder(fpCode);
    }

    public AbstractShader(StringBuilder vpCode, StringBuilder fpCode) {
        this.vpCode = vpCode;
        this.fpCode = fpCode;
    }

    protected abstract String getUniqueName(String var1);

    @Override
    public Uniform1i getUniform1i(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImp1i.class, UniformImp1i::new);
    }

    @Override
    public Uniform2i getUniform2i(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImp2i.class, UniformImp2i::new);
    }

    @Override
    public Uniform3i getUniform3i(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImp3i.class, UniformImp3i::new);
    }

    @Override
    public Uniform4i getUniform4i(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImp4i.class, UniformImp4i::new);
    }

    @Override
    public Uniform1iv getUniform1iv(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImp1iv.class, UniformImp1iv::new);
    }

    @Override
    public Uniform3iv getUniform3iv(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImp3iv.class, UniformImp3iv::new);
    }

    @Override
    public Uniform2iv getUniform2iv(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImp2iv.class, UniformImp2iv::new);
    }

    @Override
    public Uniform4iv getUniform4iv(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImp4iv.class, UniformImp4iv::new);
    }

    @Override
    public Uniform1f getUniform1f(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImp1f.class, UniformImp1f::new);
    }

    @Override
    public Uniform2f getUniform2f(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImp2f.class, UniformImp2f::new);
    }

    @Override
    public Uniform3f getUniform3f(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImp3f.class, UniformImp3f::new);
    }

    @Override
    public Uniform4f getUniform4f(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImp4f.class, UniformImp4f::new);
    }

    @Override
    public Uniform1fv getUniform1fv(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImp1fv.class, UniformImp1fv::new);
    }

    @Override
    public Uniform3fv getUniform3fv(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImp3fv.class, UniformImp3fv::new);
    }

    @Override
    public Uniform2fv getUniform2fv(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImp2fv.class, UniformImp2fv::new);
    }

    @Override
    public Uniform4fv getUniform4fv(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImp4fv.class, UniformImp4fv::new);
    }

    @Override
    public UniformMatrix4f getUniformMatrix4f(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImpMatrix4f.class, UniformImpMatrix4f::new);
    }

    @Override
    public UniformMatrix3f getUniformMatrix3f(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImpMatrix3f.class, UniformImpMatrix3f::new);
    }

    @Override
    public UniformSampler getUniformSampler(String key) {
        return this.getUniform(this.getUniqueName(key), UniformImpSampler.class, UniformImpSampler::new);
    }

    @Override
    public void use(GpuContext gpu) {
        gpu.use(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindSamplers(GpuContext gpu) {
        boolean firstTextureUnit = true;
        int nextUnit = 1;
        HashMap<Texture, Integer> units = new HashMap<Texture, Integer>();
        Iterator<UniformImpSampler> iterator = this.samplers.iterator();
        while (iterator.hasNext()) {
            UniformImpSampler uniform;
            UniformImpSampler uniformImpSampler = uniform = iterator.next();
            synchronized (uniformImpSampler) {
                int unit = units.getOrDefault(uniform.texture, -1);
                if (unit == -1) {
                    unit = nextUnit++;
                    gpu.bindTexture(uniform.texture, unit);
                    units.put(uniform.texture, unit);
                }
                if (uniform.v0 != unit) {
                    uniform.v0 = unit;
                    uniform.modified = true;
                }
                uniform.valid = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUniforms(GpuContext gpu) {
        SetUniforms visitor = gpu.getUniformSetter(this);
        Iterator<UniformImp> iterator = this.uniforms.values().iterator();
        while (iterator.hasNext()) {
            UniformImp uniform;
            UniformImp uniformImp = uniform = iterator.next();
            synchronized (uniformImp) {
                if (visitor.shouldSet(uniform.modified)) {
                    uniform.setInShader(visitor);
                    uniform.modified = false;
                }
            }
        }
    }

    @Override
    public StringBuilder getVertexShaderCode() {
        return this.vpCode;
    }

    @Override
    public StringBuilder getFragmentShaderCode() {
        return this.fpCode;
    }

    private synchronized <T extends UniformImp> T getUniform(String name, Class<T> klass, Function<String, T> create) {
        UniformImp uniform = this.uniforms.get(name);
        if (uniform == null) {
            UniformImp u = (UniformImp)create.apply(name);
            this.uniforms.put(name, u);
            if (UniformImpSampler.class.isInstance(u)) {
                this.samplers.add((UniformImpSampler)u);
            }
            return (T)u;
        }
        if (klass.isInstance(uniform)) {
            return (T)uniform;
        }
        throw new IllegalArgumentException("trying to get uniform '" + name + "' of class " + klass.getSimpleName() + " which is already present with class " + uniform.getClass().getSimpleName());
    }

    private static FloatBuffer newDirectFloatBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    static /* synthetic */ FloatBuffer access$300(int x0) {
        return AbstractShader.newDirectFloatBuffer(x0);
    }

    static class UniformImpSampler
    extends UniformImp
    implements UniformSampler {
        private Texture texture;
        private boolean valid = false;
        private int v0;

        UniformImpSampler(String name) {
            super(name);
        }

        @Override
        public synchronized void set(Texture texture) {
            this.texture = texture;
            this.valid = false;
            this.modified = true;
        }

        @Override
        void setInShader(SetUniforms visitor) {
            if (this.valid) {
                visitor.setUniform1i(this.name, this.v0);
            }
        }
    }

    static class UniformImpMatrix4f
    extends UniformImp
    implements UniformMatrix4f {
        private final FloatBuffer value = AbstractShader.access$300(16);

        public UniformImpMatrix4f(String name) {
            super(name);
        }

        @Override
        void setInShader(SetUniforms visitor) {
            visitor.setUniformMatrix4f(this.name, false, this.value);
        }

        @Override
        public synchronized void set(Matrix4fc m44) {
            m44.get(0, this.value);
            this.modified = true;
        }
    }

    static class UniformImpMatrix3f
    extends UniformImp
    implements UniformMatrix3f {
        private final FloatBuffer value = AbstractShader.access$300(9);

        public UniformImpMatrix3f(String name) {
            super(name);
        }

        @Override
        void setInShader(SetUniforms visitor) {
            visitor.setUniformMatrix3f(this.name, false, this.value);
        }

        @Override
        public synchronized void set(Matrix3fc m33) {
            m33.get(0, this.value);
            this.modified = true;
        }
    }

    static class UniformImp4fv
    extends UniformImp
    implements Uniform4fv {
        private float[] v;

        public UniformImp4fv(String name) {
            super(name);
        }

        @Override
        void setInShader(SetUniforms visitor) {
            if (this.v != null) {
                visitor.setUniform4fv(this.name, this.v.length / 4, this.v);
            }
        }

        @Override
        public synchronized void set(float[] value) {
            this.v = (float[])value.clone();
            this.modified = true;
        }
    }

    static class UniformImp3fv
    extends UniformImp
    implements Uniform3fv {
        private float[] v;

        public UniformImp3fv(String name) {
            super(name);
        }

        @Override
        void setInShader(SetUniforms visitor) {
            if (this.v != null) {
                visitor.setUniform3fv(this.name, this.v.length / 3, this.v);
            }
        }

        @Override
        public synchronized void set(float[] value) {
            this.v = (float[])value.clone();
            this.modified = true;
        }
    }

    static class UniformImp2fv
    extends UniformImp
    implements Uniform2fv {
        private float[] v;

        public UniformImp2fv(String name) {
            super(name);
        }

        @Override
        void setInShader(SetUniforms visitor) {
            if (this.v != null) {
                visitor.setUniform2fv(this.name, this.v.length / 2, this.v);
            }
        }

        @Override
        public synchronized void set(float[] value) {
            this.v = (float[])value.clone();
            this.modified = true;
        }
    }

    static class UniformImp1fv
    extends UniformImp
    implements Uniform1fv {
        private float[] v;

        public UniformImp1fv(String name) {
            super(name);
        }

        @Override
        void setInShader(SetUniforms visitor) {
            if (this.v != null) {
                visitor.setUniform1fv(this.name, this.v.length, this.v);
            }
        }

        @Override
        public synchronized void set(float[] value) {
            this.v = (float[])value.clone();
            this.modified = true;
        }
    }

    static class UniformImp4f
    extends UniformImp
    implements Uniform4f {
        private float v0;
        private float v1;
        private float v2;
        private float v3;

        public UniformImp4f(String name) {
            super(name);
        }

        @Override
        public synchronized void set(float v0, float v1, float v2, float v3) {
            if (this.v0 != v0 || this.v1 != v1 || this.v2 != v2 || this.v3 != v3) {
                this.v0 = v0;
                this.v1 = v1;
                this.v2 = v2;
                this.v3 = v3;
                this.modified = true;
            }
        }

        @Override
        void setInShader(SetUniforms visitor) {
            visitor.setUniform4f(this.name, this.v0, this.v1, this.v2, this.v3);
        }
    }

    static class UniformImp3f
    extends UniformImp
    implements Uniform3f {
        private float v0;
        private float v1;
        private float v2;

        public UniformImp3f(String name) {
            super(name);
        }

        @Override
        public synchronized void set(float v0, float v1, float v2) {
            if (this.v0 != v0 || this.v1 != v1 || this.v2 != v2) {
                this.v0 = v0;
                this.v1 = v1;
                this.v2 = v2;
                this.modified = true;
            }
        }

        @Override
        void setInShader(SetUniforms visitor) {
            visitor.setUniform3f(this.name, this.v0, this.v1, this.v2);
        }
    }

    static class UniformImp2f
    extends UniformImp
    implements Uniform2f {
        private float v0;
        private float v1;

        public UniformImp2f(String name) {
            super(name);
        }

        @Override
        public synchronized void set(float v0, float v1) {
            if (this.v0 != v0 || this.v1 != v1) {
                this.v0 = v0;
                this.v1 = v1;
                this.modified = true;
            }
        }

        @Override
        void setInShader(SetUniforms visitor) {
            visitor.setUniform2f(this.name, this.v0, this.v1);
        }
    }

    static class UniformImp1f
    extends UniformImp
    implements Uniform1f {
        private float v0;

        public UniformImp1f(String name) {
            super(name);
        }

        @Override
        public synchronized void set(float v0) {
            if (this.v0 != v0) {
                this.v0 = v0;
                this.modified = true;
            }
        }

        @Override
        void setInShader(SetUniforms visitor) {
            visitor.setUniform1f(this.name, this.v0);
        }
    }

    static class UniformImp4iv
    extends UniformImp
    implements Uniform4iv {
        private int[] v;

        public UniformImp4iv(String name) {
            super(name);
        }

        @Override
        void setInShader(SetUniforms visitor) {
            if (this.v != null) {
                visitor.setUniform4iv(this.name, this.v.length, this.v);
            }
        }

        @Override
        public synchronized void set(int[] value) {
            this.v = (int[])value.clone();
            this.modified = true;
        }
    }

    static class UniformImp3iv
    extends UniformImp
    implements Uniform3iv {
        private int[] v;

        public UniformImp3iv(String name) {
            super(name);
        }

        @Override
        void setInShader(SetUniforms visitor) {
            if (this.v != null) {
                visitor.setUniform3iv(this.name, this.v.length, this.v);
            }
        }

        @Override
        public synchronized void set(int[] value) {
            this.v = (int[])value.clone();
            this.modified = true;
        }
    }

    static class UniformImp2iv
    extends UniformImp
    implements Uniform2iv {
        private int[] v;

        public UniformImp2iv(String name) {
            super(name);
        }

        @Override
        void setInShader(SetUniforms visitor) {
            if (this.v != null) {
                visitor.setUniform2iv(this.name, this.v.length, this.v);
            }
        }

        @Override
        public synchronized void set(int[] value) {
            this.v = (int[])value.clone();
            this.modified = true;
        }
    }

    static class UniformImp1iv
    extends UniformImp
    implements Uniform1iv {
        private int[] v;

        public UniformImp1iv(String name) {
            super(name);
        }

        @Override
        void setInShader(SetUniforms visitor) {
            if (this.v != null) {
                visitor.setUniform1iv(this.name, this.v.length, this.v);
            }
        }

        @Override
        public synchronized void set(int[] value) {
            this.v = (int[])value.clone();
            this.modified = true;
        }
    }

    static class UniformImp4i
    extends UniformImp
    implements Uniform4i {
        private int v0;
        private int v1;
        private int v2;
        private int v3;

        public UniformImp4i(String name) {
            super(name);
        }

        @Override
        public synchronized void set(int v0, int v1, int v2, int v3) {
            if (this.v0 != v0 || this.v1 != v1 || this.v2 != v2 || this.v3 != v3) {
                this.v0 = v0;
                this.v1 = v1;
                this.v2 = v2;
                this.v3 = v3;
                this.modified = true;
            }
        }

        @Override
        void setInShader(SetUniforms visitor) {
            visitor.setUniform4i(this.name, this.v0, this.v1, this.v2, this.v3);
        }
    }

    static class UniformImp3i
    extends UniformImp
    implements Uniform3i {
        private int v0;
        private int v1;
        private int v2;

        public UniformImp3i(String name) {
            super(name);
        }

        @Override
        public synchronized void set(int v0, int v1, int v2) {
            if (this.v0 != v0 || this.v1 != v1 || this.v2 != v2) {
                this.v0 = v0;
                this.v1 = v1;
                this.v2 = v2;
                this.modified = true;
            }
        }

        @Override
        void setInShader(SetUniforms visitor) {
            visitor.setUniform3i(this.name, this.v0, this.v1, this.v2);
        }
    }

    static class UniformImp2i
    extends UniformImp
    implements Uniform2i {
        private int v0;
        private int v1;

        public UniformImp2i(String name) {
            super(name);
        }

        @Override
        public synchronized void set(int v0, int v1) {
            if (this.v0 != v0 || this.v1 != v1) {
                this.v0 = v0;
                this.v1 = v1;
                this.modified = true;
            }
        }

        @Override
        void setInShader(SetUniforms visitor) {
            visitor.setUniform2i(this.name, this.v0, this.v1);
        }
    }

    static class UniformImp1i
    extends UniformImp
    implements Uniform1i {
        private int v0;

        public UniformImp1i(String name) {
            super(name);
        }

        @Override
        public synchronized void set(int v0) {
            if (this.v0 != v0) {
                this.v0 = v0;
                this.modified = true;
            }
        }

        @Override
        void setInShader(SetUniforms visitor) {
            visitor.setUniform1i(this.name, this.v0);
        }
    }

    static abstract class UniformImp {
        final String name;
        boolean modified;

        UniformImp(String name) {
            this.name = name;
            this.modified = true;
        }

        abstract void setInShader(SetUniforms var1);
    }
}

