/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.render;

import bdv.tools.brightness.ConverterSetup;
import bvv.core.backend.GpuContext;
import bvv.core.backend.Texture;
import bvv.core.backend.Texture2D;
import bvv.core.cache.CacheSpec;
import bvv.core.cache.TextureCache;
import bvv.core.dither.DitherBuffer;
import bvv.core.multires.SourceStacks;
import bvv.core.render.LookupTextureARGB;
import bvv.core.render.SimpleVolume;
import bvv.core.render.VolumeBlocks;
import bvv.core.render.VolumeShaderSignature;
import bvv.core.shadergen.Uniform1f;
import bvv.core.shadergen.Uniform2f;
import bvv.core.shadergen.Uniform3f;
import bvv.core.shadergen.Uniform3fv;
import bvv.core.shadergen.Uniform4f;
import bvv.core.shadergen.UniformMatrix4f;
import bvv.core.shadergen.UniformSampler;
import bvv.core.shadergen.generate.Segment;
import bvv.core.shadergen.generate.SegmentTemplate;
import bvv.core.shadergen.generate.SegmentType;
import bvv.core.shadergen.generate.SegmentedShader;
import bvv.core.shadergen.generate.SegmentedShaderBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.imglib2.type.numeric.ARGBType;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class MultiVolumeShaderMip {
    private static final int NUM_BLOCK_SCALES = 10;
    private final VolumeShaderSignature signature;
    private final boolean useDepthTexture;
    private double degrade;
    private final SegmentedShader prog;
    private final VolumeSegment[] volumeSegments;
    private final ConverterSegment[] converterSegments;
    private final UniformMatrix4f uniformIpv;
    private final Uniform2f uniformViewportSize;
    private final Uniform1f uniformNw;
    private final Uniform1f uniformFwnw;
    private final Uniform1f uniformXf;
    private final UniformMatrix4f uniformTransform;
    private final Uniform2f uniformDsp;
    private int viewportWidth;
    private String sceneDepthTextureName;

    public MultiVolumeShaderMip(VolumeShaderSignature signature, boolean useDepthTexture, double degrade, Map<SegmentType, SegmentTemplate> segments, SegmentConsumer runBeforeBinding, String depthTextureName) {
        int i;
        this.signature = signature;
        this.useDepthTexture = useDepthTexture;
        this.degrade = degrade;
        this.sceneDepthTextureName = depthTextureName;
        int numVolumes = signature.getVolumeSignatures().size();
        if (!Arrays.stream(SegmentType.values()).allMatch(segments::containsKey)) {
            throw new IllegalStateException("Segments array does not contain all required SegmentTypes.");
        }
        SegmentedShaderBuilder builder = new SegmentedShaderBuilder();
        Segment vp = segments.get((Object)SegmentType.VertexShader).instantiate();
        builder.vertex(vp);
        SegmentTemplate templateVolBlocks = segments.get((Object)SegmentType.SampleMultiresolutionVolume);
        SegmentTemplate templateVolSimple = segments.get((Object)SegmentType.SampleVolume);
        SegmentTemplate templateVolSimpleRGBA = segments.get((Object)SegmentType.SampleRGBAVolume);
        SegmentTemplate templateConvert = segments.get((Object)SegmentType.Convert);
        SegmentTemplate templateConvertRGBA = segments.get((Object)SegmentType.ConvertRGBA);
        SegmentTemplate templateMaxDepth = segments.get((Object)SegmentType.MaxDepth);
        builder.fragment(templateMaxDepth.instantiate());
        SegmentTemplate templateMainFp = segments.get((Object)SegmentType.FragmentShader);
        Segment fp = templateMainFp.instantiate();
        fp.repeat("vis", numVolumes);
        SegmentTemplate templateAccumulateMipBlocks = segments.get((Object)SegmentType.AccumulatorMultiresolution);
        SegmentTemplate templateAccumulateMipSimple = segments.get((Object)SegmentType.Accumulator);
        Segment[] sampleVolumeSegs = new Segment[numVolumes];
        Segment[] convertSegs = new Segment[numVolumes];
        Segment[] accumulateSegs = new Segment[numVolumes];
        for (i = 0; i < numVolumes; ++i) {
            Segment convert;
            Segment sampleVolume;
            Segment accumulate;
            HashMap<SegmentType, Segment> instancedSegments = new HashMap<SegmentType, Segment>();
            VolumeShaderSignature.VolumeSignature volumeSignature = signature.getVolumeSignatures().get(i);
            instancedSegments.put(SegmentType.FragmentShader, fp);
            switch (volumeSignature.getSourceStackType()) {
                case MULTIRESOLUTION: {
                    accumulate = templateAccumulateMipBlocks.instantiate();
                    instancedSegments.put(SegmentType.AccumulatorMultiresolution, accumulate);
                    sampleVolume = templateVolBlocks.instantiate();
                    instancedSegments.put(SegmentType.SampleMultiresolutionVolume, sampleVolume);
                    break;
                }
                case SIMPLE: {
                    accumulate = templateAccumulateMipSimple.instantiate();
                    instancedSegments.put(SegmentType.Accumulator, accumulate);
                    sampleVolume = volumeSignature.getPixelType() == VolumeShaderSignature.PixelType.ARGB ? templateVolSimpleRGBA.instantiate() : templateVolSimple.instantiate();
                    instancedSegments.put(SegmentType.SampleVolume, sampleVolume);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            switch (volumeSignature.getPixelType()) {
                default: {
                    convert = templateConvert.instantiate();
                    instancedSegments.put(SegmentType.Convert, convert);
                    break;
                }
                case ARGB: {
                    convert = templateConvertRGBA.instantiate();
                    instancedSegments.put(SegmentType.ConvertRGBA, convert);
                }
            }
            if (runBeforeBinding != null) {
                runBeforeBinding.accept(segments, instancedSegments, i);
            }
            fp.bind("intersectBoundingBox", i, sampleVolume);
            fp.bind("vis", i, accumulate);
            accumulate.bind("sampleVolume", sampleVolume);
            accumulate.bind("convert", convert);
            sampleVolumeSegs[i] = sampleVolume;
            convertSegs[i] = convert;
            accumulateSegs[i] = accumulate;
        }
        fp.insert("SampleVolume", sampleVolumeSegs);
        fp.insert("Convert", convertSegs);
        fp.insert("Accumulate", accumulateSegs);
        builder.fragment(fp);
        this.prog = builder.build();
        this.uniformIpv = this.prog.getUniformMatrix4f("ipv");
        this.uniformViewportSize = this.prog.getUniform2f("viewportSize");
        this.uniformNw = this.prog.getUniform1f("nw");
        this.uniformFwnw = this.prog.getUniform1f("fwnw");
        this.uniformXf = this.prog.getUniform1f("xf");
        this.volumeSegments = new VolumeSegment[numVolumes];
        this.converterSegments = new ConverterSegment[numVolumes];
        for (i = 0; i < numVolumes; ++i) {
            VolumeShaderSignature.VolumeSignature volumeSignature = signature.getVolumeSignatures().get(i);
            switch (volumeSignature.getSourceStackType()) {
                case SIMPLE: {
                    this.volumeSegments[i] = new VolumeSimpleSegment(this.prog, sampleVolumeSegs[i]);
                    break;
                }
                case MULTIRESOLUTION: {
                    this.volumeSegments[i] = new VolumeBlocksSegment(this.prog, sampleVolumeSegs[i]);
                }
            }
            this.converterSegments[i] = new ConverterSegment(this.prog, convertSegs[i], volumeSignature.getPixelType());
        }
        this.uniformTransform = this.prog.getUniformMatrix4f("transform");
        this.uniformDsp = this.prog.getUniform2f("dsp");
        this.uniformTransform.set((Matrix4fc)new Matrix4f());
        this.uniformDsp.set((Vector2fc)new Vector2f());
    }

    public static Map<SegmentType, SegmentTemplate> getDefaultSegments(boolean useDepthTexture) {
        HashMap<SegmentType, SegmentTemplate> segments = new HashMap<SegmentType, SegmentTemplate>();
        segments.put(SegmentType.SampleMultiresolutionVolume, new SegmentTemplate("sample_volume_blocks.frag", "im", "sourcemin", "sourcemax", "intersectBoundingBox", "lutSampler", "blockScales", "lutSize", "lutOffset", "sampleVolume"));
        segments.put(SegmentType.SampleVolume, new SegmentTemplate("sample_volume_simple.frag", "im", "sourcemax", "intersectBoundingBox", "volume", "sampleVolume"));
        segments.put(SegmentType.SampleRGBAVolume, new SegmentTemplate("sample_volume_simple_rgba.frag", "im", "sourcemax", "intersectBoundingBox", "volume", "sampleVolume"));
        segments.put(SegmentType.Convert, new SegmentTemplate("convert.frag", "convert", "offset", "scale"));
        segments.put(SegmentType.ConvertRGBA, new SegmentTemplate("convert_rgba.frag", "convert", "offset", "scale"));
        segments.put(SegmentType.MaxDepth, new SegmentTemplate(useDepthTexture ? "maxdepthtexture.frag" : "maxdepthone.frag", new String[0]));
        segments.put(SegmentType.VertexShader, new SegmentTemplate("multi_volume.vert", new String[0]));
        segments.put(SegmentType.FragmentShader, new SegmentTemplate("multi_volume.frag", "intersectBoundingBox", "vis", "SampleVolume", "Convert", "Accumulate"));
        segments.put(SegmentType.AccumulatorMultiresolution, new SegmentTemplate("accumulate_mip_blocks.frag", "vis", "sampleVolume", "convert"));
        segments.put(SegmentType.Accumulator, new SegmentTemplate("accumulate_mip_simple.frag", "vis", "sampleVolume", "convert"));
        return segments;
    }

    public MultiVolumeShaderMip(VolumeShaderSignature signature, boolean useDepthTexture, double degrade) {
        this(signature, useDepthTexture, degrade, MultiVolumeShaderMip.getDefaultSegments(useDepthTexture), null, "sceneDepth");
    }

    public void setTextureCache(TextureCache textureCache) {
        CacheSpec spec = textureCache.spec();
        int[] bs = spec.blockSize();
        int[] pbs = spec.paddedBlockSize();
        int[] bo = spec.padOffset();
        this.prog.getUniform3f("blockSize").set(bs[0], bs[1], bs[2]);
        this.prog.getUniform3f("paddedBlockSize").set(pbs[0], pbs[1], pbs[2]);
        this.prog.getUniform3f("cachePadOffset").set(bo[0], bo[1], bo[2]);
        this.prog.getUniformSampler("volumeCache").set(textureCache);
        this.prog.getUniform3f("cacheSize").set(textureCache.texWidth(), textureCache.texHeight(), textureCache.texDepth());
    }

    public void setDepthTexture(Texture2D depth) {
        if (!this.useDepthTexture) {
            throw new UnsupportedOperationException();
        }
        this.prog.getUniformSampler(this.sceneDepthTextureName).set(depth);
    }

    public void setDepthTextureName(String name) {
        this.sceneDepthTextureName = name;
    }

    public void setConverter(int index, ConverterSetup converter) {
        this.converterSegments[index].setData(converter);
    }

    public void setUniform(int index, String name, Object value) {
        this.prog.setUniformValueByType(this.volumeSegments[index].volume, name, value);
    }

    public void setUniform(int index, String name, int elementSize, Object value) {
        this.prog.setUniformValueByType(this.volumeSegments[index].volume, name, elementSize, value);
    }

    @Deprecated
    public void registerCustomSampler(int index, String name, Texture texture) {
        this.setUniform(index, name, texture);
    }

    @Deprecated
    public void setCustomUniformForVolume(int index, String name, Object value) {
        this.setUniform(index, name, value);
    }

    @Deprecated
    public void removeCustomUniformForVolume(int index, String name) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setCustomIntArrayUniformForVolume(int index, String name, int elementSize, int[] value) {
        this.setUniform(index, name, elementSize, value);
    }

    @Deprecated
    public void setCustomFloatArrayUniformForVolume(int index, String name, int elementSize, float[] value) {
        this.setUniform(index, name, elementSize, value);
    }

    public void setVolume(int index, VolumeBlocks volume) {
        VolumeShaderSignature.VolumeSignature vs = this.signature.getVolumeSignatures().get(index);
        if (vs.getSourceStackType() != SourceStacks.SourceStackType.MULTIRESOLUTION) {
            throw new IllegalArgumentException();
        }
        ((VolumeBlocksSegment)this.volumeSegments[index]).setData(volume);
    }

    public void setVolume(int index, SimpleVolume volume) {
        VolumeShaderSignature.VolumeSignature vs = this.signature.getVolumeSignatures().get(index);
        if (vs.getSourceStackType() != SourceStacks.SourceStackType.SIMPLE) {
            throw new IllegalArgumentException();
        }
        ((VolumeSimpleSegment)this.volumeSegments[index]).setData(volume);
    }

    public void setDither(DitherBuffer dither, int step) {
        this.uniformViewportSize.set(dither.effectiveViewportWidth(), dither.effectiveViewportHeight());
        this.uniformTransform.set((Matrix4fc)dither.ndcTransform(step));
        this.uniformDsp.set((Vector2fc)dither.fragShift(step));
    }

    public void setDegrade(Double farPlaneStepSizeDegradation) {
        this.degrade = farPlaneStepSizeDegradation;
    }

    public void setProjectionViewMatrix(Matrix4fc pv, double minWorldVoxelSize) {
        Matrix4f ipv = pv.invert(new Matrix4f());
        float dx = (float)(2.0 / (double)this.viewportWidth);
        Vector4f a = ipv.transform(new Vector4f(0.0f, 0.0f, -1.0f, 1.0f));
        Vector4f c = ipv.transform(new Vector4f(0.0f, 0.0f, 1.0f, 1.0f));
        Vector4f b = ipv.transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        Vector4f adx = ipv.transform(new Vector4f(dx, 0.0f, -1.0f, 1.0f));
        Vector4f cdx = ipv.transform(new Vector4f(dx, 0.0f, 1.0f, 1.0f));
        a.div(a.w());
        b.div(b.w());
        c.div(c.w());
        adx.div(adx.w());
        cdx.div(cdx.w());
        double sNear = Math.max((double)adx.sub((Vector4fc)a).length(), minWorldVoxelSize);
        double sFar = Math.max((double)cdx.sub((Vector4fc)c).length(), minWorldVoxelSize);
        double ac = c.sub((Vector4fc)a).length();
        double scale = 1.0 / ac;
        double nw = sNear * scale;
        double fw = this.degrade * sFar * scale;
        double ab = b.sub((Vector4fc)a, new Vector4f()).length();
        double f = ab / ac;
        this.uniformIpv.set((Matrix4fc)ipv);
        this.uniformNw.set((float)nw);
        this.uniformFwnw.set((float)(fw - nw));
        this.uniformXf.set((float)f);
    }

    public void setViewportWidth(int width) {
        this.viewportWidth = width;
    }

    public void setEffectiveViewportSize(int width, int height) {
        this.uniformViewportSize.set(width, height);
    }

    public void use(GpuContext context) {
        this.prog.use(context);
    }

    public void bindSamplers(GpuContext context) {
        this.prog.bindSamplers(context);
    }

    public void setUniforms(GpuContext context) {
        this.prog.setUniforms(context);
    }

    static class VolumeSimpleSegment
    extends VolumeSegment {
        private final UniformSampler uniformVolumeSampler;
        private final UniformMatrix4f uniformIm;
        private final Uniform3f uniformSourcemax;

        public VolumeSimpleSegment(SegmentedShader prog, Segment volume) {
            super(volume);
            this.uniformVolumeSampler = prog.getUniformSampler(volume, "volume");
            this.uniformIm = prog.getUniformMatrix4f(volume, "im");
            this.uniformSourcemax = prog.getUniform3f(volume, "sourcemax");
        }

        public void setData(SimpleVolume volume) {
            this.uniformVolumeSampler.set(volume.getVolumeTexture());
            this.uniformIm.set((Matrix4fc)volume.getIms());
            this.uniformSourcemax.set((Vector3fc)volume.getSourceMax());
        }
    }

    static class VolumeBlocksSegment
    extends VolumeSegment {
        private final Uniform3fv uniformBlockScales;
        private final UniformSampler uniformLutSampler;
        private final Uniform3f uniformLutSize;
        private final Uniform3f uniformLutOffset;
        private final UniformMatrix4f uniformIm;
        private final Uniform3f uniformSourcemin;
        private final Uniform3f uniformSourcemax;

        public VolumeBlocksSegment(SegmentedShader prog, Segment volume) {
            super(volume);
            this.uniformBlockScales = prog.getUniform3fv(volume, "blockScales");
            this.uniformLutSampler = prog.getUniformSampler(volume, "lutSampler");
            this.uniformLutSize = prog.getUniform3f(volume, "lutSize");
            this.uniformLutOffset = prog.getUniform3f(volume, "lutOffset");
            this.uniformIm = prog.getUniformMatrix4f(volume, "im");
            this.uniformSourcemin = prog.getUniform3f(volume, "sourcemin");
            this.uniformSourcemax = prog.getUniform3f(volume, "sourcemax");
        }

        public void setData(VolumeBlocks blocks) {
            this.uniformBlockScales.set(blocks.getLutBlockScales(10));
            LookupTextureARGB lut = blocks.getLookupTexture();
            this.uniformLutSampler.set(lut);
            this.uniformLutSize.set((Vector3fc)lut.getSize3f());
            this.uniformLutOffset.set((Vector3fc)lut.getOffset3f());
            this.uniformIm.set((Matrix4fc)blocks.getIms());
            this.uniformSourcemin.set((Vector3fc)blocks.getSourceLevelMin());
            this.uniformSourcemax.set((Vector3fc)blocks.getSourceLevelMax());
        }
    }

    static abstract class VolumeSegment {
        final Segment volume;

        public VolumeSegment(Segment volume) {
            this.volume = volume;
        }
    }

    static class ConverterSegment {
        private final Uniform4f uniformOffset;
        private final Uniform4f uniformScale;
        private final VolumeShaderSignature.PixelType pixelType;
        private final double rangeScale;

        public ConverterSegment(SegmentedShader prog, Segment segment, VolumeShaderSignature.PixelType pixelType) {
            this.uniformOffset = prog.getUniform4f(segment, "offset");
            this.uniformScale = prog.getUniform4f(segment, "scale");
            this.pixelType = pixelType;
            switch (pixelType) {
                default: {
                    this.rangeScale = 65535.0;
                    break;
                }
                case UBYTE: 
                case ARGB: {
                    this.rangeScale = 255.0;
                }
            }
        }

        public void setData(ConverterSetup converter) {
            double fmin = converter.getDisplayRangeMin() / this.rangeScale;
            double fmax = converter.getDisplayRangeMax() / this.rangeScale;
            double s = 1.0 / (fmax - fmin);
            double o = -fmin * s;
            if (this.pixelType == VolumeShaderSignature.PixelType.ARGB) {
                this.uniformOffset.set((float)o, (float)o, (float)o, (float)o);
                this.uniformScale.set((float)s, (float)s, (float)s, (float)s);
            } else {
                int color = converter.getColor().get();
                double r = (double)ARGBType.red((int)color) / 255.0;
                double g = (double)ARGBType.green((int)color) / 255.0;
                double b = (double)ARGBType.blue((int)color) / 255.0;
                this.uniformOffset.set((float)(o * r), (float)(o * g), (float)(o * b), (float)o);
                this.uniformScale.set((float)(s * r), (float)(s * g), (float)(s * b), (float)s);
            }
        }
    }

    @FunctionalInterface
    public static interface SegmentConsumer {
        public void accept(Map<SegmentType, SegmentTemplate> var1, Map<SegmentType, Segment> var2, int var3);
    }
}

