/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.dither;

import java.util.ArrayList;
import java.util.Comparator;

public class DitherPattern {
    public static void makePattern(int spw, int step, int[] spox, int[] spoy) {
        int sps = spw * spw;
        for (int i = 0; i < sps; ++i) {
            int fo = i * step % sps;
            spoy[i] = fo / spw;
            spox[i] = fo % spw;
        }
    }

    public static String makeShader(int numSamples) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("out vec4 FragColor;\n");
        sb.append("\n");
        sb.append("uniform sampler2D tex;\n");
        sb.append("uniform vec2 spw;\n");
        sb.append("uniform vec2 dsp;\n");
        sb.append("\n");
        sb.append(String.format("uniform vec2 spo[ %d ];\n", numSamples));
        sb.append(String.format("uniform float K[ %d ];\n", numSamples));
        sb.append("\n");
        sb.append("void main()\n");
        sb.append("{\n");
        sb.append("\tvec2 xg = gl_FragCoord.xy + dsp;\n");
        sb.append("\n");
        sb.append("\tvec2 texsize = textureSize( tex, 0 );\n");
        for (i = 0; i < numSamples; ++i) {
            sb.append(String.format("\tvec4 v%1$d = texture( tex, ( xg + spo[ %1$d ] ) / texsize );\n", i));
        }
        sb.append("\tFragColor = K[ 0 ] * v0");
        for (i = 1; i < numSamples; ++i) {
            sb.append(String.format(" + K[ %1$d ] * v%1$d", i));
        }
        sb.append(";\n");
        sb.append("}\n");
        return sb.toString();
    }

    public static DitherWeights getWeights(int spw, int tlw, int tlh, int numValidTextures, int ox, int oy, int maxNeighbors, double sigma, int[] spox, int[] spoy) {
        ArrayList<OD> squdist = new ArrayList<OD>();
        for (int spi = 0; spi < numValidTextures; ++spi) {
            int[] spox4 = new int[4];
            int[] spoy4 = new int[4];
            if (ox < spox[spi]) {
                spox4[0] = spox[spi] - spw;
                spox4[1] = spox[spi];
                spox4[2] = spox[spi] - spw;
                spox4[3] = spox[spi];
            } else {
                spox4[0] = spox[spi];
                spox4[1] = spox[spi] + spw;
                spox4[2] = spox[spi];
                spox4[3] = spox[spi] + spw;
            }
            if (oy < spoy[spi]) {
                spoy4[0] = spoy[spi] - spw;
                spoy4[1] = spoy[spi] - spw;
                spoy4[2] = spoy[spi];
                spoy4[3] = spoy[spi];
            } else {
                spoy4[0] = spoy[spi];
                spoy4[1] = spoy[spi];
                spoy4[2] = spoy[spi] + spw;
                spoy4[3] = spoy[spi] + spw;
            }
            for (int i = 0; i < 4; ++i) {
                int kx = Math.abs(ox - spox4[i]);
                int ky = Math.abs(oy - spoy4[i]);
                int sd = kx * kx + ky * ky;
                squdist.add(new OD(spox4[i], spoy4[i], spox[spi], spoy[spi], sd));
            }
        }
        squdist.sort(Comparator.comparingDouble(o -> o.squdist));
        double swu = 0.0;
        int n = 0;
        for (OD od : squdist) {
            double wu;
            double sd = od.squdist;
            od.weight = wu = Math.exp(-sd / (2.0 * sigma * sigma));
            swu += wu;
            if (++n != maxNeighbors) continue;
            break;
        }
        for (int i = 0; i < n; ++i) {
            ((OD)squdist.get((int)i)).weight /= swu;
        }
        float[][] spo = new float[maxNeighbors][2];
        float[] K = new float[maxNeighbors];
        for (int i = 0; i < n; ++i) {
            OD od = (OD)squdist.get(i);
            spo[i][0] = (float)((double)(od.spox - od.sptx - ox) / (double)spw + (double)(od.sptx * tlw) + 0.5);
            spo[i][1] = (float)((double)(od.spoy - od.spty - oy) / (double)spw + (double)(od.spty * tlh) + 0.5);
            K[i] = (float)od.weight;
        }
        return new DitherWeights(spo, K);
    }

    public static class DitherWeights {
        public final float[][] spo;
        public final float[] K;

        public DitherWeights(float[][] spo, float[] k) {
            this.spo = spo;
            this.K = k;
        }
    }

    private static class OD {
        final int spox;
        final int spoy;
        final int sptx;
        final int spty;
        final double squdist;
        double weight;

        public OD(int spox, int spoy, int sptx, int spty, double squdist) {
            this.spox = spox;
            this.spoy = spoy;
            this.sptx = sptx;
            this.spty = spty;
            this.squdist = squdist;
        }
    }
}

