/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.cache;

import bvv.core.backend.GpuContext;
import bvv.core.cache.FillTask;
import bvv.core.cache.PboChain;
import bvv.core.cache.TextureCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;

public class ProcessFillTasks {
    public static void sequential(TextureCache textureCache, PboChain pboChain, GpuContext context, Collection<? extends FillTask> tasks) throws InterruptedException {
        TextureCache.StagedTasks stagedTasks = textureCache.stage(tasks);
        pboChain.init(stagedTasks);
        int numTasks = stagedTasks.tasks.size();
        for (int i = 0; i < numTasks; ++i) {
            pboChain.tryActivate(context);
            TextureCache.TileFillTask task = pboChain.nextTask();
            if (task.containsData()) {
                PboChain.PboUploadBuffer buf = pboChain.take(task);
                task.fill(buf);
                pboChain.commit(buf);
            }
            pboChain.tryUpload(context);
        }
        pboChain.flush();
        pboChain.tryUpload(context);
    }

    public static void parallel(TextureCache textureCache, final PboChain pboChain, GpuContext context, ForkJoinPool forkJoinPool, Collection<? extends FillTask> tasks) throws InterruptedException {
        TextureCache.StagedTasks stagedTasks = textureCache.stage(tasks);
        final int numTasks = stagedTasks.tasks.size();
        if (numTasks == 0) {
            return;
        }
        pboChain.init(stagedTasks);
        int restoreId = context.bindTexture(textureCache);
        forkJoinPool.execute(new RecursiveAction(){

            @Override
            protected void compute() {
                ArrayList<1> actions = new ArrayList<1>();
                for (int i = 0; i < numTasks; ++i) {
                    RecursiveAction recursiveAction = new RecursiveAction(){

                        @Override
                        protected void compute() {
                            try {
                                TextureCache.TileFillTask task = pboChain.nextTask();
                                if (task.containsData()) {
                                    PboChain.PboUploadBuffer buf = pboChain.take(task);
                                    task.fill(buf);
                                    pboChain.commit(buf);
                                }
                            }
                            catch (InterruptedException e) {
                                throw new AssertionError((Object)e);
                            }
                        }
                    };
                    recursiveAction.fork();
                    actions.add(recursiveAction);
                }
                for (RecursiveAction recursiveAction : actions) {
                    recursiveAction.join();
                }
                pboChain.flush();
            }
        });
        pboChain.maintain(context);
        context.bindTextureId(restoreId, 3);
    }
}

