/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.cache;

import bvv.core.backend.GpuContext;
import bvv.core.backend.StagingBuffer;
import bvv.core.cache.TextureCache;
import bvv.core.cache.UploadBuffer;
import java.nio.Buffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.imglib2.util.Intervals;

public class PboChain {
    private final int numBufs;
    private final int bufSize;
    private final int blockSize;
    private final Queue<Pbo> cleanPbos;
    private final Queue<Pbo> readyForUploadPbos;
    private Pbo activePbo;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition gpu;
    private final Condition allClean;
    private List<TextureCache.TileFillTask> tileFillTasks;
    private List<TextureCache.Tile> reusableTiles;
    private AtomicInteger ti = new AtomicInteger();
    private int rti;
    private PboChainState chainState = PboChainState.FLUSH;

    public PboChain(int numBufs, int bufSize, TextureCache cache) {
        this(numBufs, bufSize, cache.spec().format().getBytesPerElement() * (int)Intervals.numElements((int[])cache.spec().paddedBlockSize()), cache.spec().paddedBlockSize(), cache);
    }

    PboChain(int numBufs, int bufSize, int blockSize, int[] blockDimensions, TextureCache cache) {
        this.numBufs = numBufs;
        this.bufSize = bufSize;
        this.blockSize = blockSize;
        this.cleanPbos = new ArrayDeque<Pbo>(numBufs);
        for (int i = 0; i < numBufs; ++i) {
            this.cleanPbos.add(new Pbo(bufSize, blockSize, blockDimensions, cache));
        }
        this.readyForUploadPbos = new ArrayDeque<Pbo>(numBufs);
        this.activePbo = this.cleanPbos.peek();
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
        this.gpu = this.lock.newCondition();
        this.allClean = this.lock.newCondition();
    }

    TextureCache.TileFillTask nextTask() {
        int i = this.ti.getAndIncrement();
        if (i >= this.tileFillTasks.size()) {
            throw new NoSuchElementException();
        }
        return this.tileFillTasks.get(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PboUploadBuffer take(TextureCache.TileFillTask task) throws InterruptedException, NoSuchElementException, IllegalStateException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            if (this.chainState != PboChainState.FILL) {
                throw new IllegalStateException();
            }
            while (!this.activePbo.hasRemainingBuffers()) {
                this.notEmpty.await();
            }
            if (task.getTile() == null) {
                if (this.rti >= this.reusableTiles.size()) {
                    throw new NoSuchElementException();
                }
                task.setTile(this.reusableTiles.get(this.rti++));
            }
            PboUploadBuffer buffer = this.activePbo.takeBuffer();
            buffer.setTask(task);
            if (!this.activePbo.hasRemainingBuffers()) {
                this.gpu.signal();
            }
            PboUploadBuffer pboUploadBuffer = buffer;
            return pboUploadBuffer;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(PboUploadBuffer buffer) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.chainState != PboChainState.FILL) {
                throw new IllegalStateException();
            }
            Pbo pbo = buffer.pbo;
            pbo.commitBuffer();
            if (pbo.isReadyForUpload()) {
                this.readyForUploadPbos.add(pbo);
                this.gpu.signal();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void flush() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.chainState != PboChainState.FILL) {
                throw new IllegalStateException();
            }
            this.chainState = PboChainState.FLUSH;
            if (this.activePbo.flush()) {
                this.readyForUploadPbos.add(this.activePbo);
            }
            this.gpu.signal();
        }
        finally {
            lock.unlock();
        }
    }

    public boolean ready() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.chainState == PboChainState.FLUSH && this.cleanPbos.size() == this.numBufs;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void init(TextureCache.StagedTasks stagedTasks) throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (!this.ready()) {
                this.allClean.await();
            }
            this.tileFillTasks = stagedTasks.tasks;
            this.reusableTiles = stagedTasks.reusableTiles;
            this.ti.set(0);
            this.rti = 0;
            this.chainState = PboChainState.FILL;
        }
        finally {
            lock.unlock();
        }
    }

    public void maintain(GpuContext context) throws InterruptedException {
        while (!this.ready()) {
            ReentrantLock lock = this.lock;
            lock.lockInterruptibly();
            try {
                while (!(this.chainState == PboChainState.FLUSH && this.cleanPbos.size() == this.numBufs || this.chainState != PboChainState.FLUSH && !this.activePbo.hasRemainingBuffers() && this.cleanPbos.peek() != null || this.readyForUploadPbos.peek() != null)) {
                    this.gpu.await();
                }
            }
            finally {
                lock.unlock();
            }
            this.tryActivate(context);
            this.tryUpload(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryActivate(GpuContext context) {
        Pbo pbo = null;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.chainState == PboChainState.FLUSH) {
                boolean bl = false;
                return bl;
            }
            if (this.activePbo.hasRemainingBuffers()) {
                boolean bl = false;
                return bl;
            }
            pbo = this.cleanPbos.poll();
        }
        finally {
            lock.unlock();
        }
        if (pbo == null) {
            return false;
        }
        pbo.map(context);
        lock.lock();
        try {
            if (this.chainState == PboChainState.FLUSH) {
                if (pbo.flush()) {
                    this.readyForUploadPbos.add(pbo);
                }
                this.gpu.signal();
            } else {
                this.activePbo = pbo;
                this.notEmpty.signalAll();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryUpload(GpuContext context) {
        Pbo pbo = null;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            pbo = this.readyForUploadPbos.poll();
        }
        finally {
            lock.unlock();
        }
        if (pbo == null) {
            return false;
        }
        pbo.unmap(context);
        pbo.uploadToTexture(context);
        lock.lock();
        try {
            this.cleanPbos.add(pbo);
            if (this.cleanPbos.size() == this.numBufs) {
                this.allClean.signalAll();
            }
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    static class Pbo
    implements StagingBuffer {
        private final int bufSize;
        private final int blockSize;
        private final int[] blockDimensions;
        private final TextureCache cache;
        private final ArrayList<PboUploadBuffer> buffers = new ArrayList();
        private PboState state;
        private Buffer buffer;
        private int nextIndex;
        private int uncommitted;

        Pbo(int bufSize, int blockSize, int[] blockDimensions, TextureCache cache) {
            this.bufSize = bufSize;
            this.blockSize = blockSize;
            this.blockDimensions = blockDimensions;
            this.cache = cache;
            this.state = PboState.CLEAN;
            this.buffer = null;
            this.nextIndex = 0;
            this.uncommitted = 0;
        }

        @Override
        public int getSizeInBytes() {
            return this.bufSize * this.blockSize;
        }

        PboUploadBuffer takeBuffer() {
            if (this.state != PboState.MAPPED) {
                throw new IllegalStateException();
            }
            if (this.nextIndex >= this.bufSize) {
                throw new NoSuchElementException();
            }
            PboUploadBuffer b = new PboUploadBuffer(this.buffer, this.nextIndex * this.blockSize, this);
            this.buffers.add(b);
            ++this.uncommitted;
            ++this.nextIndex;
            return b;
        }

        void commitBuffer() {
            --this.uncommitted;
        }

        boolean hasRemainingBuffers() {
            return this.state == PboState.MAPPED && this.bufSize - this.nextIndex > 0;
        }

        boolean hasUncommittedBuffers() {
            return this.uncommitted > 0;
        }

        boolean isReadyForUpload() {
            return !this.hasUncommittedBuffers() && !this.hasRemainingBuffers();
        }

        boolean flush() {
            boolean ret = this.hasRemainingBuffers() && !this.hasUncommittedBuffers();
            this.nextIndex = this.bufSize;
            return ret;
        }

        void map(GpuContext context) {
            if (this.state != PboState.CLEAN) {
                throw new IllegalStateException();
            }
            this.buffer = context.map(this);
            this.state = PboState.MAPPED;
            this.nextIndex = 0;
            this.uncommitted = 0;
        }

        void unmap(GpuContext context) {
            if (this.state != PboState.MAPPED || this.hasUncommittedBuffers()) {
                throw new IllegalStateException();
            }
            context.unmap(this);
            this.state = PboState.UNMAPPED;
        }

        void uploadToTexture(GpuContext context) {
            int nb;
            if (this.state != PboState.UNMAPPED) {
                throw new IllegalStateException();
            }
            int restoreId = context.bindStagingBuffer(this);
            for (int bi = 0; bi < this.buffers.size(); bi += nb) {
                PboUploadBuffer buf0 = this.buffers.get(bi);
                TextureCache.Tile prevTile = buf0.task.getTile();
                int x = this.blockDimensions[0] * prevTile.x;
                int y = this.blockDimensions[1] * prevTile.y;
                int z = this.blockDimensions[2] * prevTile.z;
                long pixels_buffer_offset = buf0.getOffset();
                int remainingBlocks = this.buffers.size() - bi;
                if (x != 0 || y != 0 || z != 0) {
                    for (nb = 1; nb < remainingBlocks; ++nb) {
                        TextureCache.Tile tile = this.buffers.get((int)(bi + nb)).task.getTile();
                        if (tile.z != prevTile.z + 1 || tile.y != prevTile.y || tile.x != prevTile.x) break;
                        prevTile = tile;
                    }
                }
                int w = this.blockDimensions[0];
                int h = this.blockDimensions[1];
                int d = this.blockDimensions[2] * nb;
                context.texSubImage3D(this, this.cache, x, y, z, w, h, d, pixels_buffer_offset);
                for (int i = 0; i < nb; ++i) {
                    PboUploadBuffer buffer = this.buffers.get(bi + i);
                    this.cache.assign(buffer.task.getTile(), buffer.task.getKey(), buffer.getContentState());
                }
            }
            context.bindStagingBufferId(restoreId);
            this.buffers.clear();
            this.state = PboState.CLEAN;
        }
    }

    static class PboUploadBuffer
    extends UploadBuffer {
        TextureCache.TileFillTask task;
        final Pbo pbo;

        public PboUploadBuffer(Buffer buffer, int offset, Pbo pbo) {
            super(buffer, offset);
            this.pbo = pbo;
        }

        public void setTask(TextureCache.TileFillTask task) {
            this.task = task;
        }
    }

    static enum PboState {
        CLEAN,
        MAPPED,
        UNMAPPED;

    }

    static enum PboChainState {
        FLUSH,
        FILL;

    }
}

