/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.blocks;

import bdv.util.volatiles.VolatileView;
import bvv.core.backend.Texture;
import bvv.core.blocks.ByteUtils;
import bvv.core.blocks.CopyGridBlock;
import bvv.core.blocks.CopySubArray;
import bvv.core.blocks.CopySubArrayImp;
import bvv.core.blocks.GridDataAccess;
import bvv.core.blocks.GridDataAccessImp;
import bvv.core.cache.CacheSpec;
import bvv.core.cache.UploadBuffer;
import bvv.core.multires.ResolutionLevel3D;
import net.imglib2.RandomAccessible;
import net.imglib2.Volatile;
import net.imglib2.cache.UncheckedCache;
import net.imglib2.cache.ref.WeakRefLoaderCache;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.util.Fraction;

public class TileAccess<S> {
    private final CacheSpec cacheSpec;
    private final GridDataAccess<S> dataAccess;
    private final CopySubArray<S, ByteUtils.Address> copySubArray;
    private final CopyGridBlock gcopy = new CopyGridBlock();
    private final int[] min = new int[3];

    public TileAccess(GridDataAccess<S> dataAccess, CopySubArray<S, ByteUtils.Address> copySubArray, CacheSpec cacheSpec) {
        this.dataAccess = dataAccess;
        this.copySubArray = copySubArray;
        this.cacheSpec = cacheSpec;
    }

    public boolean canLoadCompletely(int[] gridPos, boolean failfast) {
        for (int d = 0; d < 3; ++d) {
            this.min[d] = gridPos[d] * this.cacheSpec.blockSize()[d] - this.cacheSpec.padOffset()[d];
        }
        return this.gcopy.canLoadCompletely(this.min, this.cacheSpec.paddedBlockSize(), this.dataAccess, failfast);
    }

    public boolean canLoadPartially(int[] gridPos) {
        for (int d = 0; d < 3; ++d) {
            this.min[d] = gridPos[d] * this.cacheSpec.blockSize()[d] - this.cacheSpec.padOffset()[d];
        }
        return this.gcopy.canLoadPartially(this.min, this.cacheSpec.paddedBlockSize(), this.dataAccess);
    }

    public boolean loadTile(int[] gridPos, UploadBuffer buffer) {
        for (int d = 0; d < 3; ++d) {
            this.min[d] = gridPos[d] * this.cacheSpec.blockSize()[d] - this.cacheSpec.padOffset()[d];
        }
        return this.gcopy.copy(this.min, this.cacheSpec.paddedBlockSize(), buffer, this.dataAccess, this.copySubArray);
    }

    static TileAccess<?> create(ResolutionLevel3D<?> resolutionLevel3D, CacheSpec cacheSpec) {
        Object type = resolutionLevel3D.getType();
        if (TileAccess.isSupportedType(type)) {
            RandomAccessible img = resolutionLevel3D.getImage();
            if (img instanceof VolatileView) {
                img = ((VolatileView)img).getVolatileViewData().getImg();
            }
            boolean cellimg = img instanceof AbstractCellImg;
            if (cacheSpec.format() == Texture.InternalFormat.R16 && cellimg) {
                boolean volatil = type instanceof Volatile;
                return new TileAccess<short[]>(volatil ? new GridDataAccessImp.VolatileCells((AbstractCellImg)img) : new GridDataAccessImp.Cells((AbstractCellImg)img), new CopySubArrayImp.ShortToAddress(), cacheSpec);
            }
        }
        throw new UnsupportedOperationException("pixel and/or image type not supported (yet).");
    }

    public static boolean isSupportedType(Object type) {
        if (type instanceof NativeType) {
            PrimitiveType primitive = ((NativeType)type).getNativeTypeFactory().getPrimitiveType();
            Fraction epp = ((NativeType)type).getEntitiesPerPixel();
            if (primitive == PrimitiveType.SHORT && epp.getNumerator() == epp.getDenominator()) {
                return true;
            }
        }
        return false;
    }

    public static class Cache {
        private final ThreadLocal<UncheckedCache<Key, TileAccess<?>>> accesses = ThreadLocal.withInitial(() -> new WeakRefLoaderCache().withLoader(key -> TileAccess.create(key.resolutionLevel3D, key.cacheSpec)).unchecked());

        public TileAccess<?> get(ResolutionLevel3D<?> resolutionLevel3D, CacheSpec cacheSpec) {
            return (TileAccess)this.accesses.get().get((Object)new Key(resolutionLevel3D, cacheSpec));
        }

        private static class Key {
            final ResolutionLevel3D<?> resolutionLevel3D;
            final CacheSpec cacheSpec;
            private final int hashcode;

            Key(ResolutionLevel3D<?> resolutionLevel3D, CacheSpec cacheSpec) {
                this.resolutionLevel3D = resolutionLevel3D;
                this.cacheSpec = cacheSpec;
                int value = resolutionLevel3D.hashCode();
                this.hashcode = value = 31 * value + cacheSpec.hashCode();
            }

            public boolean equals(Object o) {
                if (!(o instanceof Key)) {
                    return false;
                }
                Key key = (Key)o;
                if (!this.resolutionLevel3D.equals(key.resolutionLevel3D)) {
                    return false;
                }
                return this.cacheSpec.equals(key.cacheSpec);
            }

            public int hashCode() {
                return this.hashcode;
            }
        }
    }
}

