/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.blocks;

import bvv.core.blocks.ByteUtils;
import bvv.core.blocks.CopySubArray;

public class CopySubArrayImp {
    static void copysubarray3dn(ArrayCopy copysubarray1dn, int sox, int soy, int soz, int ssx, int ssy, int dox, int doy, int doz, int dsx, int dsy, int csx, int csy, int csz) {
        for (int z = 0; z < csz; ++z) {
            CopySubArrayImp.copysubarray2dn(copysubarray1dn, sox, soy + soz * ssy + z * ssy, ssx, dox, doy + doz * dsy + z * dsy, dsx, csx, csy);
        }
    }

    static void copysubarray2dn(ArrayCopy copysubarray1dn, int sox, int soy, int ssx, int dox, int doy, int dsx, int csx, int csy) {
        for (int y = 0; y < csy; ++y) {
            copysubarray1dn.copy(sox + soy * ssx + y * ssx, dox + doy * dsx + y * dsx, csx);
        }
    }

    static void fillsubarray3dn(ArrayFill fillsubarray1dn, int dox, int doy, int doz, int dsx, int dsy, int csx, int csy, int csz) {
        for (int z = 0; z < csz; ++z) {
            CopySubArrayImp.fillsubarray2dn(fillsubarray1dn, dox, doy + doz * dsy + z * dsy, dsx, csx, csy);
        }
    }

    static void fillsubarray2dn(ArrayFill fillsubarray1dn, int dox, int doy, int dsx, int csx, int csy) {
        for (int y = 0; y < csy; ++y) {
            fillsubarray1dn.fill(dox + doy * dsx + y * dsx, csx);
        }
    }

    @FunctionalInterface
    static interface ArrayFill {
        public void fill(int var1, int var2);
    }

    @FunctionalInterface
    static interface ArrayCopy {
        public void copy(int var1, int var2, int var3);
    }

    public static class ShortToAddress
    implements CopySubArray<short[], ByteUtils.Address> {
        @Override
        public void clearsubarray3d(ByteUtils.Address dst, int dox, int doy, int doz, int dsx, int dsy, int csx, int csy, int csz) {
            ArrayFill fill = (o, l) -> ByteUtils.setShorts((short)0, dst.getAddress() + (long)(2 * o), l);
            CopySubArrayImp.fillsubarray3dn(fill, dox, doy, doz, dsx, dsy, csx, csy, csz);
        }

        @Override
        public void copysubarray3d(short[] src, int sox, int soy, int soz, int ssx, int ssy, ByteUtils.Address dst, int dox, int doy, int doz, int dsx, int dsy, int csx, int csy, int csz) {
            ArrayCopy copy = (so, o, l) -> ByteUtils.copyShorts(src, dst.getAddress() + (long)(2 * o), so, l);
            CopySubArrayImp.copysubarray3dn(copy, sox, soy, soz, ssx, ssy, dox, doy, doz, dsx, dsy, csx, csy, csz);
        }
    }
}

