/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.blocks;

import bvv.core.blocks.CopySubArray;
import bvv.core.blocks.GridDataAccess;

public class CopyGridBlock {
    private final int[][] spans = new int[3][6];
    private final int[] ls = new int[3];
    private final int[] gmin = new int[3];
    private final int[] nmin = new int[3];
    private final int[] ndim = new int[3];
    private final int[] css = new int[3];
    private final int[] doo = new int[3];
    private final int[] doo2 = new int[3];

    public <S, T> boolean copy(int[] min, int[] dim, T dst, GridDataAccess<S> srca, CopySubArray<S, T> copy) {
        int d;
        for (d = 0; d < 3; ++d) {
            this.nmin[d] = min[d];
            this.ndim[d] = dim[d];
            this.css[d] = dim[d];
            this.doo2[d] = 0;
            this.doo[d] = 0;
        }
        for (d = 2; d >= 0; --d) {
            if (min[d] < srca.imgSize(d) && min[d] + dim[d] > 0) continue;
            copy.clearsubarray3d(dst, 0, 0, 0, dim[0], dim[1], dim[0], dim[1], dim[2]);
            return true;
        }
        for (d = 2; d >= 0; --d) {
            int b;
            if (min[d] < 0) {
                this.css[d] = -min[d];
                copy.clearsubarray3d(dst, this.doo[0], this.doo[1], this.doo[2], dim[0], dim[1], this.css[0], this.css[1], this.css[2]);
                this.nmin[d] = 0;
                int n = d;
                this.ndim[n] = this.ndim[n] - this.css[d];
                this.doo[d] = this.css[d];
            }
            if ((b = min[d] + dim[d] - srca.imgSize(d)) > 0) {
                this.doo2[d] = dim[d] - b;
                this.css[d] = b;
                copy.clearsubarray3d(dst, this.doo2[0], this.doo2[1], this.doo2[2], dim[0], dim[1], this.css[0], this.css[1], this.css[2]);
                int n = d;
                this.ndim[n] = this.ndim[n] - this.css[d];
            }
            this.css[d] = this.ndim[d];
            this.doo2[d] = this.doo[d];
        }
        return this.copyNoOob(this.nmin, this.ndim, this.doo, dim, dst, srca, copy);
    }

    private <S, T> boolean copyNoOob(int[] min, int[] dim, int[] doff, int[] ddim, T dst, GridDataAccess<S> srca, CopySubArray<S, T> copy) {
        boolean complete = true;
        for (int d = 0; d < 3; ++d) {
            int cellsize = srca.cellSize(d);
            int g0 = min[d] / cellsize;
            int g1 = (min[d] + dim[d] - 1) / cellsize;
            this.gmin[d] = g0;
            this.ls[d] = g1 - g0 + 1;
            int spanreq = 3 * this.ls[d];
            if (this.spans[d].length < spanreq) {
                this.spans[d] = new int[spanreq];
            }
            int[] span = this.spans[d];
            int i = 0;
            int o = min[d] - g0 * cellsize;
            for (int g = g0; g < g1; ++g) {
                span[i++] = o;
                span[i++] = cellsize - o;
                span[i++] = cellsize;
                o = 0;
            }
            span[i++] = o;
            span[i++] = min[d] + dim[d] - g1 * cellsize - o;
            span[i] = srca.cellSize(d, g1);
        }
        srca.setPosition(this.gmin);
        int gsx = this.ls[0];
        int gsy = this.ls[1];
        int gsz = this.ls[2];
        int[] spanx = this.spans[0];
        int[] spany = this.spans[1];
        int[] spanz = this.spans[2];
        int dsx = ddim[0];
        int dsy = ddim[1];
        int doz = doff[2];
        for (int gz = 0; gz < gsz; ++gz) {
            int oz = spanz[3 * gz];
            int sz = spanz[3 * gz + 1];
            int doy = doff[1];
            for (int gy = 0; gy < gsy; ++gy) {
                int oy = spany[3 * gy];
                int sy = spany[3 * gy + 1];
                int ssy = spany[3 * gy + 2];
                int dox = doff[0];
                for (int gx = 0; gx < gsx; ++gx) {
                    int ox = spanx[3 * gx];
                    int sx = spanx[3 * gx + 1];
                    int ssx = spanx[3 * gx + 2];
                    S src = srca.get();
                    if (src == null) {
                        complete = false;
                        copy.clearsubarray3d(dst, dox, doy, doz, dsx, dsy, sx, sy, sz);
                    } else {
                        copy.copysubarray3d(src, ox, oy, oz, ssx, ssy, dst, dox, doy, doz, dsx, dsy, sx, sy, sz);
                    }
                    dox += sx;
                    if (gx >= gsx - 1) continue;
                    srca.fwd(0);
                }
                doy += sy;
                if (gsx > 1) {
                    srca.setPosition(this.gmin[0], 0);
                }
                if (gy >= gsy - 1) continue;
                srca.fwd(1);
            }
            doz += sz;
            if (gsy > 1) {
                srca.setPosition(this.gmin[1], 1);
            }
            if (gz >= gsz - 1) continue;
            srca.fwd(2);
        }
        return complete;
    }

    public boolean canLoadCompletely(int[] min, int[] dim, GridDataAccess<?> srca, boolean failfast) {
        int d;
        for (d = 2; d >= 0; --d) {
            if (min[d] < srca.imgSize(d) && min[d] + dim[d] > 0) continue;
            return true;
        }
        for (d = 0; d < 3; ++d) {
            int b;
            int srcsize = srca.imgSize(d);
            this.nmin[d] = min[d];
            this.ndim[d] = dim[d];
            if (min[d] < 0) {
                this.nmin[d] = 0;
                int n = d;
                this.ndim[n] = this.ndim[n] + min[d];
            }
            if ((b = min[d] + dim[d] - srcsize) <= 0) continue;
            int n = d;
            this.ndim[n] = this.ndim[n] - b;
        }
        return this.canLoadCompletelyNoOob(this.nmin, this.ndim, srca, failfast);
    }

    private boolean canLoadCompletelyNoOob(int[] min, int[] dim, GridDataAccess<?> srca, boolean failfast) {
        boolean complete = true;
        for (int d = 0; d < 3; ++d) {
            int cellsize = srca.cellSize(d);
            int g0 = min[d] / cellsize;
            int g1 = (min[d] + dim[d] - 1) / cellsize;
            this.gmin[d] = g0;
            this.ls[d] = g1 - g0 + 1;
        }
        srca.setPosition(this.gmin);
        int gsx = this.ls[0];
        int gsy = this.ls[1];
        int gsz = this.ls[2];
        for (int gz = 0; gz < gsz; ++gz) {
            for (int gy = 0; gy < gsy; ++gy) {
                for (int gx = 0; gx < gsx; ++gx) {
                    if (srca.get() == null) {
                        complete = false;
                        if (failfast) {
                            return false;
                        }
                    }
                    if (gx >= gsx - 1) continue;
                    srca.fwd(0);
                }
                if (gsx > 1) {
                    srca.setPosition(this.gmin[0], 0);
                }
                if (gy >= gsy - 1) continue;
                srca.fwd(1);
            }
            if (gsy > 1) {
                srca.setPosition(this.gmin[1], 1);
            }
            if (gz >= gsz - 1) continue;
            srca.fwd(2);
        }
        return complete;
    }

    public boolean canLoadPartially(int[] min, int[] dim, GridDataAccess<?> srca) {
        int d;
        for (d = 2; d >= 0; --d) {
            if (min[d] < srca.imgSize(d) && min[d] + dim[d] > 0) continue;
            return false;
        }
        for (d = 0; d < 3; ++d) {
            int b;
            int srcsize = srca.imgSize(d);
            this.nmin[d] = min[d];
            this.ndim[d] = dim[d];
            if (min[d] < 0) {
                this.nmin[d] = 0;
                int n = d;
                this.ndim[n] = this.ndim[n] + min[d];
            }
            if ((b = min[d] + dim[d] - srcsize) <= 0) continue;
            int n = d;
            this.ndim[n] = this.ndim[n] - b;
        }
        return this.canLoadPartiallyNoOob(this.nmin, this.ndim, srca);
    }

    private boolean canLoadPartiallyNoOob(int[] min, int[] dim, GridDataAccess<?> srca) {
        for (int d = 0; d < 3; ++d) {
            int cellsize = srca.cellSize(d);
            int g0 = min[d] / cellsize;
            int g1 = (min[d] + dim[d] - 1) / cellsize;
            this.gmin[d] = g0;
            this.ls[d] = g1 - g0 + 1;
        }
        srca.setPosition(this.gmin);
        int gsx = this.ls[0];
        int gsy = this.ls[1];
        int gsz = this.ls[2];
        for (int gz = 0; gz < gsz; ++gz) {
            for (int gy = 0; gy < gsy; ++gy) {
                for (int gx = 0; gx < gsx; ++gx) {
                    if (srca.get() != null) {
                        return true;
                    }
                    if (gx >= gsx - 1) continue;
                    srca.fwd(0);
                }
                if (gsx > 1) {
                    srca.setPosition(this.gmin[0], 0);
                }
                if (gy >= gsy - 1) continue;
                srca.fwd(1);
            }
            if (gsy > 1) {
                srca.setPosition(this.gmin[1], 1);
            }
            if (gz >= gsz - 1) continue;
            srca.fwd(2);
        }
        return false;
    }
}

