/*
 * Decompiled with CFR 0.152.
 */
package bvv.core.blockmath;

import bvv.core.blockmath.GeomUtils;
import bvv.core.blockmath.RequiredBlocks;
import bvv.core.util.MatrixMath;
import java.util.ArrayList;
import net.imglib2.Localizable;
import net.imglib2.RealLocalizable;
import net.imglib2.algorithm.kdtree.ConvexPolytope;
import net.imglib2.algorithm.kdtree.HyperPlane;
import net.imglib2.iterator.LocalizingIntervalIterator;
import net.imglib2.util.LinAlgHelpers;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class FindRequiredBlocks {
    public static ConvexPolytope shrinkClippingPolytope(ConvexPolytope clip, int[] blockSize) {
        int n = clip.numDimensions();
        double[] cellBBMin = new double[n];
        double[] cellBBMax = new double[n];
        for (int d = 0; d < n; ++d) {
            cellBBMin[d] = -0.5;
            cellBBMax[d] = (double)blockSize[d] - 0.5;
        }
        double[] offset = new double[n];
        ArrayList<HyperPlane> planes = new ArrayList<HyperPlane>();
        for (HyperPlane plane : clip.getHyperplanes()) {
            double[] nn = plane.getNormal();
            double m = plane.getDistance();
            for (int d = 0; d < n; ++d) {
                offset[d] = nn[d] < 0.0 ? cellBBMin[d] : cellBBMax[d];
            }
            planes.add(new HyperPlane(nn, m - LinAlgHelpers.dot((double[])nn, (double[])offset)));
        }
        return new ConvexPolytope(planes);
    }

    public static ConvexPolytope scaleClippingPolytope(ConvexPolytope clip, int[] blockSize) {
        int n = clip.numDimensions();
        double[] nn = new double[n];
        ArrayList<HyperPlane> planes = new ArrayList<HyperPlane>();
        for (HyperPlane plane : clip.getHyperplanes()) {
            double[] normal = plane.getNormal();
            for (int d = 0; d < n; ++d) {
                nn[d] = normal[d] * (double)blockSize[d];
            }
            double len = LinAlgHelpers.length((double[])nn);
            int d = 0;
            while (d < n) {
                int n2 = d++;
                nn[n2] = nn[n2] / len;
            }
            double m = plane.getDistance() / len;
            planes.add(new HyperPlane(nn, m));
        }
        return new ConvexPolytope(planes);
    }

    public static RequiredBlocks getRequiredBlocks(ConvexPolytope clip, int[] blockSize, long[] gridMin, long[] gridMax) {
        int n = clip.numDimensions();
        RequiredBlocks required = new RequiredBlocks(n);
        ConvexPolytope shrunkClip = FindRequiredBlocks.shrinkClippingPolytope(clip, blockSize);
        ConvexPolytope gridClip = FindRequiredBlocks.scaleClippingPolytope(shrunkClip, blockSize);
        LocalizingIntervalIterator gridIter = new LocalizingIntervalIterator(gridMin, gridMax);
        while (gridIter.hasNext()) {
            gridIter.fwd();
            if (!GeomUtils.isInside(gridClip, (RealLocalizable)gridIter)) continue;
            required.add((Localizable)gridIter);
        }
        return required;
    }

    private static HyperPlane sourceHyperPlane(Matrix4fc sourceToNDCTransposed, double nx, double ny, double nz, double d) {
        return MatrixMath.hyperPlane(new Vector4f((float)nx, (float)ny, (float)nz, (float)(-d)).mul(sourceToNDCTransposed).normalize3());
    }

    public static RequiredBlocks getRequiredLevelBlocksFrustum(Matrix4fc levelToNDC, int[] blockSize, long[] gridMin, long[] gridMax) {
        Matrix4f T = levelToNDC.transpose(new Matrix4f());
        ConvexPolytope sourceRegion = new ConvexPolytope(new HyperPlane[]{FindRequiredBlocks.sourceHyperPlane((Matrix4fc)T, 1.0, 0.0, 0.0, -1.0), FindRequiredBlocks.sourceHyperPlane((Matrix4fc)T, -1.0, 0.0, 0.0, -1.0), FindRequiredBlocks.sourceHyperPlane((Matrix4fc)T, 0.0, 1.0, 0.0, -1.0), FindRequiredBlocks.sourceHyperPlane((Matrix4fc)T, 0.0, -1.0, 0.0, -1.0), FindRequiredBlocks.sourceHyperPlane((Matrix4fc)T, 0.0, 0.0, 1.0, -1.0), FindRequiredBlocks.sourceHyperPlane((Matrix4fc)T, 0.0, 0.0, -1.0, -1.0)});
        return FindRequiredBlocks.getRequiredBlocks(sourceRegion, blockSize, gridMin, gridMax);
    }
}

