/*
 * Decompiled with CFR 0.152.
 */
package bvv.core;

import bdv.TransformEventHandler3D;
import bdv.TransformEventHandlerFactory;
import bdv.ui.appearance.AppearanceManager;
import bdv.ui.keymap.KeymapManager;
import bdv.viewer.animate.MessageOverlayAnimator;
import org.scijava.ui.behaviour.KeyPressedManager;
import org.scijava.ui.behaviour.io.InputTriggerConfig;

public class VolumeViewerOptions {
    public final Values values = new Values();

    public static VolumeViewerOptions options() {
        return new VolumeViewerOptions();
    }

    public VolumeViewerOptions width(int w) {
        this.values.width = w;
        return this;
    }

    public VolumeViewerOptions height(int h) {
        this.values.height = h;
        return this;
    }

    public VolumeViewerOptions renderWidth(int w) {
        this.values.renderWidth = w;
        return this;
    }

    public VolumeViewerOptions renderHeight(int h) {
        this.values.renderHeight = h;
        return this;
    }

    public VolumeViewerOptions maxRenderMillis(int t) {
        this.values.maxRenderMillis = t;
        return this;
    }

    public VolumeViewerOptions ditherWidth(int w) {
        this.values.ditherWidth = w;
        return this;
    }

    public VolumeViewerOptions numDitherSamples(int n) {
        this.values.numDitherSamples = n;
        return this;
    }

    public VolumeViewerOptions cacheBlockSize(int[] s) {
        assert (s.length == 3);
        ((Values)this.values).cacheBlockSize[0] = s[0];
        ((Values)this.values).cacheBlockSize[1] = s[1];
        ((Values)this.values).cacheBlockSize[2] = s[2];
        return this;
    }

    public VolumeViewerOptions cacheBlockSize(int s) {
        ((Values)this.values).cacheBlockSize[0] = s;
        ((Values)this.values).cacheBlockSize[1] = s;
        ((Values)this.values).cacheBlockSize[2] = s;
        return this;
    }

    public VolumeViewerOptions maxCacheSizeInMB(int s) {
        this.values.maxCacheSizeInMB = s;
        return this;
    }

    public VolumeViewerOptions dCam(double d) {
        this.values.dCam = d;
        return this;
    }

    public VolumeViewerOptions dClipNear(double d) {
        this.values.dClipNear = d;
        return this;
    }

    public VolumeViewerOptions dClipFar(double d) {
        this.values.dClipFar = d;
        return this;
    }

    public VolumeViewerOptions dClip(double d) {
        this.values.dClipNear = d;
        this.values.dClipFar = d;
        return this;
    }

    public VolumeViewerOptions maxAllowedStepInVoxels(double s) {
        this.values.maxAllowedStepInVoxels = s;
        return this;
    }

    public VolumeViewerOptions numSourceGroups(int n) {
        this.values.numSourceGroups = n;
        return this;
    }

    public VolumeViewerOptions msgOverlay(MessageOverlayAnimator o) {
        this.values.msgOverlay = o;
        return this;
    }

    public VolumeViewerOptions transformEventHandlerFactory(TransformEventHandlerFactory f) {
        this.values.transformEventHandlerFactory = f;
        return this;
    }

    public VolumeViewerOptions inputTriggerConfig(InputTriggerConfig c) {
        this.values.inputTriggerConfig = c;
        return this;
    }

    public VolumeViewerOptions shareKeyPressedEvents(KeyPressedManager manager) {
        this.values.keyPressedManager = manager;
        return this;
    }

    public VolumeViewerOptions keymapManager(KeymapManager keymapManager) {
        this.values.keymapManager = keymapManager;
        return this;
    }

    public VolumeViewerOptions appearanceManager(AppearanceManager appearanceManager) {
        this.values.appearanceManager = appearanceManager;
        return this;
    }

    public static class Values {
        private int width = 800;
        private int height = 600;
        private int maxRenderMillis = 30;
        private int renderWidth = 512;
        private int renderHeight = 512;
        private int ditherWidth = 3;
        private int numDitherSamples = 8;
        private final int[] cacheBlockSize = new int[]{32, 32, 32};
        private int maxCacheSizeInMB = 300;
        private double dCam = 2000.0;
        private double dClipNear = 1000.0;
        private double dClipFar = 1000.0;
        private double maxAllowedStepInVoxels = 1.0;
        private int numSourceGroups = 10;
        private MessageOverlayAnimator msgOverlay = new MessageOverlayAnimator(800L);
        private TransformEventHandlerFactory transformEventHandlerFactory = TransformEventHandler3D::new;
        private InputTriggerConfig inputTriggerConfig = null;
        private KeyPressedManager keyPressedManager = null;
        private KeymapManager keymapManager = null;
        private AppearanceManager appearanceManager = null;

        public VolumeViewerOptions optionsFromValues() {
            return new VolumeViewerOptions().width(this.width).height(this.height).renderWidth(this.renderWidth).renderHeight(this.renderHeight).maxRenderMillis(this.maxRenderMillis).ditherWidth(this.ditherWidth).numDitherSamples(this.numDitherSamples).cacheBlockSize(this.cacheBlockSize).maxCacheSizeInMB(this.maxCacheSizeInMB).dCam(this.dCam).dClipNear(this.dClipNear).dClipFar(this.dClipFar).maxAllowedStepInVoxels(this.maxAllowedStepInVoxels).numSourceGroups(this.numSourceGroups).msgOverlay(this.msgOverlay).transformEventHandlerFactory(this.transformEventHandlerFactory).inputTriggerConfig(this.inputTriggerConfig).shareKeyPressedEvents(this.keyPressedManager).keymapManager(this.keymapManager).appearanceManager(this.appearanceManager);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getRenderWidth() {
            return this.renderWidth;
        }

        public int getRenderHeight() {
            return this.renderHeight;
        }

        public int getMaxRenderMillis() {
            return this.maxRenderMillis;
        }

        public int getDitherWidth() {
            return this.ditherWidth;
        }

        public int getNumDitherSamples() {
            return this.numDitherSamples;
        }

        public int[] getCacheBlockSize() {
            return (int[])this.cacheBlockSize.clone();
        }

        public int getMaxCacheSizeInMB() {
            return this.maxCacheSizeInMB;
        }

        public double getDCam() {
            return this.dCam;
        }

        public double getDClipNear() {
            return this.dClipNear;
        }

        public double getDClipFar() {
            return this.dClipFar;
        }

        public double getMaxAllowedStepInVoxels() {
            return this.maxAllowedStepInVoxels;
        }

        public int getNumSourceGroups() {
            return this.numSourceGroups;
        }

        public MessageOverlayAnimator getMsgOverlay() {
            return this.msgOverlay;
        }

        public TransformEventHandlerFactory getTransformEventHandlerFactory() {
            return this.transformEventHandlerFactory;
        }

        public InputTriggerConfig getInputTriggerConfig() {
            return this.inputTriggerConfig;
        }

        public KeyPressedManager getKeyPressedManager() {
            return this.keyPressedManager;
        }

        public KeymapManager getKeymapManager() {
            return this.keymapManager;
        }

        public AppearanceManager getAppearanceManager() {
            return this.appearanceManager;
        }
    }
}

