/*
 * Decompiled with CFR 0.152.
 */
package bvv.core;

import bdv.TransformEventHandler;
import bdv.viewer.InteractiveDisplay;
import bdv.viewer.OverlayRenderer;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.awt.GLJPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.util.function.Consumer;
import org.scijava.listeners.Listeners;

public class InteractiveGLDisplayCanvas<C extends Component>
implements InteractiveDisplay {
    private TransformEventHandler handler;
    private final Listeners.List<OverlayRenderer> overlayRenderers;
    private final C canvas;
    private final boolean yAxisFlipped;
    private final Listeners.List<CanvasSizeListener> canvasSizeListeners;

    public static InteractiveGLDisplayCanvas<GLCanvas> createGLCanvas(int width, int height) {
        GLCanvas canvas = new GLCanvas((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.getMaxProgrammableCore((boolean)true)));
        return new InteractiveGLDisplayCanvas<GLCanvas>(canvas, width, height, false);
    }

    public static InteractiveGLDisplayCanvas<GLJPanel> createGLJPanel(int width, int height) {
        MyGLJPanel panel = new MyGLJPanel((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.getMaxProgrammableCore((boolean)true)));
        InteractiveGLDisplayCanvas<GLJPanel> canvas = new InteractiveGLDisplayCanvas<GLJPanel>(panel, width, height, true);
        panel.onPaintComponent = canvas::paintOverlays;
        return canvas;
    }

    private InteractiveGLDisplayCanvas(C canvas, int width, int height, boolean yAxisFlipped) {
        this.canvas = canvas;
        this.yAxisFlipped = yAxisFlipped;
        ((Component)canvas).setPreferredSize(new Dimension(width, height));
        ((Component)canvas).setFocusable(true);
        this.canvasSizeListeners = new Listeners.SynchronizedList(r -> r.setCanvasSize(canvas.getWidth(), canvas.getHeight()));
        this.overlayRenderers = new Listeners.SynchronizedList(r -> r.setCanvasSize(canvas.getWidth(), canvas.getHeight()));
        ((Component)canvas).addComponentListener(new ComponentAdapter((Component)canvas){
            final /* synthetic */ Component val$canvas;
            {
                this.val$canvas = component;
            }

            @Override
            public void componentResized(ComponentEvent e) {
                int w = this.val$canvas.getWidth();
                int h = this.val$canvas.getHeight();
                ((InteractiveGLDisplayCanvas)InteractiveGLDisplayCanvas.this).overlayRenderers.list.forEach(r -> r.setCanvasSize(w, h));
                ((InteractiveGLDisplayCanvas)InteractiveGLDisplayCanvas.this).canvasSizeListeners.list.forEach(r -> r.setCanvasSize(w, h));
                if (InteractiveGLDisplayCanvas.this.handler != null) {
                    InteractiveGLDisplayCanvas.this.handler.setCanvasSize(w, h, true);
                }
            }
        });
        ((Component)canvas).addMouseListener(new MouseAdapter((Component)canvas){
            final /* synthetic */ Component val$canvas;
            {
                this.val$canvas = component;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.val$canvas.requestFocusInWindow();
            }
        });
    }

    public Listeners<CanvasSizeListener> canvasSizeListeners() {
        return this.canvasSizeListeners;
    }

    public Listeners<OverlayRenderer> overlays() {
        return this.overlayRenderers;
    }

    private void paintOverlays(Graphics g) {
        this.overlayRenderers.list.forEach(r -> r.drawOverlays(g));
    }

    public void addHandler(Object h) {
        if (h instanceof KeyListener) {
            ((Component)this.canvas).addKeyListener((KeyListener)h);
        }
        if (h instanceof MouseMotionListener) {
            ((Component)this.canvas).addMouseMotionListener((MouseMotionListener)h);
        }
        if (h instanceof MouseListener) {
            ((Component)this.canvas).addMouseListener((MouseListener)h);
        }
        if (h instanceof MouseWheelListener) {
            ((Component)this.canvas).addMouseWheelListener((MouseWheelListener)h);
        }
        if (h instanceof FocusListener) {
            ((Component)this.canvas).addFocusListener((FocusListener)h);
        }
    }

    public void removeHandler(Object h) {
        if (h instanceof KeyListener) {
            ((Component)this.canvas).removeKeyListener((KeyListener)h);
        }
        if (h instanceof MouseMotionListener) {
            ((Component)this.canvas).removeMouseMotionListener((MouseMotionListener)h);
        }
        if (h instanceof MouseListener) {
            ((Component)this.canvas).removeMouseListener((MouseListener)h);
        }
        if (h instanceof MouseWheelListener) {
            ((Component)this.canvas).removeMouseWheelListener((MouseWheelListener)h);
        }
        if (h instanceof FocusListener) {
            ((Component)this.canvas).removeFocusListener((FocusListener)h);
        }
    }

    public void setTransformEventHandler(TransformEventHandler transformEventHandler) {
        if (this.handler != null) {
            this.removeHandler(this.handler);
        }
        this.handler = transformEventHandler;
        int w = ((Component)this.canvas).getWidth();
        int h = ((Component)this.canvas).getHeight();
        if (w <= 0 || h <= 0) {
            Dimension preferred = ((Component)this.canvas).getPreferredSize();
            w = preferred.width;
            h = preferred.height;
        }
        this.handler.setCanvasSize(w, h, false);
        this.addHandler(this.handler);
    }

    public C getComponent() {
        return this.canvas;
    }

    public boolean yAxisFlipped() {
        return this.yAxisFlipped;
    }

    public void addGLEventListener(GLEventListener listener) {
        ((GLAutoDrawable)this.canvas).addGLEventListener(listener);
    }

    public void display() {
        ((GLAutoDrawable)this.canvas).display();
    }

    public boolean requestFocusInWindow() {
        return ((Component)this.canvas).requestFocusInWindow();
    }

    public int getWidth() {
        return ((Component)this.canvas).getWidth();
    }

    public int getHeight() {
        return ((Component)this.canvas).getHeight();
    }

    public Dimension getSize() {
        return ((Component)this.canvas).getSize();
    }

    static class MyGLJPanel
    extends GLJPanel {
        private Consumer<Graphics> onPaintComponent;

        public MyGLJPanel(GLCapabilitiesImmutable userCapsRequest) throws GLException {
            super(userCapsRequest);
            this.setSurfaceScale(new float[]{1.0f, 1.0f});
            this.setSkipGLOrientationVerticalFlip(true);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.onPaintComponent.accept(g);
        }
    }

    public static interface CanvasSizeListener {
        public void setCanvasSize(int var1, int var2);
    }
}

