/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.skeletonize3D;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.util.ArrayList;

public class Skeletonize3D_
implements PlugInFilter {
    private ImagePlus imRef;
    private int width = 0;
    private int height = 0;
    private int depth = 0;
    private ImageStack inputImage = null;
    private int iterations;

    public int setup(String arg, ImagePlus imp) {
        this.imRef = imp;
        if (arg.equals("about")) {
            this.showAbout();
            return 4096;
        }
        return 1;
    }

    public void run(ImageProcessor ip) {
        this.width = this.imRef.getWidth();
        this.height = this.imRef.getHeight();
        this.depth = this.imRef.getStackSize();
        this.inputImage = this.imRef.getStack();
        this.prepareData(this.inputImage);
        this.computeThinImage(this.inputImage);
        for (int i = 1; i <= this.inputImage.getSize(); ++i) {
            this.inputImage.getProcessor(i).multiply(255.0);
        }
        this.inputImage.update(ip);
    }

    public void prepareData(ImageStack outputImage) {
        IJ.showStatus((String)"Prepare Data: Copy input to output ...");
        for (int z = 0; z < this.depth; ++z) {
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    if (((byte[])this.inputImage.getPixels(z + 1))[x + y * this.width] == 0) continue;
                    ((byte[])outputImage.getPixels((int)(z + 1)))[x + y * this.width] = 1;
                }
            }
        }
        IJ.showStatus((String)"Prepare Data End.");
    }

    public void computeThinImage(ImageStack outputImage) {
        IJ.showStatus((String)"Computing thin image ...");
        int[] eulerLUT = new int[256];
        this.fillEulerLUT(eulerLUT);
        int[] pointsLUT = new int[256];
        this.fillnumOfPointsLUT(pointsLUT);
        ArrayList<int[]> simpleBorderPoints = new ArrayList<int[]>();
        this.iterations = 0;
        int unchangedBorders = 0;
        while (unchangedBorders < 6) {
            unchangedBorders = 0;
            ++this.iterations;
            for (int currentBorder = 1; currentBorder <= 6; ++currentBorder) {
                IJ.showStatus((String)("Thinning iteration " + this.iterations + " (" + currentBorder + "/6 borders) ..."));
                boolean noChange = true;
                for (int z = 0; z < this.depth; ++z) {
                    for (int y = 0; y < this.height; ++y) {
                        for (int x = 0; x < this.width; ++x) {
                            byte[] neighborhood;
                            if (this.getPixelNoCheck(outputImage, x, y, z) != 1) continue;
                            boolean isBorderPoint = false;
                            if (currentBorder == 1 && this.N(outputImage, x, y, z) <= 0) {
                                isBorderPoint = true;
                            }
                            if (currentBorder == 2 && this.S(outputImage, x, y, z) <= 0) {
                                isBorderPoint = true;
                            }
                            if (currentBorder == 3 && this.E(outputImage, x, y, z) <= 0) {
                                isBorderPoint = true;
                            }
                            if (currentBorder == 4 && this.W(outputImage, x, y, z) <= 0) {
                                isBorderPoint = true;
                            }
                            if (outputImage.getSize() > 1) {
                                if (currentBorder == 5 && this.U(outputImage, x, y, z) <= 0) {
                                    isBorderPoint = true;
                                }
                                if (currentBorder == 6 && this.B(outputImage, x, y, z) <= 0) {
                                    isBorderPoint = true;
                                }
                            }
                            if (!isBorderPoint || this.isEndPoint(outputImage, x, y, z) || !this.isEulerInvariant(neighborhood = this.getNeighborhood(outputImage, x, y, z), eulerLUT) || !this.isSimplePoint(neighborhood)) continue;
                            int[] index = new int[]{x, y, z};
                            simpleBorderPoints.add(index);
                        }
                    }
                    IJ.showProgress((int)z, (int)this.depth);
                }
                for (int[] simpleBorderPoint : simpleBorderPoints) {
                    int[] index = simpleBorderPoint;
                    if (!this.isSimplePoint(this.getNeighborhood(outputImage, index[0], index[1], index[2]))) continue;
                    this.setPixel(outputImage, index[0], index[1], index[2], (byte)0);
                    noChange = false;
                }
                if (noChange) {
                    ++unchangedBorders;
                }
                simpleBorderPoints.clear();
            }
        }
        IJ.showStatus((String)"Computed thin image.");
    }

    boolean isEndPoint(ImageStack image, int x, int y, int z) {
        int numberOfNeighbors = -1;
        byte[] neighbor = this.getNeighborhood(image, x, y, z);
        for (int i = 0; i < 27; ++i) {
            if (neighbor[i] != 1) continue;
            ++numberOfNeighbors;
        }
        return numberOfNeighbors == 1;
    }

    public byte[] getNeighborhood(ImageStack image, int x, int y, int z) {
        byte[] neighborhood = new byte[]{this.getPixel(image, x - 1, y - 1, z - 1), this.getPixel(image, x, y - 1, z - 1), this.getPixel(image, x + 1, y - 1, z - 1), this.getPixel(image, x - 1, y, z - 1), this.getPixel(image, x, y, z - 1), this.getPixel(image, x + 1, y, z - 1), this.getPixel(image, x - 1, y + 1, z - 1), this.getPixel(image, x, y + 1, z - 1), this.getPixel(image, x + 1, y + 1, z - 1), this.getPixel(image, x - 1, y - 1, z), this.getPixel(image, x, y - 1, z), this.getPixel(image, x + 1, y - 1, z), this.getPixel(image, x - 1, y, z), this.getPixel(image, x, y, z), this.getPixel(image, x + 1, y, z), this.getPixel(image, x - 1, y + 1, z), this.getPixel(image, x, y + 1, z), this.getPixel(image, x + 1, y + 1, z), this.getPixel(image, x - 1, y - 1, z + 1), this.getPixel(image, x, y - 1, z + 1), this.getPixel(image, x + 1, y - 1, z + 1), this.getPixel(image, x - 1, y, z + 1), this.getPixel(image, x, y, z + 1), this.getPixel(image, x + 1, y, z + 1), this.getPixel(image, x - 1, y + 1, z + 1), this.getPixel(image, x, y + 1, z + 1), this.getPixel(image, x + 1, y + 1, z + 1)};
        return neighborhood;
    }

    private byte getPixel(ImageStack image, int x, int y, int z) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height && z >= 0 && z < this.depth) {
            return ((byte[])image.getPixels(z + 1))[x + y * this.width];
        }
        return 0;
    }

    private byte getPixelNoCheck(ImageStack image, int x, int y, int z) {
        return ((byte[])image.getPixels(z + 1))[x + y * this.width];
    }

    private void setPixel(ImageStack image, int x, int y, int z, byte value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height && z >= 0 && z < this.depth) {
            ((byte[])image.getPixels((int)(z + 1)))[x + y * this.width] = value;
        }
    }

    private byte N(ImageStack image, int x, int y, int z) {
        return this.getPixel(image, x, y - 1, z);
    }

    private byte S(ImageStack image, int x, int y, int z) {
        return this.getPixel(image, x, y + 1, z);
    }

    private byte E(ImageStack image, int x, int y, int z) {
        return this.getPixel(image, x + 1, y, z);
    }

    private byte W(ImageStack image, int x, int y, int z) {
        return this.getPixel(image, x - 1, y, z);
    }

    private byte U(ImageStack image, int x, int y, int z) {
        return this.getPixel(image, x, y, z + 1);
    }

    private byte B(ImageStack image, int x, int y, int z) {
        return this.getPixel(image, x, y, z - 1);
    }

    private void fillEulerLUT(int[] LUT) {
        LUT[1] = 1;
        LUT[3] = -1;
        LUT[5] = -1;
        LUT[7] = 1;
        LUT[9] = -3;
        LUT[11] = -1;
        LUT[13] = -1;
        LUT[15] = 1;
        LUT[17] = -1;
        LUT[19] = 1;
        LUT[21] = 1;
        LUT[23] = -1;
        LUT[25] = 3;
        LUT[27] = 1;
        LUT[29] = 1;
        LUT[31] = -1;
        LUT[33] = -3;
        LUT[35] = -1;
        LUT[37] = 3;
        LUT[39] = 1;
        LUT[41] = 1;
        LUT[43] = -1;
        LUT[45] = 3;
        LUT[47] = 1;
        LUT[49] = -1;
        LUT[51] = 1;
        LUT[53] = 1;
        LUT[55] = -1;
        LUT[57] = 3;
        LUT[59] = 1;
        LUT[61] = 1;
        LUT[63] = -1;
        LUT[65] = -3;
        LUT[67] = 3;
        LUT[69] = -1;
        LUT[71] = 1;
        LUT[73] = 1;
        LUT[75] = 3;
        LUT[77] = -1;
        LUT[79] = 1;
        LUT[81] = -1;
        LUT[83] = 1;
        LUT[85] = 1;
        LUT[87] = -1;
        LUT[89] = 3;
        LUT[91] = 1;
        LUT[93] = 1;
        LUT[95] = -1;
        LUT[97] = 1;
        LUT[99] = 3;
        LUT[101] = 3;
        LUT[103] = 1;
        LUT[105] = 5;
        LUT[107] = 3;
        LUT[109] = 3;
        LUT[111] = 1;
        LUT[113] = -1;
        LUT[115] = 1;
        LUT[117] = 1;
        LUT[119] = -1;
        LUT[121] = 3;
        LUT[123] = 1;
        LUT[125] = 1;
        LUT[127] = -1;
        LUT[129] = -7;
        LUT[131] = -1;
        LUT[133] = -1;
        LUT[135] = 1;
        LUT[137] = -3;
        LUT[139] = -1;
        LUT[141] = -1;
        LUT[143] = 1;
        LUT[145] = -1;
        LUT[147] = 1;
        LUT[149] = 1;
        LUT[151] = -1;
        LUT[153] = 3;
        LUT[155] = 1;
        LUT[157] = 1;
        LUT[159] = -1;
        LUT[161] = -3;
        LUT[163] = -1;
        LUT[165] = 3;
        LUT[167] = 1;
        LUT[169] = 1;
        LUT[171] = -1;
        LUT[173] = 3;
        LUT[175] = 1;
        LUT[177] = -1;
        LUT[179] = 1;
        LUT[181] = 1;
        LUT[183] = -1;
        LUT[185] = 3;
        LUT[187] = 1;
        LUT[189] = 1;
        LUT[191] = -1;
        LUT[193] = -3;
        LUT[195] = 3;
        LUT[197] = -1;
        LUT[199] = 1;
        LUT[201] = 1;
        LUT[203] = 3;
        LUT[205] = -1;
        LUT[207] = 1;
        LUT[209] = -1;
        LUT[211] = 1;
        LUT[213] = 1;
        LUT[215] = -1;
        LUT[217] = 3;
        LUT[219] = 1;
        LUT[221] = 1;
        LUT[223] = -1;
        LUT[225] = 1;
        LUT[227] = 3;
        LUT[229] = 3;
        LUT[231] = 1;
        LUT[233] = 5;
        LUT[235] = 3;
        LUT[237] = 3;
        LUT[239] = 1;
        LUT[241] = -1;
        LUT[243] = 1;
        LUT[245] = 1;
        LUT[247] = -1;
        LUT[249] = 3;
        LUT[251] = 1;
        LUT[253] = 1;
        LUT[255] = -1;
    }

    public void fillnumOfPointsLUT(int[] LUT) {
        for (int i = 0; i < 256; ++i) {
            LUT[i] = Integer.bitCount(i);
        }
    }

    boolean isEulerInvariant(byte[] neighbors, int[] LUT) {
        int eulerChar = 0;
        char n = this.indexOctantSWU(neighbors);
        eulerChar += LUT[n];
        n = this.indexOctantSEU(neighbors);
        eulerChar += LUT[n];
        n = this.indexOctantNWU(neighbors);
        eulerChar += LUT[n];
        n = this.indexOctantNEU(neighbors);
        eulerChar += LUT[n];
        n = this.indexOctantSWB(neighbors);
        eulerChar += LUT[n];
        n = this.indextOctantSEB(neighbors);
        eulerChar += LUT[n];
        n = this.indexOctantNWB(neighbors);
        eulerChar += LUT[n];
        n = this.indexOctantNEB(neighbors);
        return (eulerChar += LUT[n]) == 0;
    }

    public char indexOctantNEB(byte[] neighbors) {
        char n = '\u0001';
        if (neighbors[2] == 1) {
            n = (char)(n | 0x80);
        }
        if (neighbors[1] == 1) {
            n = (char)(n | 0x40);
        }
        if (neighbors[11] == 1) {
            n = (char)(n | 0x20);
        }
        if (neighbors[10] == 1) {
            n = (char)(n | 0x10);
        }
        if (neighbors[5] == 1) {
            n = (char)(n | 8);
        }
        if (neighbors[4] == 1) {
            n = (char)(n | 4);
        }
        if (neighbors[14] == 1) {
            n = (char)(n | 2);
        }
        return n;
    }

    public char indexOctantNWB(byte[] neighbors) {
        char n = '\u0001';
        if (neighbors[0] == 1) {
            n = (char)(n | 0x80);
        }
        if (neighbors[9] == 1) {
            n = (char)(n | 0x40);
        }
        if (neighbors[3] == 1) {
            n = (char)(n | 0x20);
        }
        if (neighbors[12] == 1) {
            n = (char)(n | 0x10);
        }
        if (neighbors[1] == 1) {
            n = (char)(n | 8);
        }
        if (neighbors[10] == 1) {
            n = (char)(n | 4);
        }
        if (neighbors[4] == 1) {
            n = (char)(n | 2);
        }
        return n;
    }

    public char indextOctantSEB(byte[] neighbors) {
        char n = '\u0001';
        if (neighbors[8] == 1) {
            n = (char)(n | 0x80);
        }
        if (neighbors[7] == 1) {
            n = (char)(n | 0x40);
        }
        if (neighbors[17] == 1) {
            n = (char)(n | 0x20);
        }
        if (neighbors[16] == 1) {
            n = (char)(n | 0x10);
        }
        if (neighbors[5] == 1) {
            n = (char)(n | 8);
        }
        if (neighbors[4] == 1) {
            n = (char)(n | 4);
        }
        if (neighbors[14] == 1) {
            n = (char)(n | 2);
        }
        return n;
    }

    public char indexOctantSWB(byte[] neighbors) {
        char n = '\u0001';
        if (neighbors[6] == 1) {
            n = (char)(n | 0x80);
        }
        if (neighbors[15] == 1) {
            n = (char)(n | 0x40);
        }
        if (neighbors[7] == 1) {
            n = (char)(n | 0x20);
        }
        if (neighbors[16] == 1) {
            n = (char)(n | 0x10);
        }
        if (neighbors[3] == 1) {
            n = (char)(n | 8);
        }
        if (neighbors[12] == 1) {
            n = (char)(n | 4);
        }
        if (neighbors[4] == 1) {
            n = (char)(n | 2);
        }
        return n;
    }

    public char indexOctantNEU(byte[] neighbors) {
        char n = '\u0001';
        if (neighbors[20] == 1) {
            n = (char)(n | 0x80);
        }
        if (neighbors[23] == 1) {
            n = (char)(n | 0x40);
        }
        if (neighbors[19] == 1) {
            n = (char)(n | 0x20);
        }
        if (neighbors[22] == 1) {
            n = (char)(n | 0x10);
        }
        if (neighbors[11] == 1) {
            n = (char)(n | 8);
        }
        if (neighbors[14] == 1) {
            n = (char)(n | 4);
        }
        if (neighbors[10] == 1) {
            n = (char)(n | 2);
        }
        return n;
    }

    public char indexOctantNWU(byte[] neighbors) {
        char n = '\u0001';
        if (neighbors[18] == 1) {
            n = (char)(n | 0x80);
        }
        if (neighbors[21] == 1) {
            n = (char)(n | 0x40);
        }
        if (neighbors[9] == 1) {
            n = (char)(n | 0x20);
        }
        if (neighbors[12] == 1) {
            n = (char)(n | 0x10);
        }
        if (neighbors[19] == 1) {
            n = (char)(n | 8);
        }
        if (neighbors[22] == 1) {
            n = (char)(n | 4);
        }
        if (neighbors[10] == 1) {
            n = (char)(n | 2);
        }
        return n;
    }

    public char indexOctantSEU(byte[] neighbors) {
        char n = '\u0001';
        if (neighbors[26] == 1) {
            n = (char)(n | 0x80);
        }
        if (neighbors[23] == 1) {
            n = (char)(n | 0x40);
        }
        if (neighbors[17] == 1) {
            n = (char)(n | 0x20);
        }
        if (neighbors[14] == 1) {
            n = (char)(n | 0x10);
        }
        if (neighbors[25] == 1) {
            n = (char)(n | 8);
        }
        if (neighbors[22] == 1) {
            n = (char)(n | 4);
        }
        if (neighbors[16] == 1) {
            n = (char)(n | 2);
        }
        return n;
    }

    public char indexOctantSWU(byte[] neighbors) {
        char n = '\u0001';
        if (neighbors[24] == 1) {
            n = (char)(n | 0x80);
        }
        if (neighbors[25] == 1) {
            n = (char)(n | 0x40);
        }
        if (neighbors[15] == 1) {
            n = (char)(n | 0x20);
        }
        if (neighbors[16] == 1) {
            n = (char)(n | 0x10);
        }
        if (neighbors[21] == 1) {
            n = (char)(n | 8);
        }
        if (neighbors[22] == 1) {
            n = (char)(n | 4);
        }
        if (neighbors[12] == 1) {
            n = (char)(n | 2);
        }
        return n;
    }

    private boolean isSimplePoint(byte[] neighbors) {
        int i;
        int[] cube = new int[26];
        for (i = 0; i < 13; ++i) {
            cube[i] = neighbors[i];
        }
        for (i = 14; i < 27; ++i) {
            cube[i - 1] = neighbors[i];
        }
        int label = 2;
        for (i = 0; i < 26; ++i) {
            if (cube[i] != 1) continue;
            switch (i) {
                case 0: 
                case 1: 
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 12: {
                    this.octreeLabeling(1, label, cube);
                    break;
                }
                case 2: 
                case 5: 
                case 11: 
                case 13: {
                    this.octreeLabeling(2, label, cube);
                    break;
                }
                case 6: 
                case 7: 
                case 14: 
                case 15: {
                    this.octreeLabeling(3, label, cube);
                    break;
                }
                case 8: 
                case 16: {
                    this.octreeLabeling(4, label, cube);
                    break;
                }
                case 17: 
                case 18: 
                case 20: 
                case 21: {
                    this.octreeLabeling(5, label, cube);
                    break;
                }
                case 19: 
                case 22: {
                    this.octreeLabeling(6, label, cube);
                    break;
                }
                case 23: 
                case 24: {
                    this.octreeLabeling(7, label, cube);
                    break;
                }
                case 25: {
                    this.octreeLabeling(8, label, cube);
                }
            }
            if (++label - 2 < 2) continue;
            return false;
        }
        return true;
    }

    private void octreeLabeling(int octant, int label, int[] cube) {
        if (octant == 1) {
            if (cube[0] == 1) {
                cube[0] = label;
            }
            if (cube[1] == 1) {
                cube[1] = label;
                this.octreeLabeling(2, label, cube);
            }
            if (cube[3] == 1) {
                cube[3] = label;
                this.octreeLabeling(3, label, cube);
            }
            if (cube[4] == 1) {
                cube[4] = label;
                this.octreeLabeling(2, label, cube);
                this.octreeLabeling(3, label, cube);
                this.octreeLabeling(4, label, cube);
            }
            if (cube[9] == 1) {
                cube[9] = label;
                this.octreeLabeling(5, label, cube);
            }
            if (cube[10] == 1) {
                cube[10] = label;
                this.octreeLabeling(2, label, cube);
                this.octreeLabeling(5, label, cube);
                this.octreeLabeling(6, label, cube);
            }
            if (cube[12] == 1) {
                cube[12] = label;
                this.octreeLabeling(3, label, cube);
                this.octreeLabeling(5, label, cube);
                this.octreeLabeling(7, label, cube);
            }
        }
        if (octant == 2) {
            if (cube[1] == 1) {
                cube[1] = label;
                this.octreeLabeling(1, label, cube);
            }
            if (cube[4] == 1) {
                cube[4] = label;
                this.octreeLabeling(1, label, cube);
                this.octreeLabeling(3, label, cube);
                this.octreeLabeling(4, label, cube);
            }
            if (cube[10] == 1) {
                cube[10] = label;
                this.octreeLabeling(1, label, cube);
                this.octreeLabeling(5, label, cube);
                this.octreeLabeling(6, label, cube);
            }
            if (cube[2] == 1) {
                cube[2] = label;
            }
            if (cube[5] == 1) {
                cube[5] = label;
                this.octreeLabeling(4, label, cube);
            }
            if (cube[11] == 1) {
                cube[11] = label;
                this.octreeLabeling(6, label, cube);
            }
            if (cube[13] == 1) {
                cube[13] = label;
                this.octreeLabeling(4, label, cube);
                this.octreeLabeling(6, label, cube);
                this.octreeLabeling(8, label, cube);
            }
        }
        if (octant == 3) {
            if (cube[3] == 1) {
                cube[3] = label;
                this.octreeLabeling(1, label, cube);
            }
            if (cube[4] == 1) {
                cube[4] = label;
                this.octreeLabeling(1, label, cube);
                this.octreeLabeling(2, label, cube);
                this.octreeLabeling(4, label, cube);
            }
            if (cube[12] == 1) {
                cube[12] = label;
                this.octreeLabeling(1, label, cube);
                this.octreeLabeling(5, label, cube);
                this.octreeLabeling(7, label, cube);
            }
            if (cube[6] == 1) {
                cube[6] = label;
            }
            if (cube[7] == 1) {
                cube[7] = label;
                this.octreeLabeling(4, label, cube);
            }
            if (cube[14] == 1) {
                cube[14] = label;
                this.octreeLabeling(7, label, cube);
            }
            if (cube[15] == 1) {
                cube[15] = label;
                this.octreeLabeling(4, label, cube);
                this.octreeLabeling(7, label, cube);
                this.octreeLabeling(8, label, cube);
            }
        }
        if (octant == 4) {
            if (cube[4] == 1) {
                cube[4] = label;
                this.octreeLabeling(1, label, cube);
                this.octreeLabeling(2, label, cube);
                this.octreeLabeling(3, label, cube);
            }
            if (cube[5] == 1) {
                cube[5] = label;
                this.octreeLabeling(2, label, cube);
            }
            if (cube[13] == 1) {
                cube[13] = label;
                this.octreeLabeling(2, label, cube);
                this.octreeLabeling(6, label, cube);
                this.octreeLabeling(8, label, cube);
            }
            if (cube[7] == 1) {
                cube[7] = label;
                this.octreeLabeling(3, label, cube);
            }
            if (cube[15] == 1) {
                cube[15] = label;
                this.octreeLabeling(3, label, cube);
                this.octreeLabeling(7, label, cube);
                this.octreeLabeling(8, label, cube);
            }
            if (cube[8] == 1) {
                cube[8] = label;
            }
            if (cube[16] == 1) {
                cube[16] = label;
                this.octreeLabeling(8, label, cube);
            }
        }
        if (octant == 5) {
            if (cube[9] == 1) {
                cube[9] = label;
                this.octreeLabeling(1, label, cube);
            }
            if (cube[10] == 1) {
                cube[10] = label;
                this.octreeLabeling(1, label, cube);
                this.octreeLabeling(2, label, cube);
                this.octreeLabeling(6, label, cube);
            }
            if (cube[12] == 1) {
                cube[12] = label;
                this.octreeLabeling(1, label, cube);
                this.octreeLabeling(3, label, cube);
                this.octreeLabeling(7, label, cube);
            }
            if (cube[17] == 1) {
                cube[17] = label;
            }
            if (cube[18] == 1) {
                cube[18] = label;
                this.octreeLabeling(6, label, cube);
            }
            if (cube[20] == 1) {
                cube[20] = label;
                this.octreeLabeling(7, label, cube);
            }
            if (cube[21] == 1) {
                cube[21] = label;
                this.octreeLabeling(6, label, cube);
                this.octreeLabeling(7, label, cube);
                this.octreeLabeling(8, label, cube);
            }
        }
        if (octant == 6) {
            if (cube[10] == 1) {
                cube[10] = label;
                this.octreeLabeling(1, label, cube);
                this.octreeLabeling(2, label, cube);
                this.octreeLabeling(5, label, cube);
            }
            if (cube[11] == 1) {
                cube[11] = label;
                this.octreeLabeling(2, label, cube);
            }
            if (cube[13] == 1) {
                cube[13] = label;
                this.octreeLabeling(2, label, cube);
                this.octreeLabeling(4, label, cube);
                this.octreeLabeling(8, label, cube);
            }
            if (cube[18] == 1) {
                cube[18] = label;
                this.octreeLabeling(5, label, cube);
            }
            if (cube[21] == 1) {
                cube[21] = label;
                this.octreeLabeling(5, label, cube);
                this.octreeLabeling(7, label, cube);
                this.octreeLabeling(8, label, cube);
            }
            if (cube[19] == 1) {
                cube[19] = label;
            }
            if (cube[22] == 1) {
                cube[22] = label;
                this.octreeLabeling(8, label, cube);
            }
        }
        if (octant == 7) {
            if (cube[12] == 1) {
                cube[12] = label;
                this.octreeLabeling(1, label, cube);
                this.octreeLabeling(3, label, cube);
                this.octreeLabeling(5, label, cube);
            }
            if (cube[14] == 1) {
                cube[14] = label;
                this.octreeLabeling(3, label, cube);
            }
            if (cube[15] == 1) {
                cube[15] = label;
                this.octreeLabeling(3, label, cube);
                this.octreeLabeling(4, label, cube);
                this.octreeLabeling(8, label, cube);
            }
            if (cube[20] == 1) {
                cube[20] = label;
                this.octreeLabeling(5, label, cube);
            }
            if (cube[21] == 1) {
                cube[21] = label;
                this.octreeLabeling(5, label, cube);
                this.octreeLabeling(6, label, cube);
                this.octreeLabeling(8, label, cube);
            }
            if (cube[23] == 1) {
                cube[23] = label;
            }
            if (cube[24] == 1) {
                cube[24] = label;
                this.octreeLabeling(8, label, cube);
            }
        }
        if (octant == 8) {
            if (cube[13] == 1) {
                cube[13] = label;
                this.octreeLabeling(2, label, cube);
                this.octreeLabeling(4, label, cube);
                this.octreeLabeling(6, label, cube);
            }
            if (cube[15] == 1) {
                cube[15] = label;
                this.octreeLabeling(3, label, cube);
                this.octreeLabeling(4, label, cube);
                this.octreeLabeling(7, label, cube);
            }
            if (cube[16] == 1) {
                cube[16] = label;
                this.octreeLabeling(4, label, cube);
            }
            if (cube[21] == 1) {
                cube[21] = label;
                this.octreeLabeling(5, label, cube);
                this.octreeLabeling(6, label, cube);
                this.octreeLabeling(7, label, cube);
            }
            if (cube[22] == 1) {
                cube[22] = label;
                this.octreeLabeling(6, label, cube);
            }
            if (cube[24] == 1) {
                cube[24] = label;
                this.octreeLabeling(7, label, cube);
            }
            if (cube[25] == 1) {
                cube[25] = label;
            }
        }
    }

    void showAbout() {
        IJ.showMessage((String)"About Skeletonize3D...", (String)"This plug-in filter produces 3D thinning (skeletonization) of binary 3D images.\n");
    }

    public int getThinningIterations() {
        return this.iterations;
    }
}

