/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.java;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.scijava.command.CommandService;
import org.scijava.minimaven.BuildEnvironment;
import org.scijava.minimaven.Coordinate;
import org.scijava.minimaven.MavenProject;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginService;
import org.scijava.plugins.scripting.java.JavaEngineBindings;
import org.scijava.run.RunService;
import org.scijava.script.AbstractScriptEngine;
import org.scijava.util.FileUtils;
import org.scijava.util.LineOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class JavaEngine
extends AbstractScriptEngine {
    private static final String DEFAULT_GROUP_ID = "org.scijava.scripting.java";
    private static final String DEFAULT_VERSION = "1.0.0-SNAPSHOT";
    private static final String XALAN_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    @Parameter
    private PluginService pluginService;
    @Parameter
    private CommandService commandService;
    @Parameter
    private RunService runService;

    public JavaEngine() {
        this.engineScopeBindings = new JavaEngineBindings();
    }

    public Object eval(String script) throws ScriptException {
        Writer writer = this.getContext().getErrorWriter();
        try {
            Class<?> clazz = this.compile(script);
            this.runService.run(clazz, new Object[0]);
        }
        catch (Exception e) {
            if (writer != null) {
                PrintWriter err = new PrintWriter(writer);
                e.printStackTrace(err);
                err.flush();
            }
            if (e instanceof ScriptException) {
                throw (ScriptException)e;
            }
            throw new ScriptException(e);
        }
        return null;
    }

    public Object eval(Reader reader) throws ScriptException {
        String script;
        try {
            script = JavaEngine.getReaderContentsAsString(reader);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        return this.eval(script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> compile(String script) throws ScriptException {
        block11: {
            String path = (String)this.get("javax.script.filename");
            File file = path == null ? null : new File(path);
            Writer writer = this.getContext().getErrorWriter();
            Builder builder = new Builder();
            try {
                if (file != null && file.exists()) {
                    builder.initialize(file, writer);
                } else {
                    StringReader reader = script == null ? null : new StringReader(script);
                    builder.initialize(reader, writer);
                }
                MavenProject project = builder.project;
                String mainClass = builder.mainClass;
                project.build(true);
                if (mainClass == null && (mainClass = project.getMainClass()) == null) {
                    throw new ScriptException("No main class found for file " + file);
                }
                String[] paths = project.getClassPath(false).split(File.pathSeparator);
                URL[] urls = new URL[paths.length];
                for (int i = 0; i < urls.length; ++i) {
                    urls[i] = new URL("file:" + paths[i] + (paths[i].endsWith(".jar") ? "" : "/"));
                }
                URLClassLoader classLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
                Class<?> clazz = classLoader.loadClass(mainClass);
                return clazz;
            }
            catch (Exception e) {
                if (writer != null) {
                    PrintWriter err = new PrintWriter(writer);
                    e.printStackTrace(err);
                    err.flush();
                    break block11;
                }
                if (e instanceof ScriptException) {
                    throw (ScriptException)e;
                }
                throw new ScriptException(e);
            }
            finally {
                builder.cleanup();
            }
        }
        return null;
    }

    public Class<?> compile(Reader reader) throws ScriptException {
        String script;
        try {
            script = JavaEngine.getReaderContentsAsString(reader);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        return this.compile(script);
    }

    public void compile(File file) {
        this.compile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(File file, Writer errorWriter) {
        Writer writer = errorWriter == null ? this.getContext().getErrorWriter() : errorWriter;
        Builder builder = new Builder();
        try {
            builder.initialize(file, writer);
            builder.project.build();
        }
        catch (Throwable t) {
            this.printOrThrow(t, errorWriter);
        }
        finally {
            builder.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeJar(File file, boolean includeSources, File output, Writer errorWriter) {
        Builder builder = new Builder();
        try {
            builder.initialize(file, errorWriter);
            builder.project.build(true, true, includeSources);
            File target = builder.project.getTarget();
            if (output != null && !target.equals(output)) {
                BuildEnvironment.copyFile((File)target, (File)output);
            }
        }
        catch (Throwable t) {
            this.printOrThrow(t, errorWriter);
        }
        finally {
            builder.cleanup();
        }
    }

    private void printOrThrow(Throwable t, Writer errorWriter) {
        RuntimeException e;
        RuntimeException runtimeException = e = t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
        if (errorWriter == null) {
            throw e;
        }
        PrintWriter err = new PrintWriter(errorWriter);
        e.printStackTrace(err);
        err.flush();
    }

    private MavenProject getMavenProject(BuildEnvironment env, File file, String mainClass) throws IOException, ParserConfigurationException, SAXException, ScriptException, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        File pom;
        String path = file.getAbsolutePath();
        if (!path.replace(File.separatorChar, '.').endsWith("." + mainClass + ".java")) {
            throw new ScriptException("Class " + mainClass + " in invalid directory: " + path);
        }
        if ((path = path.substring(0, path.length() - mainClass.length() - 5)).replace(File.separatorChar, '/').endsWith("/src/main/java/") && (pom = new File(path = path.substring(0, path.length() - "src/main/java/".length()), "pom.xml")).exists()) {
            return env.parse(pom, null);
        }
        return JavaEngine.writeTemporaryProject(env, new FileReader(file));
    }

    private static String getFullClassName(File file) throws IOException {
        String line;
        String name = file.getName();
        if (!name.endsWith(".java")) {
            throw new UnsupportedOperationException();
        }
        name = name.substring(0, name.length() - 5);
        String packageName = "";
        Pattern packagePattern = Pattern.compile("package ([a-zA-Z0-9_.]*).*");
        Pattern classPattern = Pattern.compile(".*public class ([a-zA-Z0-9_]*).*");
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            Matcher classMatcher;
            line = line.trim();
            block1: while (line.startsWith("/*")) {
                int end = line.indexOf("*/", 2);
                while (end < 0) {
                    line = reader.readLine();
                    if (line == null) break block1;
                    end = line.indexOf("*/");
                }
                line = line.substring(end + 2).trim();
            }
            if (line == null || line.equals("") || line.startsWith("//")) continue;
            Matcher packageMatcher = packagePattern.matcher(line);
            if (packageMatcher.matches()) {
                packageName = packageMatcher.group(1) + ".";
            }
            if (!(classMatcher = classPattern.matcher(line)).matches()) continue;
            name = classMatcher.group(1);
            break;
        }
        reader.close();
        return packageName + name;
    }

    private static MavenProject writeTemporaryProject(BuildEnvironment env, Reader reader) throws IOException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        String line;
        File directory = FileUtils.createTemporaryDirectory((String)"java", (String)"");
        File file = new File(directory, ".java");
        BufferedReader in = new BufferedReader(reader);
        FileWriter out = new FileWriter(file);
        while ((line = in.readLine()) != null) {
            out.write(line);
            ((Writer)out).write(10);
        }
        in.close();
        ((Writer)out).close();
        String mainClass = JavaEngine.getFullClassName(file);
        File result = new File(directory, "src/main/java/" + mainClass.replace('.', '/') + ".java");
        if (!result.getParentFile().mkdirs()) {
            throw new IOException("Could not make directory for " + result);
        }
        if (!file.renameTo(result)) {
            throw new IOException("Could not move " + file + " into the correct location");
        }
        String artifactId = mainClass.substring(mainClass.lastIndexOf(46) + 1);
        return JavaEngine.fakePOM(env, directory, artifactId, mainClass, true);
    }

    private static String fakeArtifactId(BuildEnvironment env, String name) {
        String prefix;
        int dot = name.indexOf(46);
        String string = dot < 0 ? name : (prefix = dot == 0 ? "dependency" : name.substring(0, dot));
        if (!env.containsProject(DEFAULT_GROUP_ID, prefix)) {
            return prefix;
        }
        int i = 1;
        String artifactId;
        while (env.containsProject(DEFAULT_GROUP_ID, artifactId = prefix + "-" + i)) {
            ++i;
        }
        return artifactId;
    }

    private static MavenProject fakePOM(BuildEnvironment env, File directory, String artifactId, String mainClass, boolean writePOM) throws IOException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        File projectRootDirectory;
        File pomFile;
        Document pom = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element project = pom.createElement("project");
        pom.appendChild(project);
        project.setAttribute("xmlns", "http://maven.apache.org/POM/4.0.0");
        project.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        project.setAttribute("xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd");
        JavaEngine.append(pom, project, "groupId", DEFAULT_GROUP_ID);
        JavaEngine.append(pom, project, "artifactId", artifactId);
        JavaEngine.append(pom, project, "version", DEFAULT_VERSION);
        Element build = JavaEngine.append(pom, project, "build", null);
        if (mainClass != null) {
            Element plugins = JavaEngine.append(pom, build, "plugins", null);
            Element plugin = JavaEngine.append(pom, plugins, "plugin", null);
            JavaEngine.append(pom, plugin, "artifactId", "maven-jar-plugin");
            Element configuration = JavaEngine.append(pom, plugin, "configuration", null);
            Element archive = JavaEngine.append(pom, configuration, "archive", null);
            Element manifest = JavaEngine.append(pom, archive, "manifest", null);
            JavaEngine.append(pom, manifest, "mainClass", mainClass);
        }
        Element dependencies = JavaEngine.append(pom, project, "dependencies", null);
        for (Coordinate dependency : JavaEngine.getAllDependencies(env)) {
            Element dep = JavaEngine.append(pom, dependencies, "dependency", null);
            JavaEngine.append(pom, dep, "groupId", dependency.getGroupId());
            JavaEngine.append(pom, dep, "artifactId", dependency.getArtifactId());
            JavaEngine.append(pom, dep, "version", dependency.getVersion());
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty(XALAN_INDENT_AMOUNT, "4");
        if (directory.getPath().replace(File.separatorChar, '/').endsWith("/src/main/java") && !(pomFile = new File(projectRootDirectory = directory.getParentFile().getParentFile().getParentFile(), "pom.xml")).exists()) {
            FileWriter writer = new FileWriter(pomFile);
            transformer.transform(new DOMSource(pom), new StreamResult(writer));
            return env.parse(pomFile);
        }
        if (writePOM) {
            transformer.transform(new DOMSource(pom), new StreamResult(new File(directory, "pom.xml")));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(pom), new StreamResult(out));
        return env.parse((InputStream)new ByteArrayInputStream(out.toByteArray()), directory, null, null);
    }

    private static Element append(Document document, Element parent, String tag, String content) {
        Element child = document.createElement(tag);
        if (content != null) {
            child.appendChild(document.createCDATASection(content));
        }
        parent.appendChild(child);
        return child;
    }

    private static List<Coordinate> getAllDependencies(BuildEnvironment env) {
        ArrayList<Coordinate> result = new ArrayList<Coordinate>();
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                if (!url.getProtocol().equals("file")) continue;
                File file = new File(url.getPath());
                if (url.toString().matches(".*/target/surefire/surefirebooter[0-9]*\\.jar")) {
                    JavaEngine.getSurefireBooterURLs(file, url, env, result);
                    continue;
                }
                result.add(JavaEngine.fakeDependency(env, file));
            }
        }
        return result;
    }

    private static Coordinate fakeDependency(BuildEnvironment env, File file) {
        String artifactId = JavaEngine.fakeArtifactId(env, file.getName());
        Coordinate dependency = new Coordinate(DEFAULT_GROUP_ID, artifactId, "1.0.0");
        env.fakePOM(file, dependency);
        return dependency;
    }

    private static void getSurefireBooterURLs(File file, URL baseURL, BuildEnvironment env, List<Coordinate> result) {
        try {
            String classPath;
            JarFile jar = new JarFile(file);
            Manifest manifest = jar.getManifest();
            if (manifest != null && (classPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) != null) {
                for (String element : classPath.split(" +")) {
                    try {
                        File dependency = new File(new URL(baseURL, element).getPath());
                        result.add(JavaEngine.fakeDependency(env, dependency));
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getReaderContentsAsString(Reader reader) throws IOException {
        int read;
        if (reader == null) {
            return null;
        }
        char[] buffer = new char[1024];
        StringBuilder builder = new StringBuilder();
        while ((read = reader.read(buffer)) != -1) {
            builder.append(buffer, 0, read);
        }
        return builder.toString();
    }

    private class Builder {
        private PrintStream err;
        private File temporaryDirectory;
        private String mainClass;
        private MavenProject project;

        private Builder() {
        }

        private void initialize(File file, Writer errorWriter) throws ScriptException, IOException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
            this.err = this.createErrorPrintStream(errorWriter);
            BuildEnvironment env = this.createBuildEnvironment();
            this.temporaryDirectory = null;
            if (file.getName().equals("pom.xml")) {
                this.project = env.parse(file, null);
            } else {
                this.mainClass = JavaEngine.getFullClassName(file);
                this.project = JavaEngine.this.getMavenProject(env, file, this.mainClass);
            }
        }

        private void initialize(Reader reader, Writer errorWriter) throws ScriptException, IOException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
            this.err = this.createErrorPrintStream(errorWriter);
            BuildEnvironment env = this.createBuildEnvironment();
            try {
                this.project = JavaEngine.writeTemporaryProject(env, reader);
                this.temporaryDirectory = this.project.getDirectory();
                this.mainClass = this.project.getMainClass();
            }
            catch (Exception e) {
                throw new ScriptException(e);
            }
        }

        private PrintStream createErrorPrintStream(final Writer errorWriter) {
            if (errorWriter == null) {
                return null;
            }
            return new PrintStream((OutputStream)new LineOutputStream(){

                public void println(String line) throws IOException {
                    errorWriter.append(line).append('\n');
                }
            });
        }

        private BuildEnvironment createBuildEnvironment() {
            boolean verbose = "true".equals(JavaEngine.this.get("verbose")) || JavaEngine.this.log().isInfo();
            boolean debug = "true".equals(JavaEngine.this.get("debug")) || JavaEngine.this.log().isDebug();
            return new BuildEnvironment(this.err, true, verbose, debug);
        }

        private void cleanup() {
            if (this.err != null) {
                this.err.close();
            }
            if (this.err != null) {
                this.err.close();
            }
            if (this.temporaryDirectory != null && !FileUtils.deleteRecursively((File)this.temporaryDirectory)) {
                this.temporaryDirectory.deleteOnExit();
            }
        }
    }
}

