/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.zip.GZIPInputStream;

public class TorstenRaw_GZ_Reader
extends ImagePlus
implements PlugIn {
    public String imageName = null;
    protected File headerFile = null;
    protected File dataFile = null;

    public void run(String arg) {
        String directory = "";
        String name = arg;
        if (arg == null || arg == "") {
            OpenDialog od = new OpenDialog("Load TorstenRaw File...", arg);
            name = od.getFileName();
            if (name == null) {
                return;
            }
            directory = od.getDirectory();
        } else {
            File dest = new File(arg);
            directory = dest.getParent();
            name = dest.getName();
        }
        ImagePlus imp = this.load(directory, name);
        if (imp == null) {
            return;
        }
        if (this.imageName != null) {
            this.setStack(this.imageName, imp.getStack());
        } else {
            this.setStack(name, imp.getStack());
        }
        this.copyScale(imp);
        if (arg.equals("")) {
            this.show();
        }
    }

    public ImagePlus load(String directory, String name) {
        FileInfo fi = new FileInfo();
        try {
            fi = this.getHeaderInfo(directory, name);
        }
        catch (IOException e) {
            IJ.write((String)("FileLoader: " + e.getMessage()));
            return null;
        }
        if (!directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        IJ.showStatus((String)("Loading Torsten Raw File: " + directory + name));
        FileOpener fo = name.toLowerCase().endsWith(".gz") && IJ.getVersion().compareTo("1.38s") < 0 ? new GZIPFileOpener(fi) : new FileOpener(fi);
        ImagePlus imp = fo.open(false);
        if (imp == null) {
            return null;
        }
        Calibration cal = imp.getCalibration();
        Calibration spatialCal = this.getCalibration();
        cal.pixelWidth = spatialCal.pixelWidth;
        cal.pixelHeight = spatialCal.pixelHeight;
        cal.pixelDepth = spatialCal.pixelDepth;
        cal.setUnit(spatialCal.getUnit());
        imp.setCalibration(cal);
        return imp;
    }

    File getHeaderFile(String directory, String name) throws IOException {
        if (name == null || name == "") {
            return null;
        }
        if (name.endsWith(".bin") || name.endsWith(".bin.gz")) {
            File imageFile = new File(directory, name);
            File imageDir = new File(imageFile.getParent());
            File commonDir = new File(imageDir.getParent());
            this.imageName = imageDir.getName();
            File headerFile = null;
            String[] list = commonDir.list();
            if (list == null) {
                return null;
            }
            for (int i = 0; i < list.length; ++i) {
                File f = new File(commonDir.getPath(), list[i]);
                if (!f.isDirectory() || !f.getName().equals(imageDir.getName() + ".study")) continue;
                headerFile = new File(f.getPath(), "images");
                if (headerFile.exists()) {
                    return headerFile;
                }
                throw new IOException("No header file for image");
            }
        }
        return null;
    }

    public FileInfo getHeaderInfo(String dir, String fileName) throws IOException {
        String thisLine;
        if (this.dataFile == null) {
            this.dataFile = new File(dir, fileName);
        }
        if (!this.dataFile.exists()) {
            IJ.write((String)("FileLoader: unable to find data file: " + this.dataFile));
            return null;
        }
        if (this.headerFile == null) {
            this.headerFile = this.getHeaderFile(dir, fileName);
        }
        BufferedReader input = new BufferedReader(new FileReader(this.headerFile));
        FileInfo fi = new FileInfo();
        fi.fileName = this.dataFile.getName();
        fi.directory = this.dataFile.getParent();
        fi.fileFormat = 1;
        Calibration spatialCal = this.getCalibration();
        boolean signed = false;
        int bytesPerPixel = 1;
        fi.fileType = 0;
        while ((thisLine = input.readLine()) != null) {
            String noteType = this.getField(thisLine, 1);
            String noteValue = this.getField(thisLine, 2);
            if (IJ.debugMode) {
                IJ.log((String)("NoteType:" + noteType + ", noteValue:" + noteValue));
            }
            if (noteType.equals("width")) {
                fi.width = Integer.valueOf(noteValue);
            }
            if (noteType.equals("height")) {
                fi.height = Integer.valueOf(noteValue);
            }
            if (noteType.equals("depth")) {
                fi.nImages = Integer.valueOf(noteValue);
            }
            if (noteType.equals("bytesperpixel")) {
                bytesPerPixel = Integer.valueOf(noteValue);
            }
            if (noteType.equals("signed")) {
                signed = noteValue.equals("yes");
            }
            if (noteType.equals("calibrationx") && Double.valueOf(noteValue) > 0.0) {
                spatialCal.pixelWidth = Double.valueOf(noteValue);
            }
            if (noteType.equals("calibrationy") && Double.valueOf(noteValue) > 0.0) {
                spatialCal.pixelHeight = Double.valueOf(noteValue);
            }
            if (noteType.equals("slicedistance")) {
                spatialCal.pixelDepth = Double.valueOf(noteValue);
            }
            if (noteType.equals("offset")) {
                fi.offset = Integer.valueOf(noteValue);
            }
            if (noteType.equals("littleendian")) {
                fi.intelByteOrder = noteValue.equals("yes");
            }
            if (!noteType.equals("width")) continue;
            fi.width = Integer.valueOf(noteValue);
        }
        switch (bytesPerPixel) {
            case 1: {
                if (!signed) {
                    fi.fileType = 0;
                    break;
                }
                throw new IOException("Unimplemented ImageData signed 8 bit");
            }
            case 2: {
                if (signed) {
                    fi.fileType = 1;
                    break;
                }
                fi.fileType = 2;
                break;
            }
            case 4: {
                fi.fileType = 4;
                IJ.log((String)"Assuming data is float");
                break;
            }
            default: {
                throw new IOException("Unimplemented ImageData bytes/pixel=" + bytesPerPixel + ", signed =" + signed + "");
            }
        }
        spatialCal.setUnit("micron");
        this.setCalibration(spatialCal);
        return fi;
    }

    String getField(String str, int fieldIndex) {
        String[] fields = (str = str.trim()).split("\\s+");
        if (fieldIndex > fields.length) {
            return "";
        }
        return fields[fieldIndex - 1];
    }

    class GZIPFileOpener
    extends FileOpener {
        public GZIPFileOpener(FileInfo fi) {
            super(fi);
        }

        public InputStream createInputStream(FileInfo fi) throws IOException, MalformedURLException {
            InputStream is = super.createInputStream(fi);
            if (is != null) {
                return new GZIPInputStream(is);
            }
            return is;
        }
    }
}

