/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class Open_DAT_EMMENU
extends ImagePlus
implements PlugIn {
    public void run(String arg) {
        String path = arg;
        String directory = null;
        String filename = null;
        if (null == path || 0 == path.length()) {
            OpenDialog od = new OpenDialog("Choose .dat file", null);
            directory = od.getDirectory();
            if (null == directory) {
                return;
            }
            filename = od.getFileName();
            if (!filename.toLowerCase().endsWith(".dat")) {
                IJ.error((String)"Not a .dat file.");
                return;
            }
            path = directory + "/" + filename;
        } else {
            File file = new File(path);
            directory = file.getParent();
            filename = file.getName();
            if (directory.startsWith("http:/")) {
                directory = "http://" + directory.substring(6);
            }
        }
        if (!filename.toLowerCase().endsWith(".dat")) {
            this.height = -1;
            this.width = -1;
            return;
        }
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        byte[] buf = new byte[136];
        try {
            InputStream is = 0 == path.indexOf("http://") ? new URL(path).openStream() : new FileInputStream(path);
            is.read(buf, 0, 136);
            is.close();
        }
        catch (IOException e) {
            this.height = -1;
            this.width = -1;
            return;
        }
        byte datatype = buf[3];
        int width = (buf[4] << 24) + (buf[5] << 16) + (buf[6] << 8) + buf[7];
        int height = (buf[8] << 24) + (buf[9] << 16) + (buf[10] << 8) + buf[11];
        int n_images = (buf[12] << 24) + (buf[13] << 16) + (buf[14] << 8) + buf[15];
        byte[] b_msg = new byte[80];
        System.arraycopy(buf, 16, b_msg, 0, 80);
        String comment = new String(b_msg);
        int high_tension = (buf[96] << 24) + (buf[97] << 16) + (buf[98] << 8) + buf[99];
        int spherical_aberration = (buf[100] << 24) + (buf[101] << 16) + (buf[102] << 8) + buf[103];
        int illum_aperture = (buf[104] << 24) + (buf[105] << 16) + (buf[106] << 8) + buf[107];
        int magnification = (buf[108] << 24) + (buf[109] << 16) + (buf[110] << 8) + buf[111];
        int post_magnification = (buf[112] << 24) + (buf[113] << 16) + (buf[114] << 8) + buf[115];
        int ccd_exposure = (buf[116] << 24) + (buf[117] << 16) + (buf[118] << 8) + buf[119];
        int ccd_pixels = (buf[120] << 24) + (buf[121] << 16) + (buf[122] << 8) + buf[123];
        int ccd_pixel_size = (buf[124] << 24) + (buf[125] << 16) + (buf[126] << 8) + buf[127];
        int image_length = (buf[128] << 24) + (buf[129] << 16) + (buf[130] << 8) + buf[131];
        int defocus = (buf[132] << 24) + (buf[133] << 16) + (buf[134] << 8) + buf[135];
        StringBuffer sb_info = new StringBuffer("Tecnai EMMENU .dat file info:");
        sb_info.append("\ndirectory=").append(directory).append("\nname=").append(filename).append("\ndatatype=").append(datatype).append("\nwidth=").append(width).append("\nheight=").append(height).append("\nn_images=").append(n_images).append("\ncomment=").append(comment).append("\nhigh_tension=").append(high_tension).append("\nspherical_aberration=").append(spherical_aberration).append("\nillum_aperture=").append(illum_aperture).append("\nmagnification=").append(magnification).append("\npost_magnification=").append(post_magnification).append("\nccd_exposure=").append(ccd_exposure).append("\nccd_pixels=").append(ccd_pixels).append("\nccd_pixel_size=").append(ccd_pixel_size).append("\nimage_length=").append(image_length).append("\ndefocus=").append(defocus);
        ImagePlus imp = Open_DAT_EMMENU.openRaw(this.getType(datatype), directory, filename, width, height, 512L, n_images, 0, false, false);
        String info = (String)imp.getProperty("Info");
        info = null == info ? sb_info.toString() : info + "\n" + sb_info.toString();
        ImageStack stack = imp.getStack();
        this.setStack(imp.getTitle(), stack);
        this.setCalibration(imp.getCalibration());
        this.setProperty("Info", sb_info.toString());
        this.setFileInfo(imp.getOriginalFileInfo());
        if (null == arg || 0 == arg.length()) {
            this.show();
        }
    }

    private int getType(int datatype) {
        switch (datatype) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 8: {
                return 16;
            }
        }
        return -1;
    }

    public static ImagePlus openRaw(int imageType, String directory, String fileName, int width, int height, long offset, int nImages, int gapBetweenImages, boolean intelByteOrder, boolean whiteIsZero) {
        FileInfo fi = new FileInfo();
        fi.fileType = imageType;
        fi.fileFormat = 1;
        fi.fileName = fileName;
        if (0 == directory.indexOf("http://")) {
            fi.url = directory;
        } else {
            fi.directory = directory;
        }
        fi.width = width;
        fi.height = height;
        if (offset > Integer.MAX_VALUE) {
            fi.longOffset = offset;
        } else {
            fi.offset = (int)offset;
        }
        fi.nImages = nImages;
        fi.gapBetweenImages = gapBetweenImages;
        fi.intelByteOrder = intelByteOrder;
        fi.whiteIsZero = whiteIsZero;
        FileOpener fo = new FileOpener(fi);
        try {
            return fo.open(false);
        }
        catch (Exception e) {
            return null;
        }
    }
}

