/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class FIBSEM_Reader
implements PlugIn {
    public static boolean openAsFloat = false;
    public static boolean openAsRaw = false;
    FIBSEMData header;

    public FIBSEMData getHeader() {
        return this.header;
    }

    public void run(String filename) {
        OpenDialog od;
        File f = new File(filename);
        if (!f.exists() && !(f = new File((od = new OpenDialog("Open FIB-SEM raw file", null)).getDirectory() + od.getFileName())).exists()) {
            IJ.log((String)("Cannot find file '" + f.getAbsolutePath() + "'"));
            return;
        }
        try {
            FileInputStream file = new FileInputStream(f);
            FIBSEMData header = this.parseHeader(file);
            if (header == null) {
                IJ.log((String)("The file '" + f.getAbsolutePath() + "' is not a FIB-SEM raw file, the magic number does not match."));
                return;
            }
            file.close();
            file = new FileInputStream(f);
            ImagePlus imp = this.readFIBSEM(header, file, openAsFloat);
            file.close();
            if (imp == null) {
                return;
            }
            this.header = header;
            imp.setTitle(f.getName());
            Calibration cal = imp.getCalibration();
            cal.setXUnit("nm");
            cal.setYUnit("nm");
            cal.pixelWidth = header.pixelSize;
            cal.pixelHeight = header.pixelSize;
            imp.show();
        }
        catch (FileNotFoundException e) {
            IJ.log((String)("Error opening the file '" + f.getAbsolutePath() + "': " + e));
            return;
        }
        catch (IOException e) {
            IJ.log((String)("Error parsing the file '" + f.getAbsolutePath() + "': " + e));
            return;
        }
    }

    public static boolean isFIBSEM(File f) {
        try {
            FileInputStream file = new FileInputStream(f);
            DataInputStream s = new DataInputStream(file);
            long magicNumber = FIBSEM_Reader.getUnsignedInt(s.readInt());
            s.close();
            return magicNumber == 3555587570L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ImagePlus readFIBSEM(FIBSEMData header, FileInputStream file, boolean openAsFloat) throws IOException {
        ImagePlus imp;
        file.skip(1024L);
        double[] minmax = new double[]{Double.MAX_VALUE, Double.MIN_VALUE};
        ImageProcessor[] channels = this.readChannels(header, file, minmax, openAsFloat);
        if (header.numChannels == 1) {
            imp = new ImagePlus("", channels[0]);
        } else {
            ImageStack stack = new ImageStack((int)header.xRes, (int)header.yRes);
            for (int c = 0; c < header.numChannels; ++c) {
                stack.addSlice("channel " + c, channels[c]);
            }
            imp = new ImagePlus("", stack);
            imp.setDimensions(1, header.numChannels, 1);
            imp = new CompositeImage(imp, 3);
        }
        imp.setDisplayRange(minmax[0], minmax[1]);
        return imp;
    }

    final ImageProcessor[] readChannels(FIBSEMData header, FileInputStream file, double[] minmax, boolean openAsFloat) throws IOException {
        int numChannels = header.numChannels;
        byte[] slice = new byte[(int)header.xRes * (int)header.yRes * numChannels * 2];
        file.read(slice);
        ByteBuffer buffer = ByteBuffer.wrap(slice);
        ShortBuffer shortBuffer = buffer.asShortBuffer();
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        ImageProcessor[] channels = new ImageProcessor[numChannels];
        if (openAsFloat) {
            float[][] floatSlice = new float[numChannels][(int)header.xRes * (int)header.yRes];
            for (int i = 0; i < floatSlice[0].length; ++i) {
                for (int c = 0; c < numChannels; ++c) {
                    int j = i * numChannels + c;
                    short v = shortBuffer.get(j);
                    float v2 = this.scale(header, v, c);
                    if ((double)v2 < min) {
                        min = v2;
                    }
                    if ((double)v2 > max) {
                        max = v2;
                    }
                    floatSlice[c][i] = v2;
                }
            }
            for (int c = 0; c < numChannels; ++c) {
                channels[c] = new FloatProcessor((int)header.xRes, (int)header.yRes, floatSlice[c], null);
            }
        } else {
            int i;
            short[][] shortSlice = new short[numChannels][(int)header.xRes * (int)header.yRes];
            float minVolts = -10.0f;
            float rangeVolts = 20.0f;
            int[] cropped = new int[numChannels];
            for (i = 0; i < shortSlice[0].length; ++i) {
                for (int c = 0; c < numChannels; ++c) {
                    int j = i * numChannels + c;
                    short v = shortBuffer.get(j);
                    if (openAsRaw) {
                        v = (short)(v + 32768);
                    } else {
                        int iv;
                        float fv = this.scale(header, v, c);
                        if (header.fileVersion <= 6) {
                            fv = (fv - -10.0f) / 20.0f * 65535.0f;
                        }
                        if ((iv = Math.round(fv)) < 0) {
                            iv = 0;
                            int n = c;
                            cropped[n] = cropped[n] + 1;
                        }
                        if (iv > 65535) {
                            iv = 65535;
                            int n = c;
                            cropped[n] = cropped[n] + 1;
                        }
                        v = (short)iv;
                    }
                    if ((double)v < min) {
                        min = v;
                    }
                    if ((double)v > max) {
                        max = v;
                    }
                    shortSlice[c][i] = v;
                }
            }
            for (i = 0; i < numChannels; ++i) {
                if (cropped[i] <= 0) continue;
                IJ.log((String)("Warning (channel " + (i + 1) + "/" + numChannels + "): " + cropped[i] + " values have been truncated as they were out of range of 16 bit. To verify this, please open the image as float (see http://fiji.sc/wiki/index.php/FIBSEM_importer#Open_image_as_float)"));
            }
            for (int c = 0; c < numChannels; ++c) {
                channels[c] = new ShortProcessor((int)header.xRes, (int)header.yRes, shortSlice[c], null);
            }
        }
        minmax[0] = min;
        minmax[1] = max;
        return channels;
    }

    final float scale(FIBSEMData header, short value, int channel) {
        if (header.fileVersion <= 6) {
            return header.offset[channel] + (float)value * header.gain[channel];
        }
        return ((float)value - header.gain[channel]) * header.secondOrder[channel];
    }

    public FIBSEMData parseHeader(FileInputStream file) throws IOException {
        DataInputStream s = new DataInputStream(file);
        FIBSEMData data = new FIBSEMData();
        data.magicNumber = FIBSEM_Reader.getUnsignedInt(s.readInt());
        if (data.magicNumber != 3555587570L) {
            return null;
        }
        data.fileVersion = FIBSEM_Reader.getUnsignedShort(s.readShort());
        data.fileType = FIBSEM_Reader.getUnsignedShort(s.readShort());
        byte[] tmp = new byte[10];
        s.read(tmp);
        data.swDate = new String(tmp);
        s.skip(6L);
        data.timeStep = s.readDouble();
        data.numChannels = FIBSEM_Reader.getUnsignedByte(s.readByte());
        data.offset = new float[data.numChannels];
        data.gain = new float[data.numChannels];
        data.secondOrder = new float[data.numChannels];
        data.thirdOrder = new float[data.numChannels];
        data.eightBit = FIBSEM_Reader.getUnsignedByte(s.readByte());
        s.skip(2L);
        if (data.fileVersion == 1) {
            for (int c = 0; c < data.numChannels; ++c) {
                data.offset[c] = (float)s.readDouble();
                data.gain[c] = (float)s.readDouble();
                data.secondOrder[c] = (float)s.readDouble();
                data.thirdOrder[c] = (float)s.readDouble();
            }
            s.skip(64 - data.numChannels * 8 * 4);
        } else if (data.fileVersion >= 2 && data.fileVersion <= 6) {
            for (int c = 0; c < data.numChannels; ++c) {
                data.offset[c] = s.readFloat();
                data.gain[c] = s.readFloat();
                data.secondOrder[c] = s.readFloat();
                data.thirdOrder[c] = s.readFloat();
            }
            s.skip(64 - data.numChannels * 4 * 4);
        } else {
            for (int c = 0; c < 2; ++c) {
                data.offset[c] = s.readFloat();
                data.gain[c] = s.readFloat();
                data.secondOrder[c] = s.readFloat();
                data.thirdOrder[c] = s.readFloat();
            }
            s.skip(32L);
        }
        data.xRes = FIBSEM_Reader.getUnsignedInt(s.readInt());
        data.yRes = FIBSEM_Reader.getUnsignedInt(s.readInt());
        if (data.fileVersion == 1 || data.fileVersion == 2 || data.fileVersion == 3) {
            data.oversampling = FIBSEM_Reader.getUnsignedByte(s.readByte());
            data.AIdelay = s.readShort();
        } else {
            data.oversampling = FIBSEM_Reader.getUnsignedShort(s.readShort());
            s.skip(1L);
        }
        data.zeissScanSpeed = FIBSEM_Reader.getUnsignedByte(s.readByte());
        if (data.fileVersion == 1 || data.fileVersion == 2 || data.fileVersion == 3) {
            data.scanRate = s.readDouble();
            data.framelineRampdownRatio = s.readDouble();
            data.xMin = s.readDouble();
            data.xMax = s.readDouble();
            data.detMin = -10.0;
            data.detMax = 10.0;
            s.skip(7L);
        } else {
            data.scanRate = s.readFloat();
            data.framelineRampdownRatio = s.readFloat();
            data.xMin = s.readFloat();
            data.xMax = s.readFloat();
            data.detMin = s.readFloat();
            data.detMax = s.readFloat();
            data.decimatingFactor = FIBSEM_Reader.getUnsignedShort(s.readShort());
            s.skip(13L);
        }
        data.AI1 = FIBSEM_Reader.getUnsignedByte(s.readByte());
        data.AI2 = FIBSEM_Reader.getUnsignedByte(s.readByte());
        data.AI3 = FIBSEM_Reader.getUnsignedByte(s.readByte());
        data.AI4 = FIBSEM_Reader.getUnsignedByte(s.readByte());
        s.skip(25L);
        tmp = new byte[200];
        s.read(tmp);
        data.notes = new String(tmp);
        if (data.fileVersion == 1 || data.fileVersion == 2) {
            tmp = new byte[10];
            s.read(tmp);
            data.detectorA = new String(tmp);
            tmp = new byte[18];
            s.read(tmp);
            data.detectorB = new String(tmp);
            data.magnification = s.readDouble();
            data.pixelSize = s.readDouble();
            data.wd = s.readDouble();
            data.eht = s.readDouble();
            data.semApr = FIBSEM_Reader.getUnsignedByte(s.readByte());
            data.highCurrent = FIBSEM_Reader.getUnsignedByte(s.readByte());
            s.skip(6L);
            data.semCurr = s.readDouble();
            data.semRot = s.readDouble();
            data.chamVac = s.readDouble();
            data.gunVac = s.readDouble();
            data.semStiX = s.readDouble();
            data.semStiY = s.readDouble();
            data.semAlnX = s.readDouble();
            data.semAlnY = s.readDouble();
            data.stageX = s.readDouble();
            data.stageY = s.readDouble();
            data.stageZ = s.readDouble();
            data.stageT = s.readDouble();
            data.stageR = s.readDouble();
            data.stageM = s.readDouble();
            data.brightnessA = s.readDouble();
            data.contrastA = s.readDouble();
            data.brightnessB = s.readDouble();
            data.contrastB = s.readDouble();
            s.skip(8L);
            data.mode = FIBSEM_Reader.getUnsignedByte(s.readByte());
            s.skip(7L);
            data.fibFocus = s.readDouble();
            data.fibProb = FIBSEM_Reader.getUnsignedByte(s.readByte());
            s.skip(7L);
            data.fibCurr = s.readDouble();
            data.fibRot = s.readDouble();
            data.fibAlnX = s.readDouble();
            data.fibAlnY = s.readDouble();
            data.fibStiX = s.readDouble();
            data.fibStiY = s.readDouble();
            data.fibShiftX = s.readDouble();
            data.fibShiftY = s.readDouble();
            s.skip(12L);
            tmp = new byte[20];
            s.read(tmp);
            data.detectorC = new String(tmp);
            s.read(tmp);
            data.detectorD = new String(tmp);
            s.skip(60L);
        } else {
            tmp = new byte[10];
            s.read(tmp);
            data.detectorA = new String(tmp);
            tmp = new byte[18];
            s.read(tmp);
            data.detectorB = new String(tmp);
            s.skip(2L);
            tmp = new byte[20];
            s.read(tmp);
            data.detectorC = new String(tmp);
            s.read(tmp);
            data.detectorD = new String(tmp);
            s.skip(10L);
            data.magnification = s.readFloat();
            data.pixelSize = s.readFloat();
            data.wd = s.readFloat();
            data.eht = s.readFloat();
            s.skip(4L);
            data.semApr = FIBSEM_Reader.getUnsignedByte(s.readByte());
            data.highCurrent = FIBSEM_Reader.getUnsignedByte(s.readByte());
            s.skip(8L);
            data.semCurr = s.readFloat();
            data.semRot = s.readFloat();
            data.chamVac = s.readFloat();
            data.gunVac = s.readFloat();
            s.skip(4L);
            data.semShiftX = s.readFloat();
            data.semShiftY = s.readFloat();
            data.semStiX = s.readFloat();
            data.semStiY = s.readFloat();
            data.semAlnX = s.readFloat();
            data.semAlnY = s.readFloat();
            data.stageX = s.readFloat();
            data.stageY = s.readFloat();
            data.stageZ = s.readFloat();
            data.stageT = s.readFloat();
            data.stageR = s.readFloat();
            data.stageM = s.readFloat();
            s.skip(2L);
            data.brightnessA = s.readFloat();
            data.contrastA = s.readFloat();
            data.brightnessB = s.readFloat();
            data.contrastB = s.readFloat();
            s.skip(24L);
            data.mode = FIBSEM_Reader.getUnsignedByte(s.readByte());
            s.skip(3L);
            data.fibFocus = s.readFloat();
            data.fibProb = FIBSEM_Reader.getUnsignedByte(s.readByte());
            s.skip(11L);
            data.fibCurr = s.readFloat();
            data.fibRot = s.readFloat();
            data.fibAlnX = s.readFloat();
            data.fibAlnY = s.readFloat();
            data.fibStiX = s.readFloat();
            data.fibStiY = s.readFloat();
            data.fibShiftX = s.readFloat();
            data.fibShiftY = s.readFloat();
        }
        if (data.fileVersion >= 5 && data.fileVersion <= 8) {
            data.millingXResolution = FIBSEM_Reader.getUnsignedInt(s.readInt());
            data.millingYResolution = FIBSEM_Reader.getUnsignedInt(s.readInt());
            data.millingXSize = s.readFloat();
            data.millingYSize = s.readFloat();
            data.millingULAng = s.readFloat();
            data.millingURAng = s.readFloat();
            data.millingLineTime = s.readFloat();
            data.fibFOV = s.readFloat();
            data.millingLinesPerImage = FIBSEM_Reader.getUnsignedShort(s.readShort());
            data.millingPIDOn = FIBSEM_Reader.getUnsignedByte(s.readByte());
            s.skip(2L);
            data.millingPIDMeasured = FIBSEM_Reader.getUnsignedByte(s.readByte());
            data.millingPIDTarget = s.readFloat();
            data.millingPIDTargetSlope = s.readFloat();
            data.millingPIDP = s.readFloat();
            data.millingPIDI = s.readFloat();
            data.millingPIDD = s.readFloat();
            s.skip(90L);
            tmp = new byte[30];
            s.read(tmp);
            data.machineID = new String(tmp);
            s.skip(20L);
            if (data.fileVersion == 6 || data.fileVersion == 7) {
                data.temperature = s.readFloat();
                data.faradayCupI = s.readFloat();
                data.fibSpecimenI = s.readFloat();
                data.beamDumpI = s.readFloat();
                data.semSpecimenI = s.readFloat();
                data.millingYVoltage = s.readFloat();
                data.focusIndex = s.readFloat();
                data.fibSliceNum = FIBSEM_Reader.getUnsignedInt(s.readInt());
            } else {
                s.skip(32L);
            }
            if (data.fileVersion == 8) {
                data.beamDump2I = s.readFloat();
                data.millingI = s.readFloat();
                s.skip(90L);
            } else {
                s.skip(98L);
            }
            data.semSpecimenI = s.readFloat();
            s.skip(16L);
        } else {
            s.skip(148L);
            tmp = new byte[160];
            s.read(tmp);
            data.machineID = new String(tmp);
            s.skip(40L);
        }
        data.fileLength = s.readLong();
        s.skip(16L);
        return data;
    }

    public static long getUnsignedInt(int signedInt) {
        return (long)signedInt & 0xFFFFFFFFL;
    }

    public static int getUnsignedShort(short signedShort) {
        return signedShort & 0xFFFF;
    }

    public static int getUnsignedByte(byte signedByte) {
        return signedByte & 0xFF;
    }

    public static void main(String[] args) {
        new ImageJ();
        openAsFloat = false;
        openAsRaw = false;
        FIBSEM_Reader r = new FIBSEM_Reader();
        r.run("/Users/preibischs/Desktop/Zeiss_12-01-14_210123.dat");
        System.out.println(r.getHeader());
    }

    public class FIBSEMData {
        public long magicNumber;
        public int fileVersion;
        public int fileType;
        public String swDate;
        public double timeStep;
        public int numChannels;
        public int eightBit;
        public float[] offset;
        public float[] gain;
        public float[] secondOrder;
        public float[] thirdOrder;
        public long xRes;
        public long yRes;
        public int oversampling;
        public int AIdelay = 0;
        public int zeissScanSpeed;
        public double scanRate;
        public double framelineRampdownRatio;
        public double xMin;
        public double xMax;
        public double detMin;
        public double detMax;
        public int decimatingFactor;
        public int AI1;
        public int AI2;
        public int AI3;
        public int AI4;
        public String notes;
        public String detectorA = "";
        public String detectorB = "";
        public String detectorC = "";
        public String detectorD = "";
        public double magnification;
        public double pixelSize;
        public double wd;
        public double eht;
        public int semApr;
        public int highCurrent;
        public int mode;
        public double semCurr;
        public double semRot;
        public double chamVac;
        public double gunVac;
        public double semShiftX;
        public double semShiftY;
        public double semStiX;
        public double semStiY;
        public double semAlnX;
        public double semAlnY;
        public double stageX;
        public double stageY;
        public double stageZ;
        public double stageT;
        public double stageR;
        public double stageM;
        public double brightnessA;
        public double contrastA;
        public double brightnessB;
        public double contrastB;
        public double fibFocus;
        public int fibProb;
        public double fibCurr;
        public double fibRot;
        public double fibAlnX;
        public double fibAlnY;
        public double fibStiX;
        public double fibStiY;
        public double fibShiftX;
        public double fibShiftY;
        public long millingXResolution;
        public long millingYResolution;
        public float millingXSize;
        public float millingYSize;
        public float millingULAng;
        public float millingURAng;
        public float millingLineTime;
        public float fibFOV;
        public int millingLinesPerImage;
        public int millingPIDOn;
        public int millingPIDMeasured;
        public float millingPIDTarget;
        public float millingPIDTargetSlope;
        public float millingPIDP;
        public float millingPIDI;
        public float millingPIDD;
        public float temperature;
        public float faradayCupI;
        public float fibSpecimenI;
        public float beamDumpI;
        public float semSpecimenI;
        public float millingYVoltage;
        public float focusIndex;
        public long fibSliceNum;
        public float beamDump2I;
        public float millingI;
        public String machineID;
        public long fileLength;

        public String toString() {
            int c;
            String offsetString = "";
            String gainString = "";
            String secondOrderString = "";
            String thirdOrderString = "";
            for (c = 0; c < this.numChannels; ++c) {
                offsetString = offsetString + "offset channel " + c + " = " + this.offset[c] + "\n";
            }
            for (c = 0; c < this.numChannels; ++c) {
                gainString = gainString + "gain channel " + c + " = " + this.gain[c] + "\n";
            }
            for (c = 0; c < this.numChannels; ++c) {
                secondOrderString = secondOrderString + "2nd order channel " + c + " = " + this.secondOrder[c] + "\n";
            }
            for (c = 0; c < this.numChannels; ++c) {
                thirdOrderString = thirdOrderString + "3rd order channel " + c + " = " + this.thirdOrder[c] + "\n";
            }
            return "magic number, should be 3555587570 = " + this.magicNumber + "\nfile version = " + this.fileVersion + "\nfile type, 1 is Zeiss Neon detectors = " + this.fileType + "\nSW date = " + this.swDate + "\nAI sampling time (including oversampling) in seconds = " + this.timeStep + "\nnumber of channels = " + this.numChannels + "\neight bit = " + this.eightBit + "\n" + offsetString + gainString + secondOrderString + thirdOrderString + "x resolution = " + this.xRes + "\ny resolution = " + this.yRes + "\noversampling = " + this.oversampling + "\nAI delay (# of samples) = " + this.AIdelay + "\nScan speed (Zeiss #) = " + this.zeissScanSpeed + "\nActual AO (scanning) rate = " + this.scanRate + "\nFrameline rampdown ratio = " + this.framelineRampdownRatio + "\nX coil minimum voltage = " + this.xMin + "\nX coil maximum voltage = " + this.xMax + "\nDetector minimum voltage = " + this.detMin + "\nDetector maximum voltage = " + this.detMax + "\ndecimating factor = " + this.decimatingFactor + "\nAI Ch1 = " + this.AI1 + "\nAI Ch2 = " + this.AI2 + "\nAI Ch3 = " + this.AI3 + "\nAI Ch4 = " + this.AI4 + "\nnotes = " + this.notes + "\ndetector A = " + this.detectorA + "\ndetector B = " + this.detectorB + "\ndetector C = " + this.detectorC + "\ndetector D = " + this.detectorD + "\nmagnification = " + this.magnification + "\nPixel size in nm = " + this.pixelSize + "\nWorking distance in mm = " + this.wd + "\nEHT in kV = " + this.eht + "\nSEM aperture number = " + this.semApr + "\nhigh current mode (1=on, 0=off) = " + this.highCurrent + "\nFIB mode: 0=SEM, 1=FIB, 2=Milling, 3=SEM+FIB, 4=Mill+SEM, 5=SEM Drift Correction, 6=FIB Drift Correction, 7=No Beam, 8=External, 9=External+SEM = " + this.mode + "\nSEM probe current in A = " + this.semCurr + "\nSEM scan roation in degree = " + this.semRot + "\nChamber vacuum = " + this.chamVac + "\nGun vacuum = " + this.gunVac + "\nSEM beam shift X = " + this.semShiftX + "\nSEM beam shift Y = " + this.semShiftY + "\nSEM stigmation X = " + this.semStiX + "\nSEM stigmation Y = " + this.semStiY + "\nSEM aperture alignment X = " + this.semAlnX + "\nSEM aperture alignment Y = " + this.semAlnY + "\nStage position X in mm = " + this.stageX + "\nStage position Y in mm = " + this.stageY + "\nStage position Z in mm = " + this.stageZ + "\nStage position T in degree = " + this.stageT + "\nStage position R in degree = " + this.stageR + "\nStage position M in mm = " + this.stageM + "\nDetector A brightness (%) = " + this.brightnessA + "\nDetector A contrast (%) = " + this.contrastA + "\nDetector B brightness (%) = " + this.brightnessB + "\nDetector B contrast (%) = " + this.contrastB + "\nFIB focus in kV = " + this.fibFocus + "\nFIB probe number = " + this.fibProb + "\nFIB emission current = " + this.fibCurr + "\nFIB scan rotation = " + this.fibRot + "\nFIB aperture alignment X = " + this.fibAlnX + "\nFIB aperture alignment Y = " + this.fibAlnY + "\nFIB stigmation X = " + this.fibStiX + "\nFIB stigmation Y = " + this.fibStiY + "\nFIB beam shift X in micron = " + this.fibShiftX + "\nFIB beam shift Y in micron = " + this.fibShiftY + "\nMilling X resolution = " + this.millingXResolution + "\nMilling Y resolution = " + this.millingYResolution + "\nMilling X size = " + this.millingXSize + "\nMilling Y size = " + this.millingYSize + "\nMilling upper left inner angle in degree = " + this.millingULAng + "\nMilling upper right inner angle in degree = " + this.millingURAng + "\nMilling line time in second = " + this.millingLineTime + "\nFIB FOV in micron = " + this.fibFOV + "\nMilling lines per image = " + this.millingLinesPerImage + "\nMilling PID on = " + this.millingPIDOn + "\nMilling PID measured: 0=specimen, 1=beamdump = " + this.millingPIDMeasured + "\nMilling PID target = " + this.millingPIDTarget + "\nMilling PID target slope = " + this.millingPIDTargetSlope + "\nMilling PID P = " + this.millingPIDP + "\nMilling PID I = " + this.millingPIDI + "\nMilling PID D = " + this.millingPIDD + "\nTemperature in Fahrenheit = " + this.temperature + "\nFaraday cup current in nA = " + this.faradayCupI + "\nFIB specimen current in nA = " + this.fibSpecimenI + "\nBeam dump 1 current in nA = " + this.beamDumpI + "\nBeam dump 2 current in nA = " + this.beamDump2I + "\nSEM specimen current in nA = " + this.semSpecimenI + "\nMilling Y voltage = " + this.millingYVoltage + "\nFocus index = " + this.focusIndex + "\nFIB slice number = " + this.fibSliceNum + "\nMilling current in nA = " + this.millingI + "\nMachine id = " + this.machineID + "\nfile length = " + this.fileLength;
        }
    }
}

