/*
 * Decompiled with CFR 0.152.
 */
package vib.segment;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;

public class Border
implements Cloneable {
    public static final int NONE = 0;
    public static final int LINE = 1;
    public static final int THREED_IN = 2;
    public static final int THREED_OUT = 3;
    public static final int ETCHED_IN = 4;
    public static final int EMBOSSED_OUT = 5;
    public static final int ROUND_RECT = 6;
    private int type = 0;
    private Color border = null;
    private int topMargin = 0;
    private int leftMargin = 0;
    private int bottomMargin = 0;
    private int rightMargin = 0;
    private int minMargin = 0;
    private int maxMargin = 0;
    private int borderThickness = 0;
    private static final double BRIGHTER_FACTOR = 0.8;
    private static final double DARKER_FACTOR = 0.65;

    public static Color brighter(Color color) {
        Color newcolor = new Color(Math.min((int)((double)color.getRed() * 1.25), 255), Math.min((int)((double)color.getGreen() * 1.25), 255), Math.min((int)((double)color.getBlue() * 1.25), 255));
        if (newcolor.equals(color)) {
            return Color.white;
        }
        return newcolor;
    }

    public static Color darker(Color color) {
        Color newcolor = new Color(Math.max((int)((double)color.getRed() * 0.65), 0), Math.max((int)((double)color.getGreen() * 0.65), 0), Math.max((int)((double)color.getBlue() * 0.65), 0));
        if (newcolor.equals(color)) {
            return Color.black;
        }
        return newcolor;
    }

    public Object clone() {
        Border newborder = new Border();
        newborder.type = this.type;
        newborder.border = this.border;
        newborder.topMargin = this.topMargin;
        newborder.leftMargin = this.leftMargin;
        newborder.bottomMargin = this.bottomMargin;
        newborder.rightMargin = this.rightMargin;
        newborder.minMargin = this.minMargin;
        newborder.maxMargin = this.maxMargin;
        newborder.borderThickness = this.borderThickness;
        return newborder;
    }

    public void setNoInsets() {
        this.topMargin = 0;
        this.leftMargin = 0;
        this.bottomMargin = 0;
        this.rightMargin = 0;
        this.minMargin = 0;
        this.maxMargin = 0;
        this.borderThickness = 0;
    }

    public int getType() {
        return this.type;
    }

    public synchronized void setType(int type) {
        this.type = type;
    }

    public Color getBorder() {
        return this.border;
    }

    public synchronized void setBorder(Color border) {
        this.border = border;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    private void resetMinMaxMargin() {
        this.maxMargin = this.topMargin;
        this.maxMargin = Math.max(this.maxMargin, this.leftMargin);
        this.maxMargin = Math.max(this.maxMargin, this.bottomMargin);
        this.maxMargin = Math.max(this.maxMargin, this.rightMargin);
        this.minMargin = this.topMargin;
        this.minMargin = Math.min(this.minMargin, this.leftMargin);
        this.minMargin = Math.min(this.minMargin, this.bottomMargin);
        this.minMargin = Math.min(this.minMargin, this.rightMargin);
    }

    public synchronized void setMargins(int margin) {
        this.topMargin = margin;
        this.leftMargin = margin;
        this.bottomMargin = margin;
        this.rightMargin = margin;
        this.resetMinMaxMargin();
    }

    public synchronized void setMargins(int top, int left, int bottom, int right) {
        this.topMargin = top;
        this.leftMargin = left;
        this.bottomMargin = bottom;
        this.rightMargin = right;
        this.resetMinMaxMargin();
    }

    public synchronized void setTopMargin(int margin) {
        this.topMargin = margin;
        this.resetMinMaxMargin();
    }

    public synchronized void setLeftMargin(int margin) {
        this.leftMargin = margin;
        this.resetMinMaxMargin();
    }

    public synchronized void setBottomMargin(int margin) {
        this.bottomMargin = margin;
        this.resetMinMaxMargin();
    }

    public synchronized void setRightMargin(int margin) {
        this.rightMargin = margin;
        this.resetMinMaxMargin();
    }

    public int getBorderThickness() {
        return this.borderThickness;
    }

    public synchronized void setBorderThickness(int borderThickness) {
        this.borderThickness = borderThickness;
    }

    public Insets getInsets() {
        int top = this.borderThickness + this.topMargin;
        int left = this.borderThickness + this.leftMargin;
        int bottom = this.borderThickness + this.bottomMargin;
        int right = this.borderThickness + this.rightMargin;
        return new Insets(top, left, bottom, right);
    }

    public void paint(Graphics g, Color background, int x, int y, int width, int height) {
        if (this.border == null) {
            this.border = this.type == 1 || this.type == 6 ? (background == Color.black ? Color.white : Color.black) : (background == null ? Color.lightGray : background);
        }
        if (this.border != null) {
            g.setColor(this.border);
            Color brighter = null;
            Color darker = null;
            switch (this.type) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    brighter = Border.brighter(this.border);
                    darker = Border.darker(this.border);
                }
            }
            for (int idx = 0; idx < this.borderThickness; ++idx) {
                if (this.type == 1) {
                    g.drawRect(x + idx, y + idx, width - 1 - idx * 2, height - 1 - idx * 2);
                    continue;
                }
                if (this.type == 6) {
                    int arcSize = this.minMargin * 8 - idx * 2;
                    int rrx = x + idx;
                    int rry = y + idx;
                    int rrw = width - 1 - idx * 2;
                    int rrh = height - 1 - idx * 2;
                    g.drawRoundRect(x + idx, y + idx, rrw, rrh, arcSize, arcSize);
                    if (idx + 1 >= this.borderThickness) continue;
                    g.drawRoundRect(rrx, rry, rrw, rrh - 1, arcSize - 1, arcSize);
                    g.drawRoundRect(rrx + 1, rry, rrw, rrh - 1, arcSize - 1, arcSize);
                    g.drawRoundRect(rrx, rry, rrw - 1, rrh, arcSize, arcSize - 1);
                    g.drawRoundRect(rrx, rry + 1, rrw - 1, rrh, arcSize, arcSize - 1);
                    continue;
                }
                Color top = brighter;
                Color bottom = darker;
                if (this.type == 2 || this.type == 4) {
                    top = darker;
                    bottom = brighter;
                }
                if ((this.type == 4 || this.type == 5) && idx >= this.borderThickness / 2) {
                    Color temp = top;
                    top = bottom;
                    bottom = temp;
                }
                if (idx == this.borderThickness - 1 && this.type == 2) {
                    g.setColor(Border.darker(top));
                } else {
                    g.setColor(top);
                }
                g.drawLine(x + idx, y + idx, x + idx, y + (height - 1 - idx));
                g.drawLine(x + idx, y + idx, x + (width - 1 - idx), y + idx);
                if (idx == this.borderThickness - 1 && this.type == 2 || idx == 0 && this.type == 3) {
                    g.setColor(Border.darker(bottom));
                } else {
                    g.setColor(bottom);
                }
                g.drawLine(x + idx, y + (height - 1 - idx), x + (width - 1 - idx), y + (height - 1 - idx));
                g.drawLine(x + (width - 1 - idx), y + idx, x + (width - 1 - idx), y + (height - 1 - idx));
            }
        }
    }
}

