/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import distance.TwoValues;
import ij.ImagePlus;
import util.StupidLog;
import vib.FastMatrix;
import vib.FloatMatrix;
import vib.RigidRegistration;
import vib.TransformedImage;
import vib.app.ImageMetaData;
import vib.app.module.CenterTransformation;
import vib.app.module.Module;
import vib.app.module.State;

public class LabelCenterTransformation
extends Module {
    @Override
    public String getName() {
        return "LabelCenterTransformation";
    }

    @Override
    protected String getMessage() {
        return "Registering the individual neuropils";
    }

    @Override
    protected void run(State state, int index) {
        new CenterTransformation().runOnOneImage(state, index);
        this.prereqsDone(state, index);
        String labelPath = state.getResampledPath(-1, index);
        String statisticsPath = state.getStatisticsPath(index);
        ImageMetaData templStats = state.getStatistics(-1);
        ImageMetaData stats = new ImageMetaData(statisticsPath);
        boolean needsUpDate = !State.upToDate(labelPath, statisticsPath);
        String transformLabel = state.getTransformLabel(3);
        String centerLabel = state.getTransformLabel(2);
        FloatMatrix matrix = stats.getMatrix(centerLabel);
        ImagePlus labels = null;
        ImagePlus templLabels = null;
        int count = stats.materials.length;
        for (int i = 1; i < count; ++i) {
            int iTempl;
            ImageMetaData.Material m = stats.materials[i];
            if (m.count == 0 || (iTempl = templStats.getMaterialIndex(m.name)) < 0) continue;
            String matTransformLabel = transformLabel + m.name;
            if (!needsUpDate && stats.upToDate(labelPath, matTransformLabel)) continue;
            String initialTransform = matrix.toStringForAmira();
            int level = 4;
            int stoplevel = 2;
            double tolerance = 4.0;
            String materialBBox = "";
            boolean noOptimization = false;
            int nInitialPositions = 1;
            boolean showTransformed = false;
            boolean showDifferenceImage = false;
            boolean fastButInaccurate = false;
            if (labels == null) {
                labels = state.getImage(labelPath);
            }
            if (templLabels == null) {
                templLabels = state.getTemplateLabels();
            }
            while (level > 0 && templLabels.getWidth() >> level < 32) {
                --level;
            }
            if (stoplevel > level) {
                stoplevel = level;
            }
            TransformedImage trans = new TransformedImage(templLabels, labels);
            trans.measure = new TwoValues(iTempl, i);
            RigidRegistration rr = new RigidRegistration();
            StupidLog.log("registering neuropil: " + m.name + " between:");
            StupidLog.log("           labelPath: " + labelPath);
            StupidLog.log("      templateLabels: " + templLabels.getTitle());
            FastMatrix matrix2 = rr.rigidRegistration(trans, materialBBox, initialTransform, iTempl, i, noOptimization, level, stoplevel, tolerance, nInitialPositions, showTransformed, showDifferenceImage, fastButInaccurate, null);
            String forAmira = matrix2.toStringForAmira();
            FloatMatrix floatMatrix = FloatMatrix.parseMatrix(forAmira);
            stats.setMatrix(matTransformLabel, floatMatrix);
            if (stats.saveTo(statisticsPath)) continue;
            throw new RuntimeException("Could not save " + statisticsPath);
        }
    }
}

