/*
 * Decompiled with CFR 0.152.
 */
package util;

public class Penalty {
    public static double logisticPenalty(double value, double minPenaltyAt, double maxPenaltyAt, double maxPenalty) {
        if (value < minPenaltyAt) {
            return 0.0;
        }
        if (value > maxPenaltyAt) {
            return maxPenalty;
        }
        double midPoint = (minPenaltyAt + maxPenaltyAt) / 2.0;
        double minAtMinus6 = 0.00247262315663477;
        double maxAtPlus6 = 0.997527376843365;
        double logisticRange = maxAtPlus6 - minAtMinus6;
        double scaleUpT = 6.0 / (maxPenaltyAt - midPoint);
        double t = (value - midPoint) * scaleUpT;
        double rawValue = 1.0 / (1.0 + Math.exp(-t));
        double adjustedValue = (rawValue - minAtMinus6) / (maxAtPlus6 - minAtMinus6);
        return maxPenalty * adjustedValue;
    }
}

