/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.StackWindow;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import landmarks.FineTuneThread;
import landmarks.NamePoints;
import landmarks.ProgressCanvas;
import landmarks.RegistrationResult;

public class ProgressWindow
extends StackWindow
implements ActionListener {
    int width;
    int height;
    int depth;
    DecimalFormat scoreFormatter;
    DecimalFormat distanceFormatter;
    NamePoints plugin;
    ArrayList<FineTuneThread> fineTuneThreads;
    Button useThis;
    Button cancel;
    Button refineBestSoFar;
    Label lowestScore;
    Label triedSoFar;
    Button moveToRefinedPoint;
    Button moveToOriginalPoint;
    Label distanceMoved;
    RegistrationResult bestSoFar;
    boolean useTheResult = true;
    protected ProgressCanvas progressCanvas;
    boolean notShowingBest = true;
    long timeLastProgressUpdate = 0L;

    void updateLowestScore(double s) {
        this.lowestScore.setText("Score: " + this.scoreFormatter.format(s));
    }

    void updateTriedSoFar(int done, int outOf) {
        this.triedSoFar.setText("Seeds tried: " + done + " / " + outOf);
    }

    void updateDistance(double newDistance, String units) {
        this.distanceMoved.setText("Moved: " + this.scoreFormatter.format(newDistance) + " " + units);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.useThis || source == this.cancel) {
            this.cancel.setEnabled(false);
            this.useThis.setEnabled(false);
            if (source == this.useThis) {
                this.useTheResult = true;
                this.triedSoFar.setText("Finishing...");
                this.plugin.stopFineTuneThreads();
            } else if (source == this.cancel) {
                this.useTheResult = false;
                this.triedSoFar.setText("Cancelling...");
                this.plugin.stopFineTuneThreads();
            }
            this.close();
        } else if (source == this.moveToOriginalPoint) {
            this.imp.setSlice(this.progressCanvas.fixed_z + 1);
        } else if (source == this.moveToRefinedPoint) {
            this.imp.setSlice(this.progressCanvas.transformed_z + 1);
        }
    }

    void startThreads() {
        for (FineTuneThread f : this.fineTuneThreads) {
            f.start();
        }
    }

    public ProgressWindow(ImagePlus imp) {
        super(imp);
        this.width = imp.getWidth();
        this.height = imp.getHeight();
        this.depth = imp.getStackSize();
        this.scoreFormatter = new DecimalFormat("0.0000");
        this.distanceFormatter = new DecimalFormat("0.00");
    }

    public ProgressWindow(ImagePlus imp, ImageCanvas ic, NamePoints plugin) {
        super(imp, ic);
        ImageCanvas icAfter = this.getCanvas();
        this.progressCanvas = icAfter != null && ic instanceof ProgressCanvas ? (ProgressCanvas)ic : null;
        this.plugin = plugin;
        this.useThis = new Button("Use This");
        this.cancel = new Button("Cancel");
        this.lowestScore = new Label("Score: (none yet)");
        this.triedSoFar = new Label("No attempts so far.");
        this.useThis.addActionListener(this);
        this.cancel.addActionListener(this);
        this.add(this.useThis);
        this.add(this.cancel);
        this.add(this.lowestScore);
        this.add(this.triedSoFar);
        this.moveToRefinedPoint = new Button("Goto refined point");
        this.moveToOriginalPoint = new Button("Goto original guess");
        this.moveToRefinedPoint.addActionListener(this);
        this.moveToOriginalPoint.addActionListener(this);
        this.add(this.moveToRefinedPoint);
        this.add(this.moveToOriginalPoint);
        this.distanceMoved = new Label("Moved:");
        this.add(this.distanceMoved);
        this.pack();
        this.width = imp.getWidth();
        this.height = imp.getHeight();
        this.depth = imp.getStackSize();
        this.scoreFormatter = new DecimalFormat("0.0000");
    }

    synchronized void showBest() {
        int z;
        RegistrationResult r = this.bestSoFar;
        ImageStack existingStack = this.imp.getStack();
        int oldSlice = this.imp.getCurrentSlice();
        boolean setCentreSlice = false;
        if (existingStack.getSize() == 1) {
            setCentreSlice = true;
        }
        int subtract_from_new_x = (r.overlay_width - this.width) / 2;
        int subtract_from_new_y = (r.overlay_height - this.height) / 2;
        for (z = 0; z < r.overlay_depth; ++z) {
            ColorProcessor cp;
            byte[] reframedTransformedBytes = new byte[this.width * this.height];
            byte[] reframedFixedBytes = new byte[this.width * this.height];
            for (int y = 0; y < r.overlay_height; ++y) {
                for (int x = 0; x < r.overlay_width; ++x) {
                    int reframed_x = x - subtract_from_new_x;
                    int reframed_y = y - subtract_from_new_y;
                    if (reframed_x < 0 || reframed_y < 0 || reframed_x >= this.width || reframed_y >= this.height) continue;
                    reframedTransformedBytes[reframed_y * this.width + reframed_x] = r.transformed_bytes[z][y * r.overlay_width + x];
                    reframedFixedBytes[reframed_y * this.width + reframed_x] = r.fixed_bytes[z][y * r.overlay_width + x];
                }
            }
            if (z < this.depth) {
                cp = (ColorProcessor)existingStack.getProcessor(z + 1);
                cp.setRGB(reframedTransformedBytes, reframedFixedBytes, reframedTransformedBytes);
                continue;
            }
            cp = new ColorProcessor(this.width, this.height);
            cp.setRGB(reframedTransformedBytes, reframedFixedBytes, reframedTransformedBytes);
            existingStack.addSlice("", (ImageProcessor)cp);
        }
        for (z = this.depth - 1; z >= r.overlay_depth; --z) {
            existingStack.deleteSlice(z + 1);
        }
        this.depth = r.overlay_depth;
        this.progressCanvas.setCrosshairs(r.fixed_point_x - subtract_from_new_x, r.fixed_point_y - subtract_from_new_y, r.fixed_point_z, true);
        this.progressCanvas.setCrosshairs(r.transformed_point_x - subtract_from_new_x, r.transformed_point_y - subtract_from_new_y, r.transformed_point_z, false);
        this.updateDistance(r.pointMoved, this.plugin.templateUnits);
        int sliceToSet = oldSlice;
        if (setCentreSlice) {
            sliceToSet = this.depth / 2;
        }
        if (sliceToSet >= this.depth) {
            sliceToSet = this.depth - 1;
        }
        this.imp.setSlice(sliceToSet + 1);
        if (setCentreSlice) {
            this.pack();
        }
        this.imp.updateAndRepaintWindow();
        this.repaint();
        this.notShowingBest = false;
    }

    public synchronized void offerNewResult(RegistrationResult r) {
        long timeCurrently = System.currentTimeMillis();
        long timeSinceLastUpdate = timeCurrently - this.timeLastProgressUpdate;
        if (this.bestSoFar == null || r.score < this.bestSoFar.score) {
            this.bestSoFar = r;
            this.updateLowestScore(r.score);
            this.notShowingBest = true;
            System.out.println("Found a better one: " + r.score);
            if (this.timeLastProgressUpdate == 0L || timeSinceLastUpdate > 1000L) {
                System.out.println("Yeah, it's been " + (double)timeSinceLastUpdate / 1000.0 + "seconds.");
                this.showBest();
                this.timeLastProgressUpdate = timeCurrently;
            }
        }
        if (timeSinceLastUpdate > 5000L && this.notShowingBest) {
            this.timeLastProgressUpdate = timeCurrently;
            this.showBest();
        }
    }
}

