/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import ij.IJ;
import ij.ImagePlus;
import ij.measure.Calibration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import landmarks.NamedPointSet;
import landmarks.NamedPointWorld;
import math3d.Point3d;
import pal.math.MultivariateFunction;
import util.CombinationGenerator;
import vib.FastMatrix;
import vib.TransformedImage;
import vib.oldregistration.RegistrationAlgorithm;
import vib.transforms.OrderedTransformations;

public class AffineFromLandmarks
extends RegistrationAlgorithm {
    OrderedTransformations transformation;
    boolean allowScaling;
    public static final boolean tryOptimizing = false;

    static double scoreFromAllLandmarks(OrderedTransformations t, ArrayList<String> common, NamedPointSet inImage0, NamedPointSet inImage1) {
        double sum_squared_differences = 0.0;
        ListIterator<String> i = common.listIterator();
        while (i.hasNext()) {
            NamedPointWorld current;
            String s = (String)i.next();
            NamedPointWorld p0 = null;
            NamedPointWorld p1 = null;
            ListIterator i0 = inImage0.listIterator();
            while (i0.hasNext()) {
                current = (NamedPointWorld)i0.next();
                if (!s.equals(current.getName())) continue;
                p0 = current;
                break;
            }
            ListIterator i1 = inImage1.listIterator();
            while (i1.hasNext()) {
                current = (NamedPointWorld)i1.next();
                if (!s.equals(current.getName())) continue;
                p1 = current;
                break;
            }
            double[] p1_transformed = new double[3];
            t.apply(p1.x, p1.y, p1.z, p1_transformed);
            double distance = Math.sqrt((p1_transformed[0] - p0.x) * (p1_transformed[0] - p0.x) + (p1_transformed[1] - p0.y) * (p1_transformed[1] - p0.y) + (p1_transformed[2] - p0.z) * (p1_transformed[2] - p0.z));
            sum_squared_differences += distance * distance;
        }
        return sum_squared_differences / (double)common.size();
    }

    public static FastMatrix generateAffine(NamedPointWorld a1, NamedPointWorld b1, NamedPointWorld c1, NamedPointWorld d1, NamedPointWorld a2, NamedPointWorld b2, NamedPointWorld c2, NamedPointWorld d2) {
        double[][] p = new double[3][4];
        p[0][0] = b1.x - a1.x;
        p[0][1] = c1.x - a1.x;
        p[0][2] = d1.x - a1.x;
        p[1][0] = b1.y - a1.y;
        p[1][1] = c1.y - a1.y;
        p[1][2] = d1.y - a1.y;
        p[2][0] = b1.z - a1.z;
        p[2][1] = c1.z - a1.z;
        p[2][2] = d1.z - a1.z;
        double[][] q = new double[3][4];
        q[0][0] = b2.x - a2.x;
        q[0][1] = c2.x - a2.x;
        q[0][2] = d2.x - a2.x;
        q[1][0] = b2.y - a2.y;
        q[1][1] = c2.y - a2.y;
        q[1][2] = d2.y - a2.y;
        q[2][0] = b2.z - a2.z;
        q[2][1] = c2.z - a2.z;
        q[2][2] = d2.z - a2.z;
        FastMatrix Pfm = new FastMatrix(p);
        FastMatrix Qfm = new FastMatrix(q);
        FastMatrix Mfm = Qfm.times(Pfm.inverse());
        Mfm.apply(a1.x, a1.y, a1.z);
        double ox = a2.x - Mfm.x;
        double oy = a2.y - Mfm.y;
        double oz = a2.z - Mfm.z;
        FastMatrix resultFM = FastMatrix.translate(ox, oy, oz).times(Mfm);
        return resultFM;
    }

    public static double evaluateFastMatrix(FastMatrix fm, NamedPointSet from, NamedPointSet to) {
        if (from.size() != to.size()) {
            throw new RuntimeException("In evaluateFastMatrix, 'from' (size " + from.size() + ") and 'to' (size " + to.size() + ") must be equal");
        }
        double sumDistances = 0.0;
        int n = from.size();
        for (int i = 0; i < n; ++i) {
            NamedPointWorld fromPoint = from.get(i);
            NamedPointWorld toPoint = to.get(i);
            if (!fromPoint.name.equals(toPoint.name)) {
                throw new RuntimeException("In evaluateFastMatrix, point index " + i + " has a name mismatch: fromPoint = " + fromPoint + ", toPoint = " + toPoint);
            }
            fm.apply(fromPoint.x, fromPoint.y, fromPoint.z);
            double xdiff = fm.x - toPoint.x;
            double ydiff = fm.y - toPoint.y;
            double zdiff = fm.z - toPoint.z;
            sumDistances += Math.sqrt(xdiff * xdiff + ydiff * ydiff + zdiff * zdiff);
        }
        return sumDistances / (double)n;
    }

    public static FastMatrix bestBetweenPoints(NamedPointSet points0, ImagePlus image0, NamedPointSet points1, ImagePlus image1) {
        Calibration c1;
        ArrayList<String> commonPointNames = points0.namesSharedWith(points1, true);
        int n = commonPointNames.size();
        if (n < 4) {
            String error = "There are fewer than 4 points in these two images that have been marked up with the same names:";
            if (n == 0) {
                error = error + " (none in common)";
            } else {
                Iterator<String> i = commonPointNames.iterator();
                while (i.hasNext()) {
                    error = error + "\n    " + i.next();
                }
            }
            IJ.error((String)error);
            return null;
        }
        NamedPointSet fromCommon = new NamedPointSet();
        NamedPointSet toCommon = new NamedPointSet();
        for (String name : commonPointNames) {
            toCommon.add(points0.get(name));
            fromCommon.add(points1.get(name));
        }
        int[] indices = new int[n];
        for (int i = 0; i < n; ++i) {
            indices[i] = i;
        }
        CombinationGenerator generator = new CombinationGenerator(n, 4);
        FastMatrix bestFastMatrixSoFar = null;
        double minimumScoreSoFar = Double.MAX_VALUE;
        double totalCombinations = generator.getTotal().doubleValue();
        if (totalCombinations > 1024.0) {
            IJ.error((String)"There are over 1024 combinations; you probablyshouldn't be using this method.");
        }
        double sizeOfLargestDimension = Double.MIN_VALUE;
        double xSpacing0 = 1.0;
        double ySpacing0 = 1.0;
        double zSpacing0 = 1.0;
        double xSpacing1 = 1.0;
        double ySpacing1 = 1.0;
        double zSpacing1 = 1.0;
        Calibration c0 = image0.getCalibration();
        if (c0 != null) {
            xSpacing0 = c0.pixelWidth;
            ySpacing0 = c0.pixelHeight;
            zSpacing0 = c0.pixelDepth;
        }
        if ((c1 = image1.getCalibration()) != null) {
            xSpacing1 = c1.pixelWidth;
            ySpacing1 = c1.pixelHeight;
            zSpacing1 = c1.pixelDepth;
        }
        double[] sides = new double[]{Math.abs((double)image0.getWidth() * xSpacing0), Math.abs((double)image0.getHeight() * ySpacing0), Math.abs((double)image0.getStackSize() * zSpacing0), Math.abs((double)image1.getWidth() * xSpacing1), Math.abs((double)image1.getHeight() * ySpacing1), Math.abs((double)image1.getStackSize() * zSpacing1)};
        for (int i = 0; i < 6; ++i) {
            if (!(sides[i] > sizeOfLargestDimension)) continue;
            sizeOfLargestDimension = sides[i];
        }
        IJ.showProgress((double)0.0);
        int done = 0;
        while (generator.hasMore()) {
            int[] choice = generator.getNext();
            FastMatrix affine = AffineFromLandmarks.generateAffine(fromCommon.get(choice[0]), fromCommon.get(choice[1]), fromCommon.get(choice[2]), fromCommon.get(choice[3]), toCommon.get(choice[0]), toCommon.get(choice[1]), toCommon.get(choice[2]), toCommon.get(choice[3]));
            double originalScore = AffineFromLandmarks.evaluateFastMatrix(affine, fromCommon, toCommon);
            if (originalScore < minimumScoreSoFar) {
                minimumScoreSoFar = originalScore;
                bestFastMatrixSoFar = affine;
            }
            Point3d[] from = new Point3d[4];
            Point3d[] to = new Point3d[4];
            for (int i = 0; i < 4; ++i) {
                NamedPointWorld npw1 = fromCommon.get(choice[i]);
                NamedPointWorld npw0 = toCommon.get(choice[i]);
                from[i] = npw1.toPoint3d();
                to[i] = npw0.toPoint3d();
            }
            IJ.showProgress((double)((double)(++done) / totalCombinations));
        }
        IJ.showProgress((double)1.0);
        return bestFastMatrixSoFar;
    }

    @Override
    public ImagePlus register() {
        NamedPointSet points0 = null;
        NamedPointSet points1 = null;
        try {
            points0 = NamedPointSet.forImage(this.sourceImages[0]);
        }
        catch (NamedPointSet.PointsFileException e) {
            IJ.error((String)("Failed to find a corresponding points file for: " + this.sourceImages[0].getTitle()));
        }
        try {
            points1 = NamedPointSet.forImage(this.sourceImages[1]);
        }
        catch (NamedPointSet.PointsFileException e) {
            IJ.error((String)("Failed to find a corresponding points file for: " + this.sourceImages[1].getTitle()));
        }
        return this.register(points0, points1);
    }

    @Override
    public ImagePlus register(NamedPointSet points0, NamedPointSet points1) {
        FastMatrix affine = AffineFromLandmarks.bestBetweenPoints(points0, this.sourceImages[0], points1, this.sourceImages[1]);
        TransformedImage ti = new TransformedImage(this.sourceImages[0], this.sourceImages[1]);
        ti.setTransformation(affine);
        ImagePlus transformed = ti.getTransformed();
        transformed.setTitle("Transformed");
        return transformed;
    }

    public static class CandidateAffine
    implements MultivariateFunction {
        FastMatrix m = new FastMatrix();
        NamedPointSet from;
        NamedPointSet to;
        double bestScore = Double.MAX_VALUE;
        double[] bestArgument = new double[12];
        double sizeOfLargestDimension;

        public CandidateAffine(NamedPointSet from, NamedPointSet to, double sizeOfLargestDimension) {
            this.from = from;
            this.to = to;
            this.sizeOfLargestDimension = sizeOfLargestDimension;
        }

        @Override
        public double evaluate(double[] argument) {
            double[] argumentAdjusted = (double[])argument.clone();
            argumentAdjusted[3] = argumentAdjusted[3] * this.sizeOfLargestDimension;
            argumentAdjusted[7] = argumentAdjusted[7] * this.sizeOfLargestDimension;
            argumentAdjusted[11] = argumentAdjusted[11] * this.sizeOfLargestDimension;
            this.m.setFromFlatDoubleArray(argumentAdjusted);
            double score = AffineFromLandmarks.evaluateFastMatrix(this.m, this.from, this.to);
            if (score < this.bestScore) {
                this.bestScore = score;
                System.arraycopy(argument, 0, this.bestArgument, 0, 12);
            }
            return score;
        }

        @Override
        public int getNumArguments() {
            return 12;
        }

        @Override
        public double getLowerBound(int n) {
            return -1.0;
        }

        @Override
        public double getUpperBound(int n) {
            return 1.0;
        }
    }
}

