/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.localThickness;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class Clean_Up_Local_Thickness
implements PlugInFilter {
    private ImagePlus imp;
    private ImagePlus resultImage;
    public float[][] s;
    public float[][] sNew;
    public boolean runSilent = false;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 8;
    }

    public void run(ImageProcessor ip) {
        int ind;
        int i;
        int wj;
        int k;
        this.resultImage = null;
        ImageStack stack = this.imp.getStack();
        int w = stack.getWidth();
        int h = stack.getHeight();
        int d = this.imp.getStackSize();
        ImageStack newStack = new ImageStack(w, h);
        this.sNew = new float[d][];
        for (k = 0; k < d; ++k) {
            FloatProcessor ipk = new FloatProcessor(w, h);
            newStack.addSlice(null, (ImageProcessor)ipk);
            this.sNew[k] = (float[])ipk.getPixels();
        }
        this.s = new float[d][];
        for (k = 0; k < d; ++k) {
            this.s[k] = (float[])stack.getPixels(k + 1);
        }
        for (k = 0; k < d; ++k) {
            for (int j = 0; j < h; ++j) {
                wj = w * j;
                for (i = 0; i < w; ++i) {
                    this.sNew[k][i + wj] = this.setFlag(i, j, k, w, h, d);
                }
            }
        }
        for (k = 0; k < d; ++k) {
            for (int j = 0; j < h; ++j) {
                wj = w * j;
                for (i = 0; i < w; ++i) {
                    ind = i + wj;
                    if (this.sNew[k][ind] != -1.0f) continue;
                    this.sNew[k][ind] = -this.averageInteriorNeighbors(i, j, k, w, h, d);
                }
            }
        }
        for (k = 0; k < d; ++k) {
            for (int j = 0; j < h; ++j) {
                wj = w * j;
                for (i = 0; i < w; ++i) {
                    ind = i + wj;
                    this.sNew[k][ind] = Math.abs(this.sNew[k][ind]);
                }
            }
        }
        IJ.showStatus((String)"Clean Up Local Thickness complete");
        String title = this.stripExtension(this.imp.getTitle());
        int slices = this.imp.getNSlices();
        int channels = this.imp.getNChannels();
        int frames = this.imp.getNFrames();
        this.resultImage = IJ.createHyperStack((String)(title + "_CL"), (int)w, (int)h, (int)channels, (int)slices, (int)frames, (int)32);
        this.resultImage.setStack(newStack, channels, slices, frames);
        this.resultImage.getProcessor().setMinAndMax(0.0, 2.0 * this.imp.getProcessor().getMax());
        if (!this.runSilent) {
            this.resultImage.show();
            IJ.run((String)"Fire");
        }
    }

    float setFlag(int i, int j, int k, int w, int h, int d) {
        if (this.s[k][i + w * j] == 0.0f) {
            return 0.0f;
        }
        if (this.look(i, j, k - 1, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i, j, k + 1, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i, j - 1, k, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i, j + 1, k, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i - 1, j, k, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i + 1, j, k, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i, j + 1, k - 1, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i, j + 1, k + 1, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i + 1, j - 1, k, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i + 1, j + 1, k, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i - 1, j, k + 1, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i + 1, j, k + 1, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i, j - 1, k - 1, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i, j - 1, k + 1, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i - 1, j - 1, k, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i - 1, j + 1, k, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i - 1, j, k - 1, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i + 1, j, k - 1, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i + 1, j + 1, k + 1, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i + 1, j - 1, k + 1, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i - 1, j + 1, k + 1, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i - 1, j - 1, k + 1, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i + 1, j + 1, k - 1, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i + 1, j - 1, k - 1, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i - 1, j + 1, k - 1, w, h, d) == 0.0f) {
            return -1.0f;
        }
        if (this.look(i - 1, j - 1, k - 1, w, h, d) == 0.0f) {
            return -1.0f;
        }
        return this.s[k][i + w * j];
    }

    float averageInteriorNeighbors(int i, int j, int k, int w, int h, int d) {
        int n = 0;
        float sum = 0.0f;
        float value = this.lookNew(i, j, k - 1, w, h, d);
        if (value > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i, j, k + 1, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i, j - 1, k, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i, j + 1, k, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i - 1, j, k, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i + 1, j, k, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i, j + 1, k - 1, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i, j + 1, k + 1, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i + 1, j - 1, k, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i + 1, j + 1, k, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i - 1, j, k + 1, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i + 1, j, k + 1, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i, j - 1, k - 1, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i, j - 1, k + 1, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i - 1, j - 1, k, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i - 1, j + 1, k, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i - 1, j, k - 1, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i + 1, j, k - 1, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i + 1, j + 1, k + 1, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i + 1, j - 1, k + 1, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i - 1, j + 1, k + 1, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i - 1, j - 1, k + 1, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i + 1, j + 1, k - 1, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i + 1, j - 1, k - 1, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i - 1, j + 1, k - 1, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if ((value = this.lookNew(i - 1, j - 1, k - 1, w, h, d)) > 0.0f) {
            ++n;
            sum += value;
        }
        if (n > 0) {
            return sum / (float)n;
        }
        return this.s[k][i + w * j];
    }

    float look(int i, int j, int k, int w, int h, int d) {
        if (i < 0 || i >= w) {
            return -1.0f;
        }
        if (j < 0 || j >= h) {
            return -1.0f;
        }
        if (k < 0 || k >= d) {
            return -1.0f;
        }
        return this.s[k][i + w * j];
    }

    float lookNew(int i, int j, int k, int w, int h, int d) {
        if (i < 0 || i >= w) {
            return -1.0f;
        }
        if (j < 0 || j >= h) {
            return -1.0f;
        }
        if (k < 0 || k >= d) {
            return -1.0f;
        }
        return this.sNew[k][i + w * j];
    }

    String stripExtension(String name) {
        int dotIndex;
        if (name != null && (dotIndex = name.lastIndexOf(".")) >= 0) {
            name = name.substring(0, dotIndex);
        }
        return name;
    }

    public ImagePlus getResultImage() {
        return this.resultImage;
    }

    public void purge() {
        this.s = null;
        this.sNew = null;
        this.resultImage = null;
        this.imp = null;
    }
}

