/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.debug;

import net.imagej.table.DefaultResultsTable;
import net.imagej.table.ResultsTable;
import org.scijava.ItemIO;
import org.scijava.app.StatusService;
import org.scijava.command.Command;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.table.DefaultGenericTable;
import org.scijava.table.GenericTable;
import org.scijava.util.MersenneTwisterFast;

@Plugin(type=Command.class, menuPath="Plugins>Sandbox>Table Demo", headless=true, attrs={@Attr(name="no-legacy")})
public class TableDemo
implements Command {
    @Parameter
    private StatusService statusService;
    @Parameter(label="Paul Molitor Baseball Statistics", type=ItemIO.OUTPUT)
    private ResultsTable baseball;
    @Parameter(label="Big Table", type=ItemIO.OUTPUT)
    private ResultsTable big;
    @Parameter(label="Spreadsheet", type=ItemIO.OUTPUT)
    private GenericTable spreadsheet;

    public void run() {
        this.statusService.showStatus("Creating a small table...");
        this.createBaseballTable();
        this.statusService.showStatus("Creating a large table...");
        this.createBigTable();
        this.statusService.showStatus("Creating spreadsheet...");
        this.createSpreadsheet();
        this.statusService.clearStatus();
    }

    private void createBaseballTable() {
        double[][] data = new double[][]{{1978.0, 21.0, 0.273}, {1979.0, 22.0, 0.322}, {1980.0, 23.0, 0.304}, {1981.0, 24.0, 0.267}, {1982.0, 25.0, 0.302}, {1983.0, 26.0, 0.27}, {1984.0, 27.0, 0.217}, {1985.0, 28.0, 0.297}, {1986.0, 29.0, 0.281}, {1987.0, 30.0, 0.353}, {1988.0, 31.0, 0.312}, {1989.0, 32.0, 0.315}, {1990.0, 33.0, 0.285}, {1991.0, 34.0, 0.325}, {1992.0, 35.0, 0.32}, {1993.0, 36.0, 0.332}, {1994.0, 37.0, 0.341}, {1995.0, 38.0, 0.27}, {1996.0, 39.0, 0.341}, {1997.0, 40.0, 0.305}, {1998.0, 41.0, 0.281}};
        this.baseball = new DefaultResultsTable(data[0].length, data.length);
        this.baseball.setColumnHeader(0, "Year");
        this.baseball.setColumnHeader(1, "Age");
        this.baseball.setColumnHeader(2, "BA");
        this.baseball.setRowHeader(9, "Best");
        for (int row = 0; row < data.length; ++row) {
            for (int col = 0; col < data[row].length; ++col) {
                this.baseball.setValue(col, row, data[row][col]);
            }
        }
    }

    private void createBigTable() {
        int colCount = 10;
        int rowCount = 10000;
        this.big = new DefaultResultsTable(10, 10000);
        for (int col = 0; col < 10; ++col) {
            this.statusService.showProgress(col, 10);
            for (int row = 0; row < 10000; ++row) {
                this.big.setValue(col, row, (double)(row + col));
            }
        }
    }

    private void createSpreadsheet() {
        this.spreadsheet = new DefaultGenericTable(26, 50);
        MersenneTwisterFast rand = new MersenneTwisterFast();
        for (int col = 0; col < this.spreadsheet.getColumnCount(); ++col) {
            char letter = (char)(65 + col);
            this.spreadsheet.setColumnHeader(col, "" + letter);
            for (int row = 0; row < this.spreadsheet.getRowCount(); ++row) {
                String data = this.randomWord(rand, 2, 4);
                this.spreadsheet.set(col, row, (Object)data);
            }
        }
    }

    private String randomWord(MersenneTwisterFast rand, int min, int max) {
        StringBuilder sb = new StringBuilder();
        int length = rand.nextInt(max - min + 1) + min;
        for (int i = 0; i < length; ++i) {
            char letter = (char)(97 + rand.nextInt(26));
            sb.append(letter);
        }
        return sb.toString();
    }
}

