/*
 * Decompiled with CFR 0.152.
 */
package volume;

import ij.IJ;

public class Equalize {
    private static final int DEFAULTWINDOWSIZE = 20;

    public static int getDefaultWindowSize() {
        return 20;
    }

    public static float[] sliding(float[] image, int width, float center, int windowSize, boolean doShowProgress) {
        float[] equalized = new float[image.length];
        int height = image.length / width;
        for (int y = 0; y < height; ++y) {
            if (doShowProgress) {
                IJ.showProgress((int)y, (int)height);
            }
            for (int x = 0; x < width; ++x) {
                float iPixel = image[y * width + x];
                float aggr = 0.0f;
                int n = 0;
                for (int j = -windowSize / 2; j < windowSize / 2; ++j) {
                    for (int i = -windowSize / 2; i < windowSize / 2; ++i) {
                        float pixel;
                        int p;
                        int q = y + j;
                        if (q < 0) {
                            q = 0;
                        }
                        if (q >= height) {
                            q = height - 1;
                        }
                        if ((p = x + i) < 0) {
                            p = 0;
                        }
                        if (p >= width) {
                            p = width - 1;
                        }
                        if ((pixel = image[q * width + p]) == Float.NaN) continue;
                        aggr += pixel;
                        ++n;
                    }
                }
                equalized[y * width + x] = iPixel + center - aggr / (float)n;
            }
        }
        return equalized;
    }
}

