/*
 * Decompiled with CFR 0.152.
 */
package io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Frame;

public class Open_Sequence_As_Stack
implements PlugIn {
    private static int imageCount = 20;

    public void run(String arg) {
        ImagePlus imp;
        OpenDialog od = new OpenDialog("Open Numbered Sequence of Images As Stack...", arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        GenericDialog gd = new GenericDialog("Number of images", (Frame)IJ.getInstance());
        gd.addNumericField("Number: ", (double)imageCount, 0);
        gd.showDialog();
        boolean canceled = gd.wasCanceled();
        if (canceled) {
            return;
        }
        imageCount = (int)gd.getNextNumber();
        if (IJ.debugMode) {
            IJ.log((String)("SetOpener: " + directory + " (" + imageCount + " files)"));
        }
        if ((imp = new Opener().openImage(directory, name)) == null) {
            IJ.error((String)"file not found");
            return;
        }
        Calibration c = imp.getCalibration();
        int type = imp.getType();
        int width = imp.getWidth();
        int height = imp.getHeight();
        ImageStack stack = imp.createEmptyStack();
        ImageProcessor ip = imp.getProcessor();
        stack.addSlice(imp.getTitle(), ip);
        StringBuffer sb = new StringBuffer(name);
        int start = 0;
        int end = 0;
        for (int j = sb.length() - 1; j >= 0; --j) {
            if (!Character.isDigit(sb.charAt(j))) continue;
            if (end == 0) {
                end = j;
            }
            start = j;
        }
        String sNumeric = name.substring(start, end + 1);
        String sExtension = name.substring(end, sb.length() - 1);
        String sPrefix = name.substring(0, start);
        Integer iv = new Integer(sNumeric);
        for (int i = 0; i < imageCount; ++i) {
            String s = Integer.toString(i + iv + 100000000);
            String n = sPrefix + s.substring(s.length() - (end - start) - 1, s.length()) + sExtension;
            ImagePlus imp2 = new Opener().openImage(directory, n);
            if (imp2 == null) {
                IJ.log((String)(n + ": unable to open"));
                continue;
            }
            if (imp2.getWidth() != width || imp2.getHeight() != height) {
                IJ.log((String)(n + ": wrong dimensions"));
                continue;
            }
            if (imp2.getType() != type) {
                IJ.log((String)(n + ": wrong type"));
                continue;
            }
            String title = imp2.getTitle();
            IJ.showStatus((String)(stack.getSize() + 1 + "/" + i + ": " + title));
            stack.addSlice(title, imp2.getProcessor());
        }
        if (stack.getSize() > 1) {
            imp.setStack(null, stack);
        }
        imp.setCalibration(c);
        imp.show();
    }
}

