/*
 * Decompiled with CFR 0.152.
 */
package bijnum;

import ij.IJ;

public class BIJfht {
    protected float[] C;
    protected float[] S;
    protected int[] bitrev;
    protected int maxN;
    protected float[] tempArr;

    public BIJfht(int length) {
        this.maxN = (int)Math.sqrt(length);
        this.makeSinCosTables(this.maxN);
        this.makeBitReverseTable(this.maxN);
        this.tempArr = new float[this.maxN];
    }

    protected void progress(double percent) {
        IJ.showProgress((double)percent);
    }

    public void compute(float[] m, boolean inverse) throws IllegalArgumentException {
        if (this.maxN != (int)Math.sqrt(m.length)) {
            throw new IllegalArgumentException("BIJfht.compute(): matrix not square");
        }
        this.rc2DFHT(m, inverse, this.maxN);
    }

    public float[] crossPowerSpectrum(float[] im1, float[] im2) {
        float[] r = new float[im1.length];
        for (int row = 0; row < this.maxN; ++row) {
            int rowM = (this.maxN - row) % this.maxN;
            for (int col = 0; col < this.maxN; ++col) {
                int colM = (this.maxN - col) % this.maxN;
                float H2e = (im2[row * this.maxN + col] + im2[rowM * this.maxN + colM]) / 2.0f;
                float H2o = (im2[row * this.maxN + col] - im2[rowM * this.maxN + colM]) / 2.0f;
                r[row * this.maxN + col] = im1[row * this.maxN + col] * H2e - im1[rowM * this.maxN + colM] * H2o;
            }
        }
        return r;
    }

    public float[] crossPowerSpectrum2(float[] im1, float[] im2, int maxN) {
        float[] real = new float[im1.length];
        float[] imag = new float[im1.length];
        for (int row = 0; row < maxN; ++row) {
            int rowM = (maxN - row) % maxN;
            for (int col = 0; col < maxN; ++col) {
                int colM = (maxN - col) % maxN;
                double im1Re = (double)(im1[row * maxN + col] + im1[rowM * maxN + colM]) / 2.0;
                double im2Re = (double)(im2[row * maxN + col] + im2[rowM * maxN + colM]) / 2.0;
                double im1Im = (double)(-(im1[row * maxN + col] - im1[rowM * maxN + colM])) / 2.0;
                double im2Im = (double)(-(im2[row * maxN + col] - im2[rowM * maxN + colM])) / 2.0;
                double rcps = im1Re * im2Re + im1Im * im2Im;
                double icps = im1Im * im2Re - im2Im * im1Re;
                double mag = Math.sqrt(rcps * rcps + icps * icps);
                if (mag == 0.0) {
                    rcps = 0.0;
                    icps = 0.0;
                } else {
                    rcps /= mag;
                    icps = mag;
                }
                real[row * maxN + col] = (float)rcps;
                imag[row * maxN + col] = (float)icps;
            }
        }
        float[] h = new float[im1.length];
        for (int row = 0; row < maxN; ++row) {
            int rowM = (maxN - row) % maxN;
            for (int col = 0; col < maxN; ++col) {
                int colM = (maxN - col) % maxN;
                float He = real[row * maxN + col] - imag[row * maxN + col];
                float Ho = real[row * maxN + col] + imag[row * maxN + col];
                h[row * maxN + col] = He;
                h[rowM * maxN + colM] = Ho;
            }
        }
        return h;
    }

    public float[] flipquad(float[] m) {
        int y;
        int x;
        float[] t = new float[m.length];
        int halfwidth = this.maxN / 2;
        for (x = 0; x < halfwidth; ++x) {
            for (y = 0; y < halfwidth; ++y) {
                t[x + y * this.maxN] = m[x + halfwidth + (y + halfwidth) * this.maxN];
            }
        }
        for (x = 0; x < halfwidth; ++x) {
            for (y = 0; y < halfwidth; ++y) {
                m[x + halfwidth + (y + halfwidth) * this.maxN] = m[x + y * this.maxN];
            }
        }
        for (x = 0; x < halfwidth; ++x) {
            for (y = 0; y < halfwidth; ++y) {
                m[x + y * this.maxN] = t[x + y * this.maxN];
            }
        }
        for (x = 0; x < halfwidth; ++x) {
            for (y = 0; y < halfwidth; ++y) {
                t[x + halfwidth + y * this.maxN] = m[x + (y + halfwidth) * this.maxN];
            }
        }
        for (x = 0; x < halfwidth; ++x) {
            for (y = 0; y < halfwidth; ++y) {
                m[x + (y + halfwidth) * this.maxN] = m[x + halfwidth + y * this.maxN];
            }
        }
        for (x = 0; x < halfwidth; ++x) {
            for (y = 0; y < halfwidth; ++y) {
                m[x + halfwidth + y * this.maxN] = t[x + halfwidth + y * this.maxN];
            }
        }
        return m;
    }

    protected void makeSinCosTables(int maxN) {
        int n = maxN / 4;
        this.C = new float[n];
        this.S = new float[n];
        double theta = 0.0;
        double dTheta = Math.PI * 2 / (double)maxN;
        for (int i = 0; i < n; ++i) {
            this.C[i] = (float)Math.cos(theta);
            this.S[i] = (float)Math.sin(theta);
            theta += dTheta;
        }
    }

    protected void makeBitReverseTable(int maxN) {
        this.bitrev = new int[maxN];
        int nLog2 = this.log2(maxN);
        for (int i = 0; i < maxN; ++i) {
            this.bitrev[i] = this.bitRevX(i, nLog2);
        }
    }

    void rc2DFHT(float[] x, boolean inverse, int maxN) {
        int row;
        for (row = 0; row < maxN; ++row) {
            this.dfht3(x, row * maxN, inverse, maxN);
        }
        this.progress(0.4);
        this.transposeR(x, maxN);
        this.progress(0.5);
        for (row = 0; row < maxN; ++row) {
            this.dfht3(x, row * maxN, inverse, maxN);
        }
        this.progress(0.7);
        this.transposeR(x, maxN);
        this.progress(0.8);
        for (int row2 = 0; row2 < maxN / 2; ++row2) {
            for (int col = 0; col < maxN / 2; ++col) {
                int mRow = (maxN - row2) % maxN;
                int mCol = (maxN - col) % maxN;
                float A = x[row2 * maxN + col];
                float B = x[mRow * maxN + col];
                float C = x[row2 * maxN + mCol];
                float D = x[mRow * maxN + mCol];
                float E = (A + D - (B + C)) / 2.0f;
                x[row2 * maxN + col] = A - E;
                x[mRow * maxN + col] = B + E;
                x[row2 * maxN + mCol] = C + E;
                x[mRow * maxN + mCol] = D - E;
            }
        }
        this.progress(0.95);
    }

    void dfht3(float[] x, int base, boolean inverse, int maxN) {
        float rt2;
        float rt1;
        int Ad4;
        int Ad3;
        int Ad2;
        int Ad1;
        int gpNum;
        int Nlog2 = this.log2(maxN);
        this.BitRevRArr(x, base, Nlog2, maxN);
        int gpSize = 2;
        int numGps = maxN / 4;
        for (gpNum = 0; gpNum < numGps; ++gpNum) {
            Ad1 = gpNum * 4;
            Ad2 = Ad1 + 1;
            Ad3 = Ad1 + gpSize;
            Ad4 = Ad2 + gpSize;
            rt1 = x[base + Ad1] + x[base + Ad2];
            rt2 = x[base + Ad1] - x[base + Ad2];
            float rt3 = x[base + Ad3] + x[base + Ad4];
            float rt4 = x[base + Ad3] - x[base + Ad4];
            x[base + Ad1] = rt1 + rt3;
            x[base + Ad2] = rt2 + rt4;
            x[base + Ad3] = rt1 - rt3;
            x[base + Ad4] = rt2 - rt4;
        }
        if (Nlog2 > 2) {
            gpSize = 4;
            int numBfs = 2;
            numGps /= 2;
            for (int stage = 2; stage < Nlog2; ++stage) {
                for (gpNum = 0; gpNum < numGps; ++gpNum) {
                    int Ad0;
                    Ad1 = Ad0 = gpNum * gpSize * 2;
                    Ad2 = Ad1 + gpSize;
                    Ad3 = Ad1 + gpSize / 2;
                    Ad4 = Ad3 + gpSize;
                    rt1 = x[base + Ad1];
                    x[base + Ad1] = x[base + Ad1] + x[base + Ad2];
                    x[base + Ad2] = rt1 - x[base + Ad2];
                    rt1 = x[base + Ad3];
                    x[base + Ad3] = x[base + Ad3] + x[base + Ad4];
                    x[base + Ad4] = rt1 - x[base + Ad4];
                    for (int bfNum = 1; bfNum < numBfs; ++bfNum) {
                        Ad1 = bfNum + Ad0;
                        Ad2 = Ad1 + gpSize;
                        Ad3 = gpSize - bfNum + Ad0;
                        Ad4 = Ad3 + gpSize;
                        int CSAd = bfNum * numGps;
                        rt1 = x[base + Ad2] * this.C[CSAd] + x[base + Ad4] * this.S[CSAd];
                        rt2 = x[base + Ad4] * this.C[CSAd] - x[base + Ad2] * this.S[CSAd];
                        x[base + Ad2] = x[base + Ad1] - rt1;
                        x[base + Ad1] = x[base + Ad1] + rt1;
                        x[base + Ad4] = x[base + Ad3] + rt2;
                        x[base + Ad3] = x[base + Ad3] - rt2;
                    }
                }
                gpSize *= 2;
                numBfs *= 2;
                numGps /= 2;
            }
        }
        if (inverse) {
            for (int i = 0; i < maxN; ++i) {
                x[base + i] = x[base + i] / (float)maxN;
            }
        }
    }

    void transposeR(float[] x, int maxN) {
        for (int r = 0; r < maxN; ++r) {
            for (int c = r; c < maxN; ++c) {
                if (r == c) continue;
                float rTemp = x[r * maxN + c];
                x[r * maxN + c] = x[c * maxN + r];
                x[c * maxN + r] = rTemp;
            }
        }
    }

    int log2(int x) {
        int count = 15;
        while (!this.btst(x, count)) {
            --count;
        }
        return count;
    }

    private boolean btst(int x, int bit) {
        return (x & 1 << bit) != 0;
    }

    void BitRevRArr(float[] x, int base, int bitlen, int maxN) {
        int i;
        for (i = 0; i < maxN; ++i) {
            this.tempArr[i] = x[base + this.bitrev[i]];
        }
        for (i = 0; i < maxN; ++i) {
            x[base + i] = this.tempArr[i];
        }
    }

    private int bitRevX(int x, int bitlen) {
        int temp = 0;
        for (int i = 0; i <= bitlen; ++i) {
            if ((x & 1 << i) == 0) continue;
            temp |= 1 << bitlen - i - 1;
        }
        return temp & 0xFFFF;
    }

    private int bset(int x, int bit) {
        return x |= 1 << bit;
    }

    public byte[] getPowerSpectrum(float[] BIJfht2) {
        float[] fps = new float[this.maxN * this.maxN];
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        for (int row = 0; row < this.maxN; ++row) {
            this.fhtps(row, this.maxN, BIJfht2, fps);
            int base = row * this.maxN;
            for (int col = 0; col < this.maxN; ++col) {
                float r = fps[base + col];
                if (r < min) {
                    min = r;
                }
                if (!(r > max)) continue;
                max = r;
            }
        }
        this.flipquad(fps);
        min = (double)min < 1.0 ? 0.0f : (float)Math.log(min);
        max = (float)Math.log(max);
        float scale = (float)(253.0 / (double)(max - min));
        byte[] ps = new byte[this.maxN * this.maxN];
        for (int row = 0; row < this.maxN; ++row) {
            int base = row * this.maxN;
            for (int col = 0; col < this.maxN; ++col) {
                float r = fps[base + col];
                r = r < 1.0f ? 0.0f : (float)Math.log(r);
                ps[base + col] = (byte)((double)((r - min) * scale) + 0.5 + 1.0);
            }
        }
        return ps;
    }

    protected void fhtps(int row, int maxN, float[] BIJfht2, float[] ps) {
        int base = row * maxN;
        for (int c = 0; c < maxN; ++c) {
            int l = (maxN - row) % maxN * maxN + (maxN - c) % maxN;
            ps[base + c] = (float)(Math.pow(BIJfht2[base + c], 2.0) + Math.pow(BIJfht2[l], 2.0)) / 2.0f;
        }
    }
}

