/*
 * Decompiled with CFR 0.152.
 */
package bijnum;

import bijnum.BIJutil;
import ij.IJ;

public class BIJfft {
    protected int n;
    protected int nu;
    protected int n2;
    protected int nu1;
    protected double[] C;
    protected double[] S;
    protected double[] dx;
    protected float[] x;

    public BIJfft(float[] x) {
        this.n = x.length;
        this.nu = (int)(Math.log(this.n) / Math.log(2.0));
        this.n2 = this.n / 2;
        this.nu1 = this.nu - 1;
        this.x = x;
        this.dx = null;
        this.makeSinCosTables();
    }

    public BIJfft(double[] dx) {
        this.n = dx.length;
        this.nu = (int)(Math.log(this.n) / Math.log(2.0));
        this.n2 = this.n / 2;
        this.nu1 = this.nu - 1;
        this.x = null;
        this.dx = dx;
    }

    public float[] compute(float[] x) {
        if (x.length != this.n) {
            throw new IllegalArgumentException("BIJfft not properly initialized");
        }
        float[] xre = new float[this.n];
        float[] xim = new float[this.n];
        for (int i = 0; i < this.n; ++i) {
            xre[i] = x[i];
            xim[i] = 0.0f;
        }
        int k = 0;
        int localnu1 = this.nu1;
        int localn2 = this.n2;
        for (int l = 1; l <= this.nu; ++l) {
            while (k < this.n) {
                for (int i = 1; i <= localn2; ++i) {
                    int p = this.bitrev(k >> localnu1);
                    float c = (float)this.C[p];
                    float s = (float)this.S[p];
                    double arg = Math.PI * 2 * (double)p / (double)this.n;
                    c = (float)Math.cos(arg);
                    s = (float)Math.sin(arg);
                    float tr = xre[k + localn2] * c + xim[k + localn2] * s;
                    float ti = xim[k + localn2] * c - xre[k + localn2] * s;
                    xre[k + localn2] = xre[k] - tr;
                    xim[k + localn2] = xim[k] - ti;
                    int n = k;
                    xre[n] = xre[n] + tr;
                    int n2 = k++;
                    xim[n2] = xim[n2] + ti;
                }
                k += localn2;
            }
            k = 0;
            --localnu1;
            localn2 /= 2;
        }
        for (k = 0; k < this.n; ++k) {
            int r = this.bitrev(k);
            if (r <= k) continue;
            float tr = xre[k];
            float ti = xim[k];
            xre[k] = xre[r];
            xim[k] = xim[r];
            xre[r] = tr;
            xim[r] = ti;
        }
        float[] mag = new float[this.n / 2];
        mag[0] = (float)Math.sqrt(xre[0] * xre[0] + xim[0] * xim[0]) / (float)this.n;
        for (int i = 1; i < this.n / 2; ++i) {
            mag[i] = 2.0f * (float)Math.sqrt(xre[i] * xre[i] + xim[i] * xim[i]) / (float)this.n;
        }
        return mag;
    }

    public final double[] mag() {
        double ti;
        double tr;
        int i;
        this.n = this.dx.length;
        this.nu = (int)(Math.log(this.n) / Math.log(2.0));
        int n2 = this.n / 2;
        int nu1 = this.nu - 1;
        double[] xre = new double[this.n];
        double[] xim = new double[this.n];
        double[] mag = new double[n2];
        for (int i2 = 0; i2 < this.n; ++i2) {
            xre[i2] = this.dx[i2];
            xim[i2] = 0.0;
        }
        int k = 0;
        for (int l = 1; l <= this.nu; ++l) {
            while (k < this.n) {
                for (i = 1; i <= n2; ++i) {
                    double p = this.bitrev(k >> nu1);
                    double arg = Math.PI * 2 * p / (double)this.n;
                    double c = Math.cos(arg);
                    double s = Math.sin(arg);
                    tr = xre[k + n2] * c + xim[k + n2] * s;
                    ti = xim[k + n2] * c - xre[k + n2] * s;
                    xre[k + n2] = xre[k] - tr;
                    xim[k + n2] = xim[k] - ti;
                    int n = k;
                    xre[n] = xre[n] + tr;
                    int n3 = k++;
                    xim[n3] = xim[n3] + ti;
                }
                k += n2;
            }
            k = 0;
            --nu1;
            n2 /= 2;
        }
        for (k = 0; k < this.n; ++k) {
            int r = this.bitrev(k);
            if (r <= k) continue;
            tr = xre[k];
            ti = xim[k];
            xre[k] = xre[r];
            xim[k] = xim[r];
            xre[r] = tr;
            xim[r] = ti;
        }
        mag[0] = Math.sqrt(xre[0] * xre[0] + xim[0] * xim[0]) / (double)this.n;
        for (i = 1; i < this.n / 2; ++i) {
            mag[i] = 2.0 * Math.sqrt(xre[i] * xre[i] + xim[i] * xim[i]) / (double)this.n;
        }
        return mag;
    }

    protected void progress(double percent) {
        IJ.showProgress((double)percent);
    }

    protected int bitrev(int j) {
        int j1 = j;
        int k = 0;
        for (int i = 1; i <= this.nu; ++i) {
            int j2 = j1 / 2;
            k = 2 * k + j1 - 2 * j2;
            j1 = j2;
        }
        return k;
    }

    protected void makeSinCosTables() {
        int p;
        int i;
        int l;
        int pmax = -2147483647;
        int localnu1 = this.nu1;
        int localn2 = this.n2;
        int k = 0;
        for (l = 1; l <= this.nu; ++l) {
            while (k < this.n) {
                for (i = 1; i <= localn2; ++i) {
                    p = this.bitrev(k >> localnu1);
                    if (p > pmax) {
                        pmax = p;
                    }
                    ++k;
                }
                k += localn2;
            }
            k = 0;
            --localnu1;
            localn2 /= 2;
        }
        localnu1 = this.nu1;
        localn2 = this.n2;
        try {
            this.C = new double[pmax + 1];
            this.S = new double[pmax + 1];
            k = 0;
            for (l = 1; l <= this.nu; ++l) {
                while (k < this.n) {
                    for (i = 1; i <= localn2; ++i) {
                        p = this.bitrev(k >> localnu1);
                        double arg = Math.PI * 2 * (double)p / (double)this.n;
                        this.C[p] = Math.cos(arg);
                        this.S[p] = Math.sin(arg);
                        ++k;
                    }
                    k += localn2;
                }
                k = 0;
                --localnu1;
                localn2 /= 2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("FFT sin and cos tables length " + (pmax + 1));
    }

    public static void testsin(float[] wave) {
        double l = 16.0;
        for (int i = 0; i < wave.length; ++i) {
            wave[i] = (float)Math.sin((double)i * (Math.PI * 2) / l);
        }
    }

    public final float[][] compute2(float[] x) {
        float ti;
        float tr;
        int i;
        this.n = x.length;
        this.nu = (int)(Math.log(this.n) / Math.log(2.0));
        int n2 = this.n / 2;
        int nu1 = this.nu - 1;
        float[] xre = new float[this.n];
        float[] xim = new float[this.n];
        float[][] mag = new float[2][n2];
        for (int i2 = 0; i2 < this.n; ++i2) {
            xre[i2] = x[i2];
            xim[i2] = 0.0f;
        }
        int k = 0;
        for (int l = 1; l <= this.nu; ++l) {
            while (k < this.n) {
                for (i = 1; i <= n2; ++i) {
                    float p = this.bitrev(k >> nu1);
                    float arg = (float)Math.PI * 2 * p / (float)this.n;
                    float c = (float)Math.cos(arg);
                    float s = (float)Math.sin(arg);
                    tr = xre[k + n2] * c + xim[k + n2] * s;
                    ti = xim[k + n2] * c - xre[k + n2] * s;
                    xre[k + n2] = xre[k] - tr;
                    xim[k + n2] = xim[k] - ti;
                    int n = k;
                    xre[n] = xre[n] + tr;
                    int n3 = k++;
                    xim[n3] = xim[n3] + ti;
                }
                k += n2;
            }
            k = 0;
            --nu1;
            n2 /= 2;
        }
        for (k = 0; k < this.n; ++k) {
            int r = this.bitrev(k);
            if (r <= k) continue;
            tr = xre[k];
            ti = xim[k];
            xre[k] = xre[r];
            xim[k] = xim[r];
            xre[r] = tr;
            xim[r] = ti;
        }
        mag[0][0] = (float)Math.sqrt(xre[0] * xre[0] + xim[0] * xim[0]) / (float)this.n;
        mag[1][0] = 0.0f;
        for (i = 1; i < this.n / 2; ++i) {
            mag[0][i] = 2.0f * (float)Math.sqrt(xre[i] * xre[i] + xim[i] * xim[i]) / (float)this.n;
            mag[1][i] = i;
        }
        return mag;
    }

    public static double[] extend(double[] x) {
        int i;
        int n = BIJutil.minPower2(x.length);
        double[] xx = new double[n];
        for (i = 0; i < x.length; ++i) {
            xx[i] = x[i];
        }
        for (i = x.length; i < xx.length; ++i) {
            xx[i] = x[x.length + (x.length - i) - 1];
        }
        return xx;
    }

    public static double[] extend(float[] x) {
        int i;
        int n = BIJutil.minPower2(x.length);
        double[] xx = new double[n];
        for (i = 0; i < x.length; ++i) {
            xx[i] = x[i];
        }
        for (i = x.length; i < xx.length; ++i) {
            xx[i] = x[x.length + (x.length - i) - 1];
        }
        return xx;
    }
}

