/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJCell;
import VolumeJ.VJThresholdedVolume;
import VolumeJ.VJVoxelLoc;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import volume.Volume;

public class VJBinaryShell
extends Volume {
    public boolean[] v;
    private int sx;
    private int sy;
    private int sz;
    private int n;
    private int total;
    private int ix;
    private int iy;
    private int iz;
    private double Axz;
    private double Bxz;
    private double Ayz;
    private double Byz;
    private int Cxzai;
    private int Cxzbi;
    private int Cyzai;
    private int Cyzbi;
    private int Cxzas;
    private int Cxzbs;
    private int Cyzas;
    private int Cyzbs;
    private double Cxzc1;
    private double Cxzc2;
    private double Cyzc1;
    private double Cyzc2;
    private double dx;
    private double dy;
    private double dz;
    private double inflater;
    private int distanceDeltaxzi;
    private int distanceDeltayzi;
    String s;

    public VJBinaryShell() {
    }

    public VJBinaryShell(VJThresholdedVolume vt) {
        this.depth = vt.getDepth() - 1;
        this.height = vt.getHeight() - 1;
        this.width = vt.getWidth() - 1;
        int vtdepth = vt.getDepth();
        int vtheight = vt.getHeight();
        int vtwidth = vt.getWidth();
        this.v = new boolean[this.depth * this.height * this.width];
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    boolean origin = vt.v[z * vtheight * vtwidth + y * vtwidth + x];
                    this.v[z * this.height * this.width + y * this.width + x] = origin != vt.v[z * vtheight * vtwidth + y * vtwidth + (x + 1)] || origin != vt.v[z * vtheight * vtwidth + (y + 1) * vtwidth + x] || origin != vt.v[z * vtheight * vtwidth + (y + 1) * vtwidth + (x + 1)] || origin != vt.v[(z + 1) * vtheight * vtwidth + y * vtwidth + x] || origin != vt.v[(z + 1) * vtheight * vtwidth + y * vtwidth + (x + 1)] || origin != vt.v[(z + 1) * vtheight * vtwidth + (y + 1) * vtwidth + x] || origin != vt.v[(z + 1) * vtheight * vtwidth + (y + 1) * vtwidth + (x + 1)];
                }
            }
        }
    }

    @Override
    public Object get(int x, int y, int z) {
        return new Boolean(this.v[z * this.height * this.width + y * this.width + x]);
    }

    @Override
    public void set(Object value, int x, int y, int z) {
        this.v[z * this.height * this.width + y * this.width + x] = (Boolean)value;
    }

    public boolean surface(VJVoxelLoc vl) {
        return this.surface(vl.iz, vl.iy, vl.ix);
    }

    public boolean surface(VJCell cell) {
        return this.surface(cell.ix, cell.iy, cell.iz);
    }

    public boolean surface(int ix, int iy, int iz) {
        if (ix >= 0 && ix < this.width && iy >= 0 && iy < this.height && iz >= 0 && iz < this.depth) {
            return this.v[iz * this.height * this.width + iy * this.width + ix];
        }
        return false;
    }

    public ImageStack getImageStack() {
        ImageStack stack = new ImageStack(this.width, this.height);
        for (int z = 0; z < this.depth; ++z) {
            ByteProcessor ip = new ByteProcessor(this.width, this.height);
            byte[] plane = (byte[])ip.getPixels();
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    plane[y * this.width + x] = (byte)(this.v[z * this.height * this.width + y * this.width + x] ? 255 : 0);
                }
            }
            stack.addSlice("" + (z + 1), (ImageProcessor)ip);
        }
        return stack;
    }

    public void advancePrepare(double dx, double dy, double dz) {
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.total = (int)Math.round(Math.abs(dx) + Math.abs(dy) + Math.abs(dz));
        this.sx = this.sign(dx);
        this.sy = this.sign(dy);
        this.sz = this.sign(dz);
        this.Axz = dz;
        this.Bxz = -dx;
        this.Ayz = dz;
        this.Byz = -dy;
        double Cxza = 2.0 * this.Axz * this.Axz * (double)this.sx - 2.0 * this.Axz * this.Bxz * (double)this.sz;
        double Cxzb = 2.0 * this.Bxz * this.Bxz * (double)this.sz - 2.0 * this.Axz * this.Bxz * (double)this.sx;
        double Cyza = 2.0 * this.Ayz * this.Ayz * (double)this.sy - 2.0 * this.Ayz * this.Byz * (double)this.sz;
        double Cyzb = 2.0 * this.Byz * this.Byz * (double)this.sz - 2.0 * this.Ayz * this.Byz * (double)this.sy;
        this.Cxzc1 = this.Axz * this.Axz - this.Bxz * this.Bxz + 0.5 * (Cxza - Cxzb);
        this.Cyzc1 = this.Ayz * this.Ayz - this.Byz * this.Byz + 0.5 * (Cyza - Cyzb);
        this.Cxzc2 = 2.0 * this.Axz * (double)this.sx - 2.0 * this.Bxz * (double)this.sz;
        this.Cyzc2 = 2.0 * this.Ayz * (double)this.sy - 2.0 * this.Byz * (double)this.sz;
        double denom = Math.max(Math.abs(Cxza), Math.max(Math.abs(Cxzb), Math.max(Math.abs(Cyza), Math.abs(Cyzb))));
        this.inflater = 2.147483647E9 / (2.0 * denom);
        this.Cxzai = (int)Math.round(Cxza *= this.inflater);
        this.Cxzbi = (int)Math.round(Cxzb *= this.inflater);
        this.Cyzai = (int)Math.round(Cyza *= this.inflater);
        this.Cyzbi = (int)Math.round(Cyzb *= this.inflater);
        this.Cxzas = this.Cxzai * this.sx;
        this.Cxzbs = this.Cxzbi * this.sz;
        this.Cyzas = this.Cyzai * this.sy;
        this.Cyzbs = this.Cyzbi * this.sz;
    }

    public int advanceInit(VJCell cell, double ox, double oy, double oz) {
        double Cxz = -this.Axz * ox - this.Bxz * oz;
        double Cxzc = this.Cxzc1 + Cxz * this.Cxzc2;
        double Cyz = -this.Ayz * oy - this.Byz * oz;
        double Cyzc = this.Cyzc1 + Cyz * this.Cyzc2;
        this.ix = cell.ix;
        this.iy = cell.iy;
        this.iz = cell.iz;
        double distanceDeltaxz = (double)this.ix * (double)this.Cxzai - (double)this.iz * (double)this.Cxzbi + Cxzc * this.inflater;
        double distanceDeltayz = (double)this.iy * (double)this.Cyzai - (double)this.iz * (double)this.Cyzbi + Cyzc * this.inflater;
        this.distanceDeltaxzi = (int)Math.round(distanceDeltaxz);
        this.distanceDeltayzi = (int)Math.round(distanceDeltayz);
        this.n = this.total;
        return this.n;
    }

    public int advanceToSurface(VJCell cell) {
        while (this.n-- > 0) {
            boolean found = this.surface(this.ix, this.iy, this.iz);
            if (found) {
                cell.ix = this.ix;
                cell.iy = this.iy;
                cell.iz = this.iz;
            }
            if (this.distanceDeltaxzi >= 0 && this.distanceDeltayzi >= 0) {
                this.iz += this.sz;
                this.distanceDeltaxzi -= this.Cxzbs;
                this.distanceDeltayzi -= this.Cyzbs;
            } else if (this.distanceDeltaxzi < this.distanceDeltayzi) {
                this.ix += this.sx;
                this.distanceDeltaxzi += this.Cxzas;
            } else {
                this.iy += this.sy;
                this.distanceDeltayzi += this.Cyzas;
            }
            if (!found) continue;
            return this.total - this.n;
        }
        return this.total;
    }

    public int advanceToSurfaceTracing(VJCell cell) {
        while (this.n-- > 0) {
            boolean found = this.surface(this.ix, this.iy, this.iz);
            if (found) {
                cell.ix = this.ix;
                cell.iy = this.iy;
                cell.iz = this.iz;
            }
            this.s = this.s + "; " + this.ix + "," + this.iy + "," + this.iz;
            if (this.distanceDeltaxzi >= 0 && this.distanceDeltayzi >= 0) {
                this.iz += this.sz;
                this.distanceDeltaxzi -= this.Cxzbs;
                this.distanceDeltayzi -= this.Cyzbs;
            } else if (this.distanceDeltaxzi < this.distanceDeltayzi) {
                this.ix += this.sx;
                this.distanceDeltaxzi += this.Cxzas;
            } else {
                this.iy += this.sy;
                this.distanceDeltayzi += this.Cyzas;
            }
            if (!found) continue;
            this.s = "surface at: " + cell.ix + "," + cell.iy + "," + cell.iz + " (" + (this.total - this.n) + "): " + this.s + "\n";
            return this.total - this.n;
        }
        this.s = "no surface " + cell.ix + "," + cell.iy + "," + cell.iz + " visited (" + (this.total - this.n) + "): " + this.s + "\n";
        return this.total;
    }

    private int sign(double d) {
        if (d >= 0.0) {
            return 1;
        }
        return -1;
    }
}

