/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.gui.BufferedImageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewPane
extends JPanel
implements PropertyChangeListener,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreviewPane.class);
    protected BufferedImageReader reader = new BufferedImageReader();
    protected String loadId;
    protected String lastId;
    protected Thread loader;
    protected boolean loaderAlive;
    protected Runnable refresher;
    protected JLabel iconLabel;
    protected JLabel formatLabel;
    protected JLabel resLabel;
    protected JLabel zctLabel;
    protected JLabel typeLabel;
    protected ImageIcon icon;
    protected String iconText;
    protected String formatText;
    protected String resText;
    protected String zctText;
    protected String typeText;
    protected String iconTip;
    protected String formatTip;
    protected String resTip;
    protected String zctTip;
    protected String typeTip;

    public PreviewPane(JFileChooser jc) {
        this.reader.setNormalized(true);
        this.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.iconLabel = new JLabel();
        this.iconLabel.setMinimumSize(new Dimension(128, -1));
        this.iconLabel.setAlignmentX(0.5f);
        this.add(this.iconLabel);
        this.add(Box.createVerticalStrut(7));
        this.formatLabel = new JLabel();
        this.formatLabel.setAlignmentX(0.5f);
        this.add(this.formatLabel);
        this.add(Box.createVerticalStrut(5));
        this.resLabel = new JLabel();
        this.resLabel.setAlignmentX(0.5f);
        this.add(this.resLabel);
        this.zctLabel = new JLabel();
        this.zctLabel.setAlignmentX(0.5f);
        this.add(this.zctLabel);
        this.typeLabel = new JLabel();
        this.typeLabel.setAlignmentX(0.5f);
        this.add(this.typeLabel);
        Font font = this.formatLabel.getFont();
        font = font.deriveFont(font.getSize2D() - 3.0f);
        this.formatLabel.setFont(font);
        this.resLabel.setFont(font);
        this.zctLabel.setFont(font);
        this.typeLabel.setFont(font);
        this.icon = null;
        this.typeText = "";
        this.zctText = "";
        this.resText = "";
        this.formatText = "";
        this.iconText = "";
        this.typeTip = null;
        this.zctTip = null;
        this.resTip = null;
        this.formatTip = null;
        this.iconTip = null;
        if (jc != null) {
            jc.setAccessory(this);
            jc.addPropertyChangeListener(this);
            this.refresher = new Runnable(){

                @Override
                public void run() {
                    PreviewPane.this.iconLabel.setIcon(PreviewPane.this.icon);
                    PreviewPane.this.iconLabel.setText(PreviewPane.this.iconText);
                    PreviewPane.this.iconLabel.setToolTipText(PreviewPane.this.iconTip);
                    PreviewPane.this.formatLabel.setText(PreviewPane.this.formatText);
                    PreviewPane.this.formatLabel.setToolTipText(PreviewPane.this.formatTip);
                    PreviewPane.this.resLabel.setText(PreviewPane.this.resText);
                    PreviewPane.this.resLabel.setToolTipText(PreviewPane.this.resTip);
                    PreviewPane.this.zctLabel.setText(PreviewPane.this.zctText);
                    PreviewPane.this.zctLabel.setToolTipText(PreviewPane.this.zctTip);
                    PreviewPane.this.typeLabel.setText(PreviewPane.this.typeText);
                    PreviewPane.this.typeLabel.setToolTipText(PreviewPane.this.typeTip);
                }
            };
            this.loaderAlive = true;
            this.loader = new Thread((Runnable)this, "Preview");
            this.loader.start();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        return new Dimension(148, prefSize.height);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("JFileChooserDialogIsClosingProperty")) {
            this.loaderAlive = false;
        }
        if (!prop.equals("SelectedFileChangedProperty")) {
            return;
        }
        File f = (File)e.getNewValue();
        if (f != null && (f.isDirectory() || !f.exists())) {
            f = null;
        }
        this.loadId = f == null ? null : f.getAbsolutePath();
    }

    @Override
    public void run() {
        while (this.loaderAlive) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException exc) {
                LOGGER.info("", (Throwable)exc);
            }
            try {
                String format;
                String id = this.loadId;
                if (id == null && this.lastId == null || id != null && id.equals(this.lastId)) continue;
                if (id != null && this.lastId != null) {
                    String[] files = this.reader.getUsedFiles();
                    boolean found = false;
                    for (int i = 0; i < files.length; ++i) {
                        if (!id.equals(files[i])) continue;
                        found = true;
                        this.lastId = id;
                        break;
                    }
                    if (found) continue;
                }
                this.lastId = id;
                this.icon = null;
                this.iconText = id == null ? "" : "Reading...";
                this.typeText = "";
                this.zctText = "";
                this.resText = "";
                this.formatText = "";
                this.iconTip = id;
                this.typeTip = "";
                this.zctTip = "";
                this.resTip = "";
                this.formatTip = "";
                if (id == null) {
                    SwingUtilities.invokeLater(this.refresher);
                    continue;
                }
                try {
                    this.reader.setId(id);
                }
                catch (FormatException exc) {
                    LOGGER.debug("Failed to initialize {}", (Object)id, (Object)exc);
                    boolean badFormat = exc.getMessage().startsWith("Unknown file format");
                    this.iconText = "Unsupported " + (badFormat ? "format" : "file");
                    this.resText = "";
                    this.formatText = "";
                    SwingUtilities.invokeLater(this.refresher);
                    this.lastId = null;
                    continue;
                }
                catch (IOException exc) {
                    LOGGER.debug("Failed to initialize {}", (Object)id, (Object)exc);
                    this.iconText = "Unsupported file";
                    this.resText = "";
                    this.formatText = "";
                    SwingUtilities.invokeLater(this.refresher);
                    this.lastId = null;
                    continue;
                }
                if (!id.equals(this.loadId)) {
                    SwingUtilities.invokeLater(this.refresher);
                    continue;
                }
                this.icon = new ImageIcon(this.makeImage("Loading..."));
                this.iconText = "";
                this.formatText = format = this.reader.getFormat();
                this.formatTip = format;
                this.resText = this.reader.getSizeX() + " x " + this.reader.getSizeY();
                this.zctText = this.reader.getSizeZ() + "Z x " + this.reader.getSizeT() + "T x " + this.reader.getSizeC() + "C";
                this.typeText = this.reader.getRGBChannelCount() + " x " + FormatTools.getPixelTypeString((int)this.reader.getPixelType());
                SwingUtilities.invokeLater(this.refresher);
                int z = this.reader.getSizeZ() / 2;
                int t = this.reader.getSizeT() / 2;
                int ndx = this.reader.getIndex(z, 0, t);
                BufferedImage thumb = null;
                try {
                    thumb = this.reader.openThumbImage(ndx);
                }
                catch (FormatException exc) {
                    LOGGER.debug("Failed to read thumbnail #{} from {}", (Object)new Object[]{ndx, id}, (Object)exc);
                }
                catch (IOException exc) {
                    LOGGER.debug("Failed to read thumbnail #{} from {}", (Object)new Object[]{ndx, id}, (Object)exc);
                }
                this.icon = new ImageIcon(thumb == null ? this.makeImage("Failed") : thumb);
                this.iconText = "";
                SwingUtilities.invokeLater(this.refresher);
            }
            catch (Exception exc) {
                LOGGER.info("", (Throwable)exc);
                this.icon = null;
                this.iconText = "Thumbnail failure";
                this.typeText = "";
                this.zctText = "";
                this.resText = "";
                this.formatText = "";
                this.iconTip = this.loadId;
                this.typeTip = "";
                this.zctTip = "";
                this.resTip = "";
                this.formatTip = "";
                SwingUtilities.invokeLater(this.refresher);
            }
        }
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    private BufferedImage makeImage(String message) {
        int w = this.reader.getThumbSizeX();
        int h = this.reader.getThumbSizeY();
        if (w < 128) {
            w = 128;
        }
        if (h < 32) {
            h = 32;
        }
        BufferedImage image = new BufferedImage(w, h, 1);
        Graphics2D g = image.createGraphics();
        Rectangle2D.Float r = (Rectangle2D.Float)g.getFont().getStringBounds(message, g.getFontRenderContext());
        g.drawString(message, ((float)w - r.width) / 2.0f, ((float)h - r.height) / 2.0f + r.height);
        g.dispose();
        return image;
    }
}

