/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.util;

import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.data.ClusterMessage;
import edu.utexas.clm.archipelago.listen.TransceiverExceptionListener;
import edu.utexas.clm.archipelago.network.MessageXC;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;

public class XCErrorAdapter
implements TransceiverExceptionListener {
    private final HashSet<Class> throwablesSeenTX;
    private final HashSet<Class> throwablesSeenRX = new HashSet();
    private final AtomicBoolean isQuiet;

    public XCErrorAdapter() {
        this.throwablesSeenTX = new HashSet();
        this.isQuiet = new AtomicBoolean(false);
    }

    protected boolean handleCustomRX(Throwable t, MessageXC mxc, ClusterMessage message) {
        return true;
    }

    protected boolean handleCustomTX(Throwable t, MessageXC mxc, ClusterMessage message) {
        return true;
    }

    protected boolean handleCustom(Throwable t, MessageXC mxc, ClusterMessage message) {
        return true;
    }

    public void report(Throwable t, String message, HashSet<Class> throwablesSeen) {
        FijiArchipelago.debug(message);
        if (!throwablesSeen.contains(t.getClass())) {
            if (!this.isQuiet.get()) {
                FijiArchipelago.err(message + "\nThis error dialog will only be shown once.");
            }
            throwablesSeen.add(t.getClass());
        }
    }

    protected void reportRX(Throwable t, String message, MessageXC mxc) {
        this.report(t, "RX: " + mxc.getHostname() + ": " + message, this.throwablesSeenRX);
    }

    protected void reportTX(Throwable t, String message, MessageXC mxc) {
        this.report(t, "TX: " + mxc.getHostname() + ": " + message, this.throwablesSeenTX);
    }

    @Override
    public void handleRXThrowable(Throwable t, MessageXC mxc, ClusterMessage message) {
        if (this.handleCustom(t, mxc, message) && this.handleCustomRX(t, mxc, message)) {
            this.reportRX(t, t.toString(), mxc);
        }
    }

    @Override
    public void handleTXThrowable(Throwable t, MessageXC mxc, ClusterMessage message) {
        if (this.handleCustom(t, mxc, message) && this.handleCustomTX(t, mxc, message)) {
            this.reportTX(t, t.toString(), mxc);
        }
    }

    public void silence() {
        this.silence(true);
    }

    public void silence(boolean s) {
        this.isQuiet.set(s);
    }
}

