/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.data;

import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.data.DataChunk;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class FileChunk
extends DataChunk<String> {
    private static final long serialVersionUID = -8641288090205214129L;
    private final String fileName;
    private final boolean doAppend;

    public FileChunk(String path) {
        File f = new File(path);
        this.fileName = FijiArchipelago.truncateFileRoot(f.getAbsolutePath());
        this.doAppend = !this.fileName.equals(f.getAbsolutePath());
    }

    public FileChunk(String path, DataChunk oldChunk) {
        super(oldChunk);
        File f = new File(path);
        this.fileName = FijiArchipelago.truncateFileRoot(f.getAbsolutePath());
        this.doAppend = !this.fileName.equals(f.getAbsolutePath());
    }

    @Override
    public String getData() {
        return this.doAppend ? FijiArchipelago.getFileRoot() + this.fileName : this.fileName;
    }

    public Iterator<DataChunk<String>> iterator() {
        return new ArrayList().iterator();
    }

    public boolean equals(Object o) {
        return o instanceof FileChunk && ((FileChunk)o).fileName.equals(this.fileName);
    }

    public String toString() {
        return this.getData();
    }

    public int hashCode() {
        return this.fileName.hashCode();
    }
}

