/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij3d.Volume;
import ini.trakem2.utils.ImgLibVolume;
import ini.trakem2.utils.MCCube;
import isosurface.Triangulator;
import java.util.List;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;
import org.jogamp.vecmath.Point3f;
import vib.NaiveResampler;

public class MCTriangulator
implements Triangulator {
    public List getTriangles(ImagePlus image, int threshold, boolean[] channels, int resamplingF) {
        if (resamplingF != 1) {
            image = NaiveResampler.resample((ImagePlus)image, (int)resamplingF);
        }
        Volume volume = new Volume(image, channels);
        volume.setAverage(true);
        List<Point3f> l = MCCube.getTriangles(volume, threshold);
        return l;
    }

    public <T extends RealType<T>> List<Point3f> getTriangles(Image<T> img, int threshold, float[] origin) throws Exception {
        return MCCube.getTriangles(new ImgLibVolume<T>(img, origin), threshold);
    }

    public static void zeroPad(ImagePlus imp) {
        ImageStack stack = imp.getStack();
        int w = stack.getWidth();
        int h = stack.getHeight();
        int d = stack.getSize();
        int type = imp.getType();
        ImageStack st = new ImageStack(w + 2, h + 2);
        ImageProcessor old = stack.getProcessor(1);
        ImageProcessor ne = MCTriangulator.createProcessor(w + 2, h + 2, type);
        st.addSlice("", ne);
        for (int z = 0; z < d; ++z) {
            old = stack.getProcessor(z + 1);
            ne = MCTriangulator.createProcessor(w + 2, h + 2, type);
            ne.insert(old, 1, 1);
            st.addSlice(Integer.toString(z + 1), ne);
        }
        ne = MCTriangulator.createProcessor(w + 2, h + 2, type);
        st.addSlice(Integer.toString(d + 1), ne);
        imp.setStack(null, st);
        Calibration cal = imp.getCalibration();
        cal.xOrigin -= cal.pixelWidth;
        cal.yOrigin -= cal.pixelHeight;
        cal.zOrigin -= cal.pixelDepth;
        imp.setCalibration(cal);
    }

    private static final ImageProcessor createProcessor(int w, int h, int type) {
        if (type == 4) {
            return new ColorProcessor(w, h);
        }
        return new ByteProcessor(w, h);
    }
}

