/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging;

import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Patch;
import ini.trakem2.imaging.PhaseCorrelationCalculator;
import ini.trakem2.persistence.Loader;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mpi.fruitfly.math.datastructures.FloatArray2D;
import mpi.fruitfly.registration.CrossCorrelation2D;
import mpi.fruitfly.registration.ImageFilter;
import mpicbg.imglib.algorithm.fft.PhaseCorrelationPeak;
import mpicbg.models.Affine2D;
import mpicbg.models.ErrorStatistic;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.Tile;
import mpicbg.models.TranslationModel2D;
import mpicbg.trakem2.align.AbstractAffineTile2D;
import mpicbg.trakem2.align.Align;
import mpicbg.trakem2.align.AlignTask;
import mpicbg.trakem2.align.TranslationTile2D;

public class StitchingTEM {
    public static final int WORKING = -1;
    public static final int DONE = 0;
    public static final int ERROR = 1;
    public static final int INTERRUPTED = 2;
    public static final int SUCCESS = 3;
    public static final int TOP_BOTTOM = 4;
    public static final int LEFT_RIGHT = 5;
    public static final float DEFAULT_MIN_R = 0.4f;

    public static Runnable stitch(Patch[] patch, int grid_width, double default_bottom_top_overlap, double default_left_right_overlap, boolean optimize, PhaseCorrelationParam param) {
        if (null == patch || grid_width < 1) {
            return null;
        }
        if (patch.length < 2) {
            return null;
        }
        if (null == param) {
            param = new PhaseCorrelationParam();
            param.setup(patch[0]);
        }
        Rectangle b0 = patch[0].getBoundingBox(null);
        for (int i = 1; i < patch.length; ++i) {
            Rectangle bi = patch[i].getBoundingBox(null);
            if (bi.width == b0.width && bi.height == b0.height) continue;
            Utils.log2("Stitching: dimensions' missmatch.\n\tAll images MUST have the same dimensions.");
            return null;
        }
        Utils.log2("patch layer: " + patch[0].getLayer());
        patch[0].getLayerSet().addTransformStep(patch[0].getLayer());
        return StitchingTEM.stitchTopLeft(patch, grid_width, default_bottom_top_overlap, default_left_right_overlap, optimize, param);
    }

    private static Runnable stitchTopLeft(final Patch[] patch, final int grid_width, final double default_bottom_top_overlap, final double default_left_right_overlap, final boolean optimize, final PhaseCorrelationParam param) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    boolean LEFT = false;
                    boolean TOP = true;
                    int prev_i = 0;
                    boolean prev = false;
                    double[] R1 = null;
                    double[] R2 = null;
                    ArrayList al_tiles = new ArrayList();
                    TranslationModel2D first_tile_model = new TranslationModel2D();
                    first_tile_model.set((double)((float)patch[0].getAffineTransform().getTranslateX()), (double)((float)patch[0].getAffineTransform().getTranslateY()));
                    al_tiles.add(new TranslationTile2D(first_tile_model, patch[0]));
                    for (int i = 1; i < patch.length; ++i) {
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        double default_dx = default_left_right_overlap;
                        double default_dy = default_bottom_top_overlap;
                        AbstractAffineTile2D<?> tile_left = null;
                        AbstractAffineTile2D<?> tile_top = null;
                        TranslationModel2D tile_model = new TranslationModel2D();
                        tile_model.set((double)((float)patch[i].getAffineTransform().getTranslateX()), (double)((float)patch[i].getAffineTransform().getTranslateY()));
                        TranslationTile2D tile = new TranslationTile2D(tile_model, patch[i]);
                        al_tiles.add(tile);
                        if (0 == i % grid_width) {
                            prev_i = i - grid_width;
                            prev = true;
                        } else {
                            prev_i = i - 1;
                            prev = false;
                        }
                        if (prev) {
                            R1 = StitchingTEM.correlate(patch[prev_i], patch[i], param.overlap, param.cc_scale, 4, default_dx, default_dy, param.min_R);
                            R2 = null;
                            tile_top = al_tiles.get(i - grid_width);
                        } else {
                            R2 = StitchingTEM.correlate(patch[prev_i], patch[i], param.overlap, param.cc_scale, 5, default_dx, default_dy, param.min_R);
                            tile_left = al_tiles.get(i - 1);
                            if (i - grid_width > -1) {
                                R1 = StitchingTEM.correlate(patch[i - grid_width], patch[i], param.overlap, param.cc_scale, 4, default_dx, default_dy, param.min_R);
                                tile_top = al_tiles.get(i - grid_width);
                            } else {
                                R1 = null;
                            }
                        }
                        Rectangle box = new Rectangle();
                        Rectangle box2 = new Rectangle();
                        if (prev) {
                            if (3.0 == R1[2]) {
                                if (optimize) {
                                    StitchingTEM.addMatches(tile_top, tile, R1[0], R1[1]);
                                } else {
                                    patch[i - grid_width].getBoundingBox(box);
                                    patch[i].setLocation((double)box.x + R1[0], (double)box.y + R1[1]);
                                }
                            } else {
                                Rectangle b2 = patch[i - grid_width].getBoundingBox(null);
                                if (optimize) {
                                    StitchingTEM.addMatches(tile_top, tile, 0.0, (double)b2.height - default_bottom_top_overlap);
                                } else {
                                    patch[i - grid_width].getBoundingBox(box);
                                    patch[i].setLocation(box.x, (double)(box.y + b2.height) - default_bottom_top_overlap);
                                }
                            }
                        } else if (i - grid_width > -1) {
                            if (3.0 == R1[2]) {
                                if (3.0 == R2[2]) {
                                    if (optimize) {
                                        StitchingTEM.addMatches(tile_left, tile, R2[0], R2[1]);
                                        StitchingTEM.addMatches(tile_top, tile, R1[0], R1[1]);
                                    } else {
                                        patch[i - 1].getBoundingBox(box);
                                        patch[i - grid_width].getBoundingBox(box2);
                                        patch[i].setLocation(((double)box.x + R1[0] + (double)box2.x + R2[0]) / 2.0, ((double)box.y + R1[1] + (double)box2.y + R2[1]) / 2.0);
                                    }
                                } else if (optimize) {
                                    StitchingTEM.addMatches(tile_top, tile, R1[0], R1[1]);
                                } else {
                                    patch[i - grid_width].getBoundingBox(box);
                                    patch[i].setLocation((double)box.x + R1[0], (double)box.y + R1[1]);
                                }
                            } else if (3.0 == R2[2]) {
                                if (optimize) {
                                    StitchingTEM.addMatches(tile_left, tile, R2[0], R2[1]);
                                } else {
                                    patch[i - 1].getBoundingBox(box);
                                    patch[i].setLocation((double)box.x + R2[0], (double)box.y + R2[1]);
                                }
                            } else {
                                patch[prev_i].getBoundingBox(box);
                                patch[i - grid_width].getBoundingBox(box2);
                                if (optimize) {
                                    StitchingTEM.addMatches(tile_left, tile, (double)box.width - default_left_right_overlap, 0.0);
                                    StitchingTEM.addMatches(tile_top, tile, 0.0, (double)box2.height - default_bottom_top_overlap);
                                } else {
                                    patch[i].setLocation((double)(box.x + box.width) - default_left_right_overlap, (double)(box2.y + box2.height) - default_bottom_top_overlap);
                                }
                            }
                        } else if (3.0 == R2[2]) {
                            if (optimize) {
                                StitchingTEM.addMatches(tile_left, tile, R2[0], R2[1]);
                            } else {
                                patch[i - 1].getBoundingBox(box);
                                patch[i].setLocation((double)box.x + R2[0], (double)box.y + R2[1]);
                            }
                        } else {
                            patch[prev_i].getBoundingBox(box);
                            if (optimize) {
                                StitchingTEM.addMatches(tile_left, tile, (double)box.width - default_left_right_overlap, 0.0);
                            } else {
                                patch[i].setLocation((double)(box.x + box.width) - default_left_right_overlap, box.y);
                            }
                        }
                        if (!optimize) {
                            Display.repaint(patch[i].getLayer(), (Displayable)patch[i], null, 0, false);
                        }
                        Utils.log2(i + ": Done patch " + patch[i]);
                    }
                    if (optimize) {
                        ArrayList al_fixed_tiles = new ArrayList();
                        for (int i = 0; i < patch.length; ++i) {
                            if (!patch[i].isLocked2()) continue;
                            al_fixed_tiles.add(al_tiles.get(i));
                        }
                        if (al_fixed_tiles.isEmpty()) {
                            al_fixed_tiles.add((AbstractAffineTile2D<?>)((Object)al_tiles.get(0)));
                        }
                        StitchingTEM.optimizeTileConfiguration(al_tiles, al_fixed_tiles, param);
                        for (AbstractAffineTile2D<?> t : al_tiles) {
                            t.getPatch().setAffineTransform(((Affine2D)t.getModel()).createAffine());
                        }
                    }
                    if (param.hide_disconnected || param.remove_disconnected) {
                        ArrayList graphs = AbstractAffineTile2D.identifyConnectedGraphs(al_tiles);
                        Set largestGraph = null;
                        for (Set set : graphs) {
                            if (largestGraph != null && largestGraph.size() >= set.size()) continue;
                            largestGraph = set;
                        }
                        Utils.log("Size of largest stitching graph = " + largestGraph.size());
                        ArrayList<AbstractAffineTile2D> interestingTiles = new ArrayList<AbstractAffineTile2D>();
                        for (Tile tile : largestGraph) {
                            interestingTiles.add((AbstractAffineTile2D)tile);
                        }
                        if (param.hide_disconnected) {
                            for (AbstractAffineTile2D abstractAffineTile2D : al_tiles) {
                                if (interestingTiles.contains((Object)abstractAffineTile2D)) continue;
                                abstractAffineTile2D.getPatch().setVisible(false);
                            }
                        }
                        if (param.remove_disconnected) {
                            for (AbstractAffineTile2D abstractAffineTile2D : al_tiles) {
                                if (interestingTiles.contains((Object)abstractAffineTile2D)) continue;
                                abstractAffineTile2D.getPatch().remove(false);
                            }
                        }
                    }
                    Display.repaint(patch[0].getLayer(), null, 0, true);
                }
                catch (Exception e) {
                    IJError.print(e);
                }
            }
        };
    }

    private static final void addMatches(AbstractAffineTile2D<?> t1, AbstractAffineTile2D<?> t2, double dx, double dy) {
        Point p1 = new Point(new double[]{0.0, 0.0});
        Point p2 = new Point(new double[]{dx, dy});
        t1.addMatch(new PointMatch(p2, p1, 1.0));
        t2.addMatch(new PointMatch(p1, p2, 1.0));
        t1.addConnectedTile(t2);
        t2.addConnectedTile(t1);
    }

    public static ImageProcessor makeStripe(Patch p, Roi roi, double scale) {
        return StitchingTEM.makeStripe(p, roi, scale, false);
    }

    public static ImageProcessor makeStripe(Patch p, Roi roi, double scale, boolean ignore_patch_transform) {
        ImagePlus imp = null;
        ImageProcessor ip = null;
        Loader loader = p.getProject().getLoader();
        if (loader.isMipMapsRegenerationEnabled() && loader.checkMipMapFileExists(p, scale)) {
            Patch.PatchImage pai = p.createTransformedImage();
            pai.target.setMinAndMax(p.getMin(), p.getMax());
            Image image = pai.target.createImage();
            if (Math.abs((double)p.getWidth() * scale - (double)image.getWidth(null)) > 0.001 || Math.abs((double)p.getHeight() * scale - (double)image.getHeight(null)) > 0.001) {
                image = image.getScaledInstance((int)((double)p.getWidth() * scale), (int)((double)p.getHeight() * scale), 16);
            }
            try {
                imp = new ImagePlus("s", image);
                ip = imp.getProcessor();
            }
            catch (Exception e) {
                IJError.print(e);
            }
            if (null != roi) {
                Rectangle rb = roi.getBounds();
                Roi roi2 = new Roi((int)((double)rb.x * scale), (int)((double)rb.y * scale), (int)((double)rb.width * scale), (int)((double)rb.height * scale));
                rb = roi2.getBounds();
                if (ip.getWidth() != rb.width || ip.getHeight() != rb.height) {
                    ip.setRoi(roi2);
                    ip = ip.crop();
                }
            }
        } else {
            Patch.PatchImage pai = p.createTransformedImage();
            pai.target.setMinAndMax(p.getMin(), p.getMax());
            ip = pai.target;
            imp = new ImagePlus("", ip);
            if (!ignore_patch_transform && p.getAffineTransform().getType() != 1) {
                Rectangle b = p.getBoundingBox();
                ip = ip.resize(b.width, b.height);
            }
            if (null != roi) {
                Rectangle rb = roi.getBounds();
                if (ip.getWidth() != rb.width || ip.getHeight() != rb.height) {
                    ip.setRoi(roi);
                    ip = ip.crop();
                }
            }
            if (scale < 1.0) {
                p.getProject().getLoader().releaseToFit((long)((double)(ip.getWidth() * ip.getHeight() * 4) * 1.2));
                ip = ip.convertToFloat();
                ip.setPixels((Object)ImageFilter.computeGaussianFastMirror((FloatArray2D)new FloatArray2D((float[])((float[])ip.getPixels()), (int)ip.getWidth(), (int)ip.getHeight()), (double)Math.sqrt((double)(0.25 / scale / scale - 0.25))).data);
                ip = ip.resize((int)((double)ip.getWidth() * scale));
            }
        }
        if (imp.getType() != 2) {
            return ip.convertToFloat();
        }
        return ip;
    }

    public static double[] correlate(Patch base, Patch moving, float percent_overlap, double scale, int direction, double default_dx, double default_dy, double min_R) {
        ImageProcessor ip2;
        ImageProcessor ip1;
        double R = -2.0;
        Rectangle b1 = base.getBoundingBox(null);
        Rectangle b2 = moving.getBoundingBox(null);
        int w1 = b1.width;
        int h1 = b1.height;
        int w2 = b2.width;
        int h2 = b2.height;
        Roi roi1 = null;
        Roi roi2 = null;
        float overlap = percent_overlap;
        double dx = default_dx;
        double dy = default_dy;
        do {
            switch (direction) {
                case 4: {
                    roi1 = new Roi(0, h1 - (int)((float)h1 * overlap), w1, (int)((float)h1 * overlap));
                    roi2 = new Roi(0, 0, w2, (int)((float)h2 * overlap));
                    break;
                }
                case 5: {
                    roi1 = new Roi(w1 - (int)((float)w1 * overlap), 0, (int)((float)w1 * overlap), h1);
                    roi2 = new Roi(0, 0, (int)((float)w2 * overlap), h2);
                }
            }
            ip1 = StitchingTEM.makeStripe(base, roi1, scale);
            ip2 = StitchingTEM.makeStripe(moving, roi2, scale);
            ip1.setPixels((Object)ImageFilter.computeGaussianFastMirror((FloatArray2D)new FloatArray2D((float[])((float[])ip1.getPixels()), (int)ip1.getWidth(), (int)ip1.getHeight()), (double)1.0).data);
            ip2.setPixels((Object)ImageFilter.computeGaussianFastMirror((FloatArray2D)new FloatArray2D((float[])((float[])ip2.getPixels()), (int)ip2.getWidth(), (int)ip2.getHeight()), (double)1.0).data);
            ImagePlus imp1 = new ImagePlus("", ip1);
            ImagePlus imp2 = new ImagePlus("", ip2);
            PhaseCorrelationCalculator t = new PhaseCorrelationCalculator(imp1, imp2);
            PhaseCorrelationPeak peak = t.getPeak();
            double resultR = peak.getCrossCorrelationPeak();
            int[] peackPostion = peak.getPosition();
            java.awt.Point shift = new java.awt.Point(peackPostion[0], peackPostion[1]);
            if (resultR >= min_R) {
                int success = 3;
                switch (direction) {
                    case 4: {
                        dx = (double)shift.x / scale;
                        dy = (double)roi1.getBounds().y + (double)shift.y / scale;
                        break;
                    }
                    case 5: {
                        dx = (double)roi1.getBounds().x + (double)shift.x / scale;
                        dy = (double)shift.y / scale;
                    }
                }
                return new double[]{dx, dy, 3.0, resultR};
            }
            overlap = (float)((double)overlap + 0.1);
        } while (-2.0 < min_R && Math.abs(overlap - 1.0f) < 0.001f);
        overlap = percent_overlap * 2.0f;
        if (overlap > 1.0f) {
            overlap = 1.0f;
        }
        switch (direction) {
            case 4: {
                roi1 = new Roi(0, h1 - (int)((float)h1 * overlap), w1, (int)((float)h1 * overlap));
                roi2 = new Roi(0, 0, w2, (int)((float)h2 * overlap));
                break;
            }
            case 5: {
                roi1 = new Roi(w1 - (int)((float)w1 * overlap), 0, (int)((float)w1 * overlap), h1);
                roi2 = new Roi(0, 0, (int)((float)w2 * overlap), h2);
            }
        }
        double scale_cc = scale / 3.0;
        ip1 = StitchingTEM.makeStripe(base, roi1, scale_cc);
        ip2 = StitchingTEM.makeStripe(moving, roi2, scale_cc);
        ip1.setPixels((Object)ImageFilter.computeGaussianFastMirror((FloatArray2D)new FloatArray2D((float[])((float[])ip1.getPixels()), (int)ip1.getWidth(), (int)ip1.getHeight()), (double)1.0).data);
        ip2.setPixels((Object)ImageFilter.computeGaussianFastMirror((FloatArray2D)new FloatArray2D((float[])((float[])ip2.getPixels()), (int)ip2.getWidth(), (int)ip2.getHeight()), (double)1.0).data);
        CrossCorrelation2D cc = new CrossCorrelation2D(ip1, ip2, false);
        double[] cc_result = null;
        switch (direction) {
            case 4: {
                cc_result = cc.computeCrossCorrelationMT(0.9, 0.3, false);
                break;
            }
            case 5: {
                cc_result = cc.computeCrossCorrelationMT(0.3, 0.9, false);
            }
        }
        if (cc_result[2] > min_R / 2.0) {
            int success = 3;
            switch (direction) {
                case 4: {
                    dx = cc_result[0] / scale_cc;
                    dy = (double)roi1.getBounds().y + cc_result[1] / scale_cc;
                    break;
                }
                case 5: {
                    dx = (double)roi1.getBounds().x + cc_result[0] / scale_cc;
                    dy = cc_result[1] / scale_cc;
                }
            }
            return new double[]{dx, dy, 3.0, cc_result[2]};
        }
        return new double[]{default_dx, default_dy, 1.0, 0.0};
    }

    private static int getClosestOverlapLocation(Patch dragging_ob, Patch overlapping_ob) {
        Rectangle x_rect = dragging_ob.getBoundingBox();
        Rectangle y_rect = overlapping_ob.getBoundingBox();
        Rectangle overlap = x_rect.intersection(y_rect);
        if ((double)overlap.width / (double)overlap.height > 1.0) {
            if (y_rect.y < x_rect.y) {
                return 3;
            }
            return 1;
        }
        if (y_rect.x < x_rect.x) {
            return 2;
        }
        return 0;
    }

    public static Bureaucrat montageWithPhaseCorrelationTask(final Collection<Patch> col) {
        if (null == col || col.size() < 1) {
            return null;
        }
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Montage with phase-correlation"){

            @Override
            public void exec() {
                StitchingTEM.montageWithPhaseCorrelation(col);
            }
        }, col.iterator().next().getProject());
    }

    public static void montageWithPhaseCorrelation(final Collection<Patch> col) {
        final PhaseCorrelationParam param = new PhaseCorrelationParam();
        if (!param.setup(col.iterator().next())) {
            return;
        }
        AlignTask.transformPatchesAndVectorData(col, new Runnable(){

            @Override
            public void run() {
                StitchingTEM.montageWithPhaseCorrelation(col, param);
            }
        });
    }

    public static Bureaucrat montageWithPhaseCorrelationTask(final List<Layer> layers) {
        if (null == layers || layers.size() < 1) {
            return null;
        }
        return Bureaucrat.createAndStart((Worker)new Worker.Task("Montage layer 1/" + layers.size()){

            @Override
            public void exec() {
                StitchingTEM.montageWithPhaseCorrelation(layers, this);
            }
        }, layers.get(0).getProject());
    }

    public static void montageWithPhaseCorrelation(List<Layer> layers, Worker worker) {
        final PhaseCorrelationParam param = new PhaseCorrelationParam();
        ArrayList<Displayable> col = layers.get(0).getDisplayables(Patch.class);
        if (!param.setup(col.size() > 0 ? (Patch)col.iterator().next() : null)) {
            return;
        }
        boolean i = true;
        for (Layer la : layers) {
            if (Thread.currentThread().isInterrupted() || null != worker && worker.hasQuitted()) {
                return;
            }
            if (null != worker) {
                worker.setTaskName("Montage layer 1/" + layers.size());
            }
            final ArrayList<Displayable> patches = la.getDisplayables(Patch.class);
            AlignTask.transformPatchesAndVectorData(patches, new Runnable(){

                @Override
                public void run() {
                    StitchingTEM.montageWithPhaseCorrelation(patches, param);
                }
            });
        }
    }

    public static void montageWithPhaseCorrelation(Collection<Patch> col, PhaseCorrelationParam param) {
        float overlap;
        if (null == col || col.size() < 1) {
            return;
        }
        ArrayList<Patch> al = new ArrayList<Patch>(col);
        ArrayList tiles = new ArrayList();
        ArrayList fixed_tiles = new ArrayList();
        for (Patch p : al) {
            int aff_type = p.getAffineTransform().getType();
            switch (p.getAffineTransform().getType()) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    Utils.log2("WARNING: patch with a non-translation transform: " + p);
                }
            }
            TranslationTile2D tile = new TranslationTile2D(new TranslationModel2D(), p);
            tiles.add(tile);
            if (!p.isLocked2()) continue;
            Utils.log("Added fixed (locked) tile " + p);
            fixed_tiles.add(tile);
        }
        double cc_scale = param.cc_scale;
        if (cc_scale < 0.0 || cc_scale > 1.0) {
            Utils.log("Unacceptable cc_scale of " + param.cc_scale + ". Using 1 instead.");
            cc_scale = 1.0;
        }
        if ((overlap = param.overlap) < 0.0f || overlap > 1.0f) {
            Utils.log("Unacceptable overlap of " + param.overlap + ". Using 1 instead.");
            overlap = 1.0f;
        }
        for (int i = 0; i < al.size(); ++i) {
            Patch p1 = al.get(i);
            Rectangle r1 = p1.getBoundingBox();
            block13: for (int j = i + 1; j < al.size(); ++j) {
                double[] R;
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                Patch p2 = al.get(j);
                Rectangle r2 = p2.getBoundingBox();
                if (!r1.intersects(r2)) continue;
                int dx = Math.abs(r1.x - r2.x);
                int dy = Math.abs(r1.y - r2.y);
                if (dx > r1.width / 2 && dy > r1.height / 2) {
                    Utils.log2("Skipping diagonal overlap between " + p1 + " and " + p2);
                    continue;
                }
                p1.getProject().getLoader().releaseToFit((long)(p1.getWidth() * p1.getHeight() * 25.0f));
                if (1.0f == overlap) {
                    R = StitchingTEM.correlate(p1, p2, overlap, cc_scale, 4, 0.0, 0.0, param.min_R);
                    if (3.0 != R[2]) continue;
                    StitchingTEM.addMatches(tiles.get(i), tiles.get(j), R[0], R[1]);
                    continue;
                }
                switch (StitchingTEM.getClosestOverlapLocation(p1, p2)) {
                    case 0: {
                        R = StitchingTEM.correlate(p1, p2, overlap, cc_scale, 5, 0.0, 0.0, param.min_R);
                        if (3.0 != R[2]) continue block13;
                        StitchingTEM.addMatches(tiles.get(i), tiles.get(j), R[0], R[1]);
                        continue block13;
                    }
                    case 1: {
                        R = StitchingTEM.correlate(p1, p2, overlap, cc_scale, 4, 0.0, 0.0, param.min_R);
                        if (3.0 != R[2]) continue block13;
                        StitchingTEM.addMatches(tiles.get(i), tiles.get(j), R[0], R[1]);
                        continue block13;
                    }
                    case 2: {
                        R = StitchingTEM.correlate(p2, p1, overlap, cc_scale, 5, 0.0, 0.0, param.min_R);
                        if (3.0 != R[2]) continue block13;
                        StitchingTEM.addMatches(tiles.get(j), tiles.get(i), R[0], R[1]);
                        continue block13;
                    }
                    case 3: {
                        R = StitchingTEM.correlate(p2, p1, overlap, cc_scale, 4, 0.0, 0.0, param.min_R);
                        if (3.0 != R[2]) continue block13;
                        StitchingTEM.addMatches(tiles.get(j), tiles.get(i), R[0], R[1]);
                        continue block13;
                    }
                    default: {
                        Utils.log("Unknown overlap direction!");
                        continue block13;
                    }
                }
            }
        }
        if (param.remove_disconnected || param.hide_disconnected) {
            Iterator it = tiles.iterator();
            while (it.hasNext()) {
                AbstractAffineTile2D<?> t = (AbstractAffineTile2D<?>)((Object)it.next());
                if (null == t.getMatches() || !t.getMatches().isEmpty()) continue;
                if (param.hide_disconnected) {
                    t.getPatch().setVisible(false);
                } else if (param.remove_disconnected) {
                    t.getPatch().remove(false);
                }
                it.remove();
            }
        }
        StitchingTEM.optimizeTileConfiguration(tiles, fixed_tiles, param);
        for (AbstractAffineTile2D<?> t : tiles) {
            t.getPatch().setAffineTransform(((Affine2D)t.getModel()).createAffine());
        }
        try {
            Display.repaint(al.get(0).getLayer());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void optimizeTileConfiguration(ArrayList<AbstractAffineTile2D<?>> tiles, ArrayList<AbstractAffineTile2D<?>> fixed_tiles, PhaseCorrelationParam param) {
        if (fixed_tiles.isEmpty()) {
            fixed_tiles.add(tiles.get(0));
        }
        boolean proceed = true;
        block0: while (proceed) {
            Align.optimizeTileConfiguration(new Align.ParamOptimize(), tiles, fixed_tiles);
            ErrorStatistic e = new ErrorStatistic(tiles.size() + 1);
            for (AbstractAffineTile2D<?> t : tiles) {
                t.update();
            }
            for (AbstractAffineTile2D<?> t : tiles) {
                for (PointMatch p : t.getMatches()) {
                    e.add(p.getDistance());
                }
            }
            if (e.max > param.mean_factor * e.mean) {
                for (AbstractAffineTile2D<?> t : tiles) {
                    for (PointMatch p : t.getMatches()) {
                        if (!(p.getDistance() >= e.max)) continue;
                        Tile o = t.findConnectedTile(p);
                        t.removeConnectedTile(o);
                        o.removeConnectedTile(t);
                        continue block0;
                    }
                }
                continue;
            }
            proceed = false;
        }
    }

    public static class PhaseCorrelationParam {
        public double cc_scale = 0.25;
        public float overlap = 0.1f;
        public boolean hide_disconnected = false;
        public boolean remove_disconnected = false;
        public double mean_factor = 2.5;
        public double min_R = 0.3;

        public PhaseCorrelationParam(double cc_scale, float overlap, boolean hide_disconnected, boolean remove_disconnected, double mean_factor, double min_R) {
            this.cc_scale = cc_scale;
            this.overlap = overlap;
            this.hide_disconnected = hide_disconnected;
            this.remove_disconnected = remove_disconnected;
            this.mean_factor = mean_factor;
            this.min_R = min_R;
        }

        public PhaseCorrelationParam() {
        }

        public boolean setup(Layer layer) {
            ArrayList<Displayable> p = layer.getDisplayables(Patch.class);
            Patch patch = p.isEmpty() ? null : (Patch)p.iterator().next();
            return this.setup(patch);
        }

        public boolean setup(Patch ref) {
            GenericDialog gd = new GenericDialog("Montage with phase correlation");
            if (this.overlap < 0.0f) {
                this.overlap = 0.1f;
            } else if (this.overlap > 1.0f) {
                this.overlap = 1.0f;
            }
            gd.addSlider("tile_overlap (%): ", 1.0, 100.0, (double)(this.overlap * 100.0f));
            int sc = (int)this.cc_scale * 100;
            if (null != ref) {
                int h;
                int w = ref.getOWidth();
                sc = (int)(512.0 / (double)(w > (h = ref.getOHeight()) ? w : h) * 100.0);
            }
            if (sc <= 0) {
                sc = 25;
            } else if (sc > 100) {
                sc = 100;
            }
            gd.addSlider("scale (%):", 1.0, 100.0, (double)sc);
            gd.addNumericField("max/avg displacement threshold: ", this.mean_factor, 2);
            gd.addNumericField("regression threshold (R):", this.min_R, 2);
            gd.addCheckbox("hide disconnected", false);
            gd.addCheckbox("remove disconnected", false);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            this.overlap = (float)gd.getNextNumber() / 100.0f;
            this.cc_scale = gd.getNextNumber() / 100.0;
            this.mean_factor = gd.getNextNumber();
            this.min_R = gd.getNextNumber();
            this.hide_disconnected = gd.getNextBoolean();
            this.remove_disconnected = gd.getNextBoolean();
            return true;
        }
    }
}

