/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.Wand;
import ij.plugin.WandToolOptions;
import ij.process.ImageProcessor;
import ini.trakem2.display.AreaContainer;
import ini.trakem2.display.AreaWrapper;
import ini.trakem2.display.Display;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Patch;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.OptionPanel;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import levelsets.algorithm.Coordinate;
import levelsets.algorithm.FastMarching;
import levelsets.ij.ImageContainer;
import levelsets.ij.StateContainer;
import plugin.Lasso;

public class Segmentation {
    public static final FastMarchingParam fmp = new FastMarchingParam();

    public static Bureaucrat fastMarching(AreaWrapper aw, Layer layer, Rectangle srcRect, int x_p_w, int y_p_w, Runnable post_task) {
        return Segmentation.fastMarching(aw, layer, srcRect, x_p_w, y_p_w, Arrays.asList(post_task));
    }

    public static Bureaucrat fastMarching(final AreaWrapper aw, final Layer layer, final Rectangle srcRect, final int x_p_w, final int y_p_w, List<Runnable> post_tasks) {
        final AreaContainer ac = (AreaContainer)((Object)aw.getSource());
        final AffineTransform source_aff = aw.getSource().getAffineTransform();
        final Rectangle box = new Rectangle(x_p_w - Segmentation.fmp.width / 2, y_p_w - Segmentation.fmp.height / 2, Segmentation.fmp.width, Segmentation.fmp.height);
        Bureaucrat burro = Bureaucrat.create((Worker)new Worker.Task("Fast marching"){

            @Override
            public void exec() {
                Utils.log2("fmp box is " + box);
                ImagePlus imp = new ImagePlus("", Patch.makeFlatImage(0, layer, box, 1.0, layer.getDisplayables(Patch.class, new Area(box), true), Color.black));
                if (Segmentation.fmp.apply_bandpass_filter) {
                    IJ.run((ImagePlus)imp, (String)"Bandpass Filter...", (String)("filter_large=" + Segmentation.fmp.low_frequency_threshold + " filter_small=" + Segmentation.fmp.high_frequency_threshold + " suppress=None tolerance=5" + (Segmentation.fmp.autoscale_after_filtering ? " autoscale" : "") + (Segmentation.fmp.saturate_when_autoscaling ? " saturate" : "")));
                }
                PointRoi roi = new PointRoi(box.width / 2, box.height / 2);
                imp.setRoi((Roi)roi);
                Utils.log2("imp: " + imp);
                Utils.log2("proi: " + imp.getRoi() + "    " + Utils.toString(new int[]{x_p_w - srcRect.x, y_p_w - srcRect.y}));
                ImageContainer ic = new ImageContainer(imp);
                StateContainer state = new StateContainer();
                state.setROI((Roi)roi, ic.getWidth(), ic.getHeight(), ic.getImageCount(), imp.getCurrentSlice());
                state.setExpansionToInside(false);
                FastMarching fm = new FastMarching(ic, null, state, true, Segmentation.fmp.fm_grey, Segmentation.fmp.fm_dist, Segmentation.fmp.apply_grey_value_erosion);
                int max_iterations = Segmentation.fmp.max_iterations;
                int iter_inc = Segmentation.fmp.iter_inc;
                for (int i = 0; i < max_iterations; ++i) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    if (!fm.step(iter_inc)) break;
                }
                this.setTaskName("Adding area");
                ArrayList vc = fm.getStateContainer().getXYZ(false);
                if (0 == vc.size()) {
                    Utils.log("No area growth.");
                    return;
                }
                Area area = new Area();
                Coordinate first = (Coordinate)vc.remove(0);
                Rectangle r = new Rectangle(first.x, first.y, 1, 1);
                int count = 0;
                for (Coordinate c : vc) {
                    ++count;
                    if (c.y == r.y && c.x == r.x + 1) {
                        ++r.width;
                        continue;
                    }
                    area.add(new Area(r));
                    r.x = c.x;
                    r.y = c.y;
                    r.width = 1;
                    if (0 != count % 1024 || !Thread.currentThread().isInterrupted()) continue;
                    return;
                }
                area.add(new Area(r));
                AffineTransform aff = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, box.x, box.y);
                try {
                    aff.preConcatenate(source_aff.createInverse());
                }
                catch (NoninvertibleTransformException nite) {
                    IJError.print(nite);
                    return;
                }
                aw.getArea().add(area.createTransformedArea(aff));
                ac.calculateBoundingBox(layer);
                Display.repaint(layer);
            }
        }, layer.getProject());
        if (null != post_tasks) {
            for (Runnable task : post_tasks) {
                burro.addPostTask(task);
            }
        }
        burro.goHaveBreakfast();
        return burro;
    }

    public static BlowCommander blowRoi(AreaWrapper aw, Layer layer, Rectangle srcRect, int x_p_w, int y_p_w, Runnable post_task) throws Exception {
        return new BlowCommander(aw, layer, srcRect, x_p_w, y_p_w, Arrays.asList(post_task));
    }

    public static BlowCommander blowRoi(AreaWrapper aw, Layer layer, Rectangle srcRect, int x_p_w, int y_p_w, List<Runnable> post_tasks) throws Exception {
        return new BlowCommander(aw, layer, srcRect, x_p_w, y_p_w, post_tasks);
    }

    public static Bureaucrat magicWand(AreaWrapper aw, Layer layer, Rectangle srcRect, int x_p_w, int y_p_w, Runnable post_task, boolean inverse, boolean subtract) {
        return Segmentation.magicWand(aw, layer, srcRect, x_p_w, y_p_w, Arrays.asList(post_task), inverse, subtract);
    }

    public static Bureaucrat magicWand(final AreaWrapper aw, final Layer layer, Rectangle srcRect, int x_p_w, int y_p_w, List<Runnable> post_tasks, final boolean inverse, final boolean subtract) {
        final AreaContainer ac = (AreaContainer)((Object)aw.getSource());
        final AffineTransform source_aff = aw.getSource().getAffineTransform();
        final Rectangle box = new Rectangle(x_p_w - Segmentation.fmp.width / 2, y_p_w - Segmentation.fmp.height / 2, Segmentation.fmp.width, Segmentation.fmp.height);
        Bureaucrat burro = Bureaucrat.create((Worker)new Worker.Task("Magic Wand"){

            @Override
            public void exec() {
                Utils.log2("fmp box is " + box);
                ImageProcessor ip = Patch.makeFlatImage(0, layer, box, 1.0, layer.getDisplayables(Patch.class, new Area(box), true), Color.black);
                Wand wand = new Wand(ip);
                String smode = WandToolOptions.getMode();
                int mode = 1;
                if (null != smode) {
                    if (smode.startsWith("4")) {
                        mode = 4;
                    } else if (smode.startsWith("8")) {
                        mode = 8;
                    }
                }
                wand.autoOutline(ip.getWidth() / 2, ip.getHeight() / 2, WandToolOptions.getTolerance(), mode);
                if (wand.npoints > 0) {
                    Area area = M.getArea((Roi)new PolygonRoi(wand.xpoints, wand.ypoints, wand.npoints, 3));
                    if (inverse) {
                        Area b = new Area(new Rectangle(0, 0, box.width, box.height));
                        b.subtract(area);
                        area = b;
                    }
                    AffineTransform aff = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, box.x, box.y);
                    try {
                        aff.preConcatenate(source_aff.createInverse());
                    }
                    catch (NoninvertibleTransformException nite) {
                        IJError.print(nite);
                        return;
                    }
                    area.transform(aff);
                    if (subtract) {
                        aw.getArea().subtract(area);
                    } else {
                        aw.getArea().add(area);
                    }
                    ac.calculateBoundingBox(layer);
                    Display.repaint(layer);
                }
            }
        }, layer.getProject());
        if (null != post_tasks) {
            for (Runnable task : post_tasks) {
                burro.addPostTask(task);
            }
        }
        burro.goHaveBreakfast();
        return burro;
    }

    public static class BlowRunner {
        final Rectangle box;
        final ImagePlus imp;
        final Lasso lasso;
        final Layer layer;
        final AreaWrapper aw;

        public BlowRunner(AreaWrapper aw, Layer layer, Rectangle srcRect, int x_p_w, int y_p_w) throws Exception {
            this.aw = aw;
            this.layer = layer;
            this.box = new Rectangle(x_p_w - Segmentation.fmp.width / 2, y_p_w - Segmentation.fmp.height / 2, Segmentation.fmp.width, Segmentation.fmp.height);
            Utils.log2("fmp box is " + this.box);
            this.imp = new ImagePlus("", Patch.makeFlatImage(0, layer, this.box, 1.0, layer.getDisplayables(Patch.class, new Area(this.box), true), Color.black));
            if (Segmentation.fmp.apply_bandpass_filter) {
                IJ.run((ImagePlus)this.imp, (String)"Bandpass Filter...", (String)("filter_large=" + Segmentation.fmp.low_frequency_threshold + " filter_small=" + Segmentation.fmp.high_frequency_threshold + " suppress=None tolerance=5" + (Segmentation.fmp.autoscale_after_filtering ? " autoscale" : "") + (Segmentation.fmp.saturate_when_autoscaling ? " saturate" : "")));
            }
            this.lasso = new Lasso(this.imp, 0, this.box.width / 2, this.box.height / 2, false);
            this.lasso.setRatioSpaceColor(Segmentation.fmp.ratio_space_color);
        }

        public void moveBlow(int dx, int dy) throws Exception {
            int x = this.box.width / 2 + dx;
            int y = this.box.height / 2 + dy;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            if (x > this.box.width - 1) {
                x = this.box.width - 1;
            }
            if (y > this.box.height - 1) {
                y = this.box.height - 1;
            }
            this.lasso.moveBlow(x, y);
            Roi roi = this.imp.getRoi();
            if (null == roi) {
                Display.getFront().getCanvas().getFakeImagePlus().setRoi(roi);
            } else {
                ShapeRoi sroi = new ShapeRoi(roi);
                Rectangle b = sroi.getBounds();
                sroi.setLocation(this.box.x + b.x, this.box.y + b.y);
                Display.getFront().getCanvas().getFakeImagePlus().setRoi((Roi)sroi);
            }
        }

        public void finish(AreaContainer ac, AffineTransform source_aff) throws Exception {
            Roi roi = this.imp.getRoi();
            Utils.log2("roi is " + roi);
            if (null == roi) {
                return;
            }
            ShapeRoi sroi = new ShapeRoi(roi);
            Rectangle b = sroi.getBounds();
            sroi.setLocation(this.box.x + b.x, this.box.y + b.y);
            try {
                this.aw.getArea().add(M.getArea(sroi).createTransformedArea(source_aff.createInverse()));
                ac.calculateBoundingBox(this.layer);
                Display.getFront().getCanvas().getFakeImagePlus().killRoi();
            }
            catch (NoninvertibleTransformException nite) {
                IJError.print(nite);
            }
        }
    }

    public static class BlowCommander {
        BlowRunner br = null;
        final ExecutorService dispatcher = Executors.newFixedThreadPool(1);
        final List<Runnable> post_tasks;
        final AffineTransform source_aff;
        final AreaContainer ac;

        public BlowCommander(final AreaWrapper aw, final Layer layer, final Rectangle srcRect, final int x_p_w, final int y_p_w, List<Runnable> post_tasks) throws Exception {
            this.post_tasks = post_tasks;
            this.ac = (AreaContainer)((Object)aw.getSource());
            this.source_aff = aw.getSource().getAffineTransform();
            this.dispatcher.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        br = new BlowRunner(aw, layer, srcRect, x_p_w, y_p_w);
                    }
                    catch (Throwable t) {
                        IJError.print(t);
                        dispatcher.shutdownNow();
                    }
                }
            });
        }

        public void mouseDragged(final MouseEvent me, final Layer la, final int x_p, final int y_p, final int x_d, final int y_d, final int x_d_old, final int y_d_old) {
            try {
                this.dispatcher.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            br.moveBlow(x_p - x_d, y_p - y_d);
                        }
                        catch (Throwable t) {
                            IJError.print(t);
                            this.mouseReleased(me, la, x_p, y_p, x_d_old, y_d_old, x_d, y_d);
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }

        public void mouseReleased(MouseEvent me, Layer la, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
            this.dispatcher.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        br.finish(ac, source_aff);
                    }
                    catch (Throwable t) {
                        IJError.print(t);
                    }
                    if (null != post_tasks) {
                        try {
                            for (Runnable task : post_tasks) {
                                task.run();
                            }
                        }
                        catch (Throwable t) {
                            IJError.print(t);
                        }
                    }
                    dispatcher.shutdownNow();
                }
            });
        }
    }

    static class EndTask<T, D> {
        T target;
        Runnable after;

        EndTask(T target, Runnable after) {
            this.target = target;
            this.after = after;
        }

        void run() {
        }
    }

    public static class FastMarchingParam {
        public int fm_grey = 50;
        public double fm_dist = 0.5;
        public int max_iterations = 1000;
        public int iter_inc = 100;
        public boolean apply_grey_value_erosion = true;
        public double ratio_space_color = 1.0;
        public boolean apply_bandpass_filter = true;
        public int low_frequency_threshold = 1000;
        public int high_frequency_threshold = 5;
        public boolean autoscale_after_filtering = true;
        public boolean saturate_when_autoscaling = true;
        public int width = 100;
        public int height = 100;
        public boolean SNT_invert_image = false;

        public OptionPanel asOptionPanel() {
            OptionPanel op = new OptionPanel();
            op.addMessage("Fast Marching:");
            op.addNumericField("Grey value threshold:", this.fm_grey, (OptionPanel.Setter)new OptionPanel.IntSetter(this, "fm_grey"));
            op.addNumericField("Distance threshold:", this.fm_dist, 2, new OptionPanel.DoubleSetter(this, "fm_dist"));
            op.addNumericField("Max iterations:", this.max_iterations, (OptionPanel.Setter)new OptionPanel.IntSetter(this, "max_iterations"));
            op.addNumericField("Iterations inc:", this.iter_inc, (OptionPanel.Setter)new OptionPanel.IntSetter(this, "iter_inc"));
            op.addCheckbox("Grey value erosion filter:", this.apply_grey_value_erosion, new OptionPanel.BooleanSetter(this, "apply_grey_value_erosion"));
            op.addMessage("Lasso:");
            op.addNumericField("Ratio space/color:", this.ratio_space_color, 2, new OptionPanel.DoubleSetter(this, "ratio_space_color"));
            op.addMessage("Preprocessing by bandpass filter:");
            op.addCheckbox("Bandpass filter:", this.apply_bandpass_filter, new OptionPanel.BooleanSetter(this, "apply_bandpass_filter"));
            op.addNumericField("Filter down to:", this.low_frequency_threshold, (OptionPanel.Setter)new OptionPanel.IntSetter(this, "low_frequency_threshold"));
            op.addNumericField("Filter up to:", this.high_frequency_threshold, (OptionPanel.Setter)new OptionPanel.IntSetter(this, "high_frequency_threshold"));
            op.addCheckbox("Saturate when autoscaling:", this.saturate_when_autoscaling, new OptionPanel.BooleanSetter(this, "saturate_when_autoscaling"));
            op.addMessage("Semiautomatic neurite tracer:");
            op.addCheckbox("Invert image", this.SNT_invert_image, new OptionPanel.BooleanSetter(this, "SNT_invert_image"));
            return op;
        }

        public boolean setup() {
            GenericDialog gd = new GenericDialog("Fast Marching Options");
            gd.addMessage("Fast Marching:");
            gd.addNumericField("Grey value threshold", (double)this.fm_grey, 0);
            gd.addNumericField("Distance threshold", this.fm_dist, 2);
            gd.addNumericField("Max iterations", (double)this.max_iterations, 0);
            gd.addNumericField("Iterations inc", (double)this.iter_inc, 0);
            gd.addCheckbox("Enable grey value erosion filter", this.apply_grey_value_erosion);
            gd.addMessage("Lasso:");
            gd.addNumericField("ratio space/color:", this.ratio_space_color, 2);
            gd.addMessage("Preprocessing by bandpass filter:");
            gd.addCheckbox("Enable bandpass filter", this.apply_bandpass_filter);
            gd.addNumericField("Filter_Large Structures Down to", (double)this.low_frequency_threshold, 0, 4, "pixels");
            gd.addNumericField("Filter_Small Structures Up to", (double)this.high_frequency_threshold, 0, 4, "pixels");
            gd.addCheckbox("Autoscale After Filtering", this.autoscale_after_filtering);
            gd.addCheckbox("Saturate Image when Autoscaling", this.saturate_when_autoscaling);
            Component[] c = new Component[]{(Component)gd.getNumericFields().get(gd.getNumericFields().size() - 2), (Component)gd.getNumericFields().get(gd.getNumericFields().size() - 1), (Component)gd.getCheckboxes().get(gd.getCheckboxes().size() - 2), (Component)gd.getCheckboxes().get(gd.getCheckboxes().size() - 1)};
            Utils.addEnablerListener((Checkbox)gd.getCheckboxes().get(gd.getCheckboxes().size() - 3), c, null);
            if (!this.apply_bandpass_filter) {
                for (Component comp : c) {
                    comp.setEnabled(false);
                }
            }
            gd.addMessage("Semiautomatic neurite tracer:");
            gd.addCheckbox("Invert image", this.SNT_invert_image);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            this.fm_grey = (int)gd.getNextNumber();
            this.fm_dist = gd.getNextNumber();
            this.max_iterations = (int)gd.getNextNumber();
            this.iter_inc = (int)gd.getNextNumber();
            this.apply_grey_value_erosion = gd.getNextBoolean();
            this.ratio_space_color = gd.getNextNumber();
            this.apply_bandpass_filter = gd.getNextBoolean();
            this.low_frequency_threshold = (int)gd.getNextNumber();
            this.high_frequency_threshold = (int)gd.getNextNumber();
            this.autoscale_after_filtering = gd.getNextBoolean();
            this.saturate_when_autoscaling = gd.getNextBoolean();
            this.SNT_invert_image = gd.getNextBoolean();
            return true;
        }

        public void resizeArea(int sign, double magnification) {
            double inc = (int)((double)(10 * sign) / magnification);
            this.width = (int)((double)this.width + inc);
            this.height = (int)((double)this.height + inc);
            Utils.log2("fmp w,h: " + this.width + ", " + this.height);
        }

        public Rectangle getBounds(int x_p, int y_p) {
            return new Rectangle(x_p - this.width / 2, y_p - this.height / 2, this.width, this.height);
        }
    }
}

