/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging;

import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.ContrastEnhancer;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.StackStatistics;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Patch;
import ini.trakem2.imaging.PatchStack;
import ini.trakem2.imaging.filters.EqualizeHistogram;
import ini.trakem2.imaging.filters.IFilter;
import ini.trakem2.parallel.Process;
import ini.trakem2.parallel.TaskFactory;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ContrastEnhancerWrapper {
    private final ContrastEnhancer ce = new ContrastEnhancer();
    private Patch reference = null;
    private ImageStatistics reference_stats = null;
    private double saturated = 0.4;
    private boolean normalize = true;
    private boolean equalize = false;
    private int stats_mode = 0;
    private boolean use_full_stack = false;
    private boolean from_existing_min_and_max = false;
    private boolean visible_only = true;
    final ExecutorService waiter = Utils.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), "contrast-enhancer-waiter");
    final Vector<Future<?>> tasks = new Vector();

    public ContrastEnhancerWrapper() {
        this(null);
    }

    public ContrastEnhancerWrapper(Patch reference) {
        this.reference = reference;
        if (null != reference) {
            ImageProcessor ip = reference.getImageProcessor();
            this.reference_stats = ImageStatistics.getStatistics((ImageProcessor)ip, (int)16, (Calibration)reference.getLayer().getParent().getCalibrationCopy());
        }
    }

    private String[] getChoices() {
        String[] stringArray;
        if (null == this.reference) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "Stack Histogram";
            stringArray = stringArray2;
            stringArray2[1] = "Each image histogram";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "Stack Histogram";
            stringArray3[1] = "Each image histogram";
            stringArray = stringArray3;
            stringArray3[2] = "Active Patch Histogram";
        }
        return stringArray;
    }

    public void set(double saturated, boolean normalize, boolean equalize, int stats_mode, boolean use_full_stack, boolean from_existing_min_and_max, boolean visible_only) throws Exception {
        if (null == this.reference && 2 == stats_mode) {
            throw new IllegalArgumentException("Need a non-null reference Patch to use 2==stats_mode !");
        }
        this.saturated = saturated;
        this.set("saturated", saturated);
        this.normalize = normalize;
        this.set("normalize", normalize);
        this.equalize = equalize;
        this.set("equalize", equalize);
        this.stats_mode = stats_mode;
        this.use_full_stack = use_full_stack;
        if (from_existing_min_and_max && null != this.reference) {
            ImageProcessor ip = this.reference.getImageProcessor();
            ip.setMinAndMax(this.reference.getMin(), this.reference.getMax());
            this.reference_stats = ImageStatistics.getStatistics((ImageProcessor)ip, (int)16, (Calibration)this.reference.getLayer().getParent().getCalibrationCopy());
        }
        this.from_existing_min_and_max = from_existing_min_and_max;
        this.visible_only = visible_only;
    }

    public boolean showDialog() {
        GenericDialog gd = new GenericDialog("Enhance Contrast");
        gd.addNumericField("Saturated Pixels:", this.saturated, 1, 4, "%");
        gd.addCheckbox("Normalize", this.normalize);
        gd.addCheckbox("Equalize Histogram", this.equalize);
        String[] choices = this.getChoices();
        gd.addChoice("Use:", choices, choices[this.stats_mode]);
        gd.addCheckbox("Use full stack", this.use_full_stack);
        gd.addCheckbox("From existing min and max", this.from_existing_min_and_max);
        gd.addCheckbox("Visible images only", this.visible_only);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        try {
            this.set(gd.getNextNumber(), gd.getNextBoolean(), gd.getNextBoolean(), gd.getNextChoiceIndex(), gd.getNextBoolean(), gd.getNextBoolean(), gd.getNextBoolean());
        }
        catch (Exception e) {
            IJError.print(e);
            return false;
        }
        return true;
    }

    private void set(String field, Object value) throws Exception {
        Field f = ContrastEnhancer.class.getDeclaredField(field);
        f.setAccessible(true);
        f.set(this.ce, value);
    }

    public boolean applyLayerWise(Collection<Layer> layers) {
        boolean b = true;
        for (Layer layer : layers) {
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            b = b && this.apply(layer.getDisplayables(Patch.class, this.visible_only));
            try {
                this.waiter.submit(new Runnable(){

                    @Override
                    public void run() {
                    }
                }).get();
            }
            catch (Exception e) {
                IJError.print(e);
                return false;
            }
        }
        return b;
    }

    public boolean apply(Collection<Displayable> patches_) {
        if (null == patches_) {
            return false;
        }
        ArrayList<Patch> patches = new ArrayList<Patch>();
        for (Displayable d : patches_) {
            if (d.getClass() != Patch.class) continue;
            patches.add((Patch)d);
        }
        if (0 == patches.size()) {
            return false;
        }
        Patch firstp = (Patch)patches.get(0);
        int ptype = firstp.getType();
        double pw = firstp.getOWidth();
        double ph = firstp.getOHeight();
        for (Patch p : patches) {
            if (p.getType() != ptype) {
                Utils.log("Can't homogenize histograms: images are not all of the same type.\nFirst offending image is: " + p);
                return false;
            }
            if ((this.equalize || 0 != this.stats_mode || (double)p.getOWidth() == pw) && (double)p.getOHeight() == ph) continue;
            Utils.log("Can't homogenize histograms: images are not all of the same size.\nFirst offending image is: " + p);
            return false;
        }
        try {
            ImageStatistics stats;
            if (this.equalize) {
                for (Patch p : patches) {
                    if (Thread.currentThread().isInterrupted()) {
                        return false;
                    }
                    p.appendFilters(new IFilter[]{new EqualizeHistogram()});
                    p.getProject().getLoader().decacheImagePlus(p.getId());
                    this.regenerateMipMaps(p);
                }
                return true;
            }
            if (1 == this.stats_mode) {
                stats = null;
            } else if (0 == this.stats_mode) {
                ArrayList<Patch> sub = new ArrayList<Patch>();
                if (this.use_full_stack) {
                    sub.addAll(patches);
                } else {
                    final SortedMap sp = Collections.synchronizedSortedMap(new TreeMap());
                    Process.progressive(patches, new TaskFactory<Patch, Stats>(){

                        @Override
                        public Stats process(Patch p) {
                            if (Thread.currentThread().isInterrupted()) {
                                return null;
                            }
                            ImagePlus imp = p.getImagePlus();
                            p.getProject().getLoader().releaseToFit(p.getOWidth(), p.getOHeight(), p.getType(), 2.0f);
                            Stats s = new Stats(imp.getStatistics());
                            sp.put(s, p);
                            return s;
                        }
                    });
                    if (Thread.currentThread().isInterrupted()) {
                        return false;
                    }
                    ArrayList a = new ArrayList(sp.values());
                    int count = a.size();
                    if (count < 3) {
                        sub.addAll(a);
                    } else if (3 == count) {
                        sub.add((Patch)a.get(1));
                    } else if (4 == count) {
                        sub.addAll(a.subList(1, 3));
                    } else if (count > 4) {
                        int first = (int)((double)count / 4.0 + 0.5);
                        int last = (int)((double)count / 4.0 * 3.0 + 0.5);
                        sub.addAll(a.subList(first, last));
                    }
                }
                stats = new StackStatistics((ImagePlus)new PatchStack(sub.toArray(new Patch[sub.size()]), 1));
            } else {
                stats = this.reference_stats;
            }
            final Calibration cal = ((Patch)patches.get(0)).getLayer().getParent().getCalibrationCopy();
            Process.progressive(patches, new TaskFactory<Patch, Object>(){

                @Override
                public Object process(Patch p) {
                    if (Thread.currentThread().isInterrupted()) {
                        return null;
                    }
                    p.getProject().getLoader().releaseToFit(p.getOWidth(), p.getOHeight(), p.getType(), 3.0f);
                    ImageProcessor ip = p.getImageProcessor().duplicate();
                    if (ContrastEnhancerWrapper.this.from_existing_min_and_max) {
                        ip.setMinAndMax(p.getMin(), p.getMax());
                    }
                    ImageStatistics st = stats;
                    if (null == stats) {
                        Utils.log2("Null stats, using image's self");
                        st = ImageStatistics.getStatistics((ImageProcessor)ip, (int)16, (Calibration)cal);
                    }
                    ContrastEnhancerWrapper.this.ce.stretchHistogram(ip, ContrastEnhancerWrapper.this.saturated, st);
                    p.setMinAndMax(ip.getMin(), ip.getMax());
                    ContrastEnhancerWrapper.this.regenerateMipMaps(p);
                    return null;
                }
            });
        }
        catch (Exception e) {
            IJError.print(e);
            return false;
        }
        return true;
    }

    private void regenerateMipMaps(final Patch p) {
        final Future<Boolean> fu = p.getProject().getLoader().regenerateMipMaps(p);
        this.tasks.add(this.waiter.submit(new Runnable(){

            @Override
            public void run() {
                if (null != fu) {
                    try {
                        fu.get();
                    }
                    catch (Exception e) {
                        IJError.print(e);
                    }
                }
                p.getProject().getLoader().decacheAWT(p.getId());
            }
        }));
    }

    public void shutdown() {
        this.tasks.add(this.waiter.submit(new Runnable(){

            @Override
            public void run() {
                ContrastEnhancerWrapper.this.waiter.shutdown();
                ContrastEnhancerWrapper.this.tasks.clear();
            }
        }));
        for (Future<?> fu : new Vector(this.tasks)) {
            if (null == fu) continue;
            try {
                fu.get();
            }
            catch (InterruptedException ie) {
                this.waiter.shutdownNow();
                this.tasks.clear();
                return;
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
    }

    private static class Stats
    implements Comparable<Stats> {
        ImageStatistics s;

        Stats(ImageStatistics s) {
            this.s = s;
        }

        @Override
        public int compareTo(Stats o) {
            return (int)(o.s.stdDev - this.s.stdDev);
        }
    }
}

